.\" 1999 PTM Przemek Borys
'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" SCCS: @(#) Tcl.n 1.128 96/08/26 12:59:50
'
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  If an argument is present, then a line break is
'\"	forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" SCCS: @(#) man.macros 1.8 96/02/15 20:02:24
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$1"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "OPCJE STANDARDOWE"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
Zobacz podrcznik \fBoptions\fR(n) dla dalszych szczegw o standardowych
opcjach.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Nazwa linii komend:	\\fB\\$1\\fR
Nazwa bazy danych:	\\fB\\$2\\fR
Klasa bazy danych:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH Tcl n "" Tcl "Wbudowane komendy Tcl"
.BS
.SH NAZWA
Tcl \- Podsumowanie skadni jzyka Tcl
.BE

.SH OPIS
.PP
Nastpujce reguy definiuj semantyk jzyka Tcl:
.IP [1]
Skrypt Tcl jest acuchem, zawierajcym jedn, lub wicej komend.
redniki i nowe linie s separatorami komend, chyba e s zacytowane.
Zamykajce nawiasy s normalnie terminatorami komend.
.IP [2]
Komenda jest analizowana w dwch krokach.
Najpierw interpreter Tcl rozbija komend na \fIsowa\fR i dokonuje opisanych
niej podstawie. Podstawienia te s dokonywane jednakowo dla wszystkich
komend.
Pierwsze sowo jest uywane do lokalizowania procedury komendy, ktra wykona
polecenie, a nastpnie wszystkie pozostae sowa komendy s przekazywane do
tej procedury.
Procedura moe interpretowa kade ze swoich sw w dowolny sposb, np. jako
liczb cakowit, nazw zmiennej, list, lub skrypt Tcl.
Rne komendy rnie interpretuj swoje sowa.
.IP [3]
Sowa komendy s rozdzielane biaymi spacjami (poza nowymi liniami, ktre s
separatorami komend).
.IP [4]
Pierwszy znak sowa to podwjny cudzysw (``"''), ostatni rwnie.
Jeli midzy cudzysowami pojawi si redniki, nawiasy czy biae spacje, to
bd one traktowane jak zwyke znaki wczone w sowo.
Podstawianie komend i zmiennych, oraz podstawianie ukonikowe jest
dokonywane na znakach midzycudzysowowych w sposb opisany niej.
Podwjne cudzysowy nie s zachowywane jako elementy sowa.
.IP [5]
Jeli pierwszy znak sowa jest otwartym nawiasem klamrowym (``{''), to sowo
jest koczone klamr zamykajc, (``}'').
Klamry zagniedaj si w sowie: kada otwarta klamra musi mie klamr
zamykajc (jednak jeli klamra jest cytowana lewym ukonikiem, to jej 
dziaanie nie wymaga klamry zamykajcej).
Na znakach midzy klamrami nie dokonuje si adnych podstawie, nie liczc
podstawie lewy ukonik-nowa linia. Sowo skada si dokadnie ze znakw 
midzy klamrami, nie liczc samych klamr.
.IP [6]
Jeli sowo zawiera otwarty nawias kwadratowy (``[''), to Tcl dokonuje
\fIpodstawienia komendy\fR.
Aby tego dokona, woa rekursywnie interpreter Tcl, ktry przetwarza znaki
znajdujce za nawiasem jako skrypt Tcl. Skrypt moe zawiera dowoln liczb
komend i musi by zakoczony nawiasem zamykajcym (``]'').
Wyniki skryptu (np. wynik ostatniej komendy) s podstawiane zamiast
nawiasw, wraz ze znakami znajdujcymi si midzy nimi.
Moe by dowolnie wiele podstawie w pojedynczym sowie. Podstawianie komend
nie jest dokonywane na sowach ujtych w nawiasy klamrowe.
.IP [7]
Jeli sowo zawiera znak dolara (``$'') to Tcl dokonuje \fIpodstawienia
zmiennej\fR: znak dolara i nastpujce znaki s zastpowane wartoci
zmiennej. Podstawienie zmiennej moe przybra jedn z postaci:
.RS
.TP 15
\fB$\fInazwa\fR
 \fINazwa\fR jest nazw zmiennej skalarnej; nazwa jest koczona dowolnym
znakiem, ktry nie jest liter, cyfr, lub podkreleniem.
.TP 15
\fB$\fInazwa\fB(\fIindeks\fB)\fR
\fINazwa\fR daje nazw zmiennej tablicowej, a \fIindeks\fR daje nazw jej
elementu. \fINazwa\fR musi skada si tylko z liter, cyfr i podkrele.
Na znakach \fIindeksu\fR dokonywane s podstawienia komend, zmiennych i
lewych ukonikw.
.TP 15
\fB${\fInazwa\fB}\fR
\fINazwa\fR jest nazw zmiennej skalarnej. Moe zawiera dowolne znaki poza
zamykajcymi nawiasami klamrowymi.
.LP
W pojedynczym sowie moe by wiele podstawie zmiennych. Na sowach, ujtych
w klamry nie jest dokonywane podstawienie zmiennych.
.RE
.IP [8]
Jeli w sowie znajduje si lewy ukonik (``\e''), to nastpuje
\fIpodstawienie ukonikowe\fR.
We wszystkich wypadkach, poza opisanymi niej, ukonik jest porzucany, a
nastpujcy znak jest traktowany jak zwyky i jest wczany w sowo.
Umoliwia to wczanie znakw takich, jak podwjne cytaty, nawiasy
zamykajce i znaki dolara.
Nastpujca tabela pokazuje sekwencje ukonikowe, ktre s traktowane
szczeglnie, wraz z wartociami, ktre wchodz w ich miejsce.
.RS
.TP 6
\e\fBa\fR
Dzwonek (0x7).
.TP 6
\e\fBb\fR
Backspace (0x8).
.TP 6
\e\fBf\fR
Form feed (0xc).
.TP 6
\e\fBn\fR
Nowa linia (0xa).
.TP 6
\e\fBr\fR
Powrt karetki (0xd).
.TP 6
\e\fBt\fR
Tabulacja (0x9).
.TP 6
\e\fBv\fR
Tabulacja pionowa (0xb).
.TP 6
\e\fB<nowalinia>\fIbiaaspacja\fR
Zamiast ukonika, nowej linii i biaej (biaych) spacji, podstawiany jest 
pojedynczy znak spacji.
Sekwencja ukonikowa jest unikalna dlatego, e jest podstawiana w oddzielnym
przedbiegu przed przetworzeniem komendy.
Znaczy to, e bdzie podstawiona nawet gdy nastpi midzy nawiasami, a
wynikajca spacja bdzie traktowana jako separator sw (o ile nie jest w
cudzysowach lub klamrach).
.TP 6
\e\e
Lewy ukonik (``\e'').
.TP 6
\e\fIooo\fR
Cyfry \fIooo\fR (jedna, dwie, lub trzy z nich) daj rzeczywist semkow
warto znaku.
.TP 6
\e\fBx\fIhh\fR
Cyfry szesnastkowe \fIhh\fR daj szesnastkow warto znaku. Obecna moe by
dowolna liczba cyfr.
.LP
Podstawianie ukonikowe nie jest dokonywane na sowach ujtych w klamry, nie
liczc podstawienia ukonik-nowa linia, opisanego wyej.
.RE
.IP [9]
Jeli w miejscu, gdzie Tcl oczekuje pierwszego znaku pierwszego sowa
komendy znajduje si znak ``#'', to znak ten i znaki za nim nastpujce, a
do nowej linii, s traktowane jako komentarz i s ignorowane.
Znak komentarza ma znaczenie gdy znajduje si na pocztku komendy.
.IP [10]
Kady znak jest przetwarzany przez interpreter Tcl tylko raz jako element
tworzenia sw komendy.
Na przykad, jeli nastpi podstawienie zmiennych, dalsze podstawienia na
wartoci zmiennej nie nastpuj; warto jest wstawiana dosownie.
Jeli nastpi podstawianie komend, to zagniedone komendy s przetwarzane
caociowo przez rekursywne wywoania interpretera Tcl; przed tym wywoaniem
nie s robione adne podstawienia. Podobnie po wywoaniu nie robi si
adnych dodatkowych podstawie.
.IP [11]
Podstawienia nie tycz si ogranicznikw sw komendy. Na przykad podczas
podstawiania zmiennych caa warto zmiennej staje si czci pojedynczego
sowa, nawet jeli warto zmiennej zawiera spacje.
