<?php
	# Mantis - a php based bugtracking system
	# Copyright (C) 2000, 2001  Kenzaburo Ito - kenito@300baud.org
	# This program is distributed under the terms and conditions of the GPL
	# See the files README and LICENSE for details

	###########################################################################
	# CONFIGURATION VARIABLES
	###########################################################################

	# default/config_inc1.php

	# In general a value of 0 means the feature is disabled and 1 means the
	# feature is enabled.  Any other cases will have an explanation.

	# Look in configuration.html for more detailed comments.

	#error_reporting(E_ALL ^ E_NOTICE);
	#error_reporting(E_ALL);

	################################
	# Mantis Database Settings
	################################

	# --- database variables ---------

	# set these values to match your setup
	$g_hostname      = "localhost";
	$g_port          = 3306;         # 3306 is default
	$g_db_username   = "root";
	$g_db_password   = "";
	$g_database_name = "bugtracker";

	############################
	# Mantis Path Settings
	############################

	# --- path variables --------------

	# path to your installation as seen from the web browser
	# requires trailing /
	$g_path          = "http://yourhostnamehere/mantis/";

	# path to your images directory (for icons)
	# requires trailing /
	$g_icon_path     = $g_path."images/";

	# absolute path to your installation.  *NO* symlinks allowed (causes problems with file downloads)
	# requires trailing /
	$g_absolute_path = "/usr/local/www/data/mantis/";

	#############################
	# Web Server
	#############################

	# --- using MS IIS ----------------
	# set to ON if you use IIS
	$g_use_iis = OFF;

	#############################
	# Mantis Email Settings
	#############################

	# --- email variables -------------
	$g_administrator_email  = "administrator@nowhere";
	$g_webmaster_email      = "webmaster@nowhere";

	# the "From: " field in emails
	$g_from_email           = "noreply@nowhere";

	# the "To: " address all emails are sent.  This can be a mailing list or archive address.
	# Actual users are emailed via the bcc: fields
	$g_to_email             = "nobody@nowhere";

	# the return address for bounced mail
	$g_return_path_email    = "admin@nowhere";

	# allow users to signup for their own accounts
	$g_allow_signup              = ON;

	# if ON users will be sent their password when reset.
	# if OFF the password will be set to blank.
	$g_send_reset_password       = ON;

	# allow email notification
	$g_enable_email_notification = ON;

	# notify developers and higher when a new bug comes in
	# only if their preference is also set
	$g_notify_developers_on_new  = ON;

	# set to OFF to disable email check
	$g_validate_email            = ON;
	$g_check_mx_record           = ON;

	# This disables the automatic generation of mailto: links
	# Valid values: NONE, ALL, NO_ANONYMOUS, ADMIN_ONLY
	$g_show_user_email           = NONE;

	# Set to OFF to remove X-Priority header
	$g_use_x_priority            = ON;

	# Set to OFF on Windows systems, as long as php-mail-function has its bcc-bug (~PHP 4.0.6)
	$g_use_bcc                   = ON;

	# some Mail transfer agents (MTAs) don't like bare linefeeds...
	# or they take good input and create barelinefeeds
	# If problems occur when sending mail through your server try turning this OFF
	# more here: http://pobox.com/~djb/docs/smtplf.html
	$g_mail_send_crlf            = OFF;

	# phpMailer instead of standard mail() function (REQUIRES PHP 4.x.x)
	# Get the phpMailer-package from http://phpmailer.sourceforge.net
	# The installation is very simple you only need 2 plain text php-files
	#  class.smtp.php
	#  class.phpmailer.php

	# Copy these files to your php-include-dir i.e. "c:\php\includes" or
	# "/usr/lib/php/includes"
	# and add this path to the "include_path"-entry  in the php.ini file.
	# The installation is described in the readme and there is also a simple
	# example.
	# PhpMailer comes with a detailed documentation in phpdoc format.

	$g_use_phpMailer = OFF;

	# select the method to mail by:
	# 0 - mail()
	# 1 - sendmail
	# 2 - SMTP
	$g_phpMailer_method = 0;

	# This option allows you to use a remote SMTP host.  Must use the phpMailer script
	# Name of smtp host, needed for phpMailer, taken from php.ini
	$g_smtp_host     = "localhost";

	# --- email separator and padding ------------
	$g_email_separator1     = "=======================================================================";
	$g_email_separator2     = "-----------------------------------------------------------------------";
	$g_email_padding_length = 28;

	#############################
	# Mantis Version String
	#############################

	# --- version variables -----------
	$g_mantis_version = "0.17.5";
	$g_show_version   = ON;

	################################
	# Mantis Language Settings
	################################

	# --- language settings -----------
	$g_default_language     = "english";

	# list the choices that the users are allowed to choose
	$g_language_choices_arr = array( "english", "chinese_traditional", "czech", "danish", "dutch", "french", "french2", "german", "hungarian", "italian", "japanese_euc", "japanese_sjis", "korean", "norwegian", "polish", "portuguese_brazil", "portuguese_standard", "romanian", "russian", "russian_koi8", "spanish", "swedish", "turkish" );

	###############################
	# Mantis Display Settings
	###############################

	# --- sitewide variables ----------
	$g_window_title = "Mantis";     # browser window title
	$g_page_title   = "Mantis";     # title at top of html page

	# --- advanced views --------------
	# BOTH, SIMPLE_ONLY, ADVANCED_ONLY
	$g_show_report = BOTH;
	$g_show_update = BOTH;
	$g_show_view   = BOTH;

	# --- display source code ---------
	# display a link at the bottom of the page to show the PHP source
	# WARNING: Potential security hazard.  Only turn this on when you really
	# need it (for debugging)
	# ON = admin only; OFF = disabled
	$g_show_source = OFF;

	# --- footer menu -----------------
	# Footer Menu
	$g_show_footer_menu = OFF;

	# --- footer menu -----------------
	# show the project name in the page title
	# 0 : no project name
	# 1 : project name and any additional
	# 2 : only project name
	$g_show_project_in_title = ON;

	# --- show assigned to names ------
	# This is in the view all pages
	$g_show_assigned_names = ON;

	# --- show priority as icon ---
	# OFF: Shows priority as icon in view all bugs page
	# ON:  Shows priority as text in view all bugs page
	$g_show_priority_text = OFF;

	# --- show projects when in All Projects mode ---
	$g_show_bug_project_links = ON;

	############################
	# Mantis JPGRAPH Addon
	############################

	# --- jpgraph settings --- #
	# Initial Version from Duncan Lisset
	#
	# To use the Jpgraph addon you need the JPGRAPH package from
	# http://www.aditus.nu/jpgraph/index.php
	# You can place the package whereever you want, but you have
	# to set the var in jpgraph.php eg.
	# (DEFINE("DIR_BASE","/www/mantisbt/jpgraph/");)

	$g_use_jpgraph = OFF;
	$g_jpgraph_path = "./jpgraph/";   # dont forget the ending slash!

	############################
	# Mantis Time Settings
	############################

	# --- time varaibles --------------

	# time for 'permanent' cookie to live in seconds (1 year)
	$g_cookie_time_length = 30000000;

	# time to delay between page redirects (in seconds)
	$g_wait_time          = 2;

	# minutes to wait before document is stale (in minutes)
	$g_content_expire     = 0;

	############################
	# Mantis Date Settings
	############################

	# --- date format settings --------
	# date format strings (default is 'US' formatting)
	# go to http://www.php.net/manual/en/function.date.php
	# for detailed instructions on date formatting
	$g_short_date_format    = "m-d";
	$g_normal_date_format   = "m-d H:i";
	$g_complete_date_format = "m-d-y H:i T";

	############################
	# Mantis News Settings
	############################

	# --- Limit News Items ------------
	# limit by entry count or date
	# BY_LIMIT - entry limit
	# BY_DATE - by date
	$g_news_limit_method    = BY_LIMIT;

	# limit by last X entries
	$g_news_view_limit      = 7;

	# limit by days
	$g_news_view_limit_days = 30;

	##################################
	# Mantis Default Preferences
	##################################

	# --- signup default ---------------
	# look in constant_inc.php for values
	$g_default_new_account_access_level = REPORTER;

	# --- viewing defaults ------------
	# site defaults for viewing preferences
	$g_default_limit_view         = 50;
	$g_default_show_changed       = 6;
	$g_hide_closed_default        = ON;

	# make sure people aren't refreshing too often
	$g_min_refresh_delay          = 10;    # in minutes

	# --- account pref defaults -------
	# BOTH, SIMPLE_ONLY, ADVANCED_ONLY
	$g_default_advanced_report    = BOTH;
	$g_default_advanced_view      = BOTH;
	$g_default_advanced_update    = BOTH;
	$g_default_refresh_delay      = 30;    # in minutes
	$g_default_redirect_delay     = 2;     # in seconds
	$g_default_email_on_new       = ON;
	$g_default_email_on_assigned  = ON;
	$g_default_email_on_feedback  = ON;
	$g_default_email_on_resolved  = ON;
	$g_default_email_on_closed    = ON;
	$g_default_email_on_reopened  = ON;
	$g_default_email_on_bugnote   = ON;
	$g_default_email_on_status    = 0; # @@@ Unused
	$g_default_email_on_priority  = 0; # @@@ Unused
	# default_language - is set to site language

	###############################
	# Mantis Summary Settings
	###############################

	# how many reporters to show
	# this is useful when there are hundreds of reporters
	$g_reporter_summary_limit = 10;

	# default space padding (increase when bug count goes over 100,000)
	$g_summary_pad            = 5;

	# --- summary date displays -------
	# date lengths to count bugs by (in days)
	$g_date_partitions = array( 1, 2, 3, 7, 30, 60, 90, 180, 365);

	###############################
	# Mantis Bugnote Settings
	###############################

	# --- bugnote settings ------------
	# bugnote ordering
	# change to ASC or DESC
	$g_bugnote_order = "ASC";

	###################################
	# Mantis File Upload Settings
	###################################

	# --- file upload settings --------
	# @@@ This should be broken into per project settings and split between bug uploads and project document uploads
	$g_allow_file_upload    = ON;

	# Upload destination: specify actual location in project settings
	# DISK or DATABASE
	$g_file_upload_method   = DATABASE;

	# Maximum file size that can be uploaded
	# Also check your PHP settings (default is usually 2MBs)
	$g_max_file_size        = 5000000; # 5 MB

	# Files that are allowed or not allowed.  Separate items by commas.
	# eg. "php,html,java,exe,pl"
	# if $g_allowed_files is filled in NO other file types will be allowed.
	# $g_disallowed_files takes precedence over $g_allowed_files
	$g_allowed_files     = "";
	$g_disallowed_files  = "";

	############################
	# Mantis HTML Settings
	############################

	# --- html tags -------------------
	$g_allow_html_tags        = ON;

	# do NOT include href or img tags here
	# do NOT include tags that have parameters (eg. <font face="arial">)
	$g_html_tags              = array("<p>","</p>","<li>","</li>","<ul>","</ul>",
									"<ol>","</ol>","<br />","<br>","<pre>","</pre>",
									"<i>","</i>","<b>","</b>","<u>","</u>");

	$g_allow_href_tags        = ON;

	# --- table tags ------------------
	# this is inserted into the outermost tables ( tags like border, cellspacing, etc)
	$g_primary_table_tags          = "";

	##########################
	# Mantis HR Settings
	##########################

	# --- hr --------------------------
	$g_hr_size  = 1;
	$g_hr_width = 50;

	#############################
	# Mantis LDAP Settings
	#############################

	# look in README.LDAP for details

	# --- using openldap -------------
	$g_ldap_server       = "192.168.192.38";
	$g_ldap_root_dn      = "dc=traffic,dc=redflex,dc=com,dc=au";
	$g_ldap_organisation = "(organizationname=*Traffic)"; # optional
	$g_use_ldap_email    = OFF; # Should we send to the LDAP email address or what MySql tells us
	# --- ldapauth type --- CLEAR or CRYPT (as in /etc/passwd /etc/shadow)
	$g_ldapauth_type	= "CRYPT";

	############################
	# Mantis Misc Settings
	############################

	# --- threshold -------------------
	# access level needed to re-open bugs
	# Look in the constant_inc.php file if you want to set a different value
	$g_reopen_bug_threshold = DEVELOPER;

	# access level needed to close bugs
	# Look in the constant_inc.php file if you want to set a different value
	$g_close_bug_threshold = DEVELOPER;

	# access level needed to monitor bugs
	# Look in the constant_inc.php file if you want to set a different value
	$g_monitor_bug_threshold = REPORTER;
	$g_private_bug_threshold = DEVELOPER;

	# --- login method ----------------
	# CRYPT or CRYPT_FULL_SALT or PLAIN or MD5 or LDAP or BASIC_AUTH
	# If you were using CRYPT and it now fails, try CRYPT_FULL_SALT
	$g_login_method = MD5;

	# --- limit reporters -------------
	# Set to ON if you wish to limit reporters to only viewing bugs that they report.
	$g_limit_reporters = OFF;

	# --- close immediately -----------
	# Allow developers and above to close bugs immediately when resolving bugs
	$g_allow_close_immediately = OFF;

	# --- account delete -----------
	# Allow the specified access level and higher to delete bugs
	$g_allow_bug_delete_access_level = DEVELOPER;

	# --- move bugs -----------
	# Allow the specified access level and higher to move bugs between projects
	$g_bug_move_access_level = DEVELOPER;

	# --- account delete -----------
	# Allow users to delete their own accounts
	$g_allow_account_delete = OFF;

	# --- anonymous login -----------
	# Allow anonymous login
	$g_allow_anonymous_login = OFF;
	$g_anonymous_account = "";

	# --- CVS linking ---------------
	# insert the URL to your CVSweb or ViewCVS
	$g_cvs_web = "http://cvs.sourceforge.net/cgi-bin/viewcvs.cgi/mantisbt/mantisbt/";

	# --- Bug Linking ---------------
	# if a number follows this tag it will create a link to a bug.
	# eg. for # a link would be #45
	# eg. for bug: a link would be bug:98
	$g_bug_link_tag = "#";

	# --- Timer ----------------------
	# Time page loads.  Shows at the bottom of the page.
	$g_show_timer   = OFF;

	# --- register globals -----------
	# @@@ experimental
	# if your register_globals is Off then set this to OFF
	$g_register_globals          = ON;

  	################################
	# Mantis Look and Feel Variables
	################################

	# --- color values ----------------
	# you can change the look and feel by modifying these values

	$g_background_color        = "#ffffff"; # white
	$g_required_color          = "#bb0000"; # red
	$g_table_border_color      = "#000000"; # black
	$g_category_title_color    = "#c8c8e8"; # blue
	$g_primary_color1          = "#d8d8d8"; # dark gray
	$g_primary_color2          = "#e8e8e8"; # light gray
	$g_form_title_color        = "#ffffff"; # white
	$g_spacer_color            = "#ffffff"; # white
	$g_menu_color              = "#e8e8e8"; # light gray

	# --- status color codes ----------
	#
	$g_new_color               = "#ffa0a0"; # red
	$g_feedback_color          = "#ff50a8"; # purple
	$g_acknowledged_color      = "#ffd850"; # orange
	$g_confirmed_color         = "#ffffb0"; # yellow
	$g_assigned_color          = "#c8c8ff"; # blue
	$g_resolved_color          = "#cceedd"; # buish-green
	$g_closed_color            = "#ffffff"; # white

	# --- fonts ----------
	#
	$g_fonts                   = "Verdana, Arial, Helvetica, sans-serif";
	$g_font_small              = "8pt";
	$g_font_normal             = "10pt";
	$g_font_large              = "12pt";
	$g_font_color              = "#000000"; # black

	###############################
	# Mantis Cookie Variables
	###############################

	# --- cookie path ---------------
	# set this to something more restrictive if needed
	# http://www.php.net/manual/en/function.setcookie.php
	$g_cookie_path = "/";
	# unused
	$g_cookie_domain = ".mydomain.extension";
	# cookie version for view_all_page
	$g_cookie_version = "v3";

	# --- cookie prefix ---------------
	# set this to a unique identifier.  No spaces.
	$g_cookie_prefix = "MANTIS";

	# --- cookie names ----------------
	$g_string_cookie           = $g_cookie_prefix."_STRING_COOKIE";
	$g_project_cookie          = $g_cookie_prefix."_PROJECT_COOKIE";
	$g_view_all_cookie         = $g_cookie_prefix."_VIEW_ALL_COOKIE";
	$g_manage_cookie           = $g_cookie_prefix."_MANAGE_COOKIE";

	# --- cookie values ---------------
	$g_string_cookie_val           = "";
	$g_project_cookie_val          = "";
	$g_view_all_cookie_val         = "";
	$g_manage_cookie_val           = "";

	if ( isset( $HTTP_COOKIE_VARS[$g_string_cookie] ) ) {
		$g_string_cookie_val         = $HTTP_COOKIE_VARS[$g_string_cookie];
	}
	if ( isset( $HTTP_COOKIE_VARS[$g_project_cookie] ) ) {
		$g_project_cookie_val        = $HTTP_COOKIE_VARS[$g_project_cookie];
	}
	if ( isset( $HTTP_COOKIE_VARS[$g_view_all_cookie] ) ) {
		$g_view_all_cookie_val       = $HTTP_COOKIE_VARS[$g_view_all_cookie];
	}
	if ( isset( $HTTP_COOKIE_VARS[$g_manage_cookie] ) ) {
		$g_manage_cookie_val  = $HTTP_COOKIE_VARS[$g_manage_cookie];
	}

	#######################################
	# Mantis Database Table Variables
	#######################################

	# --- table prefix ----------------
	# if you change this remember to reflect the changes in the database
	$g_db_table_prefix = "mantis";

	# --- table names -----------------
	$g_mantis_bug_file_table          = $g_db_table_prefix."_bug_file_table";
	$g_mantis_bug_table               = $g_db_table_prefix."_bug_table";
	$g_mantis_bug_text_table          = $g_db_table_prefix."_bug_text_table";
	$g_mantis_bugnote_table           = $g_db_table_prefix."_bugnote_table";
	$g_mantis_bugnote_text_table      = $g_db_table_prefix."_bugnote_text_table";
	$g_mantis_news_table              = $g_db_table_prefix."_news_table";
	$g_mantis_project_category_table  = $g_db_table_prefix."_project_category_table";
	$g_mantis_project_file_table      = $g_db_table_prefix."_project_file_table";
	$g_mantis_project_table           = $g_db_table_prefix."_project_table";
	$g_mantis_project_user_list_table = $g_db_table_prefix."_project_user_list_table";
	$g_mantis_project_version_table   = $g_db_table_prefix."_project_version_table";
	$g_mantis_user_table              = $g_db_table_prefix."_user_table";
	$g_mantis_user_profile_table      = $g_db_table_prefix."_user_profile_table";
	$g_mantis_user_pref_table         = $g_db_table_prefix."_user_pref_table";
	$g_mantis_bug_monitor_table       = $g_db_table_prefix."_bug_monitor_table";

	###########################
	# Mantis Enum Strings
	###########################

	# --- enum strings ----------------
	$g_access_levels_enum_string      = "10:viewer,25:reporter,40:updater,55:developer,70:manager,90:administrator";
	$g_project_status_enum_string     = "10:development,30:release,50:stable,70:obsolete";
	$g_project_view_state_enum_string = "10:public,50:private";

	$g_priority_enum_string           = "10:none,20:low,30:normal,40:high,50:urgent,60:immediate";
	$g_severity_enum_string           = "10:feature,20:trivial,30:text,40:tweak,50:minor,60:major,70:crash,80:block";
	$g_reproducibility_enum_string    = "10:always,30:sometimes,50:random,70:have not tried,90:unable to duplicate,100:N/A";
	$g_status_enum_string             = "10:new,20:feedback,30:acknowledged,40:confirmed,50:assigned,80:resolved,90:closed";
	$g_resolution_enum_string         = "10:open,20:fixed,30:reopened,40:unable to duplicate,50:not fixable,60:duplicate,70:not a bug,80:suspended,90:won't fix";
	$g_projection_enum_string         = "10:none,30:tweak,50:minor fix,70:major rework,90:redesign";
	$g_eta_enum_string                = "10:none,20:< 1 day,30:2-3 days,40:< 1 week,50:< 1 month,60:> 1 month";

	#############################
	# Mantis Page Variables
	#############################

	#----------------------------------
	# extensions for php 3 and php 4
	# set this to php for php4 or whatever your webserver needs
	$g_php             = ".php";
	#----------------------------------

	#############################
	# Mantis Javascript Variables
	#############################
	#----------------------------------
	# allow the use of Javascript?
	# @@@ not yet implemented, but wanted this in config for 0.17.2+ -SC
	$g_use_javascript  = ON;
	#----------------------------------
?>
