/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

#ifndef _RTP_TRANSPORT_STREAM_H
#define _RTP_TRANSPORT_STREAM_H

#include "rtpdefines.h"


#if defined(__cplusplus)
extern "C" {
#endif

    extern int rtp_transport_stream_listen(int session_type,
					   RTPSOCKET* rtpsock,
					   RTPSOCKET* rtcpsock,
					   struct sockaddr* rtp_local_addr,
					   struct sockaddr* rtcp_local_addr);
    
    extern int rtp_transport_stream_accept(int session_type,
					   RTPSOCKET rtplisten,
					   RTPSOCKET rtcplisten,
					   RTPSOCKET* rtpsock,
					   RTPSOCKET* rtcpsock,
					   struct sockaddr* rtp_peer_addr, 
					   struct sockaddr* rtcp_peer_addr,
					   int* retval_syserror);

    extern int rtp_transport_stream_connect(int session_type,
					    RTPSOCKET* rtpsock,
					    RTPSOCKET* rtcpsock,
					    struct sockaddr* rtp_peer_addr,
					    struct sockaddr*
					    rtcp_peer_addr, int* retval_syserror);
#if defined(__cplusplus)
}
#endif

#endif /* _RTP_TRANSPORT_STREAM_H */


