/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */
/*
 * $Id: mas_types.h,v 1.5 2003/10/06 21:31:23 silvio Exp $
 *
 * Copyright (c) 1999, 2000 Shiman Associates, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without
 * fee, provided that the above copyright notice appear in all copies
 * and that both that copyright notice and this permission notice
 * appear in supporting documentation, and that Shiman Associates,
 * Inc.  not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission.  Shiman Associates, Inc. makes no representations about
 * the suitability of this software for any purpose.  It is provided
 * "as is" without express or implied warranty.
 *
 * SHIMAN ASSOCIATES INC. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL SHIMAN ASSOCIATES INC. BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.  
 *
 */

/*
 * SYSTEM-WIDE TYPE AND DATA STRUCTURE DEFINITIONS
 *
 * USED IN THE SERVER, DEVICES, AND CLIENTS.
 *
 */

#ifndef _MAS_TYPES_H
#define _MAS_TYPES_H
#include <sys/types.h>
#include "mas/mas_constants.h"


/* Integers **************************************************************/

#ifdef LP64
typedef long            int64;
typedef unsigned long   u_int64;
#else
#undef int64
#undef u_int64
#endif

#ifndef AIXV3
typedef int                 int32;
typedef short int           int16;
typedef char                int8;
typedef unsigned int        u_int32;
typedef unsigned short int  u_int16;
typedef unsigned char       u_int8;
#endif
typedef unsigned int        uint32;
typedef unsigned short int  uint16;
typedef unsigned char       uint8;

/* Network Time Protocol (NTP) "timeval-style" structure.
 * 
 * Time is in seconds and fractional seconds since 0h on 01 Jan 1900.
 *
 */
struct mas_ntpval
{
    u_int32 secs;
    u_int32 frac;
};

#define MAS_SOCKET int

/************************************************************************
 * mas_event
 *
 * Specifies an action with a predicate, relative to a given device.
 * One uses this structure to program the scheduler to act.
 *
 ************************************************************************/
struct mas_event
{
    uint32              id;
    
    char*               action_name; /* name of the action to trigger */
    int16               action_index; /* cached. Only valid if "valid_action_index" is set. */
    int                 valid_action_index;
    int32               device_instance; /* action specified relative
                                            to this device instance */
    void*               predicate; /* additional information supplied
				      with the action; a form of
				      argument */
    uint32              predicate_length;

    char                type;

    /* ports we depend on to act */
    int32*              port_dependencies;
    uint32              num_port_dependencies;

    /* signal we depend on to act.  signal_dep is signal's value + 1.
     * If zero, we don't depend on a signal. */
    int                 signal_dep;
    
    /* clocks, in units of clkid - *may* be in sc units */
    uint32              period;        /* in units of clkid */
    int32               clkid;         /* clock id number */
    uint32              next_act_time; /* next action, clkid units */
    uint32              last_act_time; /* last action, clkid units */

    uint32              act_time; /* for non-periodic actions */
    int32               delta;

    /* clocks controlled by scheduler, in scheduler clock (sc) units
     * (typically microseconds) */
    uint32              last_act_time_sc; /* derived from above */
    uint32              next_act_time_sc; /* derived from above */

    uint32              act_time_sc; /* for non-periodic actions */
    int32               sc_valid; /* boolean flag */
    
    uint32              adjustment_sc;
    int32               adjusted; /* boolean flag */

    int32               priority;
    uint32              count;

    int32               response; /* portnum of response port: destination */
    int32               reaction; /* cache of reaction port number for
                                   * periodic events */

    /* The event that caused this event.  Can be used to track chains
     * of events, one event causing the next, and so on.  */
    uint32              source_event_id; 

    /* source_device_instance is the device instance of the event's
     * source, typically the net device for client-instantiated
     * devices.  source_device_subscript is an additional specifier
     * that may be used by the source device to label the event as
     * originating from a device sub-component, i.e. one client of a
     * net device, or one participant in a conference, etc.*/
    int32               source_device_instance;
    uint32              source_device_subscript;
    
    struct mas_event*   next;  /* if used in a doubly-linked list */
    struct mas_event*   prev;
    /* ---------------------------------------------------- */
};


/************************************************************************
 * mas_data_header
 *
 * This is the header for the mas_data structure defined below.
 *
 ************************************************************************/
struct mas_data_header
{
    /*** timestamp & sequence number info.  we may not end up needing
	 all this */ 
    u_int32            ntp_seconds;     /* network time protocol */
    u_int32            ntp_fraction;
    u_int32            media_timestamp; /* timestamp in media units --
					   samples, frames, etc. */
    u_int8             type;            /* maps to RTP PT */
    u_int8             mark;            /* maps to RTP mark */
    u_int32            sequence;        /* sequence number,
					   incremented once per event */
};

/************************************************************************
 * mas_data
 *
 * It's the universal data type for passing information from mas_port
 * to mas_port.  Its members are a header, a data segment, the actual
 * length of the data segment, the total allocated length of the data
 * segment, and a next data pointer for use in queueing.  The length
 * cannot exceed the allocated_length, and the segment can't be a
 * pointer to static data - it has to be freeable.  When mas_data is
 * used on it's own, "next" is assumed to be NULL.  When used as part
 * of a queue, "next" points to the next mas_data struct in the queue;
 * the end of the queue is marked by a NULL "next" pointer.
 *
 ************************************************************************/
struct mas_data
{
    struct mas_data_header  header;
    u_int16                 length;
    u_int16                 allocated_length;
    char*                   segment;
    struct mas_data*        next;
};

/************************************************************************
 * mas_data_characteristic
 *
 * ..
 *
 ************************************************************************/
struct mas_data_characteristic
{
    int32  numkeys;
    int32  allocated_keys;
    char** keys;   /* array of strings */
    char** values; /* array of strings */
};

/************************************************************************
 * mas_characteristic_matrix
 *
 * ..
 *
 ************************************************************************/
struct mas_characteristic_matrix
{
    int32   rows;
    int32   cols;   /* also, number of keys */
    char*   name;
    char**  keys;   /* array of strings */
    char*** matrix; /* matrix of strings, indexed [row][col] */
};


struct mas_package
{
    char*  contents;
    int    allocated_size;
    int    size;
    uint16 members;
    int    v; /* version */
    int    nbo; /* is network byte order */
    int    aw; /* # of additional words */
    int    flags;
    int32  error; /* if negative, error occurred; error contains the
                     code */
    char** key; /* array of pointers to key strings in the contents */
    char*  p; /* start of empty space */
};

struct mas_mc_clkval
{
    int32   id;
    uint32  ts_us;
    uint32  val;
    int     veto;
    int     newmeas;
    double  expected_rate; /* The mc will synthesize its clock at this
                            * rate initially, before any measurements
                            * are taken. */
    double  valid_sdev;   /* If less than 1.0E+6, clock rate estimates
                             are not used until the standard deviation
                             of the rate estimates is less than valid_sdev. */
};

struct mas_stats
{
    double* val; /* the last N values */

    double win_sum;
    double win_mean;
    double win_sq_error_sum;
    double win_std_dev;
    double win_min;
    double win_max;

    double max;
    double min;
    double mean;
    double sum;

    int8 valid;
    int8 compute;
    
    int i;
    int N;
    int win_size;
    int count;
};


#endif /* _MAS_TYPES_H */
