/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "mas/mas_api_internal.h"

#define DEFAULT_PACKAGE_SIZE 10240

/** LOCAL PROTOTYPES *****************************************************/


/** EXPORTED FUNCTIONS ***************************************************/

int32
mas_get( mas_device_t device, char* key, struct mas_package* arg, struct mas_package* rpack )
{
    struct mas_event   event;
    struct mas_package ppkg;
    char pbuf[DEFAULT_PACKAGE_SIZE];
    int32 err;

    masc_setup_event( &event );
    event.action_name = "mas_get";
    event.device_instance = device->device_instance;

    /* stuff the predicate package */
    masc_setup_package( &ppkg, pbuf, sizeof pbuf, MASC_PACKAGE_STATIC );
    masc_pushk_string( &ppkg, "key", key );
    if ( arg != NULL && arg->contents != NULL ) masc_pushk_package( &ppkg, "arg", arg );
    masc_finalize_package( &ppkg );
    event.predicate = ppkg.contents;
    event.predicate_length = ppkg.size;

    /* package & send event to server */
    mas_send_event( &event, device->control_channel );
    masc_strike_package( &ppkg );

    /* wait for the reply, then form into package */
    err = mas_recv_package( device->control_channel, rpack );
    if ( err < 0 ) return err;

    return 0;
}


int32
mas_set( mas_device_t device, char* key, struct mas_package* arg )
{
    struct mas_event   event;
    struct mas_package ppkg;
    char pbuf[DEFAULT_PACKAGE_SIZE];
    int32 err;

    /* we can't do this without an argument */
    if ( arg == NULL || arg->contents == NULL )
        return mas_error(MERR_INVALID);

    masc_setup_event( &event );
    event.action_name = "mas_set";
    event.device_instance = device->device_instance;

    /* stuff the predicate package */
    masc_setup_package( &ppkg, pbuf, sizeof pbuf, MASC_PACKAGE_STATIC );
    masc_pushk_string( &ppkg, "key", key );
    masc_pushk_package( &ppkg, "arg", arg );
    masc_finalize_package( &ppkg );
    event.predicate = ppkg.contents;
    event.predicate_length = ppkg.size;

    /* package & send event to server */
    err = mas_send_event( &event, device->control_channel );
    masc_strike_package( &ppkg );

    return err;
}
