/* massXpert - the true massist's program.
   --------------------------------------
   Copyright(C) 2006,2007 Filippo Rusconi

   http://www.massxpert.org/massXpert

   This file is part of the massXpert project.

   The massxpert project is the successor to the "GNU polyxmass"
   project that is an official GNU project package(see
   www.gnu.org). The massXpert project is not endorsed by the GNU
   project, although it is released ---in its entirety--- under the
   GNU General Public License. A huge part of the code in massXpert
   is actually a C++ rewrite of code in GNU polyxmass. As such
   massXpert was started at the Centre National de la Recherche
   Scientifique(FRANCE), that granted me the formal authorization to
   publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License version 3, as published by the Free Software Foundation.
   

   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this software; if not, write to the

   Free Software Foundation, Inc.,

   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
*/


/////////////////////// Qt includes
#include <QDebug>
#include <QHeaderView>
#include <QMouseEvent>


/////////////////////// Local includes
#include "mzLabOutputOligomerTreeViewModel.hpp"
#include "mzLabOutputOligomerTreeViewSortProxyModel.hpp"
#include "mzLabOutputOligomerTreeView.hpp"
#include "mzLabOutputOligomerTreeViewItem.hpp"
#include "cleaveOligomerTreeViewMimeData.hpp"
#include "oligomer.hpp"
#include "mzLabWnd.hpp"
#include "mzLabOutputOligomerTreeViewDlg.hpp"
#include "application.hpp"


namespace massXpert
{

  MzLabOutputOligomerTreeView::MzLabOutputOligomerTreeView(QWidget *parent)
    : QTreeView(parent)
  {

    setAlternatingRowColors(true);
    setAllColumnsShowFocus(true);
    //    setSortingEnabled(true);
  
    QHeaderView *headerView = header();
  
    headerView->setClickable(true);
    headerView->setMovable(true);

    setAcceptDrops(true);
    setDropIndicatorShown(true);

    connect(this,
	     SIGNAL(activated(const QModelIndex &)),
	     this,
	     SLOT(itemActivated(const QModelIndex &)));  
  }


  MzLabOutputOligomerTreeView::~MzLabOutputOligomerTreeView()
  {
  }


  MzLabOutputOligomerTreeViewDlg *
  MzLabOutputOligomerTreeView::getParentDlg()
  {
    return mp_parentDlg;
  }
  
  void 
  MzLabOutputOligomerTreeView::setParentDlg(MzLabOutputOligomerTreeViewDlg *dlg)
  {
    Q_ASSERT(dlg);
    mp_parentDlg = dlg;
  }

  
  MzLabWnd *
  MzLabOutputOligomerTreeView::getMzLabWnd()
  {
    return mp_mzLabWnd;
  }
  

  void 
  MzLabOutputOligomerTreeView::setMzLabWnd(MzLabWnd *wnd)
  {
    Q_ASSERT(wnd);
    
    mp_mzLabWnd = wnd;
  }

  void 
  MzLabOutputOligomerTreeView::itemActivated(const QModelIndex &index)
  {
    if (!index.isValid())
      return;

    MzLabOutputOligomerTreeViewModel *model();
  
    MzLabOutputOligomerTreeViewItem *childItem = 
      static_cast<MzLabOutputOligomerTreeViewItem *> 
     (index.internalPointer());
    
    OligomerPair *oligomerPair = childItem->oligomerPair();

    const Oligomer *oligomer2 = oligomerPair->oligomer2();

//     qDebug() << __FILE__ << __LINE__
// 	     << oligomer2->name();
    
    // From the oligomerPair, the oligomer of interest is the 2. Check
    // that its mp_polymer member is still non-0.

    const Polymer *polymer = oligomer2->polymer();
    
    if (!polymer)
      {
// 	qDebug() << __FILE__ << __LINE__;
	
	return;
      }
    
    // Get the sequence editor window pointer out of the oligomer, if
    // it has one in the form of a NoDeletePointerProp.

    Prop *prop = const_cast<Oligomer *>(oligomerPair->oligomer2())->
      prop("SEQUENCE_EDITOR_WND");
    
    if (!prop)
      {
// 	qDebug() << __FILE__ << __LINE__;
	
	return;
      }
    
    SequenceEditorWnd *editorWnd = 
      static_cast<SequenceEditorWnd *>(prop->data());

    if (!editorWnd)
      return;
    
    CoordinateList *coordinateList = 
      static_cast<CoordinateList *>(const_cast<Oligomer *>(oligomer2));
  
    // Remove the previous selection, so that we can start fresh.
    editorWnd->mpa_editorGraphicsView->resetSelection();
  
    for (int iter = 0; iter < coordinateList->size(); ++iter)
      {
	Coordinates *coordinates = coordinateList->at(iter);
	
	int start = coordinates->start();
	int end = coordinates->end();
	
	if(start >= polymer->size() ||
	    end >= polymer->size())
	  {
	    QMessageBox::warning(this,
				  tr("massXpert - Cleavage"),
				  tr("%1@%2\n"
				      "The monomer indices do not correspond "
				      "to a valid polymer sequence range.\n"
				      "Avoid modifying the sequence while "
				      "working with oligomers.")
				  .arg(__FILE__)
				  .arg(__LINE__),
				  QMessageBox::Ok);
	    
	    return;
	  }
	
	editorWnd->mpa_editorGraphicsView->setSelection(*coordinates, 
							 true, false);
      }
    
    editorWnd->updateSelectedSequenceMasses();  
  }
  

} // namespace massXpert
