/* matchbox - a lightweight window manager

   Copyright 2002 Matthew Allum

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/

#ifndef _MBTHEME_H_
#define _MBTHEME_H_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/Xresource.h>
#include <X11/Xmd.h>
#include <X11/keysym.h>
#include <X11/cursorfont.h>

#include "structs.h"
#include "xml.h"
#include "wm.h"
#include "list.h"

#ifdef USE_XFT
#include <X11/Xft/Xft.h>
#endif

#define FRAME_MAIN_HEIGHT        20
#define FRAME_DIALOG_HEIGHT      20
#define FRAME_DIALOG_BORDER_SIZE 1
#define FRAME_TOOLBAR_MAX_SIZE   16
#define FRAME_TOOLBAR_MIN_SIZE   16

#define THEME_LINE_WIDTH         3

#define THEME_FG_COLOR           "#666666"
#define THEME_BG_COLOR           "#ccccee"
#define THEME_TEXT_COLOR         "#666666"


#ifdef USE_XFT
#define THEME_FONT_MAIN    "sans serif-10:bold"
#define THEME_FONT_TOOLBAR "sans serif-8:bold"
#else
#define THEME_FONT_MAIN    "fixed"
#define THEME_FONT_TOOLBAR "5x7"
#endif


typedef struct _mbtheme {

  XColor col_fg;
  XColor col_bg;
  XColor col_text;

  GC gc;
  GC mask_gc;
  GC band_gc;

#ifdef USE_XFT
  XftFont *font;
  XftFont *font_toolbar;
  XftColor xftcol;
#else
  XFontStruct* font;
  XFontStruct* font_toolbar;
#endif

  struct _wm *wm;
   
} MBTheme;


void     theme_paint_rgba_icon            (MBTheme       *t,
					   Client        *c,
					   Drawable       drw,
					   int            x,
					   int            y,
					   int           *data);

void     theme_frame_icon_paint           (MBTheme       *t,
					   Client        *c,
					   MBPixbufImage *img_dest,
					   int            x,
					   int            y);


Bool     theme_frame_wants_shaped_window  (MBTheme       *theme,
					   int            frame_type);

Bool     theme_frame_supports_button_type (MBTheme       *theme,
					   int            frame_type,
					   int            button_type);

int      theme_frame_defined_width_get    (MBTheme       *theme,
					   int            frame_type );

int      theme_frame_defined_height_get   (MBTheme       *theme,
					   int            frame_ref );

Bool
theme_has_frame_type_defined (MBTheme      *theme, 
			      int           frame_type);


void     theme_img_cache_clear            (MBTheme       *theme,
					   int            frame_ref );

void     theme_img_cache_clear_all        (MBTheme       *theme );

void     theme_frame_button_paint         (MBTheme       *theme,
					   Client        *c,
					   int            action,
					   int            state,
					   int            frame_type,
					   int            dest_w,
					   int            dest_h );

Bool     theme_frame_paint                (MBTheme       *theme,
					   Client        *c,
					   int            frame_ref,
					   int            dx,
					   int            dy,
					   int            dw,
					   int            dh );

void     theme_frame_menu_paint           (MBTheme       *theme,
					   Client        *c);

Bool     theme_frame_menu_get_dimentions  (MBTheme       *theme,
					   int           *w,
					   int           *h);

MBTheme* mbtheme_new                      (Wm            *w);

void     mbtheme_switch                   (Wm            *w,
					   char          *new_theme_conf);

void     mbtheme_init                     (Wm            *w,
					   char          *theme_conf);

int      theme_frame_button_get_x_pos     (MBTheme       *theme,
					   int            frame_type,
					   int            button_type,
					   int            width);



#endif
