/* matchbox - a lightweight window manager

   Copyright 2002 Matthew Allum

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/

#ifndef _MBTHEME_H_
#define _MBTHEME_H_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/Xresource.h>
#include <X11/Xmd.h>
#include <X11/cursorfont.h>

#include "mbpixbuf.h"

#ifdef USE_XFT
#include <X11/Xft/Xft.h>
#endif

#include "structs.h"
#include "xml.h"
#include "wm.h"
#include "list.h"

typedef struct _mb_theme_param {
   enum { pixel, percentage, object, textx, textw } unit;
   signed int value;
   signed int offset;
} MBThemeParam;

enum {
  LAYER_GRADIENT_HORIZ = 1,
  LAYER_GRADIENT_VERT,
  LAYER_LABEL,
  LAYER_PLAIN,
  LAYER_PIXMAP,
  LAYER_PIXMAP_TILED,
  LAYER_PICTURE,
  LAYER_PICTURE_TILED,
  LAYER_ICON,

} MBThemeLayerType;

typedef struct _mb_theme_color 
{
   XColor xcol;

#ifdef USE_XFT
   XftColor xftcol;
#endif
  int alpha;

} MBThemeColor;

typedef struct _mb_theme_font 
{
#ifdef USE_XFT
   XftFont *font;
#else
   XFontStruct* font;
#endif
 
} MBThemeFont;


typedef struct _mb_theme_label 
{
  Alignment justify;
  struct _mb_theme_color *col;
  struct _mb_theme_color *bgcol;
  struct _mb_theme_font  *font;
} MBThemeLabel;

typedef struct _mb_theme_button {
   
  int action;

  Bool inputonly;
  Bool wants_dbl_click;
   
  MBThemeParam *x;
  MBThemeParam *y;
  MBThemeParam *w;
  MBThemeParam *h;

  MBPixbufImage *img_active;
  MBPixbufImage *img_inactive;

  int img_active_blend;
  int img_inactive_blend;
   
} MBThemeButton;

typedef struct _mb_theme_layer {

  MBThemeParam *x;
  MBThemeParam *y;
  MBThemeParam *w;
  MBThemeParam *h;
  
  MBThemeColor  *color;
  MBPixbufImage *img;
  MBThemeLabel  *label;  
  
  MBThemeColor  *color_end; 	/* for gradients */
  
} MBThemeLayer;


typedef struct _mb_theme_frame 
{
  char *options;

  struct list_item* layers;
  struct list_item* buttons;

  struct _mb_theme_color *border_col;

  int set_width;
  int set_height;
  
  MBThemeFont* font;
  MBThemeColor* color;

  Bool wants_shape;

 /* needed Below ?  */

  int type;
  int size;

  int label_w;
  int label_h; 
  int label_x;
   
  int cur_width;
   
} MBThemeFrame;


typedef struct _mbtheme {

  struct list_item* frames;
  struct list_item* images;
  struct list_item* pictures;
  struct list_item* colors;
  struct list_item* fonts;

  GC gc;
  GC mask_gc;
  GC band_gc; 	/* for drag window  */

  MBPixbufImage* img_caches[N_FRAME_TYPES];

  struct _wm *wm;
   
} MBTheme;


void     theme_paint_rgba_icon            (MBTheme       *t,
					   Client        *c,
					   Drawable       drw,
					   int            x,
					   int            y,
					   int           *data);

void     theme_frame_icon_paint           (MBTheme       *t,
					   Client        *c,
					   MBPixbufImage *img_dest,
					   int            x,
					   int            y);

Bool     theme_frame_wants_shaped_window  (MBTheme       *theme,
					   int            frame_type);

Bool     theme_frame_supports_button_type (MBTheme       *theme,
					   int            frame_type,
					   int            button_type);

Bool
theme_has_frame_type_defined               (MBTheme      *theme, 
					    int           frame_type);

int      theme_frame_defined_width_get    (MBTheme       *theme,
					   int            frame_type );

int      theme_frame_defined_height_get   (MBTheme       *theme,
					   int            frame_ref );

void     theme_img_cache_clear            (MBTheme       *theme,
					   int            frame_ref );

void     theme_img_cache_clear_all        (MBTheme       *theme );

void     theme_frame_button_paint         (MBTheme       *theme,
					   Client        *c,
					   int            action,
					   int            state,
					   int            frame_type,
					   int            dest_w,
					   int            dest_h );

Bool     theme_frame_paint                (MBTheme       *theme,
					   Client        *c,
					   int            frame_ref,
					   int            dx,
					   int            dy,
					   int            dw,
					   int            dh );

void     theme_frame_menu_paint           (MBTheme       *theme,
					   Client        *c);

Bool     theme_frame_menu_get_dimentions  (MBTheme       *theme,
					   int           *w,
					   int           *h);

MBTheme* mbtheme_new                      (Wm            *w);

void     mbtheme_switch                   (Wm            *w,
					   char          *new_theme_conf);

void     mbtheme_init                     (Wm            *w,
					   char          *theme_conf);

int      theme_frame_button_get_x_pos     (MBTheme       *theme,
					   int            frame_type,
					   int            button_type,
					   int            width);



#endif
