(* Copyright (C) 2000, HELM Team.
 * 
 * This file is part of HELM, an Hypertextual, Electronic
 * Library of Mathematics, developed at the Computer Science
 * Department, University of Bologna, Italy.
 * 
 * HELM is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * HELM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with HELM; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA  02111-1307, USA.
 * 
 * For details, see the HELM World-Wide-Web page,
 * http://cs.unibo.it/helm/.
 *)


 (** THIS MODULE SHOULD BE USED ONLY BY CoercGraph/CicCoercion/librarySync
  * 
  *   and may be merged with CicCoercion...
  *  
  * **)


  (** XXX WARNING: non-reentrant *)
type coerc_carr = 
  | Uri of UriManager.uri (* const, mutind, mutconstr *)
  | Sort of Cic.sort (* Prop, Set, Type *) 
  | Term of Cic.term (* nothing supported *)
  | Fun of int
;;
  
exception EqCarrNotImplemented of string Lazy.t
exception EqCarrOnNonMetaClosed
val eq_carr: ?exact:bool -> coerc_carr -> coerc_carr -> bool
val coerc_carr_of_term: Cic.term -> coerc_carr
val name_of_carr: coerc_carr -> string
val uri_of_carr: coerc_carr -> UriManager.uri option

val to_list:
  unit -> 
    (coerc_carr * coerc_carr * (UriManager.uri * int) list) list

val add_coercion:
  coerc_carr * coerc_carr * UriManager.uri * int -> unit

val remove_coercion:
  (coerc_carr * coerc_carr * UriManager.uri * int -> bool) -> unit

val find_coercion: 
  (coerc_carr * coerc_carr -> bool) -> (UriManager.uri * int) list 
    
val is_a_coercion: UriManager.uri -> bool
val is_a_coercion': Cic.term -> bool
val is_a_coercion_to_funclass: Cic.term -> int option
val get_carr: UriManager.uri -> coerc_carr * coerc_carr

val term_of_carr: coerc_carr -> Cic.term

