#include "Oms/OMS_SharedMemAllocator.hpp"
#include "Oms/OMS_Globals.hpp"
#include "Oms/OMS_Malloc.hpp"
#ifdef USE_SYSTEM_ALLOC_CO13
#include "geo573.h"
#endif

OMS_SharedMemAllocator OMS_Globals::m_sharedMemAllocatorInstance;

OMS_SharedMemAllocator::OMS_SharedMemAllocator() {}

void* OMS_SharedMemAllocator::allocateImpl(size_t size)
{
  return OMS_Globals::KernelInterfaceInstance->OmsAllocate(size);
}

void OMS_SharedMemAllocator::deallocateImpl(void* p) 
{
  if (NULL == p) { 
    return;
  }
  OMS_Globals::KernelInterfaceInstance->OmsDeallocate(p);
}


#if defined( USE_SYSTEM_ALLOC_CO13 ) && defined( WIN32 )
void *operator new(size_t sz) THROW_NEW_GEO573 
{
	return omsMalloc(sz);
}

void *operator new[](size_t sz) THROW_NEW_GEO573
{
	return omsMallocArray(sz);
}

void operator delete(void *p) THROW_DELETE_GEO573
{
	omsFree(p);
}

void operator delete[](void *p) THROW_DELETE_GEO573
{
	omsFreeArray(p);
}
#endif
