/*!******************************************************************************

  @file         hbd31.h

  ------------------------------------------------------------------------------

  @author       JuergenP

  @brief        leafhandling

\if EMIT_LICENCE  

    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.
 
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
 
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
\endif

********************************************************************************/

#ifndef HBD31_H
#define HBD31_H


/*===========================================================================*
 *     RefType: C++                                                          *
 *===========================================================================*/

/*===========================================================================*
 *     MD5: '\x4d\x6a\x36\x7b\x7d\xd4\x1c\xc0\xfd\x70\x43\xa2\x54\x7c\xaf\x74'
 *===========================================================================*/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"
#include "ggg00.h"
#include "gbd00.h"


/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

externPascal void b31add_to_leaf (
    tgg00_Rec             &  b,
    tbd_node_ptrs         &  nptr,
    integer                  index,
    tsp00_PageNo             left,
    tbd_current_tree      &  current);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b31append_to_leaf (
    tgg00_Rec             &  b,
    tbd_node_ptrs         &  nptr,
    integer                  index,
    integer                  page_fill_limit,
    tsp00_PageNo             left,
    tbd_current_tree      &  current);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b31del_from_leaf (
    tbd_node_ptrs         &  nptr,
    integer                  index,
    tsp00_PageNo             left,
    tbd_current_tree      &  current);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b31get_from_leaf (
    tbd_node_ptrs         &  nptr,
    integer                  index,
    pasbool                  with_kb_lock,
    tgg00_Rec             &  b,
    tbd_current_tree      &  current);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b31next_search (
    tbd_node_ptrs         &  nptr,
    integer               &  index,
    tbd_current_tree      &  current);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b31nfill_recordbuffer (
    tbd_node_ptrs         &  nptr,
    tgg00_Lkey            &  test_key,
    tgg00_FilePos         &  tree_pos,
    tgg00_BdSetResultRecord  &  set_result,
    void                  *  b,
    tbd_current_tree      &  current);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b31pfill_recordbuffer (
    tbd_node_ptrs         &  nptr,
    tgg00_Lkey            &  test_key,
    tgg00_FilePos         &  tree_pos,
    tgg00_BdSetResultRecord  &  set_result,
    void                  *  b,
    tbd_current_tree      &  current);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b31pointer_list (
    tbd_nodeptr           &  nptr);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b31prev_search (
    tsp00_Key             &  reckey,
    tsp00_Int4               KeyLen,
    tbd_node_ptrs         &  nptr,
    integer               &  index,
    tsp00_PageNo          &  prev_leaf,
    tbd_current_tree      &  current);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b31repl_in_leaf (
    tgg00_Rec             &  b,
    tbd_node_ptrs         &  nptr,
    integer                  index,
    tsp00_PageNo             left,
    tbd_current_tree      &  current);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b31search_entry (
    tbd_current_tree      &  current,
    tsp00_Key             &  rk,
    tsp00_Int4               KeyLen,
    tbd_nodeptr           &  nptr,
    tsp00_Int4            &  index,
    tbd_searchresult      &  result);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b31sort_entries (
    tbd_nodeptr           &  nptr,
    tgg00_TransContextPtr     t);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b31t_append_to_temp_leaf (
    tgg00_Rec             &  b,
    tbd_node_ptrs         &  nptr,
    tgg00_FilePos         &  tree_pos,
    tbd_current_tree      &  current);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b31t_prev_temp_search (
    tbd_node_ptrs         &  nptr,
    integer               &  index,
    tbd_current_tree      &  current);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void b31w_next_search (
    tbd_node_ptrs         &  nptr,
    integer               &  index,
    tbd_current_tree      &  current);

/* Don't edit this file by hand, it is generated by ptocProto.py */


#endif

