/*
    ========== licence begin  GPL
    Copyright (c) 2004-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

 */
#ifndef CONVERTER_MESSAGES_HPP
#define CONVERTER_MESSAGES_HPP

// Generated Header file Converter_Messages.hpp.
// Generated by genmsg V2.2 DO NOT EDIT

#include "SAPDBCommon/ErrorsAndMessages/SAPDBErr_MessageList.hpp"

#define CONVERTER_IPAGE_ENTRY_IN_USE_CONFLICT1   SAPDBErr_MessageList::Error,0,"Converter page entry %s marked as used; invalid i/o blockaddress %s found",2
#define CONVERTER_IPAGE_ENTRY_IN_USE_CONFLICT1_ID 0
#define CONVERTER_IPAGE_ENTRY_IN_USE_CONFLICT2   SAPDBErr_MessageList::Error,1,"Converter page entry %s marked as unused; invalid entry refs (backward: %s, forward: %s) found",3
#define CONVERTER_IPAGE_ENTRY_IN_USE_CONFLICT2_ID 1
#define CONVERTER_IPAGE_ENTRY_IN_USE_CONFLICT3   SAPDBErr_MessageList::Error,2,"Converter page entry %s marked as unused, but also marked with 'savepages requested",1
#define CONVERTER_IPAGE_ENTRY_IN_USE_CONFLICT3_ID 2
#define CONVERTER_IPAGE_ENTRY_IN_USE_CONFLICT4   SAPDBErr_MessageList::Error,3,"Converter page entry %s marked as unused, but also marked with 'savepages done'",1
#define CONVERTER_IPAGE_ENTRY_IN_USE_CONFLICT4_ID 3
#define CONVERTER_IPAGE_ENTRY_IN_USE_CONFLICT5   SAPDBErr_MessageList::Error,4,"Converter page entry %s reservd, but not used",1
#define CONVERTER_IPAGE_ENTRY_IN_USE_CONFLICT5_ID 4
#define CONVERTER_IPAGE_WRONG_COUNTER1           SAPDBErr_MessageList::Error,5,"Sum of free (= %s) and used entries (= %s) is not equal to the number of all entries (=%s)",3
#define CONVERTER_IPAGE_WRONG_COUNTER1_ID 5
#define CONVERTER_IPAGE_WRONG_COUNTER2           SAPDBErr_MessageList::Error,6,"Number of reserved entries (= %s) as stored in the page header is different from real number (=%s)",2
#define CONVERTER_IPAGE_WRONG_COUNTER2_ID 6
#define CONVERTER_DBFULL                         SAPDBErr_MessageList::Error,7,"Database full. No more space on data volumes.",0
#define CONVERTER_DBFULL_ID 7
#define CONVERTER_NOENTRY                        SAPDBErr_MessageList::Error,8,"No valid converter entry found for %s pageno '%s'",2
#define CONVERTER_NOENTRY_ID 8
#define CONVERTER_BAD_ENTRY_STATE                SAPDBErr_MessageList::Error,9,"Error occured by processing %s pageno %s",2
#define CONVERTER_BAD_ENTRY_STATE_ID 9
#define CONVERTER_INVALIDVERSION                 SAPDBErr_MessageList::Error,10,"Invalid converter version '%s' encountered. Actual version is '%s'",2
#define CONVERTER_INVALIDVERSION_ID 10
#define CONVERTER_MAP_ERROR                      SAPDBErr_MessageList::Error,11,"No valid converter entry for %s pageno %s. Error state is %s",3
#define CONVERTER_MAP_ERROR_ID 11
#define CONVERTER_PAGE_IN_FREE_LIST              SAPDBErr_MessageList::Error,12,"Data page %s already in free list",1
#define CONVERTER_PAGE_IN_FREE_LIST_ID 12
#define CONVERTER_PAGE_IN_USE                    SAPDBErr_MessageList::Error,13,"Requested specified data pageno %s is already in use",1
#define CONVERTER_PAGE_IN_USE_ID 13
#define CONVERTER_EXPAND_FAILED                  SAPDBErr_MessageList::Error,14,"Expanding the Converter from %s to %s pages failed",2
#define CONVERTER_EXPAND_FAILED_ID 14
#define CONVERTER_NO_MORE_MEMORY                 SAPDBErr_MessageList::Error,15,"No more memory %s",1
#define CONVERTER_NO_MORE_MEMORY_ID 15
#define CONVERTER_UNEXPECTED_ERROR               SAPDBErr_MessageList::Error,16,"Unexpected Error state %s",1
#define CONVERTER_UNEXPECTED_ERROR_ID 16
#define CONVERTER_NO_MEMORY_TO_BUILD_CONVERTER   SAPDBErr_MessageList::Error,17,"No more memory to create converter",0
#define CONVERTER_NO_MEMORY_TO_BUILD_CONVERTER_ID 17
#define CONVERTER_MAP_INIT_FAILED1               SAPDBErr_MessageList::Error,18,"Initilization of converter maps failed #all p.= %s max dyn p.=%s  max stat p.=%s",3
#define CONVERTER_MAP_INIT_FAILED1_ID 18
#define CONVERTER_MAP_INIT_FAILED2               SAPDBErr_MessageList::Error,19,"Initilization of converter maps failed #all p.= %s",1
#define CONVERTER_MAP_INIT_FAILED2_ID 19
#define CONVERTER_PNO_NOT_IN_BACKUP_PNO_LIST     SAPDBErr_MessageList::Error,20,"%s pageno %s not in backup pageno list",2
#define CONVERTER_PNO_NOT_IN_BACKUP_PNO_LIST_ID 20
#define CONVERTER_NO_MEMORY_FOR_BACKUP_CONTAINER SAPDBErr_MessageList::Error,21,"No more memory for back up page no container. max page no= %s #perm conv leaf p.= %s 'leaf page entries= %s",3
#define CONVERTER_NO_MEMORY_FOR_BACKUP_CONTAINER_ID 21
#define CONVERTER_PAGE_IS_FULL                   SAPDBErr_MessageList::Error,22,"No free entries available on page",0
#define CONVERTER_PAGE_IS_FULL_ID 22
#define CONVERTER_MAXIMUN_SIZE_REACHED           SAPDBErr_MessageList::Error,23,"Maxmimum data base size reached",0
#define CONVERTER_MAXIMUN_SIZE_REACHED_ID 23
#define CONVERTER_FREE_CNT_MISMATCH              SAPDBErr_MessageList::Error,24,"Free cnt mismatch for ParentIndexEntry: Entry cnt %s vs. IndexPage cnt %s",2
#define CONVERTER_FREE_CNT_MISMATCH_ID 24
#define CONVERTER_FULL_PAGE_IN_WRONG_CHAIN       SAPDBErr_MessageList::Error,25,"Full IndexPage is member of partially used chain. Free count %s",1
#define CONVERTER_FULL_PAGE_IN_WRONG_CHAIN_ID 25
#define CONVERTER_NOT_FULL_PAGE_IN_WRONG_CHAIN   SAPDBErr_MessageList::Error,26,"Half filled IndexPage is member of full filled chain. Free count %s",1
#define CONVERTER_NOT_FULL_PAGE_IN_WRONG_CHAIN_ID 26
#define CONVERTER_EMPTY_PAGE_IN_WRONG_CHAIN      SAPDBErr_MessageList::Error,27,"Empty IndexPage is member of partially used chain. Free count %s",1
#define CONVERTER_EMPTY_PAGE_IN_WRONG_CHAIN_ID 27
#define CONVERTER_DEVNO_BIT_COUNT                SAPDBErr_MessageList::Error,28,"Unauthorized configuration update. Parameter DEVNO_BIT_COUNT changed from %s to %s.",2
#define CONVERTER_DEVNO_BIT_COUNT_ID 28
#define CONVERTER_UNUSED_CHAIN_CORRUPTED         SAPDBErr_MessageList::Error,29,"Chain of not used converter map entries of section %s is corrupted concerning entry no %s.",2
#define CONVERTER_UNUSED_CHAIN_CORRUPTED_ID 29
#define CONVERTER_PARTIALLY_CHAIN_CORRUPTED      SAPDBErr_MessageList::Error,30,"Chain of partially used converter map entries of section %s is corrupted concerning entry no %s.",2
#define CONVERTER_PARTIALLY_CHAIN_CORRUPTED_ID 30
#define CONVERTER_FULL_CHAIN_CORRUPTED           SAPDBErr_MessageList::Error,31,"Chain of full used converter map entries of section %s is corrupted concerning entry no %s.",2
#define CONVERTER_FULL_CHAIN_CORRUPTED_ID 31
#define CONVERTER_UNUSED_CHAIN_LOOP              SAPDBErr_MessageList::Error,32,"Chain of unused converter map entries of section %s contains more than %s entries.",2
#define CONVERTER_UNUSED_CHAIN_LOOP_ID 32
#define CONVERTER_PARTIALLY_CHAIN_LOOP           SAPDBErr_MessageList::Error,33,"Chain of partially used converter map entries of section %s contains more than %s entries.",2
#define CONVERTER_PARTIALLY_CHAIN_LOOP_ID 33
#define CONVERTER_FULL_CHAIN_LOOP                SAPDBErr_MessageList::Error,34,"Chain of full used converter map entries of section %s contains more than %s entries.",2
#define CONVERTER_FULL_CHAIN_LOOP_ID 34
#define CONVERTER_ERR_CHECKSUM_MISMATCH          SAPDBErr_MessageList::Error,35,"Checksum mismatch; calculated: %s found: %s",2
#define CONVERTER_ERR_CHECKSUM_MISMATCH_ID 35
#define CONVERTER_ERR_BAD_PAGE_TYPE              SAPDBErr_MessageList::Error,36,"Bad converter page type %s and type2 %s",2
#define CONVERTER_ERR_BAD_PAGE_TYPE_ID 36
#define CONVERTER_ERR_WRITE_COUNT_MISMATCH       SAPDBErr_MessageList::Error,37,"Write count mismatch; header: %s, trailer: %s",2
#define CONVERTER_ERR_WRITE_COUNT_MISMATCH_ID 37
#define CONVERTER_ERR_BAD_PAGE_TYPE_2            SAPDBErr_MessageList::Error,38,"Read page is no converter page.",0
#define CONVERTER_ERR_BAD_PAGE_TYPE_2_ID 38
#define CONVERTER_ERR_BAD_LEAF_PAGE_TYPE         SAPDBErr_MessageList::Error,39,"Read page is no converter leaf page.",0
#define CONVERTER_ERR_BAD_LEAF_PAGE_TYPE_ID 39
#define CONVERTER_ERR_BAD_INDEX_PAGE_TYPE        SAPDBErr_MessageList::Error,40,"Read page is no converter index page.",0
#define CONVERTER_ERR_BAD_INDEX_PAGE_TYPE_ID 40
#define CONVERTER_SUSPEND_TASK_DUE_TO_DB_FULL    SAPDBErr_MessageList::Warning,41,"DB FULL: Task %s suspended (%s pages used %s pages requested %s data base size)",4
#define CONVERTER_SUSPEND_TASK_DUE_TO_DB_FULL_ID 41
#define CONVERTER_SUSPEND_TASK_DUE_TO_FBM_FULL   SAPDBErr_MessageList::Warning,42,"DB FULL(FBM): Task %s suspended (%s pages changed %s blocks occupied %s blocks available)",4
#define CONVERTER_SUSPEND_TASK_DUE_TO_FBM_FULL_ID 42
#define CONVERTER_FORCE_ROLLBACK_DUE_TO_DB_FULL  SAPDBErr_MessageList::Warning,43,"Force Rollback due to DB-Full. Tasks %s holds too many temp pages #all p.= %s #all temp. p.= %s #task temp p.= %s",4
#define CONVERTER_FORCE_ROLLBACK_DUE_TO_DB_FULL_ID 43
#define CONVERTER_NO_ADD_DATA_DEVICE             SAPDBErr_MessageList::Warning,44,"Force Rollback due to DB-Full for Task %s. No data volume can be added",1
#define CONVERTER_NO_ADD_DATA_DEVICE_ID 44
#define CONVERTER_PAGENO_NOT_REFERENCED          SAPDBErr_MessageList::Info,45,"The %s data pageno %s on block %s/%s is deleted.",4
#define CONVERTER_PAGENO_NOT_REFERENCED_ID 45
#define CONVERTER_SAVEPOINT_NEEDED               SAPDBErr_MessageList::Info,46,"Savepoint needed (%s pages changed %s blocks occupied %s blocks available)",3
#define CONVERTER_SAVEPOINT_NEEDED_ID 46
#define CONVERTER_FLUSHED_SECTION                SAPDBErr_MessageList::Info,47,"Flushed section #%s, IOPages: %s",2
#define CONVERTER_FLUSHED_SECTION_ID 47
#define CONVERTER_INFO_SHUTDOWN                  SAPDBErr_MessageList::Info,48,"Converter is in state shutdown.",0
#define CONVERTER_INFO_SHUTDOWN_ID 48
#define CONVERTER_INFO_CANCELLED_DURING_DB_FULL  SAPDBErr_MessageList::Info,49,"Task %s was cancelled during database full situation.",1
#define CONVERTER_INFO_CANCELLED_DURING_DB_FULL_ID 49

#endif /* CONVERTER_MESSAGES_HPP */
