/*!
  @file           FBM_Types.hpp
  @author         TorstenS
  @author         AlexanderK
  @ingroup        FBM

\if EMIT_LICENCE
    ========== licence begin  GPL
    Copyright (c) 2002-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

\endif
*/


#ifndef FBM_TYPES_HPP
#define FBM_TYPES_HPP

/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "SAPDBCommon/Diagnostics/SAPDBDiag_CheckTopic.hpp"
#include "SAPDBCommon/Tracing/SAPDBTrace_Topic.hpp"

/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/

#define FBM_UNDEFINED          -1
#define FBM_ABORT_IF_ERROR      true

 /*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/

 /*===========================================================================*
 *  EXTERNAL VARIABLES                                                       *
 *===========================================================================*/

extern SAPDBDiag_CheckTopic FBM_Check;
extern SAPDBTrace_Topic     FBM_Trace;

/*===========================================================================*
 *  CLASSES, STRUCTURES, TYPES, UNIONS ...                                   *
 *===========================================================================*/

enum FBM_BlockState {BlockState_Free         = 0,
                     BlockState_Occupied     = 1, 
                     BlockState_FreeAfterSVP = 2,
                     BlockState_BackUp       = 3};

#endif //FBM_TYPES_HPP
