/*

    ========== licence begin  GPL
    Copyright (c) 2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

*/
#ifndef __OMS_GUIDENTRY_HPP
#define __OMS_GUIDENTRY_HPP

#include "Oms/OMS_Defines.h"
#include "Oms/OMS_ContextDef.hpp"
#include "Oms/OMS_ClassInfo.hpp"

#include "livecachetypes.h" // nocheck
#include "geo00.h"
#include "gsp00.h"

class OMS_FreeListHeader;
class OmsAbstractObject;
class OmsObjectContainer;

class OMS_GuidEntry {
public:
  OMS_GuidEntry*      m_hashNext;
  OMS_ClassInfo*       m_classInfo;
  OMS_FreeListHeader* m_freeHead;
  OMS_FreeListHeader* m_freeHeadInVersion;
  OMS_GuidEntry(OMS_GuidEntry* next, OMS_ClassInfo* ci, OMS_FreeListHeader* fl, OMS_FreeListHeader* flv) :
  m_hashNext(next),  m_classInfo(ci), m_freeHead(fl), m_freeHeadInVersion(flv) {} 
  inline void* operator new (size_t sz, OMS_Context* context);
  void          ChainFree (OMS_Context&c, OmsAbstractObject* p, int caller);
  void          ChainFree (OMS_Context&c, OmsObjectContainer*& p, int caller);
  inline void   DeleteSelf(OMS_Context* context);
  inline const ClassIDRef GetBaseGuid() const;
  inline int         GetKeyLen();             
  inline bool        IsKeyedObject() const;   
  inline tsp00_Int4  GetObjectSize();
  inline void*       GetVirtualTablePtr();
  inline bool        IsBaseClass() const;
  inline bool        IsDerivedClass() const;
  inline bool        IsDerivedClassOf(const ClassIDRef guid) const;
  inline bool        IsVarObject();
#if defined(OMS_PLACEMENT_DELETE)
  inline void operator delete(void* p, OMS_Context* context);
#endif
  void operator delete(void*p); // not implemented, attempt to call will force linker error
};

typedef OMS_GuidEntry* OMS_GuidEntryPtr;

/*----------------------------------------------------------------------*/

inline void* OMS_GuidEntry::operator new (size_t sz, OMS_Context* context) 
{
  return context->allocate(sz);
}

/*----------------------------------------------------------------------*/

inline void OMS_GuidEntry::DeleteSelf(OMS_Context* context) 
{
  context->deallocate(this);
}

/*----------------------------------------------------------------------*/

inline const ClassIDRef OMS_GuidEntry::GetBaseGuid() const 
{
  return m_classInfo->GetBaseGuid();
}

/*----------------------------------------------------------------------*/

inline int OMS_GuidEntry::GetKeyLen() {        
  return m_classInfo->GetKeyDesc().GetLen();   
}


/*----------------------------------------------------------------------*/

inline tsp00_Int4 OMS_GuidEntry::GetObjectSize() {
  return m_classInfo->GetObjectSize();
}

/*----------------------------------------------------------------------*/

inline void* OMS_GuidEntry::GetVirtualTablePtr() {
  return m_classInfo->GetVTPtr();
}

/*----------------------------------------------------------------------*/

inline bool OMS_GuidEntry::IsBaseClass() const {
  return m_classInfo->IsBaseClass();
}

/*----------------------------------------------------------------------*/

inline bool OMS_GuidEntry::IsDerivedClass() const {
  return m_classInfo->IsDerivedClass();
}

/*----------------------------------------------------------------------*/

inline bool OMS_GuidEntry::IsDerivedClassOf(const ClassIDRef guid) const {
  return m_classInfo->IsDerivedClassOf(guid);
}

/*----------------------------------------------------------------------*/

inline bool OMS_GuidEntry::IsVarObject() {
  return m_classInfo->IsVarObject();
}

/*----------------------------------------------------------------------*/

inline bool OMS_GuidEntry::IsKeyedObject() const {
  //return m_classInfo->IsKeyedObject();
  return m_classInfo->GetKeyDesc().IsKeyed();
}

/*----------------------------------------------------------------------*/

#if defined(OMS_PLACEMENT_DELETE)
inline void OMS_GuidEntry::operator delete(void* p, OMS_Context* context) {
  context->deallocate(p);
}
#endif

#endif // __OMS_GUIDENTRY_HPP
