/*!---------------------------------------------------------------------
  @file           RTEConf_ParameterAccessKernelInterface.h
  @author         JoergM, RobinW
  @brief          C/Pascal interface for class RTEConf_ParameterAccess (class for kernel configurable parameter access)

  first created  2000-03-22  17:49

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



\endif
---------------------------------------------------------------------*/


#ifndef CONF_PARAMETER_ACCESS_H
#define CONF_PARAMETER_ACCESS_H

#include "vsp0011.h"
#include "geo002.h"

/*!--------------------------------------------------------------------
   @description    
   @param          conf_param_name [in] parameter name reference
   @param          conf_param_value [out] value reference as 4-byte integer
   @param          errtext [out] error text if unsuccessful
   @param          conf_param_ret [out] return value as defined in vsp0011.h

 --------------------------------------------------------------------*/

externC void vconf_param_get_int4      ( tsp11_ConfParamName        VAR_ARRAY_REF conf_param_name,
                                         tsp00_Int4                 VAR_VALUE_REF conf_param_value,
                                         tsp00_ErrText              VAR_ARRAY_REF errtext,
                                         tsp11_ConfParamReturnValue VAR_VALUE_REF conf_param_ret );

/*!--------------------------------------------------------------------
   @description    
   @param          conf_param_name [in] parameter name reference
   @param          conf_param_value [out] value reference as 8-byte integer
   @param          errtext [out] error text if unsuccessful
   @param          conf_param_ret [out] return value as defined in vsp0011.h

 --------------------------------------------------------------------*/

externC void vconf_param_get_integer   ( tsp11_ConfParamName        VAR_ARRAY_REF conf_param_name,
                                         tsp00_Int8                 VAR_VALUE_REF conf_param_value,
                                         tsp00_ErrText              VAR_ARRAY_REF errtext,
                                         tsp11_ConfParamReturnValue VAR_VALUE_REF conf_param_ret );

/*!--------------------------------------------------------------------
   @description    
   @param          conf_param_name [in] parameter name reference
   @param          conf_param_value [out] value reference as longreal
   @param          errtext [out] error text if unsuccessful
   @param          conf_param_ret [out] return value as defined in vsp0011.h

 --------------------------------------------------------------------*/

externC void vconf_param_get_real      ( tsp11_ConfParamName        VAR_ARRAY_REF conf_param_name,
                                         tsp00_Longreal             VAR_VALUE_REF conf_param_value,
                                         tsp00_ErrText              VAR_ARRAY_REF errtext,
                                         tsp11_ConfParamReturnValue VAR_VALUE_REF conf_param_ret );

/*!--------------------------------------------------------------------
   @description    
   @param          conf_param_name [in] parameter name reference
   @param          conf_param_value [out] value reference as string
   @param          conf_param_length [out] length of the string
   @param          errtext [out] error text if unsuccessful
   @param          conf_param_ret [out] return value as defined in vsp0011.h

 --------------------------------------------------------------------*/

externC void vconf_param_get_string    ( tsp11_ConfParamName        VAR_ARRAY_REF conf_param_name,
                                         tsp11_ConfParamValue       VAR_ARRAY_REF conf_param_value,
                                         tsp00_Int4                 VAR_VALUE_REF conf_param_length,
                                         tsp00_ErrText              VAR_ARRAY_REF errtext,
                                         tsp11_ConfParamReturnValue VAR_VALUE_REF conf_param_ret );

/*!--------------------------------------------------------------------
   @description    
   @param          conf_param_name [in] parameter name reference
   @param          conf_param_value [out] value reference as crypt info
   @param          errtext [out] error text if unsuccessful
   @param          conf_param_ret [out] return value as defined in vsp0011.h

 --------------------------------------------------------------------*/

externC void vconf_param_get_cryptinfo ( tsp11_ConfParamName        VAR_ARRAY_REF conf_param_name,
                                         tsp00_CryptName            VAR_ARRAY_REF conf_param_value,
                                         tsp00_ErrText              VAR_ARRAY_REF errtext,
                                         tsp11_ConfParamReturnValue VAR_VALUE_REF conf_param_ret );

/*!--------------------------------------------------------------------
   @description    
   @param          conf_param_name [in] parameter name reference
   @param          conf_param_value [in] value reference as string,numeric
                                  parameters are given in their ASCII representation,
   @param          is_numeric [in] flag to indicate a numeric parameter
   @param          errtext [out] error text if unsuccessful
   @param          conf_param_ret [out] return value as defined in vsp0011.h

 --------------------------------------------------------------------*/

externC void vconf_param_put           ( tsp11_ConfParamName        VAR_ARRAY_REF conf_param_name,
                                         tsp11_ConfParamValue       VAR_ARRAY_REF conf_param_value,
                                         boolean                                  is_numeric,
                                         tsp00_ErrText              VAR_ARRAY_REF errtext,
                                         tsp11_ConfParamReturnValue VAR_VALUE_REF conf_param_ret );
 
                                           
/* Error messages are reported via RTE_Message() !
 This routine should only be called from modules that cannot handle SAPDBErr_MessageLists.
 C++ modules should call RTEConf_ReadAndAnalyzeParam() and handle the SAPDBErr_MessageLists
 returned! */
externC SAPDB_Bool RTEConf_ReadAndAnalyzeParamWithOutput ( tsp00_DbNamec VAR_ARRAY_REF    ServerDB,
                                                           RTE_XPARAM_REC   *XParam );

externC void RTEConf_FreeTaskClusterArrayInXParamStructure( RTE_XPARAM_REC *XParam);

externC void RTEConf_FreeDevDescrInXParamStructure( RTE_XPARAM_REC *XParam,int idx );


externC SAPDB_Bool RTEConf_ParameterAccessGetInteger   ( SAPDB_UTF8 *conf_param_name,
									                     SAPDB_Int8  *conf_param_value,
									                     SAPDB_Char ** errtext);


externC SAPDB_Bool RTEConf_ParameterAccessGetReal      ( SAPDB_UTF8 *conf_param_name,
									                     SAPDB_Real8 *conf_param_value,
									                     SAPDB_Char ** errtext);


externC SAPDB_Bool RTEConf_ParameterAccessGetString    ( SAPDB_UTF8 *conf_param_name,
									                     SAPDB_Char **conf_param_value,
									                     SAPDB_Char ** errtext);


externC SAPDB_Bool RTEConf_ParameterAccessGetCryptInfo ( SAPDB_UTF8 *conf_param_name,
									                     SAPDB_Byte *conf_param_value,
									                     SAPDB_Char ** errtext);


externC SAPDB_Bool RTEConf_ParameterAccessSetCrashSem ( SAPDB_Int8 conf_param_value,
                                                        SAPDB_Char ** errtext);

externC SAPDB_Bool RTEConf_ParameterAccessResetParamChangedFlag ( SAPDB_Char ** errtext);

externC SAPDB_Bool RTEConf_ParameterAccessIsVerified            ( );

externC SAPDB_Bool RTEConf_ParameterAccessGetCrashSem           ( );

externC void RTEConf_ParameterAccessFreeErrorMessage(SAPDB_Char *errtext);

externC void RTEConf_HandleSpecialParametersWithMessageOutput();

/*!--------------------------------------------------------------------
   @description    Check if the configured volumes of a given type do not exceed a given limit
   @param          limit [in] the limit in bytes to check the volume sizes against
   @param          type [in] the type of volumes to check
   @return value   false if the size of one or more configured volumes exceeds the limit, true if not

 --------------------------------------------------------------------*/
externC SAPDB_Bool RTEConf_CheckVolumeSize(RTE_DevSpaceType type,RTE_XPARAM_REC *XparamParameters,SAPDB_UInt8 limit);
 
/*===========================================================================*
 *  END OF CODE                                                              *
 *===========================================================================*/

#endif /* CONF_PARAMETER_ACCESS_H */
