/*!---------------------------------------------------------------------
  @file           ven80.cpp
  @author         JoergM
  @brief          C++ Kernel Main

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



\endif
---------------------------------------------------------------------*/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gen81.h"
#include "geo50_0.h"
#include "geo007_1.h"
#include "gen38.h"
#include <stdlib.h>
#include "RunTime/RTE_KernelMain.h"
#include "RunTime/RTE_Crash.hpp"
#include "RunTime/RTE_KGS.hpp"
#include "gen60.h"
#include "SAPDBCommon/ErrorsAndMessages/SAPDBErr_MessageOutput.h"
/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/

/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/

/*===========================================================================*
 *  LOCAL CLASSES, STRUCTURES, TYPES, UNIONS ...                             *
 *===========================================================================*/

/*===========================================================================*
 *  GLOBAL VARIABLES                                                         *
 *===========================================================================*/

/*===========================================================================*
 *  LOCAL VARIABLES                                                          *
 *===========================================================================*/

/*===========================================================================*
 *  LOCAL FUNCTIONS (PROTOTYPES)                                             *
 *===========================================================================*/

/*===========================================================================*
 *  GLOBAL FUNCTIONS (CODE)                                                  *
 *===========================================================================*/

int
main ( int argc , char *argv[] , char *envp[] )
{
  SAPDBErr_SetMessageOutputCall( en60MessageOutputCall );
  /*
   * New code main routine. Performs i.e. Allocator initialization
   */
  int exit_code = RTE_KernelMain(argc, argv);

  if ( exit_code != 0 )
  {
    perror("Global initialization failed");
  }
  else
  {
    /*
     * Old code main routine (calls < 7.3 code...) Maybe one day it can be removed...
     */
    exit_code = en81_kernel_main ( argc , argv  , envp );
  }

  exit(exit_code) ;
}

/*----------*/

extern "C" int
en80RunKernel( struct ten50_KT_Control *pMain )
{
    int rc = 111;
    try 
    {
        RTE_KGS::Instance().SetKGS(kgs);

        rc = en81RunKernel( pMain );
    }
    catch (SAPDBErr_MessageList &lastMsg)
    {
        RTE_Crash(lastMsg);
    }
    return rc;
}

/*===========================================================================*
 *  LOCAL FUNCTIONS (CODE)                                                   *
 *===========================================================================*/

/*===========================================================================*
 *  END OF CODE                                                              *
 *===========================================================================*/