/****************************************************************************

  module      : FBM_Dump.hpp.hpp

  -------------------------------------------------------------------------

  responsible : TorstenS

  auhtor      : AlexanderK

  special area: FreeBlockManagement (FBM)
  description : Layout of FNM dump structures


  last changed: 2001-06-12  18:47
  see also    : 

  -------------------------------------------------------------------------

  copyright:    (c) 2001-2004 SAP AG

    ========== licence begin  GPL
    Copyright (c) 2001-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*****************************************************************************/


#ifndef FBM_DUMP_HPP
#define FBM_DUMP_HPP



/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "SAPDBCommon/SAPDB_Types.hpp"

/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/


/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/


/*===========================================================================*
 *  CLASSES, STRUCTURES, TYPES, UNIONS ...                                   *
 *===========================================================================*/

struct FBMManager 
{
    SAPDB_Bool1     dmpActive;
    SAPDB_Bool1     dmpSvpIsTriggered;
    SAPDB_UInt2     dmpFiller1;
    SAPDB_UInt4     dmpMaxNumDev;
    SAPDB_UInt4     dmpNumDev;
    SAPDB_UInt4     dmpTotalNumBlocks;
    SAPDB_UInt4     dmpSecurityLimit;
    SAPDB_UInt4     dmpTotalUsedBlocks;
    SAPDB_UInt4     dmpTotalNumBlocksFreeAfterSVP;
    SAPDB_UInt4     dmpTotalNumBlocksFree;
    SAPDB_UInt4     dmpNextDevToUseForNewBlock;
    SAPDB_UInt4     dmpNextDevToUseForFragBlock;
};

struct FBMDataDevice
{
    SAPDB_UInt4     dmpDevNo;
    SAPDB_UInt4     dmpNumBlocks;
    SAPDB_UInt4     dmpNumBlocksUsed;
    SAPDB_UInt4     dmpNumBlocksMarkedForBackup;
    SAPDB_UInt4     dmpNumBlocksFreeAfterSVP;
    SAPDB_UInt4     dmpNumBlocksToAddUntilOptIsReached;
    SAPDB_UInt4     dmpNumberOfSections;
    SAPDB_UInt4     dmpActBlockNoForBackup;            
    SAPDB_UInt4     dmpStartBlockNoToSearchFreeBlock;
    SAPDB_UInt4     dmpLastUsedBlock;
    SAPDB_UInt4     dmpFirstFreeBlock;
    SAPDB_UInt4     dmpLastFragmentedBlock;
    SAPDB_UInt4     dmpFirstFragmentedBlock;
    tsp00_Bool      dmpDeviceIsInCompressingMode;
    SAPDB_Bool1     dmpFiller1;
    SAPDB_UInt2     dmpFiller2;
};

#endif  /* FBM_DUMP_HPP */
