/*
        ========== licence begin  GPL
        Copyright (C) 2005 SAP AG

        This program is free software; you can redistribute it and/or
        modify it under the terms of the GNU General Public License
        as published by the Free Software Foundation; either version 2
        of the License, or (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
        ========== licence end
 */
#ifndef IOMAN_MESSAGES_HPP
#define IOMAN_MESSAGES_HPP

// Generated Header file IOMan_Messages.hpp.
// Generated by genmsg V2.2 DO NOT EDIT

#include "SAPDBCommon/ErrorsAndMessages/SAPDBErr_MessageList.hpp"

#define IOMAN_INFO_UNSET_BAD_VOLUME         SAPDBErr_MessageList::Info,20000,"Reset bad flag for %s volume %s",2
#define IOMAN_INFO_UNSET_BAD_VOLUME_ID 20000
#define IOMAN_INFO_VOLUME_MARKED_AS_BAD     SAPDBErr_MessageList::Info,20001,"%s volume %s is marked as bad",2
#define IOMAN_INFO_VOLUME_MARKED_AS_BAD_ID 20001
#define IOMAN_INFO_ADD_VOLUME               SAPDBErr_MessageList::Info,20002,"Add %s volume %s with %s pages successfully executed",3
#define IOMAN_INFO_ADD_VOLUME_ID 20002
#define IOMAN_INFO_DO_MIGRATION             SAPDBErr_MessageList::Info,20003,"Start data base inplace migration",0
#define IOMAN_INFO_DO_MIGRATION_ID 20003
#define IOMAN_INFO_MIGRATION_FINISHED       SAPDBErr_MessageList::Info,20004,"Data base migration successfully finished",0
#define IOMAN_INFO_MIGRATION_FINISHED_ID 20004
#define IOMAN_INFO_CONV_PAGES_MIGRATED      SAPDBErr_MessageList::Info,20005,"Migration: converter page count %s / data page count %s",2
#define IOMAN_INFO_CONV_PAGES_MIGRATED_ID 20005
#define IOMAN_INFO_START_REINTEGRATION      SAPDBErr_MessageList::Info,20006,"Start reintegration for log device %s from '%s' to '%s'.",3
#define IOMAN_INFO_START_REINTEGRATION_ID 20006
#define IOMAN_INFO_STOP_REINTEGRATION       SAPDBErr_MessageList::Info,20007,"Reintegration successfully finished.",0
#define IOMAN_INFO_STOP_REINTEGRATION_ID 20007
#define IOMAN_INFO_BAD_VOLUME_NOT_FOUND     SAPDBErr_MessageList::Info,20008,"Bad log volume '%s' not found.",1
#define IOMAN_INFO_BAD_VOLUME_NOT_FOUND_ID 20008
#define IOMAN_INFO_VOLUME_NOT_BAD           SAPDBErr_MessageList::Info,20009,"Given log volume '%s' is not marked as bad.",1
#define IOMAN_INFO_VOLUME_NOT_BAD_ID 20009
#define IOMAN_WRN_VOLUME_OFFLINE            SAPDBErr_MessageList::Warning,20010,"The %s volume %s is offline.",2
#define IOMAN_WRN_VOLUME_OFFLINE_ID 20010
#define IOMAN_WRN_SAVE_PARAM_FAILED         SAPDBErr_MessageList::Warning,20011,"The saving of the configuration file failed: %s",1
#define IOMAN_WRN_SAVE_PARAM_FAILED_ID 20011
#define IOMAN_WRN_LOG_AREA_NOT_WRITEABLE    SAPDBErr_MessageList::Warning,20012,"Operation not possible, because the log area is not writable.",0
#define IOMAN_WRN_LOG_AREA_NOT_WRITEABLE_ID 20012
#define IOMAN_BAD_PAGE                      SAPDBErr_MessageList::Error,20013,"Bad page on %s volume %s blockno %s",3
#define IOMAN_BAD_PAGE_ID 20013
#define IOMAN_ATTACH_FAILED                 SAPDBErr_MessageList::Error,20014,"Attach error on %s volume %s: %s",3
#define IOMAN_ATTACH_FAILED_ID 20014
#define IOMAN_NOT_ACCESSIBLE                SAPDBErr_MessageList::Error,20015,"Access error on %s volume %s blockno %s: %s",4
#define IOMAN_NOT_ACCESSIBLE_ID 20015
#define IOMAN_UNKNOWN_VOLUME                SAPDBErr_MessageList::Error,20016,"Unknown %s volume %s: %s",3
#define IOMAN_UNKNOWN_VOLUME_ID 20016
#define IOMAN_EMERGENCY_MSG1                SAPDBErr_MessageList::Error,20017,"EMERGENCY SHUTDOWN",0
#define IOMAN_EMERGENCY_MSG1_ID 20017
#define IOMAN_WRONG_PAGENO                  SAPDBErr_MessageList::Error,20018,"Wrong data page on data volume %s blockno %s",2
#define IOMAN_WRONG_PAGENO_ID 20018
#define IOMAN_WRONG_PAGENO2                 SAPDBErr_MessageList::Error,20019,"Wrong data page - Requested pageno %s (%s) read pageno %s",3
#define IOMAN_WRONG_PAGENO2_ID 20019
#define IOMAN_BAD_OUTPUT_PAGE               SAPDBErr_MessageList::Error,20020,"Bad output page for %s volume %s blockno %s",3
#define IOMAN_BAD_OUTPUT_PAGE_ID 20020
#define IOMAN_MIN_DATA_PAGES                SAPDBErr_MessageList::Error,20021,"Minimum of data area size is %s pages and not %s",2
#define IOMAN_MIN_DATA_PAGES_ID 20021
#define IOMAN_WRONG_CONV_PAGE               SAPDBErr_MessageList::Error,20022,"Wrong converter page on %s volume %s blockno %s",3
#define IOMAN_WRONG_CONV_PAGE_ID 20022
#define IOMAN_FBM_FULL                      SAPDBErr_MessageList::Error,20023,"No more free block address available from FBM",0
#define IOMAN_FBM_FULL_ID 20023
#define IOMAN_BAD_RESTART_PAGE              SAPDBErr_MessageList::Error,20024,"Bad restart page on %s volume %s blockno %s",3
#define IOMAN_BAD_RESTART_PAGE_ID 20024
#define IOMAN_BAD_DATA_PAGE                 SAPDBErr_MessageList::Error,20025,"Bad data page - Requested pageno %s (%s) read pageno %s",3
#define IOMAN_BAD_DATA_PAGE_ID 20025
#define IOMAN_READ_INFO_PAGE_FAILED         SAPDBErr_MessageList::Error,20026,"Can not read info page from %s volume %s",2
#define IOMAN_READ_INFO_PAGE_FAILED_ID 20026
#define IOMAN_WRITE_INFO_PAGE_FAILED        SAPDBErr_MessageList::Error,20027,"Can not write info page into %s volume %s",2
#define IOMAN_WRITE_INFO_PAGE_FAILED_ID 20027
#define IOMAN_DEVNO_MISSMATCH               SAPDBErr_MessageList::Error,20028,"Volume id from %s volume in configuration and info page are different: %s vs %s",3
#define IOMAN_DEVNO_MISSMATCH_ID 20028
#define IOMAN_CAPACITY_MISSMATCH            SAPDBErr_MessageList::Error,20029,"Capacity of %s volume %s is different between configuration and info page: %s vs. %s",4
#define IOMAN_CAPACITY_MISSMATCH_ID 20029
#define IOMAN_BLOCKSIZE_MISSMATCH           SAPDBErr_MessageList::Error,20030,"Block size of %s volume %s is different between configuration and info page: %s vs. %s",4
#define IOMAN_BLOCKSIZE_MISSMATCH_ID 20030
#define IOMAN_CORRUPTED_CONFIGURATION       SAPDBErr_MessageList::Error,20031,"%s volume configuration corrupted: Linkage missmatch between volume %s and %s",3
#define IOMAN_CORRUPTED_CONFIGURATION_ID 20031
#define IOMAN_DB_IDENTIFIER_MISSMATCH       SAPDBErr_MessageList::Error,20032,"DB volume GUID '%s' of %s volume %s is not equal to the given volume GUID '%s'",4
#define IOMAN_DB_IDENTIFIER_MISSMATCH_ID 20032
#define IOMAN_ERR_MISSING_PREDECESSOR       SAPDBErr_MessageList::Error,20033,"%s volume configuration corrupted: Predecessor of volume %s should be %s",3
#define IOMAN_ERR_MISSING_PREDECESSOR_ID 20033
#define IOMAN_ERR_MISSING_SUCCESSOR         SAPDBErr_MessageList::Error,20034,"%s volume configuration corrupted: Successor of volume %s should be %s",3
#define IOMAN_ERR_MISSING_SUCCESSOR_ID 20034
#define IOMAN_ERR_BAD_VOLUME                SAPDBErr_MessageList::Error,20035,"%s volume %s is set to bad",2
#define IOMAN_ERR_BAD_VOLUME_ID 20035
#define IOMAN_ERR_DATA_DEVNO_OUT_OF_RANGE   SAPDBErr_MessageList::Error,20036,"Data volume number %s is out of range. Upper limit is %s",2
#define IOMAN_ERR_DATA_DEVNO_OUT_OF_RANGE_ID 20036
#define IOMAN_ERR_LOG_DEVNO_OUT_OF_RANGE    SAPDBErr_MessageList::Error,20037,"Log volume number %s is out of range. Upper limit is %s",2
#define IOMAN_ERR_LOG_DEVNO_OUT_OF_RANGE_ID 20037
#define IOMAN_ERR_VOLUME_IS_ONLINE          SAPDBErr_MessageList::Error,20038,"The added %s volume %s is already online",2
#define IOMAN_ERR_VOLUME_IS_ONLINE_ID 20038
#define IOMAN_ERR_NEW_VOLUME_FAILED         SAPDBErr_MessageList::Error,20039,"The adding of %s volume %s to the RTE failed",2
#define IOMAN_ERR_NEW_VOLUME_FAILED_ID 20039
#define IOMAN_ERR_CREATE_LINKAGE            SAPDBErr_MessageList::Error,20040,"Create linkage between %s volume %s and %s failed",3
#define IOMAN_ERR_CREATE_LINKAGE_ID 20040
#define IOMAN_ERR_MIG_LOG_FAILED            SAPDBErr_MessageList::Error,20041,"Create log volume during migration failed",0
#define IOMAN_ERR_MIG_LOG_FAILED_ID 20041
#define IOMAN_ERR_MIG_LOG_FORMAT_FAILED     SAPDBErr_MessageList::Error,20042,"Format log volume during migration failed, because of %s",1
#define IOMAN_ERR_MIG_LOG_FORMAT_FAILED_ID 20042
#define IOMAN_ERR_MIG_DATA_FAILED           SAPDBErr_MessageList::Error,20043,"Create data volume during migration failed",0
#define IOMAN_ERR_MIG_DATA_FAILED_ID 20043
#define IOMAN_ERR_ILLEGAL_DATA_AREA_SIZE    SAPDBErr_MessageList::Error,20044,"Illegal data area size. Restart record %s vs. data base %s",2
#define IOMAN_ERR_ILLEGAL_DATA_AREA_SIZE_ID 20044
#define IOMAN_ERR_MIG_RESTARTREC_FAILED     SAPDBErr_MessageList::Error,20045,"Migration of restart record failed",0
#define IOMAN_ERR_MIG_RESTARTREC_FAILED_ID 20045
#define IOMAN_ERR_READ_PAGE_FAILED          SAPDBErr_MessageList::Error,20046,"Read page from %s volume %s on blockno %s failed.",3
#define IOMAN_ERR_READ_PAGE_FAILED_ID 20046
#define IOMAN_ERR_CONV_MIG_FAILED           SAPDBErr_MessageList::Error,20047,"Migration of converter failed, because of base error: %s",1
#define IOMAN_ERR_CONV_MIG_FAILED_ID 20047
#define IOMAN_ERR_MIG_ATTACH_FAILED         SAPDBErr_MessageList::Error,20048,"Attach error on migration volume %s: %s",2
#define IOMAN_ERR_MIG_ATTACH_FAILED_ID 20048
#define IOMAN_ERR_MIG_ALREADY_RUNNING       SAPDBErr_MessageList::Error,20049,"Data base migration already running.",0
#define IOMAN_ERR_MIG_ALREADY_RUNNING_ID 20049
#define IOMAN_ERR_MIG_PARAM_FAILED          SAPDBErr_MessageList::Error,20050,"Could not update param file during migration, because: %s",1
#define IOMAN_ERR_MIG_PARAM_FAILED_ID 20050
#define IOMAN_ERR_MIG_NOT_POSSIBLE          SAPDBErr_MessageList::Error,20051,"The inplace migration of a liveCache is not possible.",0
#define IOMAN_ERR_MIG_NOT_POSSIBLE_ID 20051
#define IOMAN_ERR_NOT_PREPARED_FOR_MIG      SAPDBErr_MessageList::Error,20052,"The inplace migration is not possible, because the migrate command was not executed in 7.2/7.3",0
#define IOMAN_ERR_NOT_PREPARED_FOR_MIG_ID 20052
#define IOMAN_ERR_CAPACITY_MISMATCH         SAPDBErr_MessageList::Error,20053,"Capacity mismatch for dual log device %s. Volume capacity %s. Mirrored volume capacity %s.",3
#define IOMAN_ERR_CAPACITY_MISMATCH_ID 20053
#define IOMAN_ERR_STOP_REINTEGRATION        SAPDBErr_MessageList::Error,20054,"Reintegration unsuccessfully finished: %s",1
#define IOMAN_ERR_STOP_REINTEGRATION_ID 20054
#define IOMAN_ERR_NOT_WRITEABLE             SAPDBErr_MessageList::Error,20055,"The %s volume %s is not writeable. State is %s.",3
#define IOMAN_ERR_NOT_WRITEABLE_ID 20055
#define IOMAN_ERR_LOG_OFFSET_OUT_OF_RANGE   SAPDBErr_MessageList::Error,20056,"The given log offset %s is out of range. Total log area size %s.",2
#define IOMAN_ERR_LOG_OFFSET_OUT_OF_RANGE_ID 20056
#define IOMAN_ERR_LOG_OFFSET_OUT_OF_RANGE_1 SAPDBErr_MessageList::Error,20057,"The given log offset %s with blockcount %s is out of range. Total log area size %s.",3
#define IOMAN_ERR_LOG_OFFSET_OUT_OF_RANGE_1_ID 20057
#define IOMAN_ERR_LOG_AREA_ALREADY_ONLINE   SAPDBErr_MessageList::Error,20058,"Create log area not allowed, because log area is still in use.",0
#define IOMAN_ERR_LOG_AREA_ALREADY_ONLINE_ID 20058
#define IOMAN_ERR_DATA_AREA_ALREADY_ONLINE  SAPDBErr_MessageList::Error,20059,"Create data area not allowed, because data area is still in use.",0
#define IOMAN_ERR_DATA_AREA_ALREADY_ONLINE_ID 20059
#define IOMAN_ERR_MIG_COULD_NOT_START_FBM   SAPDBErr_MessageList::Error,20060,"FBM could not be started during data base migration",0
#define IOMAN_ERR_MIG_COULD_NOT_START_FBM_ID 20060

#endif /* IOMAN_MESSAGES_HPP */
