/*!******************************************************************************

  @file         hak07.h

  ------------------------------------------------------------------------------

  @author       ElkeZ

  @brief        AK_error_handling

\if EMIT_LICENCE  

    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

\endif

********************************************************************************/

#ifndef HAK07_H
#define HAK07_H


/*===========================================================================*
 *     RefType: C++                                                          *
 *===========================================================================*/

/*===========================================================================*
 *     MD5: '\x2c\x16\x88\x35\x57\xe3\xdd\xb1\xb9\xc9\x7d\xb6\xf5\x41\x06\x23'
 *===========================================================================*/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"
#include "ggg00.h"
#include "ggg04.h"
#include "vak001.h"
#include "vsp008.h"


/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

externPascal void a07ClientLayoutParam (
    tak_all_command_glob  &  acv,
    integer                  param_no,
    tsp00_MoveObjPtr         param_addr,
    integer                  param_len);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a07_const_b_put_error (
    tak_all_command_glob  &  acv,
    tgg00_BasisError         b_err,
    tsp00_Int4               err_code,
    tsp00_MoveObjPtr         param_addr,
    integer                  const_len);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a07_error (
    tak_all_command_glob  &  acv,
    tgg00_BasisError         err,
    tsp00_Int2            &  nod1,
    tsp00_Int2            &  nod2);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a07_b_put_error (
    tak_all_command_glob  &  acv,
    tgg00_BasisError         b_err,
    tsp00_Int4               err_code);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a07_kw_put_error (
    tak_all_command_glob  &  acv,
    tgg00_BasisError         b_err,
    tsp00_Int4               err_code,
    integer                  kw);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a07_nb_put_error (
    tak_all_command_glob  &  acv,
    tgg00_BasisError         b_err,
    tsp00_Int4               err_code,
    tsp00_KnlIdentifier   &  n);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a07_sb_put_error (
    tak_all_command_glob  &  acv,
    tgg00_BasisError         b_err,
    tsp00_Int4               err_code,
    tgg04_Err             &  err);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a07_tb_put_error (
    tak_all_command_glob  &  acv,
    tgg00_BasisError         b_err,
    tsp00_Int4               err_code,
    tgg00_Surrogate       &  tab_id);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a07_intern_error_put (
    tak_all_command_glob  &  acv);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a07ak_system_error (
    tak_all_command_glob  &  acv,
    integer                  modul_no,
    integer                  id);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a07const_param (
    tak_all_command_glob  &  acv,
    integer                  param_no,
    tsp00_MoveObjPtr         param_addr,
    integer                  param_len);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a07msg_kernelsink_get (
    tak_all_command_glob  &  acv,
    tsp00_Int2               msgno,
    tak_order_errortext   &  err_text,
    integer               &  msglen);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a07_uni_error (
    tak_all_command_glob  &  acv,
    tsp8_uni_error_Param     uni_err,
    tsp00_Int4               err_code);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a07_hex_uni_error (
    tak_all_command_glob  &  acv,
    tsp8_uni_error_Param     uni_err,
    tsp00_Int4               err_code,
    pasbool                  to_unicode,
    tsp00_MoveObjPtr         bytestr,
    tsp00_Int4               len);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a07parm3_put_error (
    tak_all_command_glob  &  acv,
    tgg00_BasisError         b_err,
    tsp00_Int4               err_code,
    tsp00_KnlIdentifier   &  param1,
    tsp00_KnlIdentifier   &  param2,
    tsp00_KnlIdentifier   &  param3);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a07put_error_pos (
    tak_all_command_glob  &  acv,
    tsp00_Int4               err_pos);

/* Don't edit this file by hand, it is generated by ptocProto.py */


#endif

