/*

    @author DanielD

    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbc.packet;

import java.io.*;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.vsp001.*;

/**
 *
 */
public class ProcReplyPacket
    extends RequestPacket
{
    /**
     * creates a new ProcReplyPacket
     */
    public
    ProcReplyPacket (
        StructuredMem rawPacket)
    {
        super (rawPacket);
        this.initializePacket ((short)1);
        this.initSegment ();
    }
    /**
     *
     */
    public void
    initSegment ()
    {
        StructuredMem packet = this.mem;
        int pos = this.createSegment (SegmKind.Procreply_C);
        /*
         * fill return info
         */
        packet.putString ("00000",  pos + Segment.SqlState_O);
        packet.putInt2 (pos, Segment.Returncode_O);
        packet.putInt4 (pos, Segment.ErrorPos_O);
        packet.putInt2 (pos, Segment.ExternWarning_O);
        packet.putInt2 (pos, Segment.InternWarning_O);
        packet.putInt2 (pos, Segment.FunctionCode_O);
        packet.putInt1 (pos, Segment.TraceLevel_O);
    }
    /**
     *
     */
    public void
    setStopInfo (
        int errorCode,
        String errorMessage)
    {
        StructuredMem packet = this.mem;
        int pos = this.segmOffs;
        packet.putInt2 (errorCode, pos + Segment.Returncode_O);
        DataPart part = this.newDataPart (PartKind.Errortext_C);
        this.addString (errorMessage);
    }
    /**
     *
     */
    public void
    setExceptionInfo (
        Throwable exc)
    {
        this.setStopInfo (-4711, exc.toString ());
        /*
         * convert traceback to string
         */
        ByteArrayOutputStream bytes = new  ByteArrayOutputStream();
        PrintStream ostream = new PrintStream (bytes);
        exc.printStackTrace (ostream);
        /*
         * copy traceback string to reply packet
         */
        DataPart part = this.newDataPart (PartKind.MessageList_C);
        this.addString (bytes.toString ());
    }
    /**
     *
     */
    public void
    hexDump ()
    {
        this.mem.traceOn (System.out, this.length ());
    }
    /**
     *
     */
    public void
    hexDump (int length)
    {
        this.mem.traceOn (System.out, length);
    }

}
