/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.rte.comm;

/**
 * a packet layout suitable for communication with the dbm server.
 *
 * Sizes are currently constants as the packet size is fixed.
 */
class CserverPacketLayout
    implements com.sap.dbtech.rte.comm.PacketLayout
{
    /**
     * the maximal size of a command the client can send to the server.
     * @return int
     */
    public int maxCmdDataLength () {
        return this.maxDataLength () - this.minReplySize ();
    }
    /**
     * the maximal size of request + reply
     */
    public int maxDataLength() {
        return 16336;
    }
    /**
     * the maximal size of the whole packet (including RTE data)
     */
    public int maxSegmentSize() {
        return 16386;
    }
    /**
     * the minimal size of a reply
     */
    public int minReplySize() {
        return 100;
    }
    /**
     *
     */
    public int packetSize() {
        return AdminConstants.packetSize_C;
    }
    /**
     *
     */
    public void
    dumpOn (
        java.io.PrintStream out,
        String comment)
    {
        out.println ("CServerPacketLayout: " + comment);
        out.println ("    packetSize: " + this.packetSize ());
        out.println ("    maxSegmentSize: " + this.maxSegmentSize ());
        out.println ("    maxDataLength: " + this.maxDataLength ());
        out.println ("    minReplySize: " + this.minReplySize ());
    }
    /* (non-Javadoc)
     * @see com.sap.dbtech.rte.comm.PacketLayout#isChallengeResponseSupported()
     */
    public boolean isChallengeResponseSupported() {
        
        return false;
    }
}