/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/
package com.sap.dbtech.util;

/**
 * This class collects the message keys of the JDBC driver.
 */
public class MessageKey
{
	/**
     * An RTEException was thrown in a connect operation.
     */
    public static final String ERROR_CONNECTRTEEXCEPTION="error.connect.rteexception";

    /**
     * The transaction isolation level set as option is invalid.
     */
    public static final String ERROR_INVALIDTRANSACTIONISOLATION="error.invalid.transactionisolation";

    /*
     * The transport option was set to an invalid value.
     */
    public static final String ERROR_INVALIDTRANSPORT="error.invalid.transport";

    /**
     * Native support library was not initialised.
     */
    public static final String ERROR_LIBRARYNOTLOADED="error.library.notloaded";

    /**
     * Value overflow.
     */
    public static final String ERROR_VALUEOVERFLOW="error.valueoverflow";

    /**
     * Database exception (with error position).
     */
    public static final String ERROR_DATABASEEXCEPTION="error.databaseexception";

    /**
     * Database exception (without error position).
     */
    public static final String ERROR_DATABASEEXCEPTION_WOERRPOS="error.databaseexception.woerrpos";

    /**
     * Invalid argument value.
     */
    public static final String ERROR_INVALIDARGUMENTVALUE="error.invalid.argumentvalue";

    /**
     * Invalid argument value, correct examples are given.
     */
    public static final String ERROR_INVALIDARGUMENTVALUE_WEXAMPLE="error.invalid.argumentvalue.wexample";

    /**
     * Invalid column index.
     */
    public static final String ERROR_INVALIDCOLUMNINDEX="error.invalidcolumnindex";

    /**
     * Invalid column name.
     */
    public static final String ERROR_INVALIDCOLUMNNAME="error.invalidcolumnname";

    /**
     * Something is not yet there.
     */
    public static final String ERROR_NOTIMPLEMENTED="error.notimplemented";

    /**
     * Stream for LONG input could not be resetted.
     */
	public static final String ERROR_RESET_STREAM = "error.reset.stream";

     /**
     * An object is closed but shouldn't.
     */
    public static final String ERROR_OBJECTISCLOSED="error.objectisclosed";


    /**
     * A time out.
     */
    public static final String ERROR_TIMEOUT="error.timeout";

    /**
     * Restart required.
     */
    public static final String ERROR_RESTARTREQUIRED="error.restart.required";

    /**
     * Invariant: messswap <= 0
     */
    public static final String ERROR_INVARIANT_MESSSWAP="error.invariant.messswap";

    /**
     * No longdata packet.
     */
    public static final String ERROR_LONGDATAEXPECTED="error.longdata.expected";

    /**
     * Invalid startposition for long data. 
     */
	public static final String ERROR_INVALID_STARTPOSITION = "error.invalid.startposition";

    /**
     * SQL -> Java type conversion.
     */
    public static final String ERROR_CONVERSIONSQLJAVA="error.conversion.sqljava";

    /**
     * Java -> SQL type conversion.
     */
    public static final String ERROR_CONVERSIONJAVASQL="error.conversion.javasql";

    /**
     * Data -> any type conversion.
     */
    public static final String ERROR_CONVERSIONDATA="error.conversion.data";

    /**
     * VDN Number -> BigDecimal conversion.
     */
    public static final String ERROR_CONVERSIONVDNnumber="error.conversion.VDNnumber";

    /**
     * VDN Number -> Special Null value.
     */
    public static final String ERROR_CONVERSIONSpecialNullValue="error.conversion.SpecialNullValue";

    /**
     * Unsupported blob navigation.
     */
    public static final String ERROR_MOVEBACKWARDINBLOB="error.movebackwardinblob";

    /**
     * Try to read ASCII data from LONG column.
     */
    public static final String ERROR_ASCIIREADFROMLONG="error.asciireadfromlong";

    /**
     * Try to read binary data from LONG column.
     */
    public static final String ERROR_BINARYREADFROMLONG="error.binaryreadfromlong";

    /**
     * Try to put ASCII data into LONG column.
     */
    public static final String ERROR_ASCIIPUTTOLONG="error.asciiputtolong";

    /**
     * Try to put ASCII data into LONG column.
     */
    public static final String ERROR_UNICODETOASCII="error.unicodetoAscii";

    /**
     * No data type translator.
     */
    public static final String ERROR_NOTRANSLATOR="error.notranslator";

    /**
     * Try to put binary data into LONG column.
     */
    public static final String ERROR_BINARYPUTTOLONG="error.binaryputtolong";

    /**
     * Call of addBatch on prepared statement (not ok).
     */
    public static final String ERROR_PREPAREDSTATEMENT_ADDBATCH="error.addbatch.preparedstatement";
    
    /**
     * Call of cancel occured.
     */
    public static final String ERROR_STATEMENT_CANCELLED="error.statement.cancelled";


    /**
     * Try to execute null statement.
     */
    public static final String ERROR_SQLSTATEMENT_NULL="error.sqlstatement.null";

    /**
     * Try to execute too long statement.
     */
    public static final String ERROR_SQLSTATEMENT_TOOLONG="error.sqlstatement.toolong";

    /**
     * IN or OUT param missing.
     */
    public static final String ERROR_MISSINGINOUT="error.missinginout";

    /**
     * Statement in batch generated result set.
     */
    public static final String ERROR_BATCHRESULTSET="error.batchresultset";

    /**
     * Statement in batch generated result set.
     */
    public static final String ERROR_BATCHRESULTSET_WITHNUMBER="error.batchresultset.withnumber";

    /**
     * Procedure call in batch contained OUT/INOUT.
     */
    public static final String ERROR_BATCHPROCOUT="error.batchprocout";

    /**
     * Procedure call in batch contained OUT/INOUT.
     */
    public static final String ERROR_BATCHMISSINGIN="error.batchmissingin";

    /**
     * A statement executed as query delivered a row count.
     */
    public static final String ERROR_SQLSTATEMENT_ROWCOUNT="error.sqlstatement.rowcount";

    /**
     * A statement executed as update delivered a result set.
     */
    public static final String ERROR_SQLSTATEMENT_RESULTSET="error.sqlstatement.resultset";

    /**
     * A statement assumed to be a procedure call is not one.
     */
    public static final String ERROR_SQLSTATEMENT_NOPROCEDURE="error.sqlstatement.noprocedure";

    /**
     * Column index not found.
     */
    public static final String ERROR_COLINDEX_NOTFOUND="error.colindex.notfound";

    /**
     * User name missing.
     */
    public static final String ERROR_NOUSER="error.nouser";

    /**
     * Password missing.
     */
    public static final String ERROR_NOPASSWORD="error.nopassword";

    /**
     * Password invalid.
     */
    public static final String ERROR_INVALIDPASSWORD="error.invalidpassword";

    /**
     * Savepoint for auto-commit mode session.
     */
    public static final String ERROR_CONNECTION_AUTOCOMMIT="error.connection.autocommit";

    /**
     * Argument to row is 0.
     */
    public static final String ERROR_ROW_ISNULL="error.row.isnull";

    /**
     * Try to get record at position < first.
     */
    public static final String ERROR_RESULTSET_BEFOREFIRST="error.resultset.beforefirst";

    /**
     * Try to get record at position > last.
     */
    public static final String ERROR_RESULTSET_AFTERLAST="error.resultset.afterlast";

    /**
     * Try to fetch <0 or >maxrows items
     */
    public static final String ERROR_INVALID_FETCHSIZE="error.invalid.fetchsize";

    /**
     * Try to set a field size of too less or to much
     */
    public static final String ERROR_INVALID_MAXFIELDSIZE="error.invalid.maxfieldsize";

    /**
     * Try to set maxrows to less than 0.
     */
    public static final String ERROR_INVALID_MAXROWS="error.invalid.maxrows";

    /**
     * Try to set query timeout < 0.
     */
    public static final String ERROR_INVALID_QUERYTIMEOUT="error.invalid.querytimeout";

    /**
     * Try to update r/o result set.
     */
    public static final String ERROR_RESULTSET_NOTUPDATABLE="error.resultset.notupdatable";

    /**
     * Try to retrieve named savepoint by index.
     */
    public static final String ERROR_NAMED_SAVEPOINT="error.named.savepoint";

    /**
     * Try to retrieve unnamed savepoint by name.
     */
    public static final String ERROR_UNNAMED_SAVEPOINT="error.unnamed.savepoint";

    /**
     * Try to use something as save point.
     */
    public static final String ERROR_NO_SAVEPOINTSAPDB="error.nosavepointsapdb";

    /**
     * Try to use released savepoint
     */
    public static final String ERROR_SAVEPOINT_RELEASED="error.savepoint.released";

    /**
     * Parse id part not found.
     */
    public static final String ERROR_PARSE_NOPARSEID="error.parse.noparseid";

    /**
     * No column names delivered from kernel.
     */
    public static final String ERROR_NO_COLUMNNAMES="error.no.columnnames";

    /**
     * Fieldinfo part not found.
     */
    public static final String ERROR_PARSE_NOFIELDINFO="error.parse.nofieldinfo";

    /**
     * Data part not found after execute.
     */
    public static final String ERROR_NODATAPART="error.nodatapart";

    /**
     * Statement assigned for updatable is not
     */
    public static final String ERROR_NOTUPDATABLE="error.notupdatable";

    /**
     * Call statement did not deliver output data (DB Procedure stopped).
     */
    public static final String ERROR_NOOUTPARAMDATA="error.nooutparamdata";

    /**
     * Unknown kind of part.
     */
    public static final String WARNING_PART_NOTHANDLED="warning.part.nothandled";

    /**
     * SQL Exception while updating result set.
     */
    public static final String ERROR_INTERNAL_PREPAREHELPER="error.internal.preparehelper";

    /**
     * Connection field is null.
     */
    public static final String ERROR_INTERNAL_CONNECTIONNULL="error.internal.connectionnull";

    /**
     * No more input expected at this place.
     */
    public static final String ERROR_INTERNAL_UNEXPECTEDINPUT="error.internal.unexpectedinput";

    /**
     * No more output expected at this place.
     */
    public static final String ERROR_INTERNAL_UNEXPECTEDOUTPUT="error.internal.unexpectedoutput";

    /**
     * Internal JDBC error: parse id is null.
     */
    public static final String ERROR_INTERNAL_INVALIDPARSEID="error.internal.invalidParseid";

    /**
     * No updatable columns found.
     */
    public static final String ERROR_NOCOLUMNS_UPDATABLE="error.nocolumns.updatable";

    /**
     * Runtime: unknown host.
     */
    public static final String ERROR_UNKNOWN_HOST="error.unknown.host";

    /**
     * Runtime: connect to host failed.
     */
    public static final String ERROR_HOST_CONNECT="error.host.connect";
    
    /**
     * Runtime: connect to host failed.
     */
    public static final String ERROR_HOST_NICONNECT="error.host.niconnect";
       
    /**
     * Runtime: connect to host failed.
     */
    public static final String ERROR_WRONG_CONNECT_URL="error.host.wrongconnecturl";
    /**
     * Runtime: load ni libraries failed.
     */
    public static final String ERROR_LOAD_NILIBRARY="error.host.niloadlibrary";
    /**
     * Runtime: receive of connect failed.
     */
    public static final String ERROR_RECV_CONNECT="error.recv.connect";

    /**
     * Runtime: receive garbled reply
     */
    public static final String ERROR_REPLY_GARBLED="error.connectreply.garbled";

    /**
     * Runtime: connect reply receive failed
     */
    public static final String ERROR_CONNECT_RECVFAILED="error.connect.receivefailed";

    /**
     * Runtime: data receive failed
     */
    public static final String ERROR_DATA_RECVFAILED="error.data.receivefailed";

    /**
     * Runtime: data receive failed (w reason)
     */
        public static final String ERROR_DATA_RECVFAILED_REASON="error.data.receivefailed.reason";

    /**
     * Runtime: reconnect on admin session unsupported
     */
    public static final String ERROR_ADMIN_RECONNECT="error.admin.reconnect";

    /**
     * Runtime: invalid swapping
     */
    public static final String ERROR_INVALID_SWAPPING="error.invalid.swapping";

    /**
     * Runtime: send: getoutputstream failed (IO exception)
     */
    public static final String ERROR_SEND_GETOUTPUTSTREAM="error.send.getoutputstream";

    /**
     * Runtime: send: write failed (IO exception)
     */
    public static final String ERROR_SEND_WRITE="error.send.write";

    /**
     * Runtime: chunk overflow in read
     */
    public static final String ERROR_CHUNKOVERFLOW="error.chunkoverflow";


    /**
     * Util/printf: too few arguments for formatting.
     */
    public static final String ERROR_FORMAT_TOFEWARGS="error.format.toofewargs";

    /**
     * Util/printf: format string must start with '%'
     */
    public static final String ERROR_FORMAT_PERCENT="error.format.percent";

    /**
     * Util/printf: number object is not a number
     */
    public static final String ERROR_FORMAT_NOTANUMBER="error.format.notanumber";

    /**
     * Util/printf: unknown format spec
     */
    public static final String ERROR_FORMAT_UNKNOWN="error.format.unknown";

    /**
     * Util/printf: number object is not a number
     */
    public static final String ERROR_FORMAT_TOOMANYARGS="error.format.toomanyargs";

    /**
     * No result set.
     */
    public static final String WARNING_EMPTY_RESULTSET="warning.emptyresultset";

    /**
     * <code>executeQuery(String)</code> called on <code>PreparedStatement</code>.
     */
    public static final String ERROR_EXECUTEQUERY_PREPAREDSTATEMENT="error.executequery.preparedstatement";

    /**
     * <code>executeUpdate(String)</code> called on <code>PreparedStatement</code>.
     */
    public static final String ERROR_EXECUTEUPDATE_PREPAREDSTATEMENT="error.executeupdate.preparedstatement";

    /**
     * Internal: <code>maxRows</code> inside result but end of result unknown (should not happen).
     */
    public static final String ERROR_ASSERTION_MAXROWS_IN_RESULT="error.assertion.maxrowsinresult";

    /**
     * An illegal operation for a FORWARD_ONLY result set.
     */
    public static final String ERROR_RESULTSET_FORWARDONLY="error.resultset.forwardonly";

    /**
     * <code>cancelRowUpdates</code> called while on insert row.
     */
    public static final String ERROR_CANCELUPDATES_INSERTROW="error.cancelupdates.insertrow";

    /**
     * <code>deleteRow</code> called while on insert row.
     */
    public static final String ERROR_DELETEROW_INSERTROW="error.deleterow.insertrow";

    /**
     * <code>deleteRow</code> called while on insert row.
     */
    public static final String ERROR_UPDATEROW_INSERTROW="error.updaterow.insertrow";

    /**
     * <code>insertRow</code> called while not on insert row.
     */
    public static final String ERROR_INSERTROW_INSERTROW="error.insertrow.insertrow";

    /**
     * <code>deleteRow</code> called while not positioned at a row
     */
    public static final String ERROR_DELETEROW_NOROW="error.deleterow.norow";

    /**
     * <code>updateRow</code> called while not positioned at a row
     */
    public static final String ERROR_UPDATEROW_NOROW="error.updaterow.norow";

    /**
     * <code>updateRow</code> called while not positioned at a row
     */
    public static final String ERROR_UPDATEROW_COLUMNNOTUPDATABLE="error.updaterow.columnnotupdatable";
    
    /**
     * Reading from a stream resulted in an IOException
     */
    public static final String ERROR_STREAM_IOEXCEPTION="error.stream.ioexception";

	/**
     * Problem in access to DatabaseMetaData.
	 */
	public static final String ERROR_NOMETADATA="error.nometadata";

    // jdbcext messages
    public static final String ERROR_DATABASE_NOT_SET="error.database.notset";
    public static final String ERROR_CONNECTION_INVALIDATED="error.connection.invalidated";
    public static final String ERROR_COMMIT_XASESSION="error.commit.xasession";
    public static final String ERROR_ROLLBACK_XASESSION="error.rollback.xasession";
    public static final String ERROR_AUTOCOMMIT_XASESSION="error.autocommit.xasession";

    public static final String ERROR_MANDATORY_PROPERTY_NOTFOUND="error.mandatory.property.notfound";
    public static final String ERROR_NOT_STRINGREFADDR="error.not.stringrefaddr";
    public static final String ERROR_NOT_STRING_CONTENT="error.not.string.content";
    public static final String ERROR_NOT_NULL_CONTENT="error.not.null.content";

    public static final String ERROR_JNDILOOKUP_FAILED="error.connection.JNDILookup";

    // unsupported database features
    public static final String ERROR_ARRAY_UNSUPPORTED="error.array.unsupported";
    public static final String ERROR_TIMEZONE_UNSUPPORTED="error.timezone.unsupported";
    public static final String ERROR_REF_UNSUPPORTED="error.ref.unsupported";
    public static final String ERROR_URL_UNSUPPORTED="error.url.unsupported";
    public static final String ERROR_MEMORYRESULT_METHOD_UNSUPPORTED="error.memoryresult.method.unsupported";
    public static final String ERROR_AUTOGENKEYS_RETRIEVAL_UNSUPPORTED="error.autogenkeys.retrieval.unsupported";
    public static final String ERROR_SPECIAL_NUMBER_UNSUPPORTED="error.special.number.unsupported";

    // unimplemented todos
    public static final String ERROR_SETBYTES_NOTIMPLEMENTED="error.setbytes.notimplemented";
    public static final String ERROR_SETBINARYSTREAM_NOTIMPLEMENTED="error.setbinarystream.notimplemented";
    public static final String ERROR_TRUNCATE_NOTIMPLEMENTED="error.truncate.notimplemented";
    public static final String ERROR_SETSTRING_NOTIMPLEMENTED="error.setstring.notimplemented";
    public static final String ERROR_SETASCIISTREAM_NOTIMPLEMENTED="error.setasciistream.notimplemented";
    public static final String ERROR_SETCHARACTERSTREAM_NOTIMPLEMENTED="error.setcharacterstream.notimplemented";
    public static final String ERROR_GETSUBSTRING_NOTIMPLEMENTED="error.getsubstring.notimplemented";
    public static final String ERROR_POSITION_NOTIMPLEMENTED="error.position.notimplemented";
    public static final String ERROR_GETBYTES_NOTIMPLEMENTED="error.getbytes.notimplemented";
    public static final String ERROR_GETOBJECT_NOTIMPLEMENTED="error.getobject.notimplemented";
    public static final String ERROR_PREPARESTATEMENT_NOTIMPLEMENTED="error.preparestatement.notimplemented";
    public static final String ERROR_GETCOLUMNCLASSNAME_NOTIMPLEMENTED="error.getcolumnclassname.notimplemented";
    public static final String ERROR_MEMORYRESULT_METHOD_NOTIMPLEMENTED="error.memoryresult.method.notimplemented";
	public static final String ERROR_CODESET_UNSUPPORTED="error.codeset.unsupported";
	
    // communication errors
    public static final String COMMERROR_OK="commerror.ok";
    public static final String COMMERROR_CONNECTDOWN="commerror.connectiondown";
    public static final String COMMERROR_TASKLIMIT="commerror.tasklimit";
    public static final String COMMERROR_TIMEOUT="commerror.timeout";
    public static final String COMMERROR_CRASH="commerror.crash";
    public static final String COMMERROR_RESTARTREQUIRED="commerror.restartrequired";
    public static final String COMMERROR_SHUTDOWN="commerror.shutdown";
    public static final String COMMERROR_SENDLINEDOWN="commerror.sendlinedown";
    public static final String COMMERROR_RECVLINEDOWN="commerror.recvlinedown";
    public static final String COMMERROR_PACKETLIMIT="commerror.packetlimit";
    public static final String COMMERROR_RELEASED="commerror.released";
    public static final String COMMERROR_WOULDBLOCK="commerror.wouldblock";
    public static final String COMMERROR_UNKNOWNREQUEST="commerror.unknownrequest";
    public static final String COMMERROR_SERVERDBUNKNOWN="commerror.serverdbunknown";

	// OMS Streams
	public static final String ERROR_STREAM_ODDSIZE="error.stream.oddsize";
	public static final String ERROR_CONVERSION_STRINGSTREAM ="error.stream.conversion.string";
	public static final String ERROR_STREAM_SOURCEREAD = "error.stream.sourceread";
	public static final String ERROR_CONVERSION_BYTESTREAM="error.stream.conversion.bytes";
	public static final String ERROR_STREAM_EOF="error.stream.eof";
	public static final String ERROR_STREAM_NODATA="error.stream.nodata";
	public static final String ERROR_STREAM_UNKNOWNTYPE="error.stream.unknowntype";
	public static final String ERROR_STREAM_ISATEND="error.stream.isatend";
	public static final String ERROR_CONVERSION_STRUCTURETYPE="error.conversion.structuretype";	
	public static final String ERROR_STRUCTURE_INCOMPLETE="error.structure.incomplete";
	public static final String ERROR_STRUCTURE_COMPLETE="error.structure.complete";				
	public static final String ERROR_STRUCTURE_ARRAYWRONGLENTGH="error.structure.arraywronglength";
	public static final String ERROR_STRUCT_ELEMENT_NULL="error.structure.element.null";
	public static final String ERROR_STRUCT_ELEMENT_CONVERSION="error.structure.element.conversion";
	public static final String ERROR_STRUCT_ELEMENT_OVERFLOW="error.structure.element.overflow";
	public static final String ERROR_STREAM_BLOB_UNSUPPORTED="error.stream.blob.unsupported";
	public static final String ERROR_INVALID_BLOB_POSITION="error.invalid.blob.position";	
	// LONG in DBPROCs
	public static final String ERROR_UNKNOWN_PROCEDURELONG="error.unknown.procedurelong";
	public static final String ERROR_MESSAGE_NOT_AVAILABLE="error.message.notavailable";

    // Connection
	public static final String ERROR_CONNECTION_WRONGSERVERCHALLENGERECEIVED="error.connection.wrongserverchallengereceived";
	public static final String ERROR_CONNECTION_CHALLENGERESPONSENOTSUPPORTED="error.connection.challengeresponsenotsupported";
	// the rest
    public static final String ERROR="error";
    public static final String UNKNOWNTYPE="unknowntype";
    public static final String COMMERROR="commerror";
    public static final String INPUTPOS="inputpos";

}
