#!/usr/bin/env python
# testptoc.py

import sys
import os
import shutil

def fatalError (msg):
    sys.stderr.write ('testptoc: ' + msg + '\n')
    sys.exit (2)

def getPascalFiles (directory):
    result = []
    for entry in os.listdir (directory):
        if entry [-2:] == '.p':
            result.append (entry)
    return result

def testptoc (options, directory):
    sources = getPascalFiles (directory)
    ok = 1
    for source in sources:
        if not os.path.exists (source):
            shutil.copy (os.path.join (directory, source), '.')
        print source, '...',
        rc = os.system (options.ptocCmd + source)
        if rc != 0:
            print 'failed with rc', rc
            ok = None
            continue
        base = source [:-2]
        cfile = base + '.c'
        original = os.path.join (directory, base + '.org.c')
        diffRC = os.system ('diff -q %s %s' % (original, cfile))
        if diffRC == 0:
            print 'OK'
            os.remove (cfile)
            os.remove (source)
        else:
            print 'Difference'
            ok = None
    return ok

def checkOptions (options):
    if not options.tool:
        fatalError ('option -tool must be set')
    ptoc = os.path.join (options.tool, 'pgm', 'ptoc')
    if not os.path.exists (ptoc):
        ptoc = os.path.join (options.tool, 'bin', 'ptoc')
        if not os.path.exists (ptoc):
            fatalError ('Cannot find ptoc executable')
    os.environ ['TOOL'] = options.tool
    ptocCmd = ptoc + ' -qn -e '
    if options.slow:
        ptocCmd = ptocCmd + '-C '
    options.ptocCmd = ptocCmd

def main (options, args):
    checkOptions (options)
    ok = 1
    if not args:
        args = [sys.path [0]]
    for arg in args:
        ok = testptoc (options, arg) and ok
    if not ok:
        sys.exit (3)

def _options ():
    return [
        # (optstring, varname, typechar, default, help)
        ('tool', None, ':', os.environ.get ('TOOL'), 'root of ptoc installation'),
        ('s', 'slow', '', None, 'add range checks'),
        ]

if __name__ == '__main__':
    import optlib
    optlib.optMain2 (main, _options ())
