#!/usr/bin/perl
# @(#) test_selector.pl	05-05-2004	Ulrich Jansen
#
# Bereitstellen eines Parameter-Strings fr die Tests.
#
#    ========== licence begin  GPL
#    Copyright (C) 2001 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
#

BEGIN {
	if ($^O !~ /win32/i) {
		unshift @INC, ("/devtool/TOOL/tool/lib/perl5", "/devtool/TOOL/tool/lib/Perl", "/devtool/TOOL/tool/bin", "/SAP_DB/TESTDB");
	}
	unshift @INC, ($^O =~ /win32/i ? "\\SAP_DB\\TESTDB\\lib" : "/SAP_DB/TESTDB/lib");
}

use strict;

use Net::HTTP;
use HTTP::Status;
use Sys::Hostname;
use File::Basename;
use XML::Simple;
use Getopt::Long;
use Time::Local;
use QAConnect;

$| = 1;
print "\nbenchmark_selector 0.1 (c)2005, SAP AG\n\n";

# Local Variables:

my $DEBUG = 1;
my $hostname 		= lc(hostname());
my $version;
my $status;
my $package;

# Read command line parameters:
GetOptions('package=s' => \$package);

if ($package =~ /^\d{4}(DEV|COR|RAMP|HOT)$/i) {
	$version = substr($package, 0, 4);
	$status  = substr($package, 4, 10);
} else {
	print "Wrong format: $package\n";
	exit(1);
}


QAConnect::setdbg($DEBUG);


################################################################################


# Get Servers data from QADB.
my ($rc, $href)     = QAConnect::httpsql_request("QADB_HTTPSQL", "select IDPLATFORM from TESTER.SERVERS where HOST like '$hostname\%'", 1); 
(ref($href) and $href->{'Rows'}->{'Row'}[0]->{'IDPLATFORM'}) or QAConnect::throw_error("UNKNOWN HOSTNAME", "This host ($hostname) has no entry in the SERVERS table!", 1);

my $idplatform = $href->{'Rows'}->{'Row'}[0]->{'IDPLATFORM'};

my ($rc, $href)     = QAConnect::httpsql_request("QADB_HTTPSQL", "select ID from TESTER.TO_BENCHMARK where VERSION = '$version' and QASTATUS = '$status' and IDPLATFORM = $idplatform and IDOBJSTATUS > 999 ORDER BY id DESC", 1); 
(ref($href) and $href->{'Rows'}->{'Row'}[0]->{'ID'}) or QAConnect::throw_error("COULD NOT FIND ANYTHING", "Can not find a entry for $package!", 1);


my $idtestmake = $href->{'Rows'}->{'Row'}[0]->{'ID'};

print "ID=$idtestmake\n";

