#!/devtool/local/bin/perl
#
# Perform the tests on a chr-Based db-Installation
#
BEGIN {
    if ($^O !~ /MSWin32/i) {
		unshift @INC, "/devtool/local/bin";
		unshift @INC, "/devtool/TOOL/tool/bin";
		unshift @INC, "/devtool/TOOL/tool/lib/perl5";
		unshift @INC, "/devtool/TOOL/tool/lib";
		unshift @INC, "/SAP_DB/TESTDB/lib";
		unshift @INC, "/SAP_DB/TESTDB";
    }
}
$| = 1;

use testdbchr;
use IniFile;
use POSIX ":sys_wait_h";

my $newpid;

use Getopt::Long;
my %options = ();
if (! &GetOptions(  \%options,
            'h|help|?',
	    'no_objstat',            
	    'test_profile=s',
	    'dir=s',
	    'cfg=s'
            )) {
	print("Run testdb.pl -h for help");
	exit(1);
}

if ($options{'test_profile'} ne "weekend") {
        $options{'test_profile'} = "workday";
}

my $tdb;
my $cfg = "";

if ($options{'dir'}) {
	
	$options{'dir'} = ($options{'dir'} =~ /^0.*/ ? $options{'dir'} : "0$options{'dir'}");
	
	#
	# Get the .cfg-File right
	#
	
	if ($options{'cfg'}) {
		if (!(-r $options{'cfg'})) {
			print "Could not read $cfg\nExiting\n";
			exit(1);
		}
		$cfg = $options{'cfg'};
	}
	
	print "Reading configuration in /SAP_DB/chr/etc/$options{'dir'}..";
	
	my $etc_ref = IniFile::load("/SAP_DB/chr/etc/$options{'dir'}");
	unless($etc_ref) {
		print "..FAILED\n";
		exit(1);
	}
		
	print "OK\nChecking configuration parameters..";
	unless ($etc_ref->{'IDMAKE'} && $etc_ref->{'IDSESSION'}) {
		print "..FAILED\n\tIDMAKE = $etc_ref->{'IDMAKE'}\n\tIDSESSION = $etc_ref->{'IDSESSION'}\n";
		exit(1);
	}
	
	print "..OK\nCreating new testdbchr-Instance..\n";
	$tdb = testdbchr->new({	'ID' => $etc_ref->{'IDMAKE'},
				'profile' => $options{'test_profile'},
				'DIR' => $options{'dir'},
				'profile' => $options{'test_profile'},
				'no_objstat' => ($options{'no_objstat'} ? 1 : 0),
				'CFG' => $cfg},
				{'ID' => $etc_ref->{'IDSESSION'}});
				
	print "..OK\nSetting session-type..";
	$tdb->{'qah'}->set_sessiontype('NIGHT');
	print "..OK\n";
	
	
	$tdb->verify_chr();
	$tdb->jump_in_chr();
	
	$newpid = fork();
	
	if ($newpid) {
		$tdb->runTF();
		waitpid($newpid, 0);
		exit(0);
	}
	sleep 120;
	$tdb->run_lowtrack();
	
} else {
	print "$0 - Execute the Standard-Tests in a chr-Area. Syntax:\n$0 -dir <CHR_DIRECTORY>\n";
}

exit (0);


