;;; -*- Mode: Lisp; Package: Macsyma -*-                                 ;;;
;;;    (c) Copyright 1984 the Regents of the University of California.   ;;;
;;;        All Rights Reserved.                                          ;;;
;;;        This work was produced under the sponsorship of the           ;;;
;;;        U.S. Department of Energy.  The Government retains            ;;;
;;;        certain rights therein.                                       ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(macsyma-module scifac)

(declare (special $negdistrib))

(defmacro make-expt (base exponent) ``((mexpt simp) ,,base ,,exponent))

(defmacro acceptable-power (x)
   `(and (alike1 (cadr ,x) var)
         (setq minpow (cond (nstate (and (fixp expon) (min minpow expon)))
                            (number (and ($numberp expon)
                                         (fixp (sub minpow expon))
                                         ($min minpow expon)))
                            (t
                             (let ((powdif (sub minpow expon)))
                               (cond ((fixp powdif)
                                      (cond ((> powdif 0) expon)
                                            (t minpow)))
                                     (t
                                      (let ((g ($gcd minpow expon)))
                                        (let ((d1 ($ratsimp (div minpow g)))
                                              (d2 ($ratsimp (div expon g))))
                                          (and (fixp d1)
                                               (fixp d2)
                                               (cond ((> d1 d2) expon)
                                                     (t minpow)))))))))))
         (or (eq expon-sign
                 (cond (number (mnegp expon))
                       ((mtimesp expon)
                        (equal -1 (cadr expon)))))
             (return nil))))

(defun factorout-monomial (exp)
  (let ((monomials)
        (lead-term (cadr exp))
        (alone t)
        (minuslogic (and (> (length exp) 3)
                         (let ((minusobj (car (last exp))))
                           (cond ((fixp minusobj) (minusp minusobj))
                                 ((mtimesp minusobj)
                                  (and (fixp (cadr minusobj))
                                       (minusp (cadr minusobj)))))))))
    (do ((rem-prod (cond ((or ($mapatom lead-term)
                              (eq (caar lead-term) 'mexpt))
                          (ncons lead-term))
                         ((eq (caar lead-term) 'mtimes)
                          (setq alone nil)
                          (cdr lead-term))
                         (t nil))
                   (cdr rem-prod))
         (follow lead-term rem-prod)
         (j 1 (1+ j)))
        ((null rem-prod)
         (cond ((null monomials) exp)
               (t
                (let (($negdistrib))
                  (muln `(,.monomials ,(addn (cdr exp) nil)) nil)))))
      (let ((potentl-mon (car rem-prod)) (truth) (leadfix))
        (cond ((or (setq leadfix (fixp potentl-mon)) minuslogic)
               (let ((intgcd (cond (leadfix potentl-mon)
                                   (t (prog1 1
					(cond (alone
					       (rplaca (cdr exp) `((mtimes simp) 1 ,potentl-mon))
					       (setq rem-prod (cdadr exp)
						     alone nil))
					      (t (rplacd follow (append (ncons 1) rem-prod))
						 (setq rem-prod (cdr follow))))))))
                     (single (list (and leadfix alone))))
                 (do ((ge (cddr exp) (cdr ge))
                      (all-minus (minusp intgcd)))
                     ((null ge)
                      (and (or minuslogic all-minus)
                           (or (minusp intgcd)
                               (setq intgcd (- intgcd)))
                           (setq minuslogic nil))
                      (or (equal intgcd 1)
                          (progn
			    (setq monomials `(,@monomials ,intgcd))
			    (do ((redu-const (cdr exp) (cdr redu-const))
				 (in-follow exp redu-const)
				 (logic single (cdr logic)))
				((null redu-const))
			      (let ((term1 (car redu-const)))
				(cond ((car logic) (rplaca redu-const (quotient term1 intgcd)))
				      (t (cond ((equal 1 (car (rplaca (cdr term1) (quotient (cadr term1) intgcd))))
						(and (eq logic single)
						     (setq j (1- j)
							   rem-prod follow))
						(rplacd term1 (cddr term1))
						(or (cddr term1)
						    (let ((pluscontac (cadr term1)))
						      (cond ((mplusp pluscontac)
							     (rplacd in-follow (append (cdr pluscontac) (cdr redu-const)))
							     (setq redu-const (nthcdr (1- (length pluscontac)) in-follow))
							     (and (eq logic single)
								  (let ((new-lead (cadr exp)))
								    (cond ((mtimesp new-lead)
									   (setq rem-prod new-lead))
									  (t (setq alone t
										   rem-prod `(nil ,new-lead)))))))
							    (t (rplaca redu-const pluscontac)
							       (and (eq logic single)
								    (setq alone t)))))))))))))))
		   (let ((leadnum (car ge)))
		     (cond ((fixp leadnum)
			    (setq single `(,@single t)
				  intgcd (gcd intgcd leadnum)
				  all-minus (and all-minus (minusp leadnum))))
			   ((mtimesp leadnum)
			    (let ((numb (cadr leadnum)))
			      (cond ((fixp numb)
				     (setq single `(,@single nil)
					   intgcd (gcd intgcd numb)
					   all-minus (and all-minus (minusp numb))))
				    (minuslogic
				     (setq single `(,@single nil)
					   intgcd 1)
				     (rplacd leadnum (append (ncons 1) (cdr leadnum))))
				    (t (return nil)))))
			   (minuslogic
			    (setq single `(,@single nil)
				  intgcd 1)
			    (rplaca ge `((mtimes simp) 1 ,leadnum)))
			   (t (return nil)))))))
              (t (or ($mapatom potentl-mon)
                     (setq truth (eq (caar potentl-mon) 'mexpt)))
                 (let ((power (list (cond (truth (caddr potentl-mon))
                                          (t 1))))
                       (place (list (cond (alone -1)
                                          (t j))))
                       (var (cond (truth (cadr potentl-mon))
                                  (t potentl-mon))))
                   (let* ((minpow (car power)) (number ($numberp minpow)))
                     (do ((ge (cddr exp) (cdr ge))
                          (expon-sign (and truth
                                           (cond (number (mnegp minpow))
                                                 ((mtimesp minpow)
                                                  (equal -1 (cadr minpow))))))
                          (nstate (fixp minpow)))
                         ((null ge)
                          (or number (and expon-sign
                                          (setq minpow (mul -1 minpow))))
                          (setq monomials
                                `(,.monomials ,(cond ((equal minpow 1) var)
                                                     (t (make-expt (cadr potentl-mon) minpow)))))
                          (do ((deflate (cdr exp) (cdr deflate))
                               (d-follow exp deflate)
                               (pl place (cdr pl))
                               (pow power (cdr pow)))
                              ((null deflate))
                            (let ((pownum (car pow)) (plnum (car pl)))
                              (cond ((minusp plnum)
                                     (cond ((cond (nstate (equal pownum minpow))
                                                  (t (alike1 pownum minpow)))
                                            (rplaca deflate 1))
                                           (t (cond ((cond (nstate (equal pownum (add1 minpow)))
                                                           (t (alike1 pownum (add 1 minpow))))
                                                     (rplaca deflate (cadar deflate)))
                                                    (t (rplaca (cddar deflate) (cond (nstate (- pownum minpow))
                                                                                     (t (sub pownum minpow)))))))))
                                    (t (let* ((term (car deflate)) (point (nthcdr plnum term)))
                                         (cond ((cond (nstate (equal pownum minpow))
                                                      (t (alike1 pownum minpow)))
                                                (rplacd (nthcdr (1- plnum) term) (cdr point))
                                                (and (eq pl place)
                                                     (setq j (1- j)
                                                           rem-prod follow))
                                                (or (cddr term)
                                                    (let ((pluscontac (cadr term)))
                                                      (cond ((mplusp pluscontac)
                                                             (rplacd d-follow (append (cdr pluscontac) (cdr deflate)))
                                                             (setq deflate (nthcdr (1- (length pluscontac)) d-follow))
                                                             (and (eq pl place)
                                                                  (let ((new-lead (cadr exp)))
                                                                    (cond ((mtimesp new-lead)
                                                                           (setq rem-prod new-lead))
                                                                          (t (setq alone t
                                                                                   rem-prod `(nil ,new-lead)))))))
                                                            (t (rplaca deflate pluscontac)
                                                               (and (eq pl place)
                                                                    (setq alone t)))))))
                                               (t (cond ((cond (nstate (equal pownum (add1 minpow)))
                                                               (t (alike1 pownum (add 1 minpow))))
                                                         (rplaca point (cadar point)))
                                                        (t (rplaca (cddar point) (cond (nstate (- pownum minpow))
                                                                                       (t (sub pownum minpow))))))))))))))
                       (let ((exam-term (car ge)))
                         (cond (($mapatom exam-term)
                                (cond ((and nstate (alike1 exam-term var))
                                       (setq place `(,@place -1)
                                             minpow 1
                                             power `(,@power 1)))
                                      (t (return nil))))
                               ((eq (caar exam-term) 'mexpt)
                                (let ((expon (caddr exam-term)))
                                  (cond ((acceptable-power exam-term)
                                         (setq place `(,@place -2)
                                               power `(,@power ,expon)))
                                        (t (return nil)))))
                               ((eq (caar exam-term) 'mtimes)
                                (cond ((do ((pick (cdr exam-term) (cdr pick))
                                            (k 1 (1+ k)))
                                           ((null pick))
                                         (let ((morcel (car pick)))
                                           (cond (($mapatom morcel)
                                                  (cond ((and nstate
                                                              (alike1 morcel var))
                                                         (setq place `(,@place ,k)
                                                               minpow 1
                                                               power `(,@power 1))
                                                         (return t))))
                                                 ((eq (caar morcel) 'mexpt)
                                                  (let ((expon (caddr morcel)))
                                                    (cond ((acceptable-power morcel)
                                                           (setq place `(,@place ,k)
                                                                 power `(,@power ,expon))
                                                           (return t)))))
                                                 (t (cond ((and nstate
                                                                (alike1 morcel var)
                                                                (or (not expon-sign)
                                                                    (return nil)))
                                                           (setq place `(,@place ,k)
                                                                 minpow 1
                                                                 power `(,@power 1))
                                                           (return t))))))))
                                      (t (return nil))))
                               ((and nstate (alike1 exam-term var) (not expon-sign))
                                (setq place `(,@place -1)
                                      minpow 1
                                      power `(,@power 1)))
                               (t (return nil)))))))))))))


(defun pair-factor (gel flag)
  (cond ((and flag (or ($mapatom gel) (null (cdddr gel)))) gel)
        (t (do ((lcl (cdr gel) (cdr lcl))
                (backpnt gel lcl))
               ((null (cdr lcl)) gel)
             (let* ((pntr (add (car lcl) (cadr lcl)))
                    (g (factorout-monomial pntr)))
                (or (eq pntr g)
                    (progn (let ((again (more-subfactors-q g)))
                             (or (eq again g) (setq g again)))
                           (rplaca lcl g)
                           (let ((exp (cddr lcl)))
                             (rplacd lcl exp)
                             (and exp
                                  (pair-factor backpnt nil))
                             (return (cond ((null (cddr gel)) (cadr gel))
                                           (t gel)))))))))))


(defun more-subfactors-q (gg)
       (cond ((eq (caar gg) 'mtimes)
              (do ((lom (cdr gg) (cdr lom))
                   (modified)
                   (back gg lom))
                  ((null lom) (cond (modified (muln (cdr gg) t))
                                    (t gg)))
                (let ((obj (car lom)))
                  (and (mplusp obj)
                       (let ((pntr (pair-factor obj t)))
                         (or (eq pntr obj)
                             (let ((fit (cdr pntr)))
                               (rplacd back (append fit (cdr lom)))
                               (setq lom (nthcdr (length fit) back)
                                     modified t))))))))
             (t (pair-factor gg t))))


(defun gcfac-prodscan (x)
    (do ((inlev (cdr x) (cdr inlev))
         (modified)
         (backpnt x inlev))
        ((null inlev) (cond (modified (muln (cdr x) t))
                            (t x)))
      (let* ((possibl-sum (car inlev))
             (pntr (monomial-factor possibl-sum)))
        (or (eq pntr possibl-sum)
            (let ((fit (cdr pntr)))
              (rplacd backpnt (append fit (cdr inlev)))
              (setq inlev (nthcdr (length fit) backpnt)
                    modified t))))))


(defun monomial-factor (exp)
  (cond (($mapatom exp) exp) 
        ((eq (caar exp) 'mtimes)
         (gcfac-prodscan exp))
        ((eq (caar exp) 'mplus)
         (do ((mlm (cdr exp) (cdr mlm)))
             ((null mlm))
           (let ((potenl-prod (car mlm)))
             (cond ((mtimesp potenl-prod)
                    (let ((w (gcfac-prodscan potenl-prod)))
                      (or (eq w potenl-prod) (rplaca mlm w))))
                   (t (monomial-factor potenl-prod)))))
         (more-subfactors-q (factorout-monomial exp)))
        (t (do ((mlm (cdr exp) (cdr mlm)))
               ((null mlm) exp)
             (let* ((obj (car mlm)) (res (monomial-factor obj)))
               (or (eq obj res) (rplaca mlm res)))))))

(defun $gcfac (x)
   (cond (($mapatom x) x)
         (t (monomial-factor (copy-tree x)))))
                     
