""" The resource type for Python tuples. """


# Enthought library imports.
from enthought.envisage.resource import ObjectResourceType
from enthought.naming.adapter import TupleContextAdapterFactory
from enthought.traits.api import Tuple

# Local imports.
from tuple_node_type import TupleNodeType


class TupleResourceType(ObjectResourceType):
    """ The resource type for Python tuples. """

    #### 'ResourceType' interface #############################################

    # A trait that describes the kind of domain object that the type
    # represents.
    type = Tuple

    ###########################################################################
    # 'ResourceType' interface.
    ###########################################################################

    #### Initializers #########################################################

    def _node_type_default(self):
        """ Initializes the node type. """

        return TupleNodeType(resource_type=self)

    def _context_adapter_factory_default(self):
        """ Initializes the context adapter factory. """

        return TupleContextAdapterFactory()

##### EOF #####################################################################
