""" The action plugin definition. """


# Enthought library imports.
from enthought.envisage import PluginDefinition

# Plugin definition imports.
from enthought.envisage.action.action_plugin_definition import \
     Action, ActionSet, Group, Location, Menu


# The plugin's globally unique identifier (also used as the prefix for all
# identifiers defined in this module).
ID = "enthought.envisage.workbench.action"


###############################################################################
# Extension points.
###############################################################################

class WorkbenchActionSet(ActionSet):
    """ An action set is a collection of menus, groups and actions. """

    # A mapping from human-readable names to globally unique Ids.
    aliases = {
        'MenuBar' : 'enthought.envisage.workbench.menubar',
        'ToolBar' : 'enthought.envisage.workbench.toolbar'
    }

###############################################################################
# Extensions.
###############################################################################

# Service Ids used in actions.
WORKBENCH_UI_SERVICE = "service://enthought.envisage.workbench.IWorkbenchUI"

default_action_set = WorkbenchActionSet(
    id   = ID + ".default_action_set",
    name = "Default",

    groups = [
        Group(
            id = "FileMenuGroup",
            location = Location(path="MenuBar")
        ),

        Group(
            id = "HelpMenuGroup",
            location = Location(path="MenuBar")
        ),
    ],

    menus = [
        Menu(
            id = "FileMenu",
            name = "&File",
            location = Location(path="MenuBar/FileMenuGroup"),

            groups = [
                Group(id="ExitGroup")
            ]
        ),

        Menu(
            id = "HelpMenu",
            name = "&Help",
            location = Location(path="MenuBar/HelpMenuGroup"),

            groups = [
                Group(id="AboutGroup")
            ]
        )
    ],

    actions = [
        Action(
            id = 'Exit',
            name = "E&xit",
            description = "Exit the application",
            tooltip = "Exit the application",

            object = WORKBENCH_UI_SERVICE,
            method_name = "exit",

            locations = [
                Location(path="MenuBar/FileMenu/ExitGroup")
            ]
        ),

        Action(
            id = 'About',
            name = "&About",
            description = "Display information about the application",
            tooltip = "Display information about the application",

            object = WORKBENCH_UI_SERVICE,
            method_name = "about",

            locations = [
                Location(path="MenuBar/HelpMenu/AboutGroup")
            ]
        )
    ]
)

view_action_set = WorkbenchActionSet(
    id   = ID + ".view_action_set",
    name = "View",

    groups = [
        Group(
            id = "ViewMenuGroup",
            location = Location(path="MenuBar", before="HelpMenuGroup")
        ),
    ],

    menus = [
        Menu(
            id = "ViewMenu",
            name = "&View",
            location = Location(path="MenuBar/ViewMenuGroup")
        ),
    ]
)

###############################################################################
# The plugin definition.
###############################################################################

class ActionPluginDefinition(PluginDefinition):
    """ The action plugin definition. """

    # The plugin's globally unique identifier.
    id = ID

    # The name of the class that implements the plugin.
    class_name = ID + ".action_plugin.ActionPlugin"

    # General information about the plugin.
    name          = "Workbench Action Plugin"
    version       = "1.0.0"
    provider_name = "Enthought Inc"
    provider_url  = "www.enthought.com"
    autostart     = True

    # The Id's of the plugins that this plugin requires.
    requires = [
        "enthought.envisage.action",
        "enthought.envisage.workbench"
    ]

    # The extension points offered by this plugin.
    extension_points = [WorkbenchActionSet]

    # The contributions that this plugin makes to extension points offered by
    # either itself or other plugins.
    extensions = [default_action_set, view_action_set]

#### EOF ######################################################################
