#-----------------------------------------------------------------------------
#
#  Copyright (c) 2005-2006 by Enthought, Inc.
#  All rights reserved.
#
#  Author: David C. Morrill <dmorrill@enthought.com>
#
#-----------------------------------------------------------------------------

""" Action for renaming a user defined perspective.
"""

#-------------------------------------------------------------------------------
#  Imports:
#-------------------------------------------------------------------------------
    
from user_perspective_action \
    import UserPerspectiveAction
    
from user_perspective_name \
    import UserPerspectiveName

#-------------------------------------------------------------------------------
#  'RenameUserPerspectiveAction' class:
#-------------------------------------------------------------------------------    

class RenameUserPerspectiveAction ( UserPerspectiveAction ):
    """ Renames a user defined perspective
    """
    
    #---------------------------------------------------------------------------
    #  'Action' interface:
    #---------------------------------------------------------------------------

#-- Public Interface -----------------------------------------------------------

    def perform ( self, event ):
        """ Performs the action, which is to create a new, persistent, user 
            defined perspective.
        """
        window = event.window
        ap     = window.active_perspective
        
        # Use the name of the current active perspective:
        upn = UserPerspectiveName( name = ap.name )
        
        # Allow the user to specify a new perspective name. If the user clicks
        # the OK button, rename the perspective and update all affected objects,
        # menu actions, ...:
        if upn.edit_traits( view = 'rename_view' ).result:
            name = upn.name.strip()
            window.workbench.user_perspective.rename( ap.id, name )

            # Rename the associated Perspectives menu action:
            self._manager.rename( ap.id, name )

#### EOF #####################################################################

