#-----------------------------------------------------------------------------
#
#  Copyright (c) 2005-2006 by Enthought, Inc.
#  All rights reserved.
#
#  Author: David C. Morrill <dmorrill@enthought.com>
#
#-----------------------------------------------------------------------------

""" Base class for user defined perspective actions.
"""

#-------------------------------------------------------------------------------
#  Imports:
#-------------------------------------------------------------------------------

from workbench_action \
    import WorkbenchAction

#-------------------------------------------------------------------------------
#  'UserPerspectiveAction' class:
#-------------------------------------------------------------------------------    

class UserPerspectiveAction ( WorkbenchAction ):
    """ Base class for user defined perspective actions.
    """
    
    #---------------------------------------------------------------------------
    #  'Object' interface:
    #---------------------------------------------------------------------------
    
    def __init__ ( self, **traits ):
        """ Initializes the object.
        """
        super( UserPerspectiveAction, self ).__init__( **traits )
        
        # Listen for changes to the currently active perspective:
        self.window.on_trait_change( self._refresh, 'active_perspective' )

    #---------------------------------------------------------------------------
    #  'WorkbenchAction' interface:
    #---------------------------------------------------------------------------

#-- Private Interface -----------------------------------------------------------

    def _refresh ( self ):
        """ Refreshes the enabled/disabled state of this action.
        """
        self.enabled = self._is_user_perspective_active()
    
    #---------------------------------------------------------------------------
    #  'UserPerspectiveAction' interface:
    #---------------------------------------------------------------------------

#-- Protected Interface --------------------------------------------------------

    def _is_user_perspective_active ( self ):
        """ Returns whether or not the current active perpective is user
            defined or not.
        """
        id = self.window.active_perspective.id
        return ((id[:19] == '__user_perspective_') and (id[-2:] == '__'))

#### EOF #####################################################################

