""" A plugin that offers a UI for user preferences. """


# Enthought library imports.
from enthought.envisage import ExtensionItem, ExtensionPoint, PluginDefinition
from enthought.traits.api import List, Str

# Plugin definition imports.
from enthought.envisage.workbench.workbench_plugin_definition import \
     Workbench

from enthought.envisage.workbench.action.action_plugin_definition import \
     Action, Group, Location, Menu, WorkbenchActionSet


# The plugin's globally unique identifier (also used as the prefix for all
# identifiers defined in this module).
ID = "enthought.envisage.workbench.preference"


###############################################################################
# Extension points.
###############################################################################

class Page(ExtensionItem):
    """ A page in the preference dialog. """

    # The page's unique identifier.
    id = Str

    # The page name.
    name = Str

    # The category that the page belongs to.
    category = Str

    # The name of the class that implements the page.
    class_name = Str

    # The Id of the help topic for the page.
    help_id = Str


class PreferencePages(ExtensionPoint):
    """ Allows for contributions to the preferences dialog. """

    # Preference page contributions.
    pages = List(Page)

###############################################################################
# Extensions.
###############################################################################

preference_pages = PreferencePages(
    pages = [
        Page(
            id         = ID + ".ui_preference_page.UIPreferencePage",
            class_name = ID + ".ui_preference_page.UIPreferencePage",
            name       = "Workbench",
            category   = "",
            )
    ]
)

preference_action_set = WorkbenchActionSet(
    groups = [
        Group(
            id = "ToolsMenuGroup",
            location = Location(path="MenuBar", before="ViewMenuGroup")
        )
    ],

    menus = [
        Menu(
            id     = "ToolsMenu",
            name   = "&Tools",
            groups = [
                Group(id="StartGroup"),
                Group(id="EndGroup")
            ],

            location = Location(path="MenuBar/ToolsMenuGroup")
        )
    ],

    actions = [
        Action(
            id            = ID + ".action.EditPreferencesAction",
            class_name    = ID + ".action.EditPreferencesAction",
            name          = "&Preferences",
            image         = "images/edit_preferences.png",
            description   = "Edit user preferences",
            tooltip       = "Edit user preferences",

            locations     = [
                Location(path="MenuBar/ToolsMenu/EndGroup")
            ]
        )
    ]
)

###############################################################################
# The plugin definition!
###############################################################################

class PreferencesPluginDefinition(PluginDefinition):
    # The plugin's globally unique identifier.
    id = ID

    # The name of the class that implements the plugin.
    class_name = ID + ".preference_plugin.PreferencePlugin"

    # General information about the plugin.
    name          = "Envisage Preference UI Plugin"
    version       = "1.0.0"
    provider_name = "Enthought Inc"
    provider_url  = "www.enthought.com"
    enabled       = True

    # The Id's of the plugins that this plugin requires.
    requires = ["enthought.envisage.workbench.action"]

    # The extension points offered by this plugin.
    extension_points = [PreferencePages]

    # The contributions that this plugin makes to extension points offered by
    # either itself or other plugins.
    extensions = [preference_action_set, preference_pages]

#### EOF ######################################################################
