""" The plugin's main preference page. """


# Enthought library imports.
from enthought.envisage.workbench import IWORKBENCH
from enthought.traits.api import Bool, Property, Str
from enthought.traits.ui.api import Item, Group, View
from enthought.traits.ui.api import EnumEditor

# Local imports.
from workbench_preference_page import WorkbenchPreferencePage


class UIPreferencePage(WorkbenchPreferencePage):
    """ The plugin's main preference page. """

    # Should we prompt the user before exiting the application?
    prompt_on_exit = Bool

    # Should we display the name of each tool bar tool under its image?
    show_tool_names = Bool

    # The name of the default perspective.
    default_perspective = Str

    # The default view.
    traits_view = View(
        Group(
            Item(
                name = 'prompt_on_exit'
            ),

            Item(
                name = 'show_tool_names'
            ),

            Item(
                name   = 'default_perspective',
                editor = EnumEditor(
                    name='_perspective_names'
                )
            ),

            show_border=False, show_left=False
        ),
    )

    #### Private interface ####################################################

    # The names of all of the available perspectives.
    _perspective_names = Property

    ###########################################################################
    # Protected 'WorkbenchPreferencePage' interface.
    ###########################################################################

    def _get_preferences(self):
        """ Returns the preferences that this page is editing.
        """
        workbench = self._application.get_service(IWORKBENCH)

        return workbench.preferences

    ###########################################################################
    # Private interface.
    ###########################################################################

    def _get__perspective_names(self):
        """ Trait property getter. """
        workbench = self._application.get_service(IWORKBENCH)

        names = [perspective.name for perspective in workbench.perspectives]
        names.insert(0, 'Last one used')

        return names

#### EOF ######################################################################
