""" This plugin prints messages for the 'Hello World' example. """


# Enthought library imports.
from enthought.envisage.api import ExtensionPoint, PluginDefinition
from enthought.traits.api import Str

# Plugin definition imports.
from enthought.envisage.core.core_plugin_definition import Preferences


# The plugin's globally unique identifier (also used as the prefix for all
# identifiers defined in this module).
ID = 'enthought.envisage.examples.plugin.message'


###############################################################################
# Extension Points.
###############################################################################

class Message(ExtensionPoint):
    """ Allows other plugins to contribute a message. """
    
    # The text of the message!
    text = Str

###############################################################################
# Extensions.
###############################################################################

preferences = Preferences(
    defaults = {
        # Should we add an exclamation mark to the end of each message?
        'add_exclamation' : True
    }
)
    
###############################################################################
# The plugin definition.
###############################################################################

class MessagePluginDefinition(PluginDefinition):
    """ This plugin prints messages for the 'Hello World' example. """

    # The plugin's globally unique identifier.
    id = ID

    # The name of the class that implements the plugin.
    class_name = ID + ".plugin_implementation.MessagePlugin"

    # General information about the plugin.
    name          = "Envisage 'Message' Plugin"
    version       = "1.0.0"
    provider_name = "Enthought Inc"
    provider_url  = "www.enthought.com"
    autostart     = True
    
    # The IDs of the plugins that this plugin requires.
    requires = ["enthought.envisage.core"]

    # The extension points offered by this plugin.
    extension_points = [Message]
    
    # The contributions that this plugin makes to extension points offered by
    # either itself or other plugins.
    extensions = [preferences]
    
#### EOF ######################################################################
