""" The resource type for Python methods. """


# Standard library imports.
import types

# Enthought library imports.
from enthought.envisage.resource import ObjectResourceType

# Local imports.
from method_node_type import MethodNodeType


class MethodResourceType(ObjectResourceType):
    """ The resource type for Python methods. """

    ###########################################################################
    # 'ResourceType' interface.
    ###########################################################################

    #### Initializers #########################################################

    def _node_type_default(self):
        """ Initializes the node type. """

        return MethodNodeType(resource_type=self)

    #### Methods ##############################################################
    
    def is_type_for(self, obj): 
        """ Returns True if the resource type 'recognizes' an object. """

        return type(obj) is types.MethodType

##### EOF #####################################################################
