""" A proxy for a preference node created from a bundle. """


# Enthought library imports.
from enthought.envisage import Application
from enthought.pyface.preference.api import PreferenceNode, PreferencePage
from enthought.traits.api import Instance, Str


class WorkbenchPreferenceNode(PreferenceNode):
    """ A proxy for a preference node created from a bundle. """

    #### 'WorkbenchPreferenceNode' interface ##################################

    # The application that the preference node is part of.
    application = Instance(Application)

    # The name of the node's preference page implementation class.
    class_name = Str

    ###########################################################################
    # 'PreferenceNode' interface.
    ###########################################################################

    def create_page(self):
        """ Creates the preference page for this node. """

        # Import the class that implements the preference page for this node.
        # The class should support the 'PreferencePage' interface.
        klass = self.application.import_symbol(self.class_name)

        return klass(_application=self.application, help_id=self.help_id)

#### EOF ######################################################################
