"""
This example shows to embed a Mayavi view in a wx frame.

The trick is to create a HasTraits object, as in the
mlab_traits_ui.py, mayavi_traits_ui.py, or the modifying_mlab_source.py
examples. Calling the edit_traits method returns a ui object whose
"control" attribute is the wx widget. It can thus be embedded in a
standard wx application.
"""

from numpy import ogrid, sin

from enthought.traits.api import HasTraits, Instance
from enthought.traits.ui.api import View, Item

from enthought.mayavi.sources.api import ArraySource
from enthought.mayavi.modules.api import IsoSurface

from enthought.tvtk.pyface.scene_editor import SceneEditor
from enthought.mayavi.tools.mlab_scene_model import MlabSceneModel

class MayaviView(HasTraits):

    scene = Instance(MlabSceneModel, ())
    
    view = View(Item('scene', editor=SceneEditor(), resizable=True,
                    show_label=False), 
                    resizable=True)

    def __init__(self):
        HasTraits.__init__(self)
        x, y, z = ogrid[-10:10:100j, -10:10:100j, -10:10:100j]
        scalars = sin(x*y*z)/(x*y*z)
        src = ArraySource(scalar_data=scalars)
        self.scene.engine.add_source(src)
        src.add_module(IsoSurface())
        
#-----------------------------------------------------------------------------
# Wx Code
import wx

class MainWindow(wx.Frame):
    
    def __init__(self, parent, id):
        wx.Frame.__init__(self, parent, id, 'Mayavi in Wx')
        self.mayavi_view = MayaviView()
        self.control = self.mayavi_view.edit_traits(
                        parent=self,
                        kind='subpanel').control
        self.Show(True)

app = wx.PySimpleApp()
frame = MainWindow(None, wx.ID_ANY)
app.MainLoop()

