# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.selection_algorithm import SelectionAlgorithm


class SelectionSource(SelectionAlgorithm):
    r"""
    SelectionSource - Generate selection from given set of ids
    
    Superclass: SelectionAlgorithm
    
    SelectionSource generates a Selection from a set of (piece id,
    cell id) pairs. It will only generate the selection values that match
    UPDATE_PIECE_NUMBER (i.e. piece == UPDATE_PIECE_NUMBER).
    SelectionSource can generate a Selection with one or many
    SelectionNodes.
    
    To generate only one SelectionNode, use the functions which don't
    pass a nodeId to set/get the node information. To generate more than
    one SelectionNode, use the set_number_of_nodes/remove_node to
    manipulate the number of nodes, and use the functions that pass the
    nodeId to set the node information The different nodes can have
    different contentType per node but the fieldType/elementType is
    common across all nodes.
    
    To define the relation between the nodes you can use set_expression.
    If non-empty, the expression is a boolean expression that defines how
    the selection nodes present in the selection are to be combined
    together to form the selection. If no expression is specified and
    there are multiple selection nodes, then the default expression
    simply combines all the selection nodes using an `or` operator.
    
    User-supplied, application-specific selections (with a content_type of
    SelectionNode::USER) are not supported.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkSelectionSource, obj, update, **traits)
    
    field_type_option = tvtk_base.RevPrefixMap({'field_type': 0, 'element_type': 1}, default_value='field_type', desc=\
        r"""
        
        """
    )

    def _field_type_option_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFieldTypeOption,
                        self.field_type_option_)

    array_component = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the component number for the array specified by
        array_name.
        
        The default is component 0. Use -1 for magnitude.
        """
    )

    def _array_component_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetArrayComponent,
                        self.array_component)

    array_name = traits.String('', enter_set=True, auto_set=False, desc=\
        r"""
        Get/Set the name used for the selection_list in the generated
        SelectionNode.
        """
    )

    def _array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetArrayName,
                        self.array_name)

    assembly_name = traits.String('', enter_set=True, auto_set=False, desc=\
        r"""
        For selector-based selection qualification. Note, this should not
        be confused with block-selectors used to select blocks using
        selectors. These here are qualifiers i.e. they limit the selected
        items.
        """
    )

    def _assembly_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAssemblyName,
                        self.assembly_name)

    composite_index = traits.Int(-1, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the composite_index. If composite_index < 0 then
        COMPOSITE_INDEX() is not added to the output.
        
        The default is -1.
        """
    )

    def _composite_index_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCompositeIndex,
                        self.composite_index)

    containing_cells = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        When extracting by points, extract the cells that contain the
        passing points.
        
        The default is false.
        """
    )

    def _containing_cells_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetContainingCells,
                        self.containing_cells)

    content_type = traits.Trait(3, traits.Range(0, 10, enter_set=True, auto_set=False), desc=\
        r"""
        Set/Get the content type. Possible values are as defined by
        SelectionNode::SelectionContent.
        
        The default is SelectionNode::SelectionContent::INDICES.
        """
    )

    def _content_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetContentType,
                        self.content_type)

    element_type = traits.Trait(1, traits.Range(0, 6, enter_set=True, auto_set=False), desc=\
        r"""
        Set/Get which types of elements are being selected. Accepted
        values are defined in `vtkdata_object::attribute_types`. Note,
        `vtkdata_object::FIELD` and `vtkdata_object::POINT_THEN_CELL` are
        not supported.
        
        The default is DataObject::AttributeTypes::Cell.
        """
    )

    def _element_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetElementType,
                        self.element_type)

    expression = traits.String('', enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the expression that defines the boolean expression to
        combine the selection nodes. Expression consists of node name
        identifiers, `|` for boolean-or, '^' for boolean-xor, '&' for
        boolean and, '!' for boolean not, and parenthesis `(` and `)`. If
        you want to set the expression, be sure to define the node names.
        If no expression is specified and there are multiple selection
        nodes, then the default expression simply combines all the
        selection nodes using an `or` operator.
        
        `set_expression` does not validate the expression. It will be
        validated in `internally.
        """
    )

    def _expression_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetExpression,
                        self.expression)

    field_type = traits.Trait(0, traits.Range(0, 5, enter_set=True, auto_set=False), desc=\
        r"""
        Set/Get the field type for the generated selection. Possible
        values are as defined by SelectionNode::SelectionField.
        
        The default is SelectionNode::SelectionField::CELL.
        """
    )

    def _field_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFieldType,
                        self.field_type)

    hierarchical_index = traits.Int(-1, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _hierarchical_index_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetHierarchicalIndex,
                        self.hierarchical_index)

    hierarchical_level = traits.Int(-1, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the Hierarchical/hierarchical_index. If hierarchical_level
        or hierarchical_index < 0 , then HIERARCHICAL_LEVEL() and
        HIERARCHICAL_INDEX() keys are not added to the output.
        
        The default for both is -1.
        """
    )

    def _hierarchical_level_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetHierarchicalLevel,
                        self.hierarchical_level)

    inverse = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        Determines whether the selection describes what to include or
        exclude.
        
        The Default is 0, meaning include.
        """
    )

    def _inverse_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInverse,
                        self.inverse)

    node_name = traits.String('', enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the node name.
        
        If you want to set the Expression, be sure to define the node
        names.
        
        If the node name is not defined, a default node name is created
        atomically at each execution of the filter to guarantee
        uniqueness. get_node_name() will return a non-empty name only if
        you have defined it before.
        """
    )

    def _node_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNodeName,
                        self.node_name)

    number_of_layers = traits.Trait(0, traits.Range(0, 2147483647, enter_set=True, auto_set=False), desc=\
        r"""
        Set/Get the number of layers to extract connected to the selected
        elements.
        
        The default is 0.
        """
    )

    def _number_of_layers_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfLayers,
                        self.number_of_layers)

    number_of_nodes = traits.Int(1, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the number of nodes that will be created for the
        generated selection.
        
        The default is 1.
        """
    )

    def _number_of_nodes_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfNodes,
                        self.number_of_nodes)

    process_id = traits.Trait(-1, traits.Range(-1, 2147483647, enter_set=True, auto_set=False), desc=\
        r"""
        Set/Get which process to limit the selection to. `-1` is treated
        as all processes.
        
        The default is -1.
        """
    )

    def _process_id_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetProcessID,
                        self.process_id)

    query_string = traits.String('', enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the query expression string.
        """
    )

    def _query_string_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetQueryString,
                        self.query_string)

    def add_block(self, *args):
        """
        add_block(self, nodeId:int, block:int) -> None
        C++: void add_block(unsigned int nodeId, IdType block)
        add_block(self, blockno:int) -> None
        C++: void add_block(IdType blockno)
        Add the flat-index/composite index for a block.
        """
        ret = self._wrap_call(self._vtk_obj.AddBlock, *args)
        return ret

    def add_block_selector(self, *args):
        """
        add_block_selector(self, nodeId:int, block:str) -> None
        C++: void add_block_selector(unsigned int nodeId, const char *block)
        add_block_selector(self, selector:str) -> None
        C++: void add_block_selector(const char *selector)
        Add/Remove block-selectors to make selections with
        SelectionNode::BLOCK_SELECTORS as the content-type.
        """
        ret = self._wrap_call(self._vtk_obj.AddBlockSelector, *args)
        return ret

    def add_id(self, *args):
        """
        add_id(self, nodeId:int, piece:int, id:int) -> None
        C++: void add_id(unsigned int nodeId, IdType piece,
            IdType id)
        add_id(self, piece:int, id:int) -> None
        C++: void add_id(IdType piece, IdType id)
        Add a (piece, id) to the selection set. The source will generate
        only the ids for which piece == UPDATE_PIECE_NUMBER. If piece ==
        -1, the id applies to all pieces.
        """
        ret = self._wrap_call(self._vtk_obj.AddID, *args)
        return ret

    def add_location(self, *args):
        """
        add_location(self, nodeId:int, x:float, y:float, z:float) -> None
        C++: void add_location(unsigned int nodeId, double x, double y,
            double z)
        add_location(self, x:float, y:float, z:float) -> None
        C++: void add_location(double x, double y, double z)
        Add a point in world space to probe at.
        """
        ret = self._wrap_call(self._vtk_obj.AddLocation, *args)
        return ret

    def add_selector(self, *args):
        """
        add_selector(self, nodeId:int, selector:str) -> None
        C++: void add_selector(unsigned int nodeId, const char *selector)
        add_selector(self, selector:str) -> None
        C++: void add_selector(const char *selector)"""
        ret = self._wrap_call(self._vtk_obj.AddSelector, *args)
        return ret

    def add_string_id(self, *args):
        """
        add_string_id(self, nodeId:int, piece:int, id:str) -> None
        C++: void add_string_id(unsigned int nodeId, IdType piece,
            const char *id)
        add_string_id(self, piece:int, id:str) -> None
        C++: void add_string_id(IdType piece, const char *id)"""
        ret = self._wrap_call(self._vtk_obj.AddStringID, *args)
        return ret

    def add_threshold(self, *args):
        """
        add_threshold(self, nodeId:int, min:float, max:float) -> None
        C++: void add_threshold(unsigned int nodeId, double min,
            double max)
        add_threshold(self, min:float, max:float) -> None
        C++: void add_threshold(double min, double max)
        Add a value range to threshold within.
        """
        ret = self._wrap_call(self._vtk_obj.AddThreshold, *args)
        return ret

    def remove_all_block_selectors(self, *args):
        """
        remove_all_block_selectors(self, nodeId:int) -> None
        C++: void remove_all_block_selectors(unsigned int nodeId)
        remove_all_block_selectors(self) -> None
        C++: void remove_all_block_selectors()"""
        ret = self._wrap_call(self._vtk_obj.RemoveAllBlockSelectors, *args)
        return ret

    def remove_all_blocks(self, *args):
        """
        remove_all_blocks(self, nodeId:int) -> None
        C++: void remove_all_blocks(unsigned int nodeId)
        remove_all_blocks(self) -> None
        C++: void remove_all_blocks()
        Remove all blocks added with add_block.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveAllBlocks, *args)
        return ret

    def remove_all_i_ds(self, *args):
        """
        remove_all_i_ds(self, nodeId:int) -> None
        C++: void remove_all_i_ds(unsigned int nodeId)
        remove_all_i_ds(self) -> None
        C++: void remove_all_i_ds()
        Removes all IDs.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveAllIDs, *args)
        return ret

    def remove_all_locations(self, *args):
        """
        remove_all_locations(self, nodeId:int) -> None
        C++: void remove_all_locations(unsigned int nodeId)
        remove_all_locations(self) -> None
        C++: void remove_all_locations()
        Remove all locations added with add_location.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveAllLocations, *args)
        return ret

    def remove_all_nodes(self):
        """
        remove_all_nodes(self) -> None
        C++: virtual void remove_all_nodes()
        Remove all selection nodes.
        """
        ret = self._vtk_obj.RemoveAllNodes()
        return ret
        

    def remove_all_selectors(self, *args):
        """
        remove_all_selectors(self, nodeId:int) -> None
        C++: void remove_all_selectors(unsigned int nodeId)
        remove_all_selectors(self) -> None
        C++: void remove_all_selectors()"""
        ret = self._wrap_call(self._vtk_obj.RemoveAllSelectors, *args)
        return ret

    def remove_all_string_i_ds(self, *args):
        """
        remove_all_string_i_ds(self, nodeId:int) -> None
        C++: void remove_all_string_i_ds(unsigned int nodeId)
        remove_all_string_i_ds(self) -> None
        C++: void remove_all_string_i_ds()"""
        ret = self._wrap_call(self._vtk_obj.RemoveAllStringIDs, *args)
        return ret

    def remove_all_thresholds(self, *args):
        """
        remove_all_thresholds(self, nodeId:int) -> None
        C++: void remove_all_thresholds(unsigned int nodeId)
        remove_all_thresholds(self) -> None
        C++: void remove_all_thresholds()
        Remove all thresholds added with add_threshold.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveAllThresholds, *args)
        return ret

    def remove_node(self, *args):
        """
        remove_node(self, idx:int) -> None
        C++: void remove_node(unsigned int idx)
        remove_node(self, name:str) -> None
        C++: void remove_node(const char *name)
        Remove a selection node.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveNode, *args)
        return ret

    def set_frustum(self, *args):
        """
        set_frustum(self, nodeId:int, vertices:[float, ...]) -> None
        C++: void set_frustum(unsigned int nodeId, double *vertices)
        set_frustum(self, vertices:[float, ...]) -> None
        C++: void set_frustum(double *vertices)
        Set a frustum to choose within.
        """
        ret = self._wrap_call(self._vtk_obj.SetFrustum, *args)
        return ret

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('field_type_option', 'GetFieldTypeOption'), ('array_component',
    'GetArrayComponent'), ('array_name', 'GetArrayName'),
    ('assembly_name', 'GetAssemblyName'), ('composite_index',
    'GetCompositeIndex'), ('containing_cells', 'GetContainingCells'),
    ('content_type', 'GetContentType'), ('element_type',
    'GetElementType'), ('expression', 'GetExpression'), ('field_type',
    'GetFieldType'), ('hierarchical_index', 'GetHierarchicalIndex'),
    ('hierarchical_level', 'GetHierarchicalLevel'), ('inverse',
    'GetInverse'), ('node_name', 'GetNodeName'), ('number_of_layers',
    'GetNumberOfLayers'), ('number_of_nodes', 'GetNumberOfNodes'),
    ('process_id', 'GetProcessID'), ('query_string', 'GetQueryString'),
    ('progress_text', 'GetProgressText'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'field_type_option', 'array_component',
    'array_name', 'assembly_name', 'composite_index', 'containing_cells',
    'content_type', 'element_type', 'expression', 'field_type',
    'hierarchical_index', 'hierarchical_level', 'inverse', 'node_name',
    'number_of_layers', 'number_of_nodes', 'object_name', 'process_id',
    'progress_text', 'query_string'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(SelectionSource, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit SelectionSource properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], ['field_type_option'], ['array_component', 'array_name',
            'assembly_name', 'composite_index', 'containing_cells',
            'content_type', 'element_type', 'expression', 'field_type',
            'hierarchical_index', 'hierarchical_level', 'inverse', 'node_name',
            'number_of_layers', 'number_of_nodes', 'object_name', 'process_id',
            'query_string']),
            title='Edit SelectionSource properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit SelectionSource properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

