/*     Copyright (C) 1999, 2000, 2001, 2002, 2003, 2004 Stijn van Dongen
 *
 * This file is part of MCL.  You can redistribute and/or modify MCL under the
 * terms of the GNU General Public License; either version 2 of the License or
 * (at your option) any later version.  You should have received a copy of the
 * GPL along with MCL, in the file COPYING.
*/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <limits.h>
#include <string.h>
#include <ctype.h>
#include <time.h>

#include "alg.h"
#include "proc.h"
#include "clm.h"
#include "interpret.h"
#include "version.h"
#include "expand.h"
#include "procinit.h"

#include "impala/ivp.h"
#include "impala/compose.h"
#include "impala/iface.h"
#include "impala/io.h"

#include "util/ting.h"
#include "util/equate.h"
#include "util/io.h"
#include "util/minmax.h"
#include "util/opt.h"
#include "util/err.h"
#include "util/types.h"
#include "util/opt.h"

#define chb(a,b,c,d,e,f,g) mcxOptCheckBounds("mcl-main", a, b, c, d, e, f, g)

enum
{  ALG_OPT_OVERLAP
,  ALG_OPT_ASCII
,  ALG_OPT_BINARY
,  ALG_OPT_INFLATEFIRST
,  ALG_OPT_SHOWSETTINGS
,  ALG_OPT_DO
,  ALG_OPT_DONT
,  ALG_OPT_SHOWCHARTER
,  ALG_OPT_SHOWVERSION
,  ALG_OPT_SHOWHELP
,  ALG_OPT_SHOWRAM
,  ALG_OPT_SHOWSCHEMES
,  ALG_OPT_OUTPUTFILE
,  ALG_OPT_AUTOOUT
,  ALG_OPT_AUTOAPPEND
,  ALG_OPT_AUTOSELF
,  ALG_OPT_AUTOBOUNCE
,  ALG_OPT_AUTOPREFIX
,  ALG_OPT_CENTERING
,  ALG_OPT_CTRMAXAVG
,  ALG_OPT_DIAGADD
,  ALG_OPT_INGQ
,  ALG_OPT_PREINFLATION
,  ALG_OPT_SORT
,  ALG_OPT_DIGITS
,  ALG_OPT_PREPRUNE
}  ;


typedef struct grade
{  int   mark
;  const char* ind
;
}  grade ;

grade gradeDir[] =
{  {  10000, "impossible" }
,  { 100, "yabadabadoo!" }
,  {  99, "perfect" }            /* pf */
,  {  98, "exceptional" }        /* xl */
,  {  95, "superior" }           /* sp */
,  {  90, "excellent" }          /* xt */
,  {  80, "good" }               /* gd */
,  {  70, "acceptable" }         /* ac */
,  {  60, "mediocre" }           /* mc */
,  {  50, "poor" }               /* pr */
,  {  40, "bad" }                /* bd */
,  {  30, "lousy" }              /* ls */
,  {  20, "miserable" }          /* mi */
,  {  10, "awful" }              /* af */
,  {   5, "wretched" }           /* wr */
,  {   0, "atrocious" }          /* at */
,  {  -2, "impossible" }
}  ;

void juryCharter
(  mclProcParam* mpp
)  ;

void  howMuchRam
(  long i
,  mclProcParam* mpp
)  ;

void mclWriteLog
(  FILE* fp
,  mclAlgParam* mlp
,  mclMatrix* cl
)  ;

void mclAlgPrintInfo
(  FILE* fp
,  mclAlgParam* mlp  
,  mclMatrix* cl
)  ;

void mclCenter
(  mclMatrix*        mx
,  double            w_center
,  double            w_maxval
)  ;




/*  options with 'flags & 2' exit after displaying info                    */
/*  options with 'flags & 1' take an argument (part of the opt interface)  */

mcxOptAnchor mclAlgOptions[] =
{
   {  "--overlap",         0, ALG_OPT_OVERLAP }
,  {  "--ascii",           0, ALG_OPT_ASCII }
,  {  "--binary",          0, ALG_OPT_BINARY }
,  {  "-do",               1, ALG_OPT_DO }
,  {  "-dont",             1, ALG_OPT_DONT }
,  {  "--inflate-first",   0, ALG_OPT_INFLATEFIRST }
,  {  "--show-settings",   2, ALG_OPT_SHOWSETTINGS }
,  {  "--jury-charter",    2, ALG_OPT_SHOWCHARTER }
,  {  "-z",                2, ALG_OPT_SHOWSETTINGS }
,  {  "--version",         2, ALG_OPT_SHOWVERSION }
,  {  "-h",                2, ALG_OPT_SHOWHELP }
,  {  "--show-schemes",    2, ALG_OPT_SHOWSCHEMES }
,  {  "-o",                1, ALG_OPT_OUTPUTFILE }
,  {  "-aa",               1, ALG_OPT_AUTOAPPEND }
,  {  "-az",               2, ALG_OPT_AUTOBOUNCE }
,  {  "-ap",               1, ALG_OPT_AUTOPREFIX }
,  {  "-c",                1, ALG_OPT_CENTERING }
,  {  "-cma",              1, ALG_OPT_CTRMAXAVG }
,  {  "-a",                1, ALG_OPT_DIAGADD }
,  {  "-in-gq",            1, ALG_OPT_INGQ }
,  {  "-pi",               1, ALG_OPT_PREINFLATION }
,  {  "-sort",             1, ALG_OPT_SORT }
,  {  "-pp",               1, ALG_OPT_PREPRUNE }
,  {  "-digits",           1, ALG_OPT_DIGITS }
,  {  "-how-much-ram",     3, ALG_OPT_SHOWRAM }
,  {  NULL,                0, 0 }
}  ;


void showSettings
(  mclAlgParam* mlp
)  ;


void showSetting
(  void
)
   {  fprintf
      (  stdout
      ,
"mcl %s, %s\n"
"Copyright (c) 1999-2004, Stijn van Dongen. mcl comes with NO WARRANTY\n"
"to the extent permitted by law. You may redistribute copies of mcl under\n"
"the terms of the GNU General Public License.\n"
      ,  mclNumTag
      ,  mclDateTag
      )
;  }


const char* mclHelp
=
"\n________ mcl verbosity modes\n"
"--show ....... print MCL iterands (small graphs only)\n"
"-v all ....... turn on all -v options\n"
"-progress <i>  if i>0, (try to) print i times `.' during one iteration  [30]\n"
"                 if i<0, print `.' after every |i| cols computed\n"
"                 if i=0, print convergence measure after every iteration\n"

"\n________ on multi-processor systems\n"
"-te <i> ...... number of threads to use for expansion                    [0]\n"

"\n________ mcl info options\n"
"-z ........... shows current settings (takes other arguments into account)\n"
"--show-schemes shows the resource schemes accessible via the -scheme option\n"
"--version .... shows version and license information\n"

"\n________ speed/quality controls\n"
"-P <i> ....... set pruning number to i                            [scheme 2]\n"
"-S <i> ....... set selection number to i                          [scheme 2]\n"
"-R <i> ....... set recover number to i                            [scheme 2]\n"
"-pct <i> ..... mass percentage below which to apply recovery      [scheme 2]\n"
"-scheme <i> .. use a preset scheme for -P/-S/-R/-pct, (i=1,2,3,4,5)      [2]\n"
"                 --show-schemes shows the preset schemes\n"
"                 higher schemes are costlier and possibly more accurate\n"

"\n________ mcl cluster controls\n"
"-I <f> ....... inflation (varying this parameter affects granularity)  [2.0]\n"
"-o <fname> ... direct cluster output to file fname (- for stdout)  [out.mcl]\n"
"                 if omitted, mcl will create a meaningful output name -\n"
"                 try it out, it's convenient. (cf. -az).\n"

"\nThis is a selection of the mcl options and their defaults. Try different\n"
"-I values for finding clusterings of different granularity, (e.g. in the\n"
"range 1.2 - 4.0). See 'man mcl' and 'man mclfaq' for more information.\n"
"----> mcl <graph.mci> -I 2.0 <---- should get you going.\n"
"Usually you should only need the -I option - for large graphs the -scheme\n"
"option as well.\n"
"\n"
;


/*
 * mlp->xfout is set up for us
*/

void postprocess
(  mclAlgParam* mlp
,  mclMatrix* cl
)
   {  double pvals[5]  
   ;  double gvals[8]  
   ;  mcxIO* xf = mcxIOnew(mlp->fnin->str, "r")
   ;  mclx*  mx
   ;  mcxTing* note = mcxTingEmpty(NULL, 60)

   ;  mcxTell("__mclAfter__", "re-reading matrix for performance measures")
   ;  mx = mclxRead(xf, RETURN_ON_FAIL)
   ;  mcxIOclose(xf)
   ;  mcxIOfree(&xf)

   ;  if (!mx)
      {  mcxErr("__mclAfter__", "cannot re-read matrix")
      ;  return
   ;  }

      clmGranularity(cl, gvals)
   ;  clmGranularityPrint (mlp->xfout->fp, note->str, gvals, 1)

   ;  clmPerformance (mx, cl, pvals)
   ;  mcxTingPrint
      (  note
      ,  "target-name=%s\nsource-name=%s\n"
      ,  mlp->fnin->str
      ,  mlp->xfout->fn->str
      )
   ;  clmPerformancePrint (mlp->xfout->fp, note->str, pvals, 1)

   ;  if (mlp->pre_inflation> 0 || mlp->pre_maxnum)
      { /*  fixme do (mlp->pre_in_gq >= 0) as well
         *  dedup these pieces of code.
        */
         if (mlp->pre_inflation > 0)
            mclxInflate(mx, mlp->pre_inflation)
         ,  mcxTingPrintAfter(note, "inflation=%.1f\n", mlp->pre_inflation)

      ;  if (mlp->pre_maxnum)
            mclxMakeSparse(mx, mlp->pre_maxnum)
         ,  mcxTingPrintAfter(note, "preprune=%d\n", (int) mlp->pre_maxnum)

      ;  clmPerformance (mx, cl, pvals)
      ;  clmPerformancePrint (mlp->xfout->fp, note->str, pvals, 1)
   ;  }

      mcxTell("__mclAfter__", "included performance measures in cluster output")
   ;  mclxFree(&mx)  
   ;  mcxTingFree(&note)
;  }


mcxstatus mclAlgorithm
(  mclMatrix*  themx
,  mclAlgParam*   mlp
)
   {  mclMatrix      *thecluster       =  NULL
   ;  int            bStdout           =   0
   ;  mclProcParam*  mpp               =  mlp->mpp
   ;  const char*    me                =  "mcl"
   ;  int            n_cluster         =  -1

   ;  if (mpp->expandOnly)
      mpp->mxp->verbosity |=  XPNVB_PRUNING

   ;  if (!mpp->inflateFirst)
      {
         if (mlp->pre_diag > 0)
         {  mclMatrix* diagAll   =  mclxConstDiag
                                    (  mclvCopy(NULL, themx->dom_cols)
                                    ,  mlp->pre_diag
                                    )
         ;  mclMatrix*  t  =  mclxAdd(themx, diagAll)
         /* fixme this is way too costy for large mtcs */
         ;  mclxFree(&themx)
         ;  mclxFree(&diagAll)
         ;  themx       =  t
      ;  }

         if (mlp->pre_in_gq >= 0)
         mclxSelectValues(themx, &(mlp->pre_in_gq), NULL, MCLX_GQ)

      ;  if (mlp->pre_inflation > 0)
         mclxInflate(themx, mlp->pre_inflation)

      ;  if (mlp->pre_center >= 0)
         mclCenter(themx, mlp->pre_center, mlp->pre_ctrmaxavg)

      ;  mclxMakeStochastic(themx)

      ;  if (mlp->pre_maxnum)
         {  mclxMakeSparse(themx, mlp->pre_maxnum)
         ;  mclxMakeStochastic(themx)
      ;  }
      }

      if (mpp->expandOnly)
      {  mclMatrix* expanded = mclProcess(themx, mpp)

      ;  if (mlp->fait & ALG_DO_SHOWLOG)
         fprintf(stdout, mpp->massLog->str)

      ;  if (!strcmp(mlp->xfout->fn->str, "out.mcl"))
         mcxIOnewName(mlp->xfout, "out.mce")

      ;  if (mcxIOopen(mlp->xfout, RETURN_ON_FAIL) != STATUS_OK)
         {  mcxWarn(me,"cannot open out stream <%s>",mlp->xfout->fn->str)
         ;  mcxWarn(me, "trying to fall back to default <out.mce>")
         ;  mcxIOnewName(mlp->xfout, "out.mce")
         ;  mcxIOopen(mlp->xfout, EXIT_ON_FAIL)
      ;  }
         if
         (  mclxWrite(expanded, mlp->xfout, mlp->expandDigits, RETURN_ON_FAIL)
         != STATUS_OK
         )
            mcxErr(me, "cannot write to file!\n")
         ,  mcxExit(1)
      ;  return STATUS_OK
   ;  }

      {  int   o, m, e

      ;  thecluster = mclProcess(themx, mpp)

      ;  if (mlp->fait & ALG_DO_SHOWLOG)
         fprintf(stdout, mpp->massLog->str)

      ;  mclcEnstrict
         (  thecluster
         ,  &o
         ,  &m
         ,  &e
         ,  mlp->fait & ALG_DO_KEEPOLAP ? ENSTRICT_KEEP_OVERLAP : 0
         )
      ;  n_cluster = N_COLS(thecluster)

      ;  if (o>0)
         {  if (mlp->fait & ALG_DO_KEEPOLAP)
            mcxWarn(me, "found <%ld> instances of overlap", (long) o)

         ;  else if (!(mlp->fait & ALG_DO_KEEPOLAP))
            mcxWarn(me, "removed <%ld> instances of overlap", (long) o)

         ;  mlp->foundOverlap = TRUE
      ;  }

         if (m>0)
         mcxWarn(me, "added <%ld> garbage entries", (long) m)

      ;  if (N_COLS(thecluster) > 1)
         {  if (mlp->sortMode == 's')
            mclxColumnsRealign(thecluster, mclvSizeCmp)
         ;  else if (mlp->sortMode == 'S')
            mclxColumnsRealign(thecluster, mclvSizeRevCmp)
         ;  else if (mlp->sortMode == 'l')
            mclxColumnsRealign(thecluster, mclvLexCmp)
      ;  }
      }
     /* EO cluster enstriction
      */

      if (mcxIOopen(mlp->xfout, RETURN_ON_FAIL) != STATUS_OK)
      {  mcxWarn(me, "cannot open out stream <%s>", mlp->xfout->fn->str)
      ;  mcxWarn(me, "trying to fall back to default <out.mcl>")
      ;  mcxIOnewName(mlp->xfout, "out.mcl")
      ;  mcxIOopen(mlp->xfout, EXIT_ON_FAIL)
   ;  }

      {  if (mlp->xfout->fp == stdout)  /* what about redirection ?? */
         bStdout = 1
      ;  if
         (  mlp->writeMode == 'a'
         || (  mlp->writeMode == 'b' && bStdout
            )
         )
         {  mclxWrite(thecluster, mlp->xfout, MCLXIO_VALUE_NONE, EXIT_ON_FAIL)
         ;  if (mlp->fait & ALG_DO_WRITELOG)
            mclWriteLog(mlp->xfout->fp, mlp, thecluster)

         ;  mcxIOclose(mlp->xfout)

         ;  if (mlp->fait & (ALG_DO_WRITECLM) && strcmp(mlp->fnin->str, "-"))
            {  mcxIOrenew(mlp->xfout, NULL, "a")
            ;  if (mcxIOopen(mlp->xfout, RETURN_ON_FAIL))
               mcxWarn(me, "cannot append to file %s", mlp->xfout->fn->str)
            ;  else
               {  postprocess(mlp, thecluster)
               ;  mcxIOclose(mlp->xfout)
            ;  }
            }
            else if (mlp->fait & ALG_DO_WRITECLM)
            mcxErr("mclAfter", "Cannot reopen stdin")
      ;  }
         else
         mclxbWrite(thecluster, mlp->xfout, EXIT_ON_FAIL)

      ;  mclxFree(&thecluster)
   ;  }

      mcxTell
      (  me
      ,  "jury pruning marks (worst %d cases): <%d,%d,%d>, out of 100"
      ,  (int) mclDefaultWindowSizes[mpp->mxp->nj]
      ,  (int) mpp->marks[0]
      ,  (int) mpp->marks[1]
      ,  (int) mpp->marks[2]
      )
   ;  {  int i = 0
      ;  double f = (5*mpp->marks[0] + 2*mpp->marks[1] + mpp->marks[2]) / 8.0
      ;  while (gradeDir[i].mark > f+0.0001)
         i++
      ;  mcxTell
         (  me
         ,  "jury pruning synopsis: <%s> (cf -scheme, -do log)"
         ,  gradeDir[i].ind
         )
   ;  }
      mcxTell(me, "%ld clusters found", (long) n_cluster)
   ;  mcxTell(me, "output is in %s", mlp->xfout->fn->str)
   ;  return STATUS_OK
;  }


mcxstatus mclAlgorithmInit
(  mcxOptList*    opts
,  mcxHash*       hashedOpts
,  const char*    fname
,  mclAlgParam*   mlp
)
   {  mclProcParam*  mpp  =  mlp->mpp
   ;  const char* mkappend = NULL, *mkprefix = NULL
   ;  int mkbounce = 0
   ;  float f, f_0  =  0.0
   ;  int i_1     =  1
   ;  int i_10    =  10
   ;  int i
   ;  long l

   ;  if (fname)
      mcxTingWrite(mlp->fnin, fname)

   ;  while (opts && opts->tag)
      {  mcxKV* kv = mcxHashSearch(opts->tag, hashedOpts, MCX_DATUM_FIND)
      ;  mcxOptAnchor* anch = kv ? (mcxOptAnchor*) kv->val : NULL
      ;  mcxbool  vok   = TRUE        /* value ok */
      ;  mcxbool  doit  = TRUE
      ;  const char* arg
      ;  long  bit = 0

      ;  mcxTingPrintAfter(mlp->cline, " %s", opts->tag)

      ;  if (opts->val)
         mcxTingPrintAfter(mlp->cline, " %s", opts->val)

      ;  if (!kv)
         {  opts = opts->next
         ;  continue
      ;  }

         switch(anch->id)
         {  case ALG_OPT_ASCII
         :  mlp->writeMode  =  'a'
         ;  break
         ;

            case ALG_OPT_BINARY
         :  mlp->writeMode  =  'b'
         ;  break
         ;

            case ALG_OPT_INFLATEFIRST
         :  mpp->inflateFirst =  TRUE
         ;  break
         ;

            case ALG_OPT_SHOWVERSION
         :  showSetting()
         ;  return ALG_INIT_DONE
         ;

            case ALG_OPT_SHOWRAM
         :  l = atol(opts->val)
         ;  howMuchRam(l, mlp->mpp)
         ;  return ALG_INIT_DONE
         ;

            case ALG_OPT_SHOWHELP
         :  fprintf(stdout, mclHelp)
         ;  return ALG_INIT_DONE
         ;

            case ALG_OPT_SHOWCHARTER
         :  juryCharter(mpp)
         ;  return ALG_INIT_DONE
         ;

            case ALG_OPT_SHOWSETTINGS
         :  showSettings(mlp)
         ;  return ALG_INIT_DONE
         ;

            case ALG_OPT_SHOWSCHEMES
         :  mclShowSchemes()
         ;  return ALG_INIT_DONE
         ;

            case ALG_OPT_DO
         :  case ALG_OPT_DONT
         :  
            doit = anch->id == ALG_OPT_DO ? TRUE : FALSE
         ;  arg = opts->val
         ;  bit = 0

         ;  if (strstr(arg, "log"))
            bit = ALG_DO_WRITELOG
         ;  else if (strstr(arg, "clm"))
            bit = ALG_DO_WRITECLM
         ;  else if (strstr(arg, "keep-overlap"))
            bit = ALG_DO_KEEPOLAP
         ;  else
            mcxErr("init", "unknown mode <%s>", arg)

         ;  mlp->fait |= bit
         ;  if (!doit)
            mlp->fait ^= bit
         ;  break
         ;

            case ALG_OPT_AUTOAPPEND
         :  mkappend = opts->val
         ;  break
         ;
            case ALG_OPT_AUTOBOUNCE
         :  mkbounce = opts->next ? 2 : 1
         ;  break
         ;
            case ALG_OPT_AUTOPREFIX
         :  mkprefix = opts->val
         ;  break
         ;

            case ALG_OPT_OUTPUTFILE
         :  mcxIOnewName(mlp->xfout, opts->val)
         ;  break
         ;

            case ALG_OPT_CTRMAXAVG
         :  i = atoi(opts->val)
         ;  i = MAX(i, 0);  i = MIN(i, 100)     /* fixme; no warnings */
         ;  mlp->pre_ctrmaxavg = (double) i / 100.0
         ;  break
         ;

            case ALG_OPT_CENTERING
         :  f = atof(opts->val)
         ;  vok = chb(opts->tag, 'f', &f, fltGq, &f_0, NULL, NULL)
         ;  if (f<0.5 || f>5.0)
            mcxWarn
            (  "mcl"
            ,  "warning: conceivable/normal ranges for -c are [0.5, 5.0]"
            )
         ;  if (vok)
            mlp->pre_center = f
         ;  break
         ;

            case ALG_OPT_SORT
         :  if (!strcmp(opts->val, "lex"))
            mlp->sortMode = 'l'
         ;  else if (!strcmp(opts->val, "size"))
            mlp->sortMode = 's'
         ;  else if (!strcmp(opts->val, "revsize"))
            mlp->sortMode = 'S'
         ;  else if (!strcmp(opts->val, "none"))
            mlp->sortMode = 'n'
         ;  break
         ;

            case ALG_OPT_PREINFLATION
         :  f = atof(opts->val)
         ;  if ((vok = chb(opts->tag, 'f', &f, fltGt, &f_0, NULL, NULL)))
            mlp->pre_inflation =  f
         ;  break
         ;

            case ALG_OPT_INGQ
         :  f = atof(opts->val)
         ;  if ((vok = chb(opts->tag, 'f', &f, fltGq, &f_0, NULL, NULL)))
            mlp->pre_in_gq =  f
         ;  break
         ;

            case ALG_OPT_DIAGADD
         :  f = atof(opts->val)
         ;  if ((vok = chb(opts->tag, 'f', &f, fltGt, &f_0, NULL, NULL)))
               mlp->pre_diag =  f
            ,  mlp->pre_center =  -1.0
         ;  break
         ;

            case ALG_OPT_DIGITS
         :  l = atol(opts->val)
         ;  i = l
         ;  if ((vok = chb(opts->tag,'i', &i, intGq, &i_1, intLq, &i_10)))
            mlp->expandDigits = i
         ;  break
         ;

            case ALG_OPT_PREPRUNE
         :  i = atoi(opts->val)
         ;  if ((vok = chb(opts->tag, 'i', &i, intGq, &i_1, NULL, NULL)))
            mlp->pre_maxnum = i
         ;  break
         ;

         }

         if (vok != TRUE)
         return ALG_INIT_FAIL

      ;  opts  =  opts->next
   ;  }

      if (!mlp->xfout->fn->len)
      {  mcxTing* suf = mcxTingEmpty(NULL, 20)
      ;  mcxTing* name = mcxTingEmpty(NULL, 40)
      ;  mcxTingPrintAfter
         (suf,"I%.1fs%d", (double) mpp->mainInflation, (int)(1+mpp->mxp->scheme))

      ;  if (mpp->initLoopLength)
            mcxTingPrintAfter(suf, "l%d", (int) mpp->initLoopLength)
         ,  mcxTingPrintAfter(suf, "i%.1f", (double) mpp->initInflation)
      ;  if (mlp->pre_center != 1.0)
         mcxTingPrintAfter(suf, "c%.1f", (double) mlp->pre_center)
      ;  if (mlp->pre_inflation > 0.0)
         mcxTingPrintAfter(suf, "pi%.1f", (double) mlp->pre_inflation)
      ;  if (mlp->pre_maxnum)
         mcxTingPrintAfter(suf, "pp%d", (int) mlp->pre_maxnum)

      ;  if (mkappend)
         mcxTingPrintAfter(suf, "%s", mkappend)
      ;  mcxTingTr(suf, ".", "", 0)

      ;  if (mkprefix)
         {  char* ph /* placeholder */
         ;  if ((ph = strchr(mkprefix, '=')))
            {  mcxTingPrint(name, "%.*s", ph-mkprefix, mkprefix)
            ;  mcxTingPrintAfter(name, "%s", mlp->fnin->str)
            ;  mcxTingPrintAfter(name, "%s", ph+1)
         ;  }
            else
            mcxTingPrint(name, "%s", mkprefix)
      ;  }
         else
         mcxTingPrint(name, "out.%s", mlp->fnin->str)

      ;  mcxTingPrintAfter(name, ".%s", suf->str)
      ;  mcxTingWrite(mlp->xfout->fn, name->str)

      ;  mcxTingFree(&suf)
      ;  mcxTingFree(&name)
      ;  mlp->fait |= ALG_DO_WRITELOG | ALG_DO_WRITECLM
   ;  }

      if (mkbounce)
      {  if (mkbounce > 1)
         fprintf(stderr, "%s\n", mlp->xfout->fn->str)
      ;  fprintf
         (  stdout
         ,  "%s%s", mlp->xfout->fn->str
         ,  isatty(fileno(stdout)) ? "\n" : ""
         )
      ;  return ALG_INIT_DONE
   ;  }

      return ALG_INIT_OK
;  }


void showSettings
(  mclAlgParam* mlp
)
   {  mclShowSettings(stdout, mlp->mpp, TRUE)
;  }


mclAlgParam* mclAlgParamNew
(  mclProcParam* mpp
,  const char* prog
,  const char* fn
)  
                                                /* mq, valgrind debugging */
   {  mclAlgParam* map = (mclAlgParam*)
                               mcxAlloc(sizeof(mclAlgParam), EXIT_ON_FAIL)
   ;  if (!mpp)
      mpp =  mclProcParamNew()

   ;  map->mpp                   =     mpp

   ;  map->xfout                 =     mcxIOnew("", "w")

   ;  map->expandDigits          =     8

   ;  map->pre_center            =     1.0
   ;  map->pre_ctrmaxavg         =     0.0
   ;  map->pre_diag              =     -1.0

   ;  map->pre_inflation         =     -1.0
   ;  map->pre_in_gq             =     -1.0
   ;  map->pre_maxnum            =     0

   ;  map->fait                  =     ALG_DO_WRITELOG

   ;  map->writeMode             =     'a'
   ;  map->sortMode              =     'S'
   ;  map->cline                 =     mcxTingPrint(NULL, "%s %s", prog, fn)
   ;  map->fnin                  =     mcxTingEmpty(NULL, 10)
   ;  return map
;  }


void mclAlgParamFree
(  mclAlgParam** app
)
   {  mclAlgParam *map  = *app
   ;  mclProcParamFree(&(map->mpp))
   ;  mcxTingFree(&(map->cline))
   ;  mcxTingFree(&(map->fnin))
   ;  mcxIOfree(&(map->xfout))
   ;  mcxFree(map)
   ;  *app = NULL
;  }


void mclAlgPrintInfo
(  FILE* fp
,  mclAlgParam* mlp  
,  mclMatrix* cl
)
   {  fprintf(fp, "version <%s>\n", mclDateTag)
   ;  fprintf(fp, "input file name <%s>\n", mlp->fnin->str)
   ;  if (cl)
      fprintf(fp, "number of nodes <%ld>\n", (long) N_ROWS(cl))
   ;  if (cl)
      fprintf(fp, "number of clusters <%ld>\n", (long) N_COLS(cl))
   ;  fprintf(fp, "command line <%s>\n", mlp->cline->str)
   ;  fprintf(fp, "total time usage <%.2f>\n", (double) mlp->mpp->lap)  
   ;  fprintf(fp, "number of iterations <%d>\n", (int) mlp->mpp->n_ite)  
;  }


void juryCharter
(  mclProcParam* mpp
)
   {  grade*   gr    =  gradeDir+1
   ;  fputc('\n', stdout)
   ;  while (gr->mark >= 0)
         fprintf(stdout, "%3d%20s\n", (int) gr->mark, gr->ind)
      ,  gr++
   ;  fprintf
      (  stdout
      ,
   "\n"
"The  'synopsis' reported  by  mcl when  it is  done  corresponds with  a\n"
"weighted average of  the reported /jury/ marks. The  average is computed\n"
"as (5*m1+2*m2+m3)/8 and the correspondence is shown in the table above.\n"
"\n"
"There are  three jury marks for  the first three rounds  of expansion. A\n"
"jury mark  is the percentage of  kept stochastic mass averaged  over the\n"
"worst <%d> cases (c.q. matrix  columns). The number of cases considered\n"
"can be  set using -nj,  so you  have some control  over the mood  of the\n"
"jury. If the synopsis is low,  just increase the -scheme parameter. Read\n"
"the mcl manual for more information. Do not feel intimidated: -scheme is\n"
"your friend, and the synopsis is there  to remind you of its existence -\n"
"you can forget the rest.\n"
   "\n"
      ,  (int) mclDefaultWindowSizes[mpp->mxp->nj]
      )
   ;  return
;  }


void mclWriteLog
(  FILE* fp
,  mclAlgParam* mlp
,  mclMatrix* cl
)
   {  fputs("\n\n(mclruninfo\n\n", fp)
   ;  mclAlgPrintInfo(fp, mlp, cl)
   ;  fputc('\n', fp)
   ;  mclProcPrintInfo(fp, mlp->mpp)
   ;  fputc('\n', fp)
   ;  fprintf(mlp->xfout->fp, mlp->mpp->massLog->str)
   ;  fputs(")\n", fp)
;  }


void  howMuchRam
(  long  n
,  mclProcParam* mpp
)
   {  int x    =  MAX(mpp->mxp->selectNumber, mpp->mxp->recoverNumber)
   ;  int y    =  MIN(n, x)
   ;  mclIvp ivps[10]
   ;  int l    =  sizeof(ivps) / 10
   ;  double r =  (2.0 * l * y * n) / (1024.0 * 1024.0)
   ;  fprintf
      (  stdout
      ,  "The current settings require at most <%.2fM> RAM for a\n"
         "graph with <%ld> nodes, assuming the average node degree of\n"
         "the input graph does not exceed <%ld>. This (RAM number)\n"
         "will usually but not always be too pessimistic an estimate.\n"
      ,  (double) r
      ,  (long) n
      ,  (long) y
      )
;  }



void mclCenter
(  mclMatrix*        mx
,  double            w_self
,  double            o_ctrmax
)
   {  long cct

   ;  for (cct=0;cct<N_COLS(mx);cct++)
      {  mclVector*  vec      =  mx->cols+cct
      ;  mclIvp*     match    =  NULL
      ;  int         offset   =  -1
      ;  double      maxval   =  mclvMaxValue(vec)

      ;  if (w_self > 0 && vec->n_ivps)
         {  mclvIdxVal(vec, vec->vid, &offset)
         ;  if (offset >= 0)
            {  match = (vec->ivps+offset)
            ;  match->val  =  0.0
         ;  }
            else                    /* create extra room in vector */
            {  mclvResize (vec, (vec->n_ivps)+1)
            ;  match       =  vec->ivps+(vec->n_ivps-1)
            ;  match->val  =  0.0
            ;  match->idx  =  vec->vid
            ;  mclvSort (vec, mclpIdxCmp)
                             /* fixme ^^^ this could be done by shifting */

            ;  mclvIdxVal(vec, vec->vid, &offset)

            ;  if (offset < 0)
                  mcxErr("mclCenter", "error: insertion failed ?!?")
               ,  mcxExit(1)

            ;  match    =  (vec->ivps+offset)
         ;  }

            {  double sum =  mclvSum(vec)

            ;  if (sum > 0.0)
               {  double  selfinit
                  =     o_ctrmax * (mclvPowSum(vec, 2) / sum)
                     +  (1 - o_ctrmax) * maxval
               ;  match->val = w_self * selfinit
               ;  if (!match->val)
                  match->val =  1
            ;  }
               else
               match->val =  1
         ;  }
         }
         else if (!vec->n_ivps)
            mcxErr
            ("loop assignment", "adding loop to void column <%ld>", (long) cct)
         ,  mclvInsertIdx(vec, vec->vid, 1.0)
   ;  }
   }

