C-----------------------------------------------------------------------
#include "pdf/pilot.h"
      Subroutine Ctq4RL (Iset)
#include "pdf/impdp.inc"
      PARAMETER (MXX = 105, MXQ = 25, MXF = 6)
      PARAMETER (MXPQX = (MXF *2 +2) * MXQ * MXX)
      PARAMETER (NxI = 90, NtI = 13, NfMxI = 5)
      COMMON / W5051IC / Al, XV(0:MXX), QL(0:MXQ), UPD(MXPQX)
      COMMON / W5051ID / Nx, Nt, NfMx
      COMMON / W5051IE / Qini, Qmax, Xmin
      DIMENSION Amass(6)
      PARAMETER (NSETS=10)
      DIMENSION 
     >  XVI(0:MXX),QLI(0:MXQ),UPDI(MXPQX),
     >  AmassI(6)
C
C-----------------------------------------------------------------------
C Parton Distribution Table : CTEQ4L
C       PARAMETER (ISET=3)                                            
        DATA  DrI, FlI, AlI /             1.,   5.,  .1810 /
        DATA  (AmassI(I),I=1,6) /     .000,     .000,     .200,
     +                                 1.600,    5.000,  180.000 /
C        DATA  NXI,  NTI, NfMxI /    90,    13,     5 /
        DATA  QINII, QMAXI, (QLI(I), I =0, NTI) /
     +  .160000D+01, .100000D+05,
     +  .160000D+01, .203730D+01, .266455D+01, .359020D+01, .500000D+01,
     +  .799639D+01, .136669D+02, .251990D+02, .506628D+02, .112437D+03,
     +  .279329D+03, .789295D+03, .258339D+04, .100000D+05 /
        DATA  XMINI, (XVI(I), I =0, NXI) /
     +  .100000D-04,
     +  .000000D+00, .999983D-05, .124433D-04, .154836D-04, .192668D-04,
     +  .239740D-04, .298310D-04, .371184D-04, .461852D-04, .574656D-04,
     +  .714994D-04, .889575D-04, .110674D-03, .137686D-03, .171280D-03,
     +  .213055D-03, .264997D-03, .329564D-03, .409809D-03, .509508D-03,
     +  .633332D-03, .787053D-03, .977784D-03, .121428D-02, .150728D-02,
     +  .186993D-02, .231825D-02, .288037D-02, .356397D-02, .440443D-02,
     +  .543508D-02, .669508D-02, .822984D-02, .100851D-01, .123281D-01,
     +  .150167D-01, .182174D-01, .219985D-01, .264278D-01, .315720D-01,
     +  .374800D-01, .442088D-01, .517931D-01, .602576D-01, .696136D-01,
     +  .798586D-01, .909356D-01, .102935D+00, .115681D+00, .129293D+00,
     +  .143599D+00, .158606D+00, .174271D+00, .190550D+00, .207405D+00,
     +  .224796D+00, .242685D+00, .261038D+00, .279820D+00, .299001D+00,
     +  .318550D+00, .338442D+00, .358653D+00, .379067D+00, .399881D+00,
     +  .420953D+00, .442266D+00, .463806D+00, .485559D+00, .507513D+00,
     +  .529656D+00, .551978D+00, .574483D+00, .597187D+00, .619860D+00,
     +  .642828D+00, .665921D+00, .689135D+00, .712467D+00, .735911D+00,
     +  .759464D+00, .783080D+00, .806909D+00, .830741D+00, .854673D+00,
     +  .878696D+00, .902804D+00, .926992D+00, .951257D+00, .975603D+00,
     +  .100000D+01 /
C Parton Distribution Table:                                                     
        DATA (UPDI(I),I=1,52) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=53,104) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=105,156) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=157,208) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=209,260) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=261,312) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=313,364) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=365,416) /
     +  .278665D+06, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=417,468) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .132963D+06,
     +  .100189D+06, .741546D+05, .548596D+05, .405595D+05,
     +  .299670D+05, .221256D+05, .163242D+05, .120349D+05,
     +  .886568D+04, .652565D+04, .479912D+04, .352623D+04 /
        DATA (UPDI(I),I=469,520) /
     +  .258852D+04, .189832D+04, .139072D+04, .101777D+04,
     +  .743999D+03, .543244D+03, .396178D+03, .288567D+03,
     +  .209911D+03, .152492D+03, .110625D+03, .801401D+02,
     +  .579715D+02, .418800D+02, .300726D+02, .216679D+02,
     +  .155921D+02, .112068D+02, .804661D+01, .577271D+01,
     +  .414331D+01, .297103D+01, .213137D+01, .153051D+01,
     +  .110076D+01, .793429D+00, .573441D+00, .416033D+00,
     +  .303007D+00, .221688D+00, .162989D+00, .120455D+00,
     +  .894941D-01, .669241D-01, .502184D-01, .379402D-01,
     +  .287514D-01, .219060D-01, .167564D-01, .128616D-01,
     +  .990087D-02, .763937D-02, .590448D-02, .456844D-02,
     +  .353613D-02, .273626D-02, .211510D-02, .163190D-02,
     +  .125570D-02, .962520D-03, .735143D-03, .557137D-03 /
        DATA (UPDI(I),I=521,572) /
     +  .419009D-03, .312138D-03, .229783D-03, .166661D-03,
     +  .118615D-03, .823654D-04, .553106D-04, .354601D-04,
     +  .210951D-04, .110714D-04, .421785D-05, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .305489D+06, .229635D+06,
     +  .169475D+06, .125009D+06, .921462D+05, .678731D+05,
     +  .499564D+05, .367403D+05, .269984D+05, .198226D+05,
     +  .145411D+05, .106568D+05, .780258D+04, .570697D+04,
     +  .416980D+04, .304328D+04, .221856D+04, .161538D+04,
     +  .117474D+04, .853172D+03, .618801D+03, .448180D+03,
     +  .324140D+03, .234076D+03, .168783D+03, .121506D+03 /
        DATA (UPDI(I),I=573,624) /
     +  .873488D+02, .624023D+02, .447306D+02, .320177D+02,
     +  .228879D+02, .163426D+02, .116576D+02, .831850D+01,
     +  .592935D+01, .422774D+01, .301704D+01, .215618D+01,
     +  .154419D+01, .110877D+01, .799112D+00, .578130D+00,
     +  .420127D+00, .306786D+00, .225177D+00, .166141D+00,
     +  .123382D+00, .919300D-01, .689634D-01, .518861D-01,
     +  .392470D-01, .298013D-01, .227053D-01, .173476D-01,
     +  .132838D-01, .101885D-01, .782234D-02, .600797D-02,
     +  .461317D-02, .353884D-02, .271020D-02, .207067D-02,
     +  .157681D-02, .119742D-02, .903284D-03, .677333D-03,
     +  .504289D-03, .372294D-03, .272127D-03, .196591D-03,
     +  .140067D-03, .981673D-04, .674484D-04, .451910D-04,
     +  .294801D-04, .184481D-04, .109576D-04, .603335D-05 /
        DATA (UPDI(I),I=625,676) /
     +  .293292D-05, .109535D-05, .103726D-06, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .524297D+06, .393110D+06, .289242D+06,
     +  .212693D+06, .156286D+06, .114749D+06, .841828D+05,
     +  .617065D+05, .451914D+05, .330660D+05, .241709D+05,
     +  .176510D+05, .128765D+05, .938318D+04, .682990D+04,
     +  .496551D+04, .360565D+04, .261482D+04, .189377D+04,
     +  .136963D+04, .989151D+03, .713289D+03, .513582D+03,
     +  .369190D+03, .264970D+03, .189836D+03, .135807D+03,
     +  .965303D+02, .688411D+02, .490188D+02, .348540D+02,
     +  .247509D+02, .175566D+02, .124564D+02, .882699D+01,
     +  .625630D+01, .443759D+01, .315180D+01, .224308D+01 /
        DATA (UPDI(I),I=677,728) /
     +  .160034D+01, .114597D+01, .823676D+00, .594634D+00,
     +  .431340D+00, .314490D+00, .230478D+00, .170009D+00,
     +  .125806D+00, .937315D-01, .700327D-01, .526046D-01,
     +  .396638D-01, .300051D-01, .227608D-01, .173028D-01,
     +  .131741D-01, .100400D-01, .765394D-02, .583308D-02,
     +  .444115D-02, .337585D-02, .256023D-02, .193549D-02,
     +  .145956D-02, .109378D-02, .815267D-03, .603886D-03,
     +  .444113D-03, .323965D-03, .234167D-03, .167543D-03,
     +  .118540D-03, .828232D-04, .570586D-04, .388803D-04,
     +  .260468D-04, .172055D-04, .112191D-04, .723989D-05,
     +  .464030D-05, .297433D-05, .191524D-05, .123851D-05,
     +  .803010D-06, .512406D-06, .311845D-06, .171966D-06,
     +  .790334D-07, .241300D-07, .198761D-08, .000000D+00 /
        DATA (UPDI(I),I=729,780) /
     +  .796347D+06, .595511D+06, .436780D+06, .320154D+06,
     +  .234481D+06, .171591D+06, .125460D+06, .916482D+05,
     +  .668863D+05, .487670D+05, .355202D+05, .258442D+05,
     +  .187834D+05, .136359D+05, .988732D+04, .716023D+04,
     +  .517863D+04, .374034D+04, .269774D+04, .194289D+04,
     +  .139716D+04, .100311D+04, .719042D+03, .514536D+03,
     +  .367576D+03, .262093D+03, .186594D+03, .131966D+03,
     +  .936381D+02, .663325D+02, .469166D+02, .331381D+02,
     +  .233769D+02, .164932D+02, .116208D+02, .818845D+01,
     +  .577361D+01, .407598D+01, .288305D+01, .204417D+01,
     +  .145461D+01, .103888D+01, .745197D+00, .537069D+00,
     +  .389037D+00, .283243D+00, .207563D+00, .152574D+00,
     +  .112920D+00, .838022D-01, .625224D-01, .468207D-01 /
        DATA (UPDI(I),I=781,832) /
     +  .351761D-01, .264984D-01, .200032D-01, .151226D-01,
     +  .114429D-01, .866079D-02, .655273D-02, .495288D-02,
     +  .373753D-02, .281412D-02, .211223D-02, .158178D-02,
     +  .117739D-02, .872035D-03, .642229D-03, .470001D-03,
     +  .341584D-03, .246404D-03, .176352D-03, .125205D-03,
     +  .881595D-04, .615613D-04, .428317D-04, .295812D-04,
     +  .203776D-04, .140382D-04, .969633D-05, .672368D-05,
     +  .468307D-05, .326037D-05, .224493D-05, .151202D-05,
     +  .974170D-06, .582408D-06, .308228D-06, .132863D-06,
     +  .376866D-07, .321032D-08, .000000D+00, .112848D+07,
     +  .841593D+06, .615267D+06, .449498D+06, .328114D+06,
     +  .239297D+06, .174363D+06, .126928D+06, .923070D+05,
     +  .670598D+05, .486662D+05, .352783D+05, .255438D+05 /
        DATA (UPDI(I),I=833,884) /
     +  .184730D+05, .133428D+05, .962462D+04, .693319D+04,
     +  .498724D+04, .358223D+04, .256904D+04, .183953D+04,
     +  .131497D+04, .938417D+03, .668486D+03, .475360D+03,
     +  .337349D+03, .239025D+03, .168212D+03, .118765D+03,
     +  .837060D+02, .588988D+02, .413822D+02, .290355D+02,
     +  .203734D+02, .142744D+02, .100010D+02, .701081D+01,
     +  .492027D+01, .345948D+01, .243803D+01, .172427D+01,
     +  .122386D+01, .872411D+00, .624801D+00, .449728D+00,
     +  .325341D+00, .236892D+00, .173005D+00, .127214D+00,
     +  .937919D-01, .695158D-01, .517134D-01, .385928D-01,
     +  .288768D-01, .216508D-01, .162564D-01, .122160D-01,
     +  .918181D-02, .689847D-02, .517774D-02, .387989D-02,
     +  .290104D-02, .216248D-02, .160855D-02, .118952D-02 /
        DATA (UPDI(I),I=885,936) /
     +  .875588D-03, .641211D-03, .466957D-03, .338057D-03,
     +  .243257D-03, .174001D-03, .123768D-03, .875965D-04,
     +  .617294D-04, .435440D-04, .306536D-04, .216377D-04,
     +  .153425D-04, .109345D-04, .782185D-05, .559704D-05,
     +  .397531D-05, .276671D-05, .186425D-05, .118947D-05,
     +  .697546D-06, .358819D-06, .148612D-06, .402293D-07,
     +  .349213D-08, .000000D+00, .152723D+07, .113585D+07,
     +  .827651D+06, .602643D+06, .438415D+06, .318647D+06,
     +  .231375D+06, .167838D+06, .121623D+06, .880382D+05,
     +  .636565D+05, .459734D+05, .331624D+05, .238911D+05,
     +  .171893D+05, .123505D+05, .886126D+04, .634832D+04,
     +  .454110D+04, .324309D+04, .231232D+04, .164579D+04,
     +  .116935D+04, .829272D+03, .587015D+03, .414649D+03 /
        DATA (UPDI(I),I=937,988) /
     +  .292413D+03, .204783D+03, .143879D+03, .100902D+03,
     +  .706385D+02, .493742D+02, .344605D+02, .240505D+02,
     +  .167586D+02, .116762D+02, .813884D+01, .567914D+01,
     +  .396980D+01, .278117D+01, .195523D+01, .137943D+01,
     +  .977333D+00, .695657D+00, .497647D+00, .357768D+00,
     +  .258885D+00, .187873D+00, .137278D+00, .100566D+00,
     +  .740605D-01, .547398D-01, .405866D-01, .301705D-01,
     +  .224721D-01, .167613D-01, .125114D-01, .934085D-02,
     +  .697075D-02, .519675D-02, .386798D-02, .287290D-02,
     +  .212740D-02, .157234D-02, .115555D-02, .845635D-03,
     +  .615995D-03, .446540D-03, .322117D-03, .231261D-03,
     +  .165327D-03, .117785D-03, .837224D-04, .594364D-04,
     +  .423746D-04, .302487D-04, .217076D-04, .156697D-04 /
        DATA (UPDI(I),I=989,1040) /
     +  .113642D-04, .825288D-05, .596837D-05, .426071D-05,
     +  .296193D-05, .198090D-05, .124676D-05, .716879D-06,
     +  .359257D-06, .143690D-06, .373766D-07, .329571D-08,
     +  .000000D+00, .199870D+07, .148239D+07, .107658D+07,
     +  .781264D+06, .566429D+06, .410272D+06, .296869D+06,
     +  .214587D+06, .154944D+06, .111753D+06, .805074D+05,
     +  .579275D+05, .416284D+05, .298759D+05, .214123D+05,
     +  .153245D+05, .109514D+05, .781416D+04, .556683D+04,
     +  .395916D+04, .281100D+04, .199218D+04, .140933D+04,
     +  .995044D+03, .701203D+03, .493038D+03, .346083D+03,
     +  .241210D+03, .168660D+03, .117703D+03, .819911D+02,
     +  .570196D+02, .395913D+02, .274867D+02, .190506D+02,
     +  .132011D+02, .915097D+01, .634961D+01, .441328D+01 /
        DATA (UPDI(I),I=1041,1092) /
     +  .307407D+01, .214860D+01, .150695D+01, .106136D+01,
     +  .750954D+00, .533979D+00, .381561D+00, .274431D+00,
     +  .197930D+00, .143739D+00, .104647D+00, .765859D-01,
     +  .562520D-01, .414452D-01, .306134D-01, .226565D-01,
     +  .167904D-01, .124524D-01, .923658D-02, .684824D-02,
     +  .507234D-02, .375107D-02, .276836D-02, .203715D-02,
     +  .149652D-02, .109344D-02, .795846D-03, .576905D-03,
     +  .416480D-03, .299492D-03, .214621D-03, .153397D-03,
     +  .109474D-03, .781311D-04, .558281D-04, .401537D-04,
     +  .289744D-04, .210413D-04, .153675D-04, .112582D-04,
     +  .823536D-05, .597433D-05, .425950D-05, .294336D-05,
     +  .194768D-05, .120736D-05, .680559D-06, .332555D-06,
     +  .128736D-06, .322975D-07, .288884D-08, .000000D+00 /
        DATA (UPDI(I),I=1093,1144) /
     +  .254837D+07, .188486D+07, .136432D+07, .986753D+06,
     +  .712982D+06, .514648D+06, .371099D+06, .267300D+06,
     +  .192319D+06, .138210D+06, .992042D+05, .711171D+05,
     +  .509158D+05, .364031D+05, .259905D+05, .185288D+05,
     +  .131893D+05, .937343D+04, .665069D+04, .471063D+04,
     +  .333066D+04, .235051D+04, .165571D+04, .116392D+04,
     +  .816591D+03, .571584D+03, .399393D+03, .277058D+03,
     +  .192815D+03, .133917D+03, .928312D+02, .642387D+02,
     +  .443789D+02, .306529D+02, .211343D+02, .145673D+02,
     +  .100436D+02, .693092D+01, .479065D+01, .331821D+01,
     +  .230610D+01, .160815D+01, .112609D+01, .792119D+00,
     +  .559953D+00, .397758D+00, .284391D+00, .203885D+00,
     +  .147179D+00, .106503D+00, .774721D-01, .565564D-01 /
        DATA (UPDI(I),I=1145,1196) /
     +  .414142D-01, .304021D-01, .223609D-01, .164683D-01,
     +  .121373D-01, .894655D-02, .659175D-02, .485197D-02,
     +  .356597D-02, .261580D-02, .191344D-02, .139763D-02,
     +  .101564D-02, .735536D-03, .530837D-03, .381833D-03,
     +  .273859D-03, .195988D-03, .140107D-03, .100186D-03,
     +  .717866D-04, .515964D-04, .373870D-04, .272081D-04,
     +  .199289D-04, .146657D-04, .108032D-04, .792297D-05,
     +  .574147D-05, .407414D-05, .279132D-05, .182464D-05,
     +  .111317D-05, .615068D-06, .293209D-06, .110013D-06,
     +  .266914D-07, .241982D-08, .000000D+00, .318100D+07,
     +  .234634D+07, .169273D+07, .122018D+07, .878665D+06,
     +  .632075D+06, .454198D+06, .326013D+06, .233733D+06,
     +  .167371D+06, .119702D+06, .854973D+05, .609847D+05 /
        DATA (UPDI(I),I=1197,1248) /
     +  .434387D+05, .308961D+05, .219415D+05, .155579D+05,
     +  .110132D+05, .778304D+04, .549038D+04, .386610D+04,
     +  .271706D+04, .190585D+04, .133404D+04, .931883D+03,
     +  .649398D+03, .451740D+03, .311929D+03, .216082D+03,
     +  .149374D+03, .103053D+03, .709669D+02, .487853D+02,
     +  .335281D+02, .229989D+02, .157704D+02, .108160D+02,
     +  .742415D+01, .510386D+01, .351581D+01, .242992D+01,
     +  .168504D+01, .117328D+01, .820629D+00, .576794D+00,
     +  .407360D+00, .289579D+00, .206391D+00, .148120D+00,
     +  .106552D+00, .770506D-01, .559151D-01, .407007D-01,
     +  .296995D-01, .217128D-01, .158946D-01, .116437D-01,
     +  .853087D-02, .624762D-02, .457117D-02, .333976D-02,
     +  .243572D-02, .177169D-02, .128717D-02, .930657D-03 /
        DATA (UPDI(I),I=1249,1300) /
     +  .670910D-03, .482289D-03, .345827D-03, .247513D-03,
     +  .176983D-03, .126596D-03, .907234D-04, .652586D-04,
     +  .471531D-04, .343814D-04, .251864D-04, .185597D-04,
     +  .137204D-04, .101300D-04, .742536D-05, .536071D-05,
     +  .377800D-05, .256251D-05, .165318D-05, .992160D-06,
     +  .537378D-06, .250008D-06, .910197D-07, .214023D-07,
     +  .196555D-08, .000000D+00, .100081D+06, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=1301,1352) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=1353,1404) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .325100D+05, .247910D+05, .186121D+05,
     +  .139736D+05, .104900D+05, .787396D+04, .590965D+04,
     +  .443482D+04, .332760D+04, .249646D+04, .187263D+04,
     +  .140446D+04, .105315D+04, .789562D+03, .591832D+03,
     +  .443523D+03, .332305D+03, .248914D+03, .186403D+03,
     +  .139551D+03, .104446D+03, .781476D+02, .584526D+02,
     +  .437065D+02, .326697D+02, .244110D+02, .182346D+02,
     +  .135604D+02, .101247D+02, .755786D+01, .564094D+01,
     +  .421012D+01, .314260D+01, .234861D+01, .175511D+01,
     +  .131305D+01, .983816D+00, .738593D+00, .555868D+00 /
        DATA (UPDI(I),I=1405,1456) /
     +  .419542D+00, .317850D+00, .241724D+00, .184627D+00,
     +  .141671D+00, .109240D+00, .846528D-01, .659929D-01,
     +  .516206D-01, .406316D-01, .320803D-01, .254579D-01,
     +  .202805D-01, .162118D-01, .129980D-01, .104473D-01,
     +  .841376D-02, .678573D-02, .547753D-02, .442286D-02,
     +  .357024D-02, .287923D-02, .231840D-02, .186237D-02,
     +  .149292D-02, .119046D-02, .944650D-03, .745170D-03,
     +  .583626D-03, .453232D-03, .348403D-03, .264621D-03,
     +  .197984D-03, .145624D-03, .104699D-03, .734466D-04,
     +  .496152D-04, .319365D-04, .191640D-04, .102270D-04,
     +  .429731D-05, .582331D-06, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=1457,1508) /
     +  .773370D+05, .588903D+05, .441370D+05, .330771D+05,
     +  .247837D+05, .185657D+05, .139047D+05, .104113D+05,
     +  .779370D+04, .583264D+04, .436380D+04, .326388D+04,
     +  .244044D+04, .182414D+04, .136300D+04, .101805D+04,
     +  .760106D+03, .567281D+03, .423190D+03, .315553D+03,
     +  .235182D+03, .175193D+03, .130440D+03, .970655D+02,
     +  .721921D+02, .536603D+02, .398669D+02, .294787D+02,
     +  .218820D+02, .162361D+02, .120429D+02, .893090D+01,
     +  .662265D+01, .491627D+01, .364877D+01, .271073D+01,
     +  .201672D+01, .150325D+01, .112324D+01, .841667D+00,
     +  .633074D+00, .477997D+00, .362484D+00, .276173D+00,
     +  .211453D+00, .162712D+00, .125969D+00, .978518D-01,
     +  .764940D-01, .599806D-01, .472736D-01, .374024D-01 /
        DATA (UPDI(I),I=1509,1560) /
     +  .296942D-01, .236444D-01, .188735D-01, .150945D-01,
     +  .120891D-01, .969039D-02, .776989D-02, .622826D-02,
     +  .498811D-02, .398902D-02, .318292D-02, .253513D-02,
     +  .200917D-02, .158539D-02, .124448D-02, .970873D-03,
     +  .752000D-03, .577638D-03, .439449D-03, .330621D-03,
     +  .245569D-03, .179584D-03, .129420D-03, .912071D-04,
     +  .627684D-04, .419832D-04, .271229D-04, .167820D-04,
     +  .981911D-05, .534013D-05, .259992D-05, .106568D-05,
     +  .299579D-06, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .137095D+06,
     +  .104214D+06, .779440D+05, .582865D+05, .435741D+05,
     +  .325654D+05, .243302D+05, .181714D+05, .135668D+05,
     +  .101253D+05, .755377D+04, .563302D+04, .419886D+04 /
        DATA (UPDI(I),I=1561,1612) /
     +  .312840D+04, .232973D+04, .173407D+04, .129004D+04,
     +  .959161D+03, .712741D+03, .529302D+03, .392831D+03,
     +  .291350D+03, .215941D+03, .159935D+03, .118371D+03,
     +  .875393D+02, .646982D+02, .475782D+02, .351209D+02,
     +  .259098D+02, .191050D+02, .140824D+02, .103779D+02,
     +  .765527D+01, .564489D+01, .416614D+01, .307889D+01,
     +  .227955D+01, .169178D+01, .125906D+01, .940588D+00,
     +  .705357D+00, .531278D+00, .402048D+00, .305770D+00,
     +  .233722D+00, .179753D+00, .138709D+00, .107727D+00,
     +  .839192D-01, .657114D-01, .516528D-01, .407414D-01,
     +  .322297D-01, .255583D-01, .203065D-01, .161559D-01,
     +  .128641D-01, .102456D-01, .815748D-02, .648909D-02,
     +  .515424D-02, .408478D-02, .323158D-02, .254400D-02 /
        DATA (UPDI(I),I=1613,1664) /
     +  .199423D-02, .155543D-02, .120609D-02, .928901D-03,
     +  .709907D-03, .537772D-03, .403376D-03, .299134D-03,
     +  .218902D-03, .158339D-03, .112477D-03, .784948D-04,
     +  .536959D-04, .359279D-04, .234417D-04, .148894D-04,
     +  .918520D-05, .547268D-05, .315573D-05, .175057D-05,
     +  .926526D-06, .455826D-06, .198433D-06, .627099D-07,
     +  .455117D-08, .000000D+00, .239826D+06, .162828D+06,
     +  .121498D+06, .906360D+05, .675886D+05, .503824D+05,
     +  .375412D+05, .279610D+05, .208163D+05, .154901D+05,
     +  .115210D+05, .856452D+04, .636332D+04, .472517D+04,
     +  .350669D+04, .260079D+04, .192768D+04, .142780D+04,
     +  .105681D+04, .781624D+03, .577662D+03, .426577D+03,
     +  .314755D+03, .232044D+03, .170923D+03, .125781D+03 /
        DATA (UPDI(I),I=1665,1716) /
     +  .924920D+02, .676585D+02, .496766D+02, .364468D+02,
     +  .267232D+02, .195841D+02, .143471D+02, .105195D+02,
     +  .770934D+01, .565431D+01, .415228D+01, .305466D+01,
     +  .225245D+01, .166550D+01, .123617D+01, .921021D+00,
     +  .689239D+00, .518231D+00, .391611D+00, .297427D+00,
     +  .227305D+00, .174293D+00, .134516D+00, .104131D+00,
     +  .810287D-01, .632955D-01, .496126D-01, .390016D-01,
     +  .307339D-01, .242641D-01, .191817D-01, .151755D-01,
     +  .120085D-01, .949900D-02, .750683D-02, .592349D-02,
     +  .466337D-02, .366499D-02, .286609D-02, .223194D-02,
     +  .172954D-02, .133258D-02, .102004D-02, .775039D-03,
     +  .583984D-03, .436000D-03, .322109D-03, .235121D-03,
     +  .169935D-03, .120898D-03, .847634D-04, .584977D-04 /
        DATA (UPDI(I),I=1717,1768) /
     +  .397046D-04, .264652D-04, .173288D-04, .111341D-04,
     +  .698958D-05, .428861D-05, .254528D-05, .143568D-05,
     +  .741154D-06, .327770D-06, .100882D-06, .789558D-08,
     +  .000000D+00, .341951D+06, .258728D+06, .192441D+06,
     +  .143089D+06, .106345D+06, .789983D+05, .586547D+05,
     +  .435272D+05, .322836D+05, .239307D+05, .177284D+05,
     +  .131254D+05, .971126D+04, .718026D+04, .530516D+04,
     +  .391680D+04, .288955D+04, .212997D+04, .156876D+04,
     +  .115439D+04, .848712D+03, .623376D+03, .457433D+03,
     +  .335318D+03, .245558D+03, .179619D+03, .131271D+03,
     +  .954125D+02, .696018D+02, .507276D+02, .369420D+02,
     +  .268854D+02, .195565D+02, .142358D+02, .103562D+02,
     +  .753894D+01, .549444D+01, .401115D+01, .293500D+01 /
        DATA (UPDI(I),I=1769,1820) /
     +  .215338D+01, .158589D+01, .117241D+01, .870560D+00,
     +  .649505D+00, .487035D+00, .367063D+00, .278395D+00,
     +  .211842D+00, .162266D+00, .124664D+00, .962788D-01,
     +  .746444D-01, .580691D-01, .453058D-01, .354316D-01,
     +  .277598D-01, .217762D-01, .170938D-01, .134193D-01,
     +  .105292D-01, .825202D-02, .645612D-02, .503771D-02,
     +  .392281D-02, .303789D-02, .234131D-02, .179421D-02,
     +  .136580D-02, .103165D-02, .772307D-03, .572212D-03,
     +  .418968D-03, .302615D-03, .214972D-03, .150382D-03,
     +  .102743D-03, .684710D-04, .442982D-04, .276540D-04,
     +  .165196D-04, .933641D-05, .491931D-05, .234385D-05,
     +  .972839D-06, .320666D-06, .644642D-07, .000000D+00,
     +  .000000D+00, .518533D-09, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=1821,1872) /
     +  .508980D+06, .383992D+06, .284630D+06, .210892D+06,
     +  .156173D+06, .115587D+06, .854987D+05, .632041D+05,
     +  .466936D+05, .344732D+05, .254337D+05, .187509D+05,
     +  .138138D+05, .101687D+05, .747933D+04, .549655D+04,
     +  .403588D+04, .296061D+04, .216977D+04, .158857D+04,
     +  .116188D+04, .848873D+03, .619522D+03, .451610D+03,
     +  .328838D+03, .239128D+03, .173722D+03, .125486D+03,
     +  .909690D+02, .658780D+02, .476628D+02, .344574D+02,
     +  .248945D+02, .179969D+02, .130005D+02, .939656D+01,
     +  .679897D+01, .492739D+01, .357898D+01, .260649D+01,
     +  .190538D+01, .139815D+01, .103048D+01, .763121D+00,
     +  .568002D+00, .424922D+00, .319917D+00, .241642D+00,
     +  .183739D+00, .140124D+00, .107425D+00, .826749D-01 /
        DATA (UPDI(I),I=1873,1924) /
     +  .638428D-01, .494421D-01, .383789D-01, .298439D-01,
     +  .232346D-01, .181002D-01, .141006D-01, .109785D-01,
     +  .853744D-02, .662739D-02, .513078D-02, .396405D-02,
     +  .304576D-02, .232914D-02, .177124D-02, .133829D-02,
     +  .100369D-02, .746392D-03, .549740D-03, .400543D-03,
     +  .288295D-03, .204501D-03, .143262D-03, .984246D-04,
     +  .663514D-04, .437990D-04, .282513D-04, .177676D-04,
     +  .108811D-04, .648759D-05, .375200D-05, .211553D-05,
     +  .115847D-05, .610170D-06, .299745D-06, .128077D-06,
     +  .379797D-07, .291259D-08, .000000D+00, .722429D+06,
     +  .543391D+06, .401344D+06, .296288D+06, .218599D+06,
     +  .161178D+06, .118763D+06, .874499D+05, .643472D+05,
     +  .473127D+05, .347611D+05, .255188D+05, .187183D+05 /
        DATA (UPDI(I),I=1925,1976) /
     +  .137181D+05, .100446D+05, .734784D+04, .536989D+04,
     +  .392034D+04, .285910D+04, .208281D+04, .151561D+04,
     +  .110154D+04, .799653D+03, .579753D+03, .419803D+03,
     +  .303541D+03, .219242D+03, .157419D+03, .113431D+03,
     +  .816394D+02, .586958D+02, .421626D+02, .302630D+02,
     +  .217334D+02, .155941D+02, .111943D+02, .804379D+01,
     +  .578886D+01, .417514D+01, .301911D+01, .219134D+01,
     +  .159651D+01, .116828D+01, .858993D+00, .634807D+00,
     +  .471512D+00, .352480D+00, .264340D+00, .199577D+00,
     +  .151119D+00, .115032D+00, .878994D-01, .673928D-01,
     +  .518174D-01, .399330D-01, .308274D-01, .238253D-01,
     +  .184240D-01, .142468D-01, .110097D-01, .849766D-02,
     +  .654698D-02, .503024D-02, .385715D-02, .294129D-02 /
        DATA (UPDI(I),I=1977,2028) /
     +  .223246D-02, .168527D-02, .126427D-02, .941733D-03,
     +  .695886D-03, .509645D-03, .369587D-03, .265120D-03,
     +  .187775D-03, .131680D-03, .908760D-04, .618308D-04,
     +  .414543D-04, .273825D-04, .178209D-04, .114380D-04,
     +  .724437D-05, .450902D-05, .275660D-05, .163330D-05,
     +  .916265D-06, .465931D-06, .197964D-06, .564371D-07,
     +  .462815D-08, .000000D+00, .989256D+06, .741818D+06,
     +  .545905D+06, .401518D+06, .295122D+06, .216768D+06,
     +  .159102D+06, .116689D+06, .855162D+05, .626200D+05,
     +  .458157D+05, .334915D+05, .244603D+05, .178474D+05,
     +  .130096D+05, .947344D+04, .689118D+04, .500718D+04,
     +  .363415D+04, .263443D+04, .190742D+04, .137924D+04,
     +  .996046D+03, .718311D+03, .517324D+03, .371986D+03 /
        DATA (UPDI(I),I=2029,2080) /
     +  .267171D+03, .190719D+03, .136624D+03, .977484D+02,
     +  .698522D+02, .498675D+02, .355688D+02, .253813D+02,
     +  .180936D+02, .129033D+02, .921026D+01, .658383D+01,
     +  .471635D+01, .338722D+01, .244168D+01, .176667D+01,
     +  .128390D+01, .937494D+00, .688050D+00, .507534D+00,
     +  .376808D+00, .280631D+00, .210424D+00, .158233D+00,
     +  .119618D+00, .907728D-01, .691140D-01, .527714D-01,
     +  .403841D-01, .309567D-01, .237562D-01, .182400D-01,
     +  .140037D-01, .107441D-01, .823280D-02, .629708D-02,
     +  .480312D-02, .365644D-02, .276815D-02, .208611D-02,
     +  .156384D-02, .116529D-02, .862476D-03, .633575D-03,
     +  .461607D-03, .333335D-03, .238419D-03, .168665D-03,
     +  .118413D-03, .820612D-04, .562805D-04, .382133D-04 /
        DATA (UPDI(I),I=2081,2132) /
     +  .257008D-04, .171304D-04, .113209D-04, .741036D-05,
     +  .477137D-05, .300675D-05, .182146D-05, .103209D-05,
     +  .522355D-06, .216872D-06, .596064D-07, .502921D-08,
     +  .000000D+00, .131629D+07, .984023D+06, .721488D+06,
     +  .528687D+06, .387125D+06, .283255D+06, .207092D+06,
     +  .151285D+06, .110424D+06, .805292D+05, .586746D+05,
     +  .427106D+05, .310599D+05, .225642D+05, .163751D+05,
     +  .118705D+05, .859536D+04, .621641D+04, .449045D+04,
     +  .323950D+04, .233403D+04, .167931D+04, .120659D+04,
     +  .865651D+03, .620158D+03, .443531D+03, .316822D+03,
     +  .224888D+03, .160193D+03, .113951D+03, .809545D+02,
     +  .574495D+02, .407285D+02, .288849D+02, .204626D+02,
     +  .145004D+02, .102840D+02, .730375D+01, .519791D+01 /
        DATA (UPDI(I),I=2133,2184) /
     +  .370849D+01, .265560D+01, .190869D+01, .137787D+01,
     +  .999405D+00, .728597D+00, .533851D+00, .393713D+00,
     +  .291256D+00, .216938D+00, .162037D+00, .121675D+00,
     +  .917148D-01, .693617D-01, .526031D-01, .399824D-01,
     +  .304400D-01, .231997D-01, .176902D-01, .134877D-01,
     +  .102764D-01, .781964D-02, .593948D-02, .449878D-02,
     +  .340114D-02, .255719D-02, .191412D-02, .142550D-02,
     +  .105552D-02, .776619D-03, .567442D-03, .411510D-03,
     +  .296072D-03, .211275D-03, .149365D-03, .105019D-03,
     +  .730804D-04, .504856D-04, .346474D-04, .236351D-04,
     +  .160279D-04, .107960D-04, .720241D-05, .471524D-05,
     +  .300581D-05, .182862D-05, .103134D-05, .514403D-06,
     +  .207827D-06, .551054D-07, .474500D-08, .000000D+00 /
        DATA (UPDI(I),I=2185,2236) /
     +  .171008D+07, .127450D+07, .931042D+06, .679711D+06,
     +  .495839D+06, .361414D+06, .263213D+06, .191527D+06,
     +  .139241D+06, .101134D+06, .733849D+05, .531963D+05,
     +  .385217D+05, .278650D+05, .201339D+05, .145307D+05,
     +  .104744D+05, .754079D+04, .542187D+04, .389302D+04,
     +  .279146D+04, .199864D+04, .142893D+04, .102000D+04,
     +  .726994D+03, .517221D+03, .367505D+03, .259439D+03,
     +  .183792D+03, .130010D+03, .918400D+02, .647993D+02,
     +  .456701D+02, .321974D+02, .226717D+02, .159676D+02,
     +  .112544D+02, .794299D+01, .561717D+01, .398212D+01,
     +  .283331D+01, .202333D+01, .145121D+01, .104580D+01,
     +  .757491D+00, .551423D+00, .404050D+00, .296957D+00,
     +  .219754D+00, .163072D+00, .121656D+00, .911029D-01 /
        DATA (UPDI(I),I=2237,2288) /
     +  .684487D-01, .515704D-01, .389394D-01, .294500D-01,
     +  .222962D-01, .168879D-01, .127899D-01, .967940D-02,
     +  .731599D-02, .551976D-02, .415294D-02, .311897D-02,
     +  .232971D-02, .173271D-02, .128244D-02, .944039D-03,
     +  .690828D-03, .502317D-03, .362803D-03, .260231D-03,
     +  .185381D-03, .131045D-03, .923097D-04, .645036D-04,
     +  .448574D-04, .310663D-04, .214302D-04, .147153D-04,
     +  .100349D-04, .676655D-05, .446234D-05, .285116D-05,
     +  .172791D-05, .964104D-06, .472035D-06, .185346D-06,
     +  .474753D-07, .415865D-08, .000000D+00, .217671D+07,
     +  .161736D+07, .117721D+07, .856265D+06, .622303D+06,
     +  .451880D+06, .327838D+06, .237626D+06, .172075D+06,
     +  .124484D+06, .899631D+05, .649463D+05, .468350D+05 /
        DATA (UPDI(I),I=2289,2340) /
     +  .337356D+05, .242715D+05, .174408D+05, .125167D+05,
     +  .897088D+04, .642087D+04, .458909D+04, .327519D+04,
     +  .233384D+04, .166053D+04, .117951D+04, .836492D+03,
     +  .592098D+03, .418545D+03, .293904D+03, .207101D+03,
     +  .145707D+03, .102364D+03, .718220D+02, .503327D+02,
     +  .352809D+02, .246979D+02, .172918D+02, .121148D+02,
     +  .849846D+01, .597330D+01, .420850D+01, .297584D+01,
     +  .211188D+01, .150525D+01, .107794D+01, .775876D+00,
     +  .561249D+00, .408672D+00, .298453D+00, .219473D+00,
     +  .161832D+00, .119967D+00, .892691D-01, .666447D-01,
     +  .498912D-01, .374306D-01, .281272D-01, .211576D-01,
     +  .159220D-01, .119803D-01, .900801D-02, .676453D-02,
     +  .507087D-02, .379076D-02, .282904D-02, .210003D-02 /
        DATA (UPDI(I),I=2341,2392) /
     +  .155247D-02, .114241D-02, .836401D-03, .609037D-03,
     +  .440936D-03, .317357D-03, .227074D-03, .161577D-03,
     +  .114262D-03, .806621D-04, .565960D-04, .395951D-04,
     +  .276316D-04, .192263D-04, .133182D-04, .915091D-05,
     +  .620248D-05, .409685D-05, .260993D-05, .156884D-05,
     +  .863266D-06, .414117D-06, .157988D-06, .391549D-07,
     +  .348320D-08, .000000D+00, .272166D+07, .201624D+07,
     +  .146227D+07, .105974D+07, .767347D+06, .555125D+06,
     +  .401222D+06, .289705D+06, .208976D+06, .150585D+06,
     +  .108394D+06, .779370D+05, .559736D+05, .401514D+05,
     +  .287664D+05, .205829D+05, .147080D+05, .104953D+05,
     +  .747868D+04, .532108D+04, .378027D+04, .268128D+04,
     +  .189877D+04, .134229D+04, .947316D+03, .667227D+03 /
        DATA (UPDI(I),I=2393,2444) /
     +  .469296D+03, .327844D+03, .229826D+03, .160849D+03,
     +  .112400D+03, .784375D+02, .546669D+02, .381060D+02,
     +  .265248D+02, .184645D+02, .128614D+02, .896932D+01,
     +  .626695D+01, .438903D+01, .308485D+01, .217602D+01,
     +  .154156D+01, .109722D+01, .784937D+00, .564327D+00,
     +  .408408D+00, .296424D+00, .216647D+00, .158763D+00,
     +  .116968D+00, .865004D-01, .641785D-01, .477471D-01,
     +  .355992D-01, .265842D-01, .198719D-01, .148609D-01,
     +  .111118D-01, .830271D-02, .619603D-02, .461598D-02,
     +  .342952D-02, .254407D-02, .187736D-02, .137998D-02,
     +  .101001D-02, .735777D-03, .533370D-03, .384685D-03,
     +  .276053D-03, .197142D-03, .140191D-03, .992180D-04,
     +  .702059D-04, .494527D-04, .347808D-04, .244228D-04 /
        DATA (UPDI(I),I=2445,2496) /
     +  .171030D-04, .119156D-04, .821955D-05, .557853D-05,
     +  .367670D-05, .232769D-05, .138420D-05, .749807D-06,
     +  .352067D-06, .130522D-06, .313490D-07, .282918D-08,
     +  .000000D+00, .334969D+07, .247421D+07, .178805D+07,
     +  .129120D+07, .931558D+06, .671450D+06, .483495D+06,
     +  .347800D+06, .249927D+06, .179401D+06, .128633D+06,
     +  .921234D+05, .658976D+05, .470786D+05, .335909D+05,
     +  .239349D+05, .170312D+05, .121012D+05, .858566D+04,
     +  .608187D+04, .430153D+04, .303722D+04, .214098D+04,
     +  .150647D+04, .105817D+04, .741718D+03, .519156D+03,
     +  .360860D+03, .251705D+03, .175265D+03, .121842D+03,
     +  .845810D+02, .586346D+02, .406515D+02, .281416D+02,
     +  .194812D+02, .134933D+02, .935652D+01, .649998D+01 /
        DATA (UPDI(I),I=2497,2548) /
     +  .452586D+01, .316248D+01, .221769D+01, .156182D+01,
     +  .110506D+01, .785857D+00, .561623D+00, .404038D+00,
     +  .291493D+00, .211774D+00, .154260D+00, .112969D+00,
     +  .830410D-01, .612407D-01, .452864D-01, .335604D-01,
     +  .249097D-01, .185072D-01, .137562D-01, .102234D-01,
     +  .759268D-02, .563209D-02, .417089D-02, .308060D-02,
     +  .227215D-02, .166733D-02, .121905D-02, .887752D-03,
     +  .643748D-03, .464778D-03, .334100D-03, .239163D-03,
     +  .170554D-03, .121260D-03, .859129D-04, .609370D-04,
     +  .430787D-04, .304337D-04, .214735D-04, .151046D-04,
     +  .105577D-04, .729134D-05, .494112D-05, .324102D-05,
     +  .203462D-05, .119499D-05, .636536D-06, .292394D-06,
     +  .105377D-06, .245667D-07, .224748D-08, .000000D+00 /
        DATA (UPDI(I),I=2549,2600) /
     +  .846377D+05, .501568D+05, .385858D+05, .296844D+05,
     +  .228366D+05, .175687D+05, .135161D+05, .103985D+05,
     +  .800014D+04, .615508D+04, .473568D+04, .364372D+04,
     +  .280366D+04, .215738D+04, .166019D+04, .127767D+04,
     +  .983383D+03, .756966D+03, .582763D+03, .448728D+03,
     +  .345594D+03, .266234D+03, .205164D+03, .158164D+03,
     +  .121989D+03, .941427D+02, .727039D+02, .559905D+02,
     +  .433268D+02, .335685D+02, .260462D+02, .202447D+02,
     +  .157677D+02, .123191D+02, .964589D+01, .757756D+01,
     +  .597464D+01, .472984D+01, .376066D+01, .300339D+01,
     +  .241035D+01, .194313D+01, .157341D+01, .127925D+01,
     +  .104389D+01, .854504D+00, .701757D+00, .576676D+00,
     +  .474998D+00, .390962D+00, .321949D+00, .264882D+00 /
        DATA (UPDI(I),I=2601,2652) /
     +  .217597D+00, .178367D+00, .145804D+00, .118785D+00,
     +  .963921D-01, .778694D-01, .625887D-01, .500248D-01,
     +  .397359D-01, .313492D-01, .245490D-01, .190905D-01,
     +  .146922D-01, .111982D-01, .844527D-02, .629574D-02,
     +  .463407D-02, .336369D-02, .240428D-02, .168950D-02,
     +  .116469D-02, .785553D-03, .519109D-03, .333046D-03,
     +  .207275D-03, .124562D-03, .718713D-04, .395322D-04,
     +  .205395D-04, .997238D-05, .442855D-05, .177028D-05,
     +  .613953D-06, .175398D-06, .378401D-07, .523723D-08,
     +  .322446D-09, .273778D-11, .000000D+00, .960241D+05,
     +  .742599D+05, .566689D+05, .432509D+05, .330134D+05,
     +  .252017D+05, .192404D+05, .146907D+05, .112180D+05,
     +  .856706D+04, .654329D+04, .499813D+04, .381828D+04 /
        DATA (UPDI(I),I=2653,2704) /
     +  .291728D+04, .222918D+04, .170360D+04, .130214D+04,
     +  .995434D+03, .761112D+03, .582064D+03, .445244D+03,
     +  .340675D+03, .260750D+03, .199650D+03, .152937D+03,
     +  .117212D+03, .898936D+02, .687371D+02, .528132D+02,
     +  .406236D+02, .312891D+02, .241380D+02, .186562D+02,
     +  .144624D+02, .112336D+02, .875281D+01, .684387D+01,
     +  .537211D+01, .423469D+01, .335269D+01, .266731D+01,
     +  .213163D+01, .171116D+01, .137942D+01, .111624D+01,
     +  .906270D+00, .738403D+00, .602122D+00, .492309D+00,
     +  .402331D+00, .329068D+00, .268991D+00, .219616D+00,
     +  .178973D+00, .145495D+00, .117920D+00, .952259D-01,
     +  .765798D-01, .612950D-01, .488033D-01, .386314D-01,
     +  .303853D-01, .237302D-01, .184121D-01, .141444D-01 /
        DATA (UPDI(I),I=2705,2756) /
     +  .107664D-01, .811318D-02, .604676D-02, .445248D-02,
     +  .323512D-02, .231621D-02, .163119D-02, .112781D-02,
     +  .763058D-03, .505750D-03, .325140D-03, .202236D-03,
     +  .120773D-03, .684142D-04, .360508D-04, .169405D-04,
     +  .641680D-05, .112816D-05, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .139991D+06, .107690D+06,
     +  .816785D+05, .619580D+05, .470021D+05, .356588D+05,
     +  .270548D+05, .205282D+05, .155771D+05, .118210D+05,
     +  .897113D+04, .680881D+04, .516805D+04, .392296D+04,
     +  .297809D+04, .226099D+04, .171673D+04, .130362D+04,
     +  .990047D+03, .752005D+03, .571300D+03, .434103D+03,
     +  .329938D+03, .250839D+03, .190776D+03, .145150D+03 /
        DATA (UPDI(I),I=2757,2808) /
     +  .110503D+03, .838578D+02, .639441D+02, .488078D+02,
     +  .372995D+02, .285465D+02, .218856D+02, .168270D+02,
     +  .129615D+02, .100139D+02, .776305D+01, .604112D+01,
     +  .472081D+01, .370510D+01, .292219D+01, .231524D+01,
     +  .184277D+01, .147310D+01, .118231D+01, .952244D+00,
     +  .769878D+00, .623057D+00, .505750D+00, .410425D+00,
     +  .333441D+00, .270816D+00, .219746D+00, .178027D+00,
     +  .143913D+00, .116015D+00, .932115D-01, .745989D-01,
     +  .594380D-01, .471226D-01, .371524D-01, .291151D-01,
     +  .226612D-01, .175293D-01, .134302D-01, .101996D-01,
     +  .767239D-02, .571126D-02, .420311D-02, .305471D-02,
     +  .218978D-02, .154613D-02, .107358D-02, .731106D-03,
     +  .489233D-03, .318983D-03, .202563D-03, .124777D-03 /
        DATA (UPDI(I),I=2809,2860) /
     +  .741665D-04, .422441D-04, .228200D-04, .115375D-04,
     +  .529771D-05, .212115D-05, .657170D-06, .899277D-07,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .198910D+06, .152360D+06, .114983D+06,
     +  .867808D+05, .654950D+05, .494295D+05, .373042D+05,
     +  .281528D+05, .212460D+05, .160333D+05, .120993D+05,
     +  .913039D+04, .688986D+04, .519903D+04, .392311D+04,
     +  .296028D+04, .223377D+04, .168556D+04, .127193D+04,
     +  .959836D+03, .724377D+03, .546724D+03, .412702D+03,
     +  .311586D+03, .235306D+03, .177743D+03, .134331D+03,
     +  .101174D+03, .765672D+02, .579953D+02, .439756D+02,
     +  .333898D+02, .253930D+02, .193650D+02, .147933D+02,
     +  .113337D+02, .871226D+01, .672238D+01, .520861D+01 /
        DATA (UPDI(I),I=2861,2912) /
     +  .405329D+01, .316986D+01, .249049D+01, .196593D+01,
     +  .155883D+01, .124121D+01, .991948D+00, .795978D+00,
     +  .639467D+00, .515424D+00, .415421D+00, .335287D+00,
     +  .270595D+00, .218232D+00, .175768D+00, .141289D+00,
     +  .113285D+00, .905472D-01, .721074D-01, .571804D-01,
     +  .451275D-01, .354264D-01, .276499D-01, .214376D-01,
     +  .165231D-01, .126167D-01, .955250D-02, .716593D-02,
     +  .532168D-02, .390893D-02, .283703D-02, .203230D-02,
     +  .143519D-02, .997859D-03, .681425D-03, .458170D-03,
     +  .301020D-03, .193407D-03, .121258D-03, .740227D-04,
     +  .438937D-04, .252411D-04, .140742D-04, .757950D-05,
     +  .397103D-05, .202352D-05, .100156D-05, .471371D-06,
     +  .200497D-06, .628339D-07, .455235D-08, .000000D+00 /
        DATA (UPDI(I),I=2913,2964) /
     +  .225198D+06, .210336D+06, .158046D+06, .118753D+06,
     +  .892191D+05, .670230D+05, .503432D+05, .378100D+05,
     +  .283936D+05, .213197D+05, .160062D+05, .120154D+05,
     +  .901854D+04, .676826D+04, .507885D+04, .381065D+04,
     +  .285881D+04, .214447D+04, .160850D+04, .120637D+04,
     +  .904734D+03, .678489D+03, .508835D+03, .381614D+03,
     +  .286241D+03, .214723D+03, .161139D+03, .120484D+03,
     +  .905168D+02, .680530D+02, .512127D+02, .385869D+02,
     +  .291168D+02, .220300D+02, .166946D+02, .126872D+02,
     +  .967337D+01, .740299D+01, .568905D+01, .439100D+01,
     +  .340612D+01, .265462D+01, .207888D+01, .163554D+01,
     +  .129237D+01, .102512D+01, .816658D+00, .651437D+00,
     +  .521494D+00, .417523D+00, .334827D+00, .268551D+00 /
        DATA (UPDI(I),I=2965,3016) /
     +  .215289D+00, .172395D+00, .137804D+00, .109894D+00,
     +  .873795D-01, .692347D-01, .546357D-01, .429173D-01,
     +  .335395D-01, .260642D-01, .201238D-01, .154489D-01,
     +  .117516D-01, .886553D-02, .662830D-02, .490725D-02,
     +  .359458D-02, .260270D-02, .186093D-02, .131253D-02,
     +  .912215D-03, .623355D-03, .420030D-03, .277132D-03,
     +  .179332D-03, .113700D-03, .705954D-04, .429172D-04,
     +  .255844D-04, .149976D-04, .863804D-05, .491972D-05,
     +  .275411D-05, .149236D-05, .752741D-06, .329288D-06,
     +  .100972D-06, .789647D-08, .000000D+00, .401936D+06,
     +  .305449D+06, .228384D+06, .170740D+06, .127617D+06,
     +  .953632D+05, .712445D+05, .532129D+05, .397352D+05,
     +  .296636D+05, .221391D+05, .165190D+05, .123223D+05 /
        DATA (UPDI(I),I=3017,3068) /
     +  .918934D+04, .685113D+04, .510647D+04, .380511D+04,
     +  .283464D+04, .211118D+04, .157198D+04, .117025D+04,
     +  .871004D+03, .648193D+03, .482311D+03, .358870D+03,
     +  .266995D+03, .198693D+03, .147280D+03, .109687D+03,
     +  .817360D+02, .609556D+02, .455071D+02, .340188D+02,
     +  .254963D+02, .191367D+02, .144025D+02, .108743D+02,
     +  .824061D+01, .627071D+01, .479259D+01, .368150D+01,
     +  .284158D+01, .220411D+01, .171783D+01, .134493D+01,
     +  .105723D+01, .834878D+00, .660263D+00, .524187D+00,
     +  .416287D+00, .331226D+00, .263649D+00, .209804D+00,
     +  .166804D+00, .132412D+00, .104884D+00, .828503D-01,
     +  .652284D-01, .511552D-01, .399405D-01, .310290D-01,
     +  .239741D-01, .184044D-01, .140496D-01, .106272D-01 /
        DATA (UPDI(I),I=3069,3120) /
     +  .797213D-02, .592637D-02, .436188D-02, .317552D-02,
     +  .228420D-02, .162141D-02, .113420D-02, .780758D-03,
     +  .527249D-03, .350044D-03, .226502D-03, .142778D-03,
     +  .873080D-04, .515100D-04, .291075D-04, .155907D-04,
     +  .781590D-05, .356594D-05, .143515D-05, .471688D-06,
     +  .104899D-06, .346919D-08, .000000D+00, .580748D-09,
     +  .000000D+00, .000000D+00, .567971D+06, .429939D+06,
     +  .319977D+06, .238084D+06, .177093D+06, .131681D+06,
     +  .978797D+05, .727291D+05, .540215D+05, .401109D+05,
     +  .297711D+05, .220881D+05, .163814D+05, .121443D+05,
     +  .899950D+04, .666634D+04, .493611D+04, .365345D+04,
     +  .270306D+04, .199910D+04, .147796D+04, .109227D+04,
     +  .807002D+03, .596054D+03, .440164D+03, .324953D+03 /
        DATA (UPDI(I),I=3121,3172) /
     +  .239929D+03, .176402D+03, .130304D+03, .962911D+02,
     +  .712018D+02, .526983D+02, .390492D+02, .290069D+02,
     +  .215755D+02, .160902D+02, .120370D+02, .903761D+01,
     +  .681361D+01, .515938D+01, .392682D+01, .300326D+01,
     +  .230849D+01, .178316D+01, .138385D+01, .107846D+01,
     +  .844509D+00, .662363D+00, .521646D+00, .411014D+00,
     +  .324534D+00, .256400D+00, .202555D+00, .159900D+00,
     +  .126053D+00, .991728D-01, .778218D-01, .608736D-01,
     +  .474380D-01, .368088D-01, .284226D-01, .218299D-01,
     +  .166603D-01, .126455D-01, .951136D-02, .709592D-02,
     +  .524688D-02, .384189D-02, .278322D-02, .199280D-02,
     +  .140865D-02, .981867D-03, .674073D-03, .454524D-03,
     +  .301864D-03, .195923D-03, .124387D-03, .770882D-04 /
        DATA (UPDI(I),I=3173,3224) /
     +  .465403D-04, .273209D-04, .155764D-04, .863723D-05,
     +  .464763D-05, .244978D-05, .126606D-05, .638519D-06,
     +  .305363D-06, .128790D-06, .380214D-07, .291304D-08,
     +  .000000D+00, .780444D+06, .588577D+06, .436105D+06,
     +  .323030D+06, .239171D+06, .177005D+06, .130939D+06,
     +  .968168D+05, .715534D+05, .528568D+05, .390265D+05,
     +  .288004D+05, .212432D+05, .156608D+05, .115394D+05,
     +  .849805D+04, .625502D+04, .460153D+04, .338339D+04,
     +  .248638D+04, .182630D+04, .134077D+04, .983892D+03,
     +  .721676D+03, .529164D+03, .387829D+03, .284245D+03,
     +  .207390D+03, .152019D+03, .111459D+03, .817614D+02,
     +  .600232D+02, .441101D+02, .324926D+02, .239631D+02,
     +  .177175D+02, .131397D+02, .977960D+01, .730860D+01 /
        DATA (UPDI(I),I=3225,3276) /
     +  .548581D+01, .413890D+01, .313804D+01, .239137D+01,
     +  .183150D+01, .140948D+01, .108938D+01, .846198D+00,
     +  .658408D+00, .514520D+00, .402311D+00, .315303D+00,
     +  .247296D+00, .193973D+00, .152059D+00, .119054D+00,
     +  .930390D-01, .725288D-01, .563672D-01, .436475D-01,
     +  .336563D-01, .258289D-01, .197181D-01, .149586D-01,
     +  .112874D-01, .844070D-02, .626138D-02, .460411D-02,
     +  .335309D-02, .241658D-02, .172187D-02, .121173D-02,
     +  .841374D-03, .575916D-03, .387663D-03, .257482D-03,
     +  .167575D-03, .107094D-03, .671830D-04, .413834D-04,
     +  .250608D-04, .149578D-04, .883731D-05, .516442D-05,
     +  .299790D-05, .170982D-05, .936108D-06, .469797D-06,
     +  .198446D-06, .564650D-07, .462846D-08, .000000D+00 /
        DATA (UPDI(I),I=3277,3328) /
     +  .104631D+07, .786254D+06, .580090D+06, .427816D+06,
     +  .315353D+06, .232332D+06, .171076D+06, .125901D+06,
     +  .926028D+05, .680720D+05, .500101D+05, .367185D+05,
     +  .269430D+05, .197576D+05, .144794D+05, .106044D+05,
     +  .776143D+04, .567688D+04, .414956D+04, .303113D+04,
     +  .221279D+04, .161434D+04, .117708D+04, .857741D+03,
     +  .624739D+03, .454750D+03, .330978D+03, .239751D+03,
     +  .174469D+03, .126977D+03, .924453D+02, .673480D+02,
     +  .491080D+02, .358894D+02, .262564D+02, .192557D+02,
     +  .141638D+02, .104550D+02, .774875D+01, .576799D+01,
     +  .431582D+01, .324522D+01, .245282D+01, .186335D+01,
     +  .142252D+01, .109077D+01, .840716D+00, .649123D+00,
     +  .503469D+00, .390761D+00, .304038D+00, .236769D+00 /
        DATA (UPDI(I),I=3329,3380) /
     +  .184423D+00, .143583D+00, .111662D+00, .866850D-01,
     +  .671355D-01, .518410D-01, .398889D-01, .305662D-01,
     +  .233131D-01, .176895D-01, .133389D-01, .100057D-01,
     +  .743839D-02, .548609D-02, .401132D-02, .290542D-02,
     +  .208298D-02, .147687D-02, .103467D-02, .715677D-03,
     +  .488454D-03, .328248D-03, .218063D-03, .142317D-03,
     +  .915348D-04, .580727D-04, .364055D-04, .226102D-04,
     +  .139563D-04, .858941D-05, .525044D-05, .318076D-05,
     +  .187584D-05, .104597D-05, .525014D-06, .217198D-06,
     +  .596251D-07, .502943D-08, .000000D+00, .137240D+07,
     +  .102772D+07, .755107D+06, .554549D+06, .407021D+06,
     +  .298560D+06, .218867D+06, .160344D+06, .117393D+06,
     +  .858905D+05, .627991D+05, .458838D+05, .335012D+05 /
        DATA (UPDI(I),I=3381,3432) /
     +  .244425D+05, .178203D+05, .129824D+05, .945095D+04,
     +  .687478D+04, .499710D+04, .362943D+04, .263415D+04,
     +  .191033D+04, .138446D+04, .100261D+04, .725645D+03,
     +  .524785D+03, .379442D+03, .272988D+03, .197298D+03,
     +  .142591D+03, .103076D+03, .745502D+02, .539600D+02,
     +  .391416D+02, .284188D+02, .206819D+02, .150950D+02,
     +  .110554D+02, .812949D+01, .600377D+01, .445692D+01,
     +  .332502D+01, .249351D+01, .187958D+01, .142391D+01,
     +  .108354D+01, .828915D+00, .635268D+00, .489154D+00,
     +  .376925D+00, .291209D+00, .225209D+00, .174223D+00,
     +  .134731D+00, .104085D+00, .802761D-01, .617719D-01,
     +  .473963D-01, .362400D-01, .275979D-01, .209202D-01,
     +  .157776D-01, .118257D-01, .881821D-02, .651714D-02 /
        DATA (UPDI(I),I=3433,3484) /
     +  .477896D-02, .347464D-02, .250300D-02, .178516D-02,
     +  .125957D-02, .878595D-03, .605493D-03, .412147D-03,
     +  .276596D-03, .183846D-03, .120355D-03, .779087D-04,
     +  .499569D-04, .318092D-04, .201704D-04, .127669D-04,
     +  .807412D-05, .506505D-05, .313117D-05, .186723D-05,
     +  .104104D-05, .516231D-06, .208047D-06, .551180D-07,
     +  .474515D-08, .000000D+00, .176526D+07, .131747D+07,
     +  .964104D+06, .705145D+06, .515405D+06, .376466D+06,
     +  .274792D+06, .200435D+06, .146094D+06, .106406D+06,
     +  .774408D+05, .563165D+05, .409223D+05, .297118D+05,
     +  .215548D+05, .156239D+05, .113155D+05, .818799D+04,
     +  .591989D+04, .427626D+04, .308640D+04, .222564D+04,
     +  .160367D+04, .115452D+04, .830570D+03, .596977D+03 /
        DATA (UPDI(I),I=3485,3536) /
     +  .428946D+03, .306611D+03, .220161D+03, .158063D+03,
     +  .113491D+03, .815206D+02, .585937D+02, .422027D+02,
     +  .304212D+02, .219781D+02, .159231D+02, .115754D+02,
     +  .844836D+01, .619249D+01, .456255D+01, .337831D+01,
     +  .251455D+01, .188136D+01, .141475D+01, .106870D+01,
     +  .811678D+00, .617598D+00, .472207D+00, .361329D+00,
     +  .277246D+00, .212961D+00, .163649D+00, .125721D+00,
     +  .964929D-01, .739428D-01, .565373D-01, .431076D-01,
     +  .327560D-01, .247914D-01, .186786D-01, .140023D-01,
     +  .104324D-01, .773359D-02, .568231D-02, .414302D-02,
     +  .299554D-02, .214633D-02, .152302D-02, .106957D-02,
     +  .742973D-03, .510293D-03, .346538D-03, .232346D-03,
     +  .154583D-03, .101546D-03, .661615D-04, .428534D-04 /
        DATA (UPDI(I),I=3537,3588) /
     +  .276644D-04, .178431D-04, .115072D-04, .741032D-05,
     +  .471750D-05, .294140D-05, .175531D-05, .970880D-06,
     +  .473291D-06, .185495D-06, .474837D-07, .415876D-08,
     +  .000000D+00, .223097D+07, .165962D+07, .120972D+07,
     +  .881277D+06, .641545D+06, .466682D+06, .339225D+06,
     +  .246386D+06, .178814D+06, .129668D+06, .939513D+05,
     +  .680145D+05, .491953D+05, .355514D+05, .256685D+05,
     +  .185156D+05, .133436D+05, .960707D+04, .691036D+04,
     +  .496573D+04, .356500D+04, .255686D+04, .183217D+04,
     +  .131161D+04, .938174D+03, .670366D+03, .478814D+03,
     +  .340152D+03, .242737D+03, .173175D+03, .123545D+03,
     +  .881643D+02, .629487D+02, .450348D+02, .322408D+02,
     +  .231314D+02, .166414D+02, .120121D+02, .870470D+01 /
        DATA (UPDI(I),I=3589,3640) /
     +  .633473D+01, .463390D+01, .340651D+01, .251738D+01,
     +  .187003D+01, .139626D+01, .104729D+01, .789882D+00,
     +  .596839D+00, .453222D+00, .344448D+00, .262527D+00,
     +  .200322D+00, .152931D+00, .116729D+00, .890195D-01,
     +  .677849D-01, .515048D-01, .390273D-01, .294737D-01,
     +  .221717D-01, .166044D-01, .123734D-01, .916432D-02,
     +  .675416D-02, .493420D-02, .357739D-02, .257249D-02,
     +  .183361D-02, .129474D-02, .905201D-03, .626360D-03,
     +  .428890D-03, .290697D-03, .194812D-03, .129793D-03,
     +  .855829D-04, .561247D-04, .366956D-04, .239752D-04,
     +  .156771D-04, .102494D-04, .667740D-05, .428279D-05,
     +  .267482D-05, .158826D-05, .867996D-06, .414980D-06,
     +  .158089D-06, .391605D-07, .348328D-08, .000000D+00 /
        DATA (UPDI(I),I=3641,3692) /
     +  .277503D+07, .205780D+07, .149424D+07, .108434D+07,
     +  .786268D+06, .569681D+06, .412419D+06, .298320D+06,
     +  .215602D+06, .155683D+06, .112316D+06, .809538D+05,
     +  .582945D+05, .419368D+05, .301398D+05, .216395D+05,
     +  .155209D+05, .111207D+05, .795977D+04, .569120D+04,
     +  .406503D+04, .290037D+04, .206734D+04, .147199D+04,
     +  .104712D+04, .744019D+03, .528402D+03, .373174D+03,
     +  .264731D+03, .187733D+03, .133112D+03, .944014D+02,
     +  .669755D+02, .476087D+02, .338613D+02, .241336D+02,
     +  .172464D+02, .123648D+02, .889933D+01, .643201D+01,
     +  .467275D+01, .341142D+01, .250365D+01, .184705D+01,
     +  .136966D+01, .102033D+01, .764366D+00, .573666D+00,
     +  .432736D+00, .326704D+00, .247379D+00, .187544D+00 /
        DATA (UPDI(I),I=3693,3744) /
     +  .142260D+00, .107897D+00, .817675D-01, .618759D-01,
     +  .467254D-01, .351897D-01, .264148D-01, .197516D-01,
     +  .147042D-01, .108931D-01, .802099D-02, .587778D-02,
     +  .426978D-02, .307867D-02, .220214D-02, .156172D-02,
     +  .109758D-02, .764136D-03, .526872D-03, .359804D-03,
     +  .243506D-03, .163183D-03, .108919D-03, .721077D-04,
     +  .475901D-04, .313843D-04, .207162D-04, .136926D-04,
     +  .903830D-05, .592851D-05, .381205D-05, .237430D-05,
     +  .139796D-05, .753107D-06, .352660D-06, .130590D-06,
     +  .313528D-07, .282923D-08, .000000D+00, .340217D+07,
     +  .251509D+07, .181949D+07, .131539D+07, .950166D+06,
     +  .685764D+06, .494507D+06, .356271D+06, .256443D+06,
     +  .184414D+06, .132489D+06, .950897D+05, .681794D+05 /
        DATA (UPDI(I),I=3745,3796) /
     +  .488339D+05, .349412D+05, .249736D+05, .178303D+05,
     +  .127158D+05, .905845D+04, .644555D+04, .458129D+04,
     +  .325241D+04, .230651D+04, .163380D+04, .115611D+04,
     +  .817045D+03, .577105D+03, .405276D+03, .285883D+03,
     +  .201568D+03, .142086D+03, .100167D+03, .706363D+02,
     +  .499033D+02, .352721D+02, .249803D+02, .177374D+02,
     +  .126346D+02, .903426D+01, .648664D+01, .468135D+01,
     +  .339507D+01, .247512D+01, .181390D+01, .133618D+01,
     +  .988820D+00, .735914D+00, .548694D+00, .411226D+00,
     +  .308462D+00, .232077D+00, .174831D+00, .131786D+00,
     +  .993313D-01, .748125D-01, .562669D-01, .422322D-01,
     +  .316146D-01, .235898D-01, .175350D-01, .129777D-01,
     +  .955853D-02, .699804D-02, .509944D-02, .368395D-02 /
        DATA (UPDI(I),I=3797,3848) /
     +  .264205D-02, .188012D-02, .132689D-02, .928396D-03,
     +  .643813D-03, .442483D-03, .301485D-03, .203820D-03,
     +  .136644D-03, .914030D-04, .607629D-04, .403479D-04,
     +  .268138D-04, .178505D-04, .118948D-04, .790090D-05,
     +  .519877D-05, .333945D-05, .206809D-05, .120473D-05,
     +  .638837D-06, .292801D-06, .105423D-06, .245692D-07,
     +  .224751D-08, .000000D+00, .690363D+05, .100351D+06,
     +  .772021D+05, .593938D+05, .456938D+05, .351545D+05,
     +  .270465D+05, .208090D+05, .160103D+05, .123187D+05,
     +  .947858D+04, .729359D+04, .561259D+04, .431929D+04,
     +  .332427D+04, .255872D+04, .196969D+04, .151648D+04,
     +  .116774D+04, .899396D+03, .692889D+03, .533963D+03,
     +  .411643D+03, .317489D+03, .245006D+03, .189198D+03 /
        DATA (UPDI(I),I=3849,3900) /
     +  .146220D+03, .112705D+03, .873026D+02, .677211D+02,
     +  .526205D+02, .409691D+02, .319734D+02, .250407D+02,
     +  .196636D+02, .155007D+02, .122723D+02, .976325D+01,
     +  .780793D+01, .627837D+01, .507872D+01, .413167D+01,
     +  .338021D+01, .278015D+01, .229772D+01, .190711D+01,
     +  .158960D+01, .132713D+01, .111135D+01, .930662D+00,
     +  .780080D+00, .653526D+00, .546804D+00, .456590D+00,
     +  .380225D+00, .315560D+00, .260840D+00, .214609D+00,
     +  .175648D+00, .142922D+00, .115545D+00, .927536D-01,
     +  .738834D-01, .584219D-01, .457088D-01, .354063D-01,
     +  .271287D-01, .205405D-01, .153512D-01, .113104D-01,
     +  .820355D-02, .584796D-02, .408851D-02, .279594D-02,
     +  .187260D-02, .121745D-02, .767606D-03, .467212D-03 /
        DATA (UPDI(I),I=3901,3952) /
     +  .272969D-03, .151998D-03, .799288D-04, .392679D-04,
     +  .176423D-04, .713316D-05, .250170D-05, .722606D-06,
     +  .157588D-06, .220439D-07, .137145D-08, .117649D-10,
     +  .000000D+00, .159584D+06, .123767D+06, .947565D+05,
     +  .725537D+05, .555579D+05, .425469D+05, .325857D+05,
     +  .249588D+05, .191187D+05, .146464D+05, .112214D+05,
     +  .859818D+04, .658889D+04, .504972D+04, .387059D+04,
     +  .296721D+04, .227503D+04, .174462D+04, .133815D+04,
     +  .102662D+04, .787832D+03, .604777D+03, .464436D+03,
     +  .356821D+03, .274293D+03, .210981D+03, .162415D+03,
     +  .124684D+03, .961923D+02, .743114D+02, .575000D+02,
     +  .445772D+02, .346368D+02, .270048D+02, .211076D+02,
     +  .165595D+02, .130461D+02, .103262D+02, .821495D+01 /
        DATA (UPDI(I),I=3953,4004) /
     +  .657014D+01, .528546D+01, .427561D+01, .347784D+01,
     +  .284373D+01, .233638D+01, .192760D+01, .159710D+01,
     +  .132535D+01, .110323D+01, .918345D+00, .765208D+00,
     +  .637317D+00, .530160D+00, .440167D+00, .364488D+00,
     +  .300827D+00, .247308D+00, .202387D+00, .164775D+00,
     +  .133384D+00, .107289D+00, .857033D-01, .679357D-01,
     +  .534643D-01, .416351D-01, .321039D-01, .244890D-01,
     +  .184614D-01, .137390D-01, .100808D-01, .728222D-02,
     +  .517036D-02, .360093D-02, .245263D-02, .163580D-02,
     +  .105851D-02, .663590D-03, .400821D-03, .231504D-03,
     +  .126525D-03, .643030D-04, .295673D-04, .114676D-04,
     +  .307958D-05, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=4005,4056) /
     +  .202691D+06, .156527D+06, .119252D+06, .908649D+05,
     +  .692421D+05, .527697D+05, .402200D+05, .306578D+05,
     +  .233713D+05, .178183D+05, .135862D+05, .103604D+05,
     +  .790135D+04, .602670D+04, .459743D+04, .350760D+04,
     +  .267655D+04, .204275D+04, .155935D+04, .119060D+04,
     +  .909303D+03, .694672D+03, .530902D+03, .405911D+03,
     +  .310511D+03, .237664D+03, .182053D+03, .139054D+03,
     +  .106740D+03, .820404D+02, .631540D+02, .487055D+02,
     +  .376444D+02, .291926D+02, .226934D+02, .177051D+02,
     +  .138702D+02, .109159D+02, .863392D+01, .686478D+01,
     +  .548982D+01, .441438D+01, .356911D+01, .290069D+01,
     +  .236873D+01, .194241D+01, .159967D+01, .131943D+01,
     +  .109174D+01, .903361D+00, .748293D+00, .619601D+00 /
        DATA (UPDI(I),I=4057,4108) /
     +  .512460D+00, .423058D+00, .348360D+00, .285929D+00,
     +  .233782D+00, .190294D+00, .154111D+00, .124104D+00,
     +  .993147D-01, .789372D-01, .622624D-01, .487623D-01,
     +  .377921D-01, .290044D-01, .220239D-01, .165296D-01,
     +  .122489D-01, .895100D-02, .644139D-02, .455748D-02,
     +  .316477D-02, .215045D-02, .143221D-02, .926689D-03,
     +  .582094D-03, .353412D-03, .206255D-03, .114906D-03,
     +  .605145D-04, .297863D-04, .133634D-04, .532383D-05,
     +  .175808D-05, .400927D-06, .557918D-08, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .260773D+06,
     +  .200544D+06, .152054D+06, .115302D+06, .874380D+05,
     +  .663121D+05, .502937D+05, .381472D+05, .289362D+05,
     +  .219507D+05, .166529D+05, .126346D+05, .958677D+04 /
        DATA (UPDI(I),I=4109,4160) /
     +  .727478D+04, .552092D+04, .419034D+04, .318085D+04,
     +  .241488D+04, .183368D+04, .139262D+04, .105790D+04,
     +  .803846D+03, .611009D+03, .464607D+03, .353458D+03,
     +  .269031D+03, .204931D+03, .155635D+03, .118791D+03,
     +  .907813D+02, .694799D+02, .532730D+02, .409331D+02,
     +  .315557D+02, .243842D+02, .189100D+02, .147246D+02,
     +  .115178D+02, .905437D+01, .715490D+01, .568667D+01,
     +  .454452D+01, .365171D+01, .294958D+01, .239392D+01,
     +  .195108D+01, .159712D+01, .130938D+01, .107699D+01,
     +  .885883D+00, .729540D+00, .600596D+00, .493918D+00,
     +  .405463D+00, .332023D+00, .271031D+00, .220406D+00,
     +  .178452D+00, .143762D+00, .115170D+00, .916956D-01,
     +  .725159D-01, .569125D-01, .443542D-01, .342088D-01 /
        DATA (UPDI(I),I=4161,4212) /
     +  .261289D-01, .197473D-01, .147528D-01, .108833D-01,
     +  .791860D-02, .567480D-02, .399948D-02, .276768D-02,
     +  .187494D-02, .124590D-02, .805196D-03, .506033D-03,
     +  .308183D-03, .181167D-03, .102346D-03, .552947D-04,
     +  .284869D-04, .138845D-04, .644696D-05, .286438D-05,
     +  .123599D-05, .520610D-06, .207122D-06, .632375D-07,
     +  .455622D-08, .000000D+00, .210378D+06, .257883D+06,
     +  .194627D+06, .146897D+06, .110872D+06, .836825D+05,
     +  .631611D+05, .476724D+05, .359823D+05, .271591D+05,
     +  .204997D+05, .154735D+05, .116799D+05, .881667D+04,
     +  .665563D+04, .502453D+04, .379344D+04, .286422D+04,
     +  .216288D+04, .163348D+04, .123389D+04, .932241D+03,
     +  .704543D+03, .532629D+03, .402842D+03, .304809D+03 /
        DATA (UPDI(I),I=4213,4264) /
     +  .230808D+03, .174225D+03, .132179D+03, .100400D+03,
     +  .763724D+02, .581979D+02, .444407D+02, .340475D+02,
     +  .261455D+02, .201490D+02, .155910D+02, .121190D+02,
     +  .946722D+01, .743426D+01, .587182D+01, .466328D+01,
     +  .372393D+01, .298940D+01, .241142D+01, .195341D+01,
     +  .158945D+01, .129530D+01, .105916D+01, .866130D+00,
     +  .709172D+00, .580513D+00, .474725D+00, .387549D+00,
     +  .315618D+00, .256248D+00, .207274D+00, .166934D+00,
     +  .133783D+00, .106624D+00, .844596D-01, .664587D-01,
     +  .518982D-01, .402474D-01, .308894D-01, .234793D-01,
     +  .176600D-01, .131313D-01, .964241D-02, .698409D-02,
     +  .498324D-02, .349751D-02, .241111D-02, .162778D-02,
     +  .107867D-02, .695833D-03, .437130D-03, .266708D-03 /
        DATA (UPDI(I),I=4265,4316) /
     +  .157620D-03, .900071D-04, .495837D-04, .264002D-04,
     +  .135761D-04, .683780D-05, .339783D-05, .166953D-05,
     +  .789450D-06, .334159D-06, .101266D-06, .789939D-08,
     +  .000000D+00, .461970D+06, .352211D+06, .264360D+06,
     +  .198419D+06, .148912D+06, .111748D+06, .838508D+05,
     +  .629125D+05, .471986D+05, .354066D+05, .265586D+05,
     +  .199201D+05, .149399D+05, .112040D+05, .840197D+04,
     +  .630038D+04, .472439D+04, .354257D+04, .265647D+04,
     +  .199208D+04, .149401D+04, .112059D+04, .840690D+03,
     +  .630846D+03, .473554D+03, .355595D+03, .267209D+03,
     +  .200127D+03, .150652D+03, .113537D+03, .856859D+02,
     +  .647785D+02, .490722D+02, .372965D+02, .284113D+02,
     +  .217199D+02, .166721D+02, .128559D+02, .996296D+01 /
        DATA (UPDI(I),I=4317,4368) /
     +  .776156D+01, .608210D+01, .479251D+01, .379744D+01,
     +  .302496D+01, .242152D+01, .194677D+01, .157227D+01,
     +  .127180D+01, .103238D+01, .838126D+00, .681360D+00,
     +  .553827D+00, .449759D+00, .364651D+00, .294960D+00,
     +  .237874D+00, .191139D+00, .152932D+00, .121768D+00,
     +  .964257D-01, .758958D-01, .593439D-01, .460499D-01,
     +  .354885D-01, .270655D-01, .204428D-01, .152783D-01,
     +  .112871D-01, .823374D-02, .592343D-02, .419662D-02,
     +  .292342D-02, .199924D-02, .133759D-02, .877321D-03,
     +  .559010D-03, .345806D-03, .206769D-03, .118841D-03,
     +  .651963D-04, .337981D-04, .163752D-04, .723058D-05,
     +  .284139D-05, .937523D-06, .231339D-06, .292941D-07,
     +  .000000D+00, .783153D-09, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=4369,4420) /
     +  .627013D+06, .475928D+06, .355359D+06, .265306D+06,
     +  .198036D+06, .147794D+06, .110278D+06, .822687D+05,
     +  .613618D+05, .457592D+05, .341177D+05, .254331D+05,
     +  .189559D+05, .141258D+05, .105248D+05, .784062D+04,
     +  .584027D+04, .434974D+04, .323939D+04, .241230D+04,
     +  .179640D+04, .133776D+04, .996335D+03, .742144D+03,
     +  .552956D+03, .412085D+03, .307305D+03, .228365D+03,
     +  .170577D+03, .127550D+03, .955048D+02, .716310D+02,
     +  .538322D+02, .405891D+02, .306729D+02, .232619D+02,
     +  .177137D+02, .135507D+02, .104186D+02, .805289D+01,
     +  .626131D+01, .489565D+01, .384950D+01, .304321D+01,
     +  .241786D+01, .192939D+01, .154683D+01, .124209D+01,
     +  .100104D+01, .806888D+00, .651356D+00, .525759D+00 /
        DATA (UPDI(I),I=4421,4472) /
     +  .424030D+00, .341452D+00, .274334D+00, .219764D+00,
     +  .175419D+00, .139435D+00, .110299D+00, .867798D-01,
     +  .678662D-01, .527281D-01, .406560D-01, .311342D-01,
     +  .235947D-01, .177091D-01, .131524D-01, .965607D-02,
     +  .700043D-02, .500543D-02, .352501D-02, .244135D-02,
     +  .166047D-02, .110534D-02, .721909D-03, .458568D-03,
     +  .283342D-03, .169753D-03, .982614D-04, .547583D-04,
     +  .292666D-04, .149979D-04, .733642D-05, .346746D-05,
     +  .159818D-05, .727214D-06, .323172D-06, .131079D-06,
     +  .381572D-07, .291450D-08, .000000D+00, .838509D+06,
     +  .633805D+06, .470902D+06, .349801D+06, .259769D+06,
     +  .192853D+06, .143132D+06, .106199D+06, .787726D+05,
     +  .584119D+05, .433014D+05, .320903D+05, .237752D+05 /
        DATA (UPDI(I),I=4473,4524) /
     +  .176097D+05, .130396D+05, .965302D+04, .714432D+04,
     +  .528637D+04, .391090D+04, .289279D+04, .213950D+04,
     +  .158222D+04, .117011D+04, .865354D+03, .640088D+03,
     +  .473512D+03, .350493D+03, .258477D+03, .191607D+03,
     +  .142180D+03, .105639D+03, .786178D+02, .586223D+02,
     +  .438562D+02, .328823D+02, .247423D+02, .186938D+02,
     +  .141892D+02, .108252D+02, .830275D+01, .640638D+01,
     +  .497120D+01, .387961D+01, .304425D+01, .240092D+01,
     +  .190192D+01, .151387D+01, .120692D+01, .965846D+00,
     +  .773066D+00, .619738D+00, .496814D+00, .397969D+00,
     +  .318313D+00, .254041D+00, .202164D+00, .160313D+00,
     +  .126598D+00, .994978D-01, .777789D-01, .604387D-01,
     +  .466593D-01, .357480D-01, .272029D-01, .204850D-01 /
        DATA (UPDI(I),I=4525,4576) /
     +  .152781D-01, .112755D-01, .822625D-02, .592677D-02,
     +  .421172D-02, .294820D-02, .203002D-02, .137319D-02,
     +  .909553D-03, .591595D-03, .374723D-03, .231357D-03,
     +  .138955D-03, .810546D-04, .458898D-04, .252363D-04,
     +  .135571D-04, .713421D-05, .373323D-05, .194623D-05,
     +  .998224D-06, .482057D-06, .199994D-06, .565559D-07,
     +  .462949D-08, .000000D+00, .110341D+07, .830735D+06,
     +  .614312D+06, .454145D+06, .335611D+06, .247918D+06,
     +  .183068D+06, .135128D+06, .997029D+05, .735355D+05,
     +  .542146D+05, .399541D+05, .294334D+05, .216745D+05,
     +  .159550D+05, .117403D+05, .863610D+04, .635046D+04,
     +  .466839D+04, .343085D+04, .252084D+04, .185181D+04,
     +  .136022D+04, .999038D+03, .733817D+03, .538999D+03 /
        DATA (UPDI(I),I=4577,4628) /
     +  .396111D+03, .289970D+03, .213377D+03, .157162D+03,
     +  .115899D+03, .856049D+02, .633493D+02, .470335D+02,
     +  .349962D+02, .261324D+02, .195940D+02, .147599D+02,
     +  .111757D+02, .850741D+01, .651554D+01, .501863D+01,
     +  .388800D+01, .302874D+01, .237155D+01, .186527D+01,
     +  .147427D+01, .116711D+01, .927545D+00, .737301D+00,
     +  .587051D+00, .467440D+00, .371938D+00, .295522D+00,
     +  .234300D+00, .185237D+00, .145937D+00, .114503D+00,
     +  .894150D-01, .694512D-01, .536252D-01, .411375D-01,
     +  .313179D-01, .236819D-01, .177209D-01, .131333D-01,
     +  .963172D-02, .698312D-02, .499996D-02, .353139D-02,
     +  .245722D-02, .168227D-02, .113190D-02, .746135D-03,
     +  .483438D-03, .305462D-03, .188542D-03, .113588D-03 /
        DATA (UPDI(I),I=4629,4680) /
     +  .667937D-04, .384019D-04, .216637D-04, .120873D-04,
     +  .669187D-05, .371154D-05, .204396D-05, .108944D-05,
     +  .533449D-06, .218245D-06, .596860D-07, .503015D-08,
     +  .000000D+00, .142856D+07, .107147D+07, .788763D+06,
     +  .580443D+06, .426944D+06, .313889D+06, .230661D+06,
     +  .169419D+06, .124376D+06, .912639D+05, .669343D+05,
     +  .490662D+05, .359505D+05, .263277D+05, .192715D+05,
     +  .140997D+05, .103112D+05, .753727D+04, .550739D+04,
     +  .402256D+04, .293712D+04, .214388D+04, .156456D+04,
     +  .114156D+04, .832900D+03, .607617D+03, .443470D+03,
     +  .322345D+03, .235530D+03, .172243D+03, .126107D+03,
     +  .924698D+02, .679298D+02, .500654D+02, .369781D+02,
     +  .274091D+02, .204002D+02, .152545D+02, .114658D+02 /
        DATA (UPDI(I),I=4681,4732) /
     +  .866487D+01, .658828D+01, .503831D+01, .387550D+01,
     +  .299771D+01, .233083D+01, .182050D+01, .142901D+01,
     +  .112352D+01, .886862D+00, .700204D+00, .553792D+00,
     +  .438036D+00, .346249D+00, .273314D+00, .215287D+00,
     +  .169107D+00, .132375D+00, .103199D+00, .800759D-01,
     +  .618039D-01, .474199D-01, .361488D-01, .273469D-01,
     +  .205499D-01, .152807D-01, .112539D-01, .820189D-02,
     +  .590959D-02, .420534D-02, .295224D-02, .204219D-02,
     +  .139033D-02, .930677D-03, .610720D-03, .394326D-03,
     +  .248666D-03, .153536D-03, .928396D-04, .550565D-04,
     +  .321278D-04, .185392D-04, .106635D-04, .611869D-05,
     +  .351391D-05, .198669D-05, .107144D-05, .522032D-06,
     +  .208755D-06, .551587D-07, .474565D-08, .000000D+00 /
        DATA (UPDI(I),I=4733,4784) /
     +  .182049D+07, .136050D+07, .997204D+06, .730611D+06,
     +  .534998D+06, .391541D+06, .286391D+06, .209361D+06,
     +  .152961D+06, .111690D+06, .815078D+05, .594464D+05,
     +  .433312D+05, .315660D+05, .229821D+05, .167228D+05,
     +  .121616D+05, .883957D+04, .642177D+04, .466291D+04,
     +  .338435D+04, .245532D+04, .178078D+04, .129115D+04,
     +  .936024D+03, .678405D+03, .491880D+03, .355114D+03,
     +  .257722D+03, .187184D+03, .136100D+03, .991028D+02,
     +  .722916D+02, .529052D+02, .387988D+02, .285546D+02,
     +  .211021D+02, .156676D+02, .116933D+02, .877461D+01,
     +  .662512D+01, .503129D+01, .384338D+01, .295247D+01,
     +  .228002D+01, .176873D+01, .137907D+01, .107697D+01,
     +  .844489D+00, .662334D+00, .520406D+00, .408946D+00 /
        DATA (UPDI(I),I=4785,4836) /
     +  .321161D+00, .251878D+00, .197132D+00, .153860D+00,
     +  .119676D+00, .927102D-01, .714846D-01, .548273D-01,
     +  .418043D-01, .316695D-01, .238087D-01, .177802D-01,
     +  .131388D-01, .961639D-02, .696518D-02, .498777D-02,
     +  .352789D-02, .246199D-02, .169333D-02, .114662D-02,
     +  .763797D-03, .499118D-03, .321290D-03, .202322D-03,
     +  .125041D-03, .759350D-04, .454260D-04, .268860D-04,
     +  .158251D-04, .932495D-05, .548685D-05, .321712D-05,
     +  .184011D-05, .992125D-06, .477279D-06, .185974D-06,
     +  .475110D-07, .415911D-08, .000000D+00, .228529D+07,
     +  .170193D+07, .124228D+07, .906322D+06, .660815D+06,
     +  .481508D+06, .350633D+06, .255164D+06, .185569D+06,
     +  .134866D+06, .979512D+05, .710928D+05, .515646D+05 /
        DATA (UPDI(I),I=4837,4888) /
     +  .373751D+05, .270723D+05, .195964D+05, .141758D+05,
     +  .102479D+05, .740395D+04, .534598D+04, .385802D+04,
     +  .278272D+04, .200632D+04, .144594D+04, .104185D+04,
     +  .750406D+03, .540663D+03, .387808D+03, .279630D+03,
     +  .201768D+03, .145733D+03, .105409D+03, .763740D+02,
     +  .555150D+02, .404357D+02, .295563D+02, .216931D+02,
     +  .159965D+02, .118574D+02, .883737D+01, .662741D+01,
     +  .499913D+01, .379323D+01, .289450D+01, .222043D+01,
     +  .171111D+01, .132540D+01, .102826D+01, .801061D+00,
     +  .624191D+00, .487277D+00, .380458D+00, .296883D+00,
     +  .231359D+00, .179929D+00, .139549D+00, .107865D+00,
     +  .830387D-01, .636289D-01, .484994D-01, .367507D-01,
     +  .276693D-01, .206728D-01, .153434D-01, .112683D-01 /
        DATA (UPDI(I),I=4889,4940) /
     +  .819672D-02, .590069D-02, .419998D-02, .295304D-02,
     +  .204891D-02, .140142D-02, .944066D-03, .625987D-03,
     +  .407511D-03, .261650D-03, .164627D-03, .101906D-03,
     +  .621834D-04, .375286D-04, .225075D-04, .134757D-04,
     +  .809153D-05, .484396D-05, .287325D-05, .164842D-05,
     +  .882834D-06, .417721D-06, .158412D-06, .391788D-07,
     +  .348352D-08, .000000D+00, .282845D+07, .209942D+07,
     +  .152626D+07, .110897D+07, .805220D+06, .584263D+06,
     +  .423639D+06, .306953D+06, .222245D+06, .160795D+06,
     +  .116250D+06, .839814D+05, .606246D+05, .437304D+05,
     +  .315205D+05, .227024D+05, .163393D+05, .117509D+05,
     +  .844520D+04, .606515D+04, .435318D+04, .312245D+04,
     +  .223857D+04, .160406D+04, .114903D+04, .822684D+03 /
        DATA (UPDI(I),I=4941,4992) /
     +  .589175D+03, .419987D+03, .300960D+03, .215799D+03,
     +  .154880D+03, .111308D+03, .801275D+02, .578658D+02,
     +  .418724D+02, .304057D+02, .221699D+02, .162406D+02,
     +  .119593D+02, .885484D+01, .659710D+01, .494381D+01,
     +  .372685D+01, .282541D+01, .215342D+01, .164876D+01,
     +  .126893D+01, .978117D+00, .757150D+00, .586211D+00,
     +  .454730D+00, .352807D+00, .273575D+00, .211862D+00,
     +  .163738D+00, .126203D+00, .969446D-01, .741711D-01,
     +  .564841D-01, .427891D-01, .322252D-01, .241138D-01,
     +  .179061D-01, .132092D-01, .964185D-02, .697110D-02,
     +  .498824D-02, .352946D-02, .246718D-02, .170219D-02,
     +  .115806D-02, .776302D-03, .512554D-03, .332537D-03,
     +  .213071D-03, .134024D-03, .831400D-04, .509966D-04 /
        DATA (UPDI(I),I=4993,5044) /
     +  .310457D-04, .188457D-04, .114461D-04, .697183D-05,
     +  .422097D-05, .251699D-05, .144060D-05, .763463D-06,
     +  .354542D-06, .130809D-06, .313650D-07, .282940D-08,
     +  .000000D+00, .345471D+07, .255601D+07, .185098D+07,
     +  .133962D+07, .968805D+06, .700105D+06, .505541D+06,
     +  .364761D+06, .262977D+06, .189441D+06, .136358D+06,
     +  .980674D+05, .704712D+05, .505979D+05, .362990D+05,
     +  .260190D+05, .186352D+05, .133356D+05, .953583D+04,
     +  .681329D+04, .486463D+04, .347078D+04, .247486D+04,
     +  .176363D+04, .125627D+04, .894347D+03, .636810D+03,
     +  .451253D+03, .321450D+03, .229108D+03, .163435D+03,
     +  .116736D+03, .835143D+02, .599363D+02, .430985D+02,
     +  .310987D+02, .225319D+02, .164012D+02, .120012D+02 /
        DATA (UPDI(I),I=5045,5096) /
     +  .882949D+01, .653661D+01, .486751D+01, .364616D+01,
     +  .274680D+01, .208032D+01, .158276D+01, .121051D+01,
     +  .927201D+00, .713256D+00, .548766D+00, .423032D+00,
     +  .326175D+00, .251358D+00, .193454D+00, .148591D+00,
     +  .113825D+00, .869013D-01, .660811D-01, .500168D-01,
     +  .376597D-01, .281903D-01, .209669D-01, .154751D-01,
     +  .113474D-01, .823297D-02, .591693D-02, .420889D-02,
     +  .296071D-02, .205789D-02, .141208D-02, .955772D-03,
     +  .637738D-03, .419416D-03, .271304D-03, .173562D-03,
     +  .109200D-03, .679183D-04, .418863D-04, .257134D-04,
     +  .157779D-04, .969581D-05, .596769D-05, .363712D-05,
     +  .217059D-05, .123492D-05, .646061D-06, .294094D-06,
     +  .105571D-06, .245774D-07, .224763D-08, .000000D+00 /
        DATA (UPDI(I),I=5097,5148) /
     +  .689519D+05, .100320D+06, .771748D+05, .593696D+05,
     +  .456725D+05, .351355D+05, .270297D+05, .207941D+05,
     +  .159972D+05, .123070D+05, .946826D+04, .728445D+04,
     +  .560449D+04, .431212D+04, .331792D+04, .255308D+04,
     +  .196470D+04, .151205D+04, .116381D+04, .895906D+03,
     +  .689790D+03, .531207D+03, .409191D+03, .315304D+03,
     +  .243056D+03, .187455D+03, .144659D+03, .111306D+03,
     +  .860423D+02, .665821D+02, .515871D+02, .400274D+02,
     +  .311110D+02, .242466D+02, .189284D+02, .148162D+02,
     +  .116315D+02, .916024D+01, .723799D+01, .573781D+01,
     +  .456480D+01, .364255D+01, .291479D+01, .233797D+01,
     +  .187876D+01, .151166D+01, .121804D+01, .980079D+00,
     +  .789061D+00, .633525D+00, .507997D+00, .406235D+00 /
        DATA (UPDI(I),I=5149,5200) /
     +  .323774D+00, .257032D+00, .203117D+00, .159682D+00,
     +  .124812D+00, .969366D-01, .747618D-01, .572211D-01,
     +  .434332D-01, .326706D-01, .243340D-01, .179568D-01,
     +  .130728D-01, .939625D-02, .665972D-02, .464795D-02,
     +  .318915D-02, .214728D-02, .141566D-02, .911529D-03,
     +  .571275D-03, .346958D-03, .204287D-03, .115027D-03,
     +  .616741D-04, .311453D-04, .145787D-04, .616563D-05,
     +  .224689D-05, .630335D-06, .757438D-07, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .159548D+06,
     +  .123734D+06, .947278D+05, .725282D+05, .555353D+05,
     +  .425270D+05, .325680D+05, .249431D+05, .191048D+05,
     +  .146342D+05, .112105D+05, .858854D+04, .658035D+04 /
        DATA (UPDI(I),I=5201,5252) /
     +  .504215D+04, .386389D+04, .296126D+04, .226975D+04,
     +  .173994D+04, .133399D+04, .102292D+04, .784548D+03,
     +  .601856D+03, .461834D+03, .354501D+03, .272221D+03,
     +  .209127D+03, .160753D+03, .123192D+03, .948482D+02,
     +  .730960D+02, .563969D+02, .435719D+02, .337165D+02,
     +  .261580D+02, .203247D+02, .158321D+02, .123668D+02,
     +  .968912D+01, .761529D+01, .600408D+01, .475015D+01,
     +  .376909D+01, .299889D+01, .239168D+01, .191099D+01,
     +  .152889D+01, .122511D+01, .980375D+00, .785135D+00,
     +  .627141D+00, .500414D+00, .398304D+00, .316056D+00,
     +  .249875D+00, .196714D+00, .154120D+00, .120101D+00,
     +  .930389D-01, .716090D-01, .547285D-01, .415091D-01,
     +  .312256D-01, .232795D-01, .172131D-01, .125730D-01 /
        DATA (UPDI(I),I=5253,5304) /
     +  .908107D-02, .647979D-02, .456318D-02, .316793D-02,
     +  .216535D-02, .145517D-02, .959683D-03, .619920D-03,
     +  .390779D-03, .240685D-03, .143062D-03, .816287D-04,
     +  .440329D-04, .217495D-04, .911173D-05, .230842D-05,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .202653D+06, .156493D+06,
     +  .119221D+06, .908381D+05, .692184D+05, .527487D+05,
     +  .402014D+05, .306413D+05, .233567D+05, .178054D+05,
     +  .135747D+05, .103502D+05, .789235D+04, .601871D+04,
     +  .459035D+04, .350132D+04, .267098D+04, .203780D+04,
     +  .155495D+04, .118669D+04, .905827D+03, .691578D+03,
     +  .528144D+03, .403450D+03, .308312D+03, .235695D+03 /
        DATA (UPDI(I),I=5305,5356) /
     +  .180286D+03, .137468D+03, .105309D+03, .807470D+02,
     +  .619800D+02, .476360D+02, .366659D+02, .282932D+02,
     +  .218632D+02, .169354D+02, .131535D+02, .102461D+02,
     +  .800597D+01, .627479D+01, .493478D+01, .389218D+01,
     +  .307832D+01, .244041D+01, .193846D+01, .154183D+01,
     +  .122847D+01, .977551D+00, .778644D+00, .618684D+00,
     +  .491174D+00, .389060D+00, .307300D+00, .241895D+00,
     +  .189656D+00, .148028D+00, .114956D+00, .887780D-01,
     +  .681461D-01, .519659D-01, .393466D-01, .295672D-01,
     +  .220334D-01, .162978D-01, .119202D-01, .863091D-02,
     +  .618235D-02, .437788D-02, .306249D-02, .211473D-02,
     +  .144035D-02, .966842D-03, .639119D-03, .415286D-03,
     +  .266194D-03, .167028D-03, .102743D-03, .618008D-04 /
        DATA (UPDI(I),I=5357,5408) /
     +  .362065D-04, .205286D-04, .111388D-04, .568892D-05,
     +  .262998D-05, .103034D-05, .271756D-06, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .260732D+06, .200509D+06, .152022D+06,
     +  .115273D+06, .874131D+05, .662900D+05, .502741D+05,
     +  .381299D+05, .289208D+05, .219371D+05, .166408D+05,
     +  .126239D+05, .957729D+04, .726636D+04, .551346D+04,
     +  .418371D+04, .317497D+04, .240966D+04, .182904D+04,
     +  .138849D+04, .105423D+04, .800571D+03, .608089D+03,
     +  .461999D+03, .351127D+03, .266942D+03, .203056D+03,
     +  .153952D+03, .117273D+03, .894083D+02, .682340D+02,
     +  .521385D+02, .398961D+02, .306039D+02, .235072D+02,
     +  .180988D+02, .139716D+02, .108165D+02, .839958D+01 /
        DATA (UPDI(I),I=5409,5460) /
     +  .654254D+01, .511355D+01, .400830D+01, .315071D+01,
     +  .248264D+01, .196021D+01, .154993D+01, .122783D+01,
     +  .971513D+00, .769611D+00, .608253D+00, .480421D+00,
     +  .378670D+00, .297684D+00, .233274D+00, .182118D+00,
     +  .141576D+00, .109536D+00, .843017D-01, .645090D-01,
     +  .490571D-01, .370571D-01, .277947D-01, .206835D-01,
     +  .152867D-01, .111789D-01, .809923D-02, .581047D-02,
     +  .412537D-02, .289720D-02, .201156D-02, .138016D-02,
     +  .935424D-03, .626099D-03, .413363D-03, .270361D-03,
     +  .174092D-03, .110705D-03, .695154D-04, .431017D-04,
     +  .263626D-04, .159000D-04, .944362D-05, .548993D-05,
     +  .312641D-05, .172880D-05, .917276D-06, .453239D-06,
     +  .198001D-06, .626786D-07, .455082D-08, .000000D+00 /
        DATA (UPDI(I),I=5461,5512) /
     +  .210276D+06, .257845D+06, .194594D+06, .146867D+06,
     +  .110846D+06, .836593D+05, .631405D+05, .476542D+05,
     +  .359661D+05, .271447D+05, .204870D+05, .154622D+05,
     +  .116699D+05, .880781D+04, .664777D+04, .501754D+04,
     +  .378724D+04, .285871D+04, .215797D+04, .162911D+04,
     +  .123001D+04, .928780D+03, .701455D+03, .529871D+03,
     +  .400375D+03, .302598D+03, .228823D+03, .172442D+03,
     +  .130571D+03, .989459D+02, .750536D+02, .569980D+02,
     +  .433452D+02, .330434D+02, .252223D+02, .192972D+02,
     +  .148027D+02, .113874D+02, .878704D+01, .680110D+01,
     +  .528222D+01, .411466D+01, .321431D+01, .251728D+01,
     +  .197561D+01, .155287D+01, .122309D+01, .962276D+00,
     +  .758125D+00, .595974D+00, .468298D+00, .367280D+00 /
        DATA (UPDI(I),I=5513,5564) /
     +  .287349D+00, .224143D+00, .174223D+00, .134875D+00,
     +  .103941D+00, .797008D-01, .607795D-01, .460761D-01,
     +  .347074D-01, .259685D-01, .192838D-01, .142284D-01,
     +  .103926D-01, .752476D-02, .539837D-02, .383565D-02,
     +  .269808D-02, .187823D-02, .129361D-02, .881377D-03,
     +  .594046D-03, .395743D-03, .261799D-03, .171035D-03,
     +  .110755D-03, .711447D-04, .453791D-04, .287459D-04,
     +  .181037D-04, .113255D-04, .699838D-05, .426442D-05,
     +  .252822D-05, .142861D-05, .739216D-06, .327452D-06,
     +  .100859D-06, .789532D-08, .000000D+00, .461925D+06,
     +  .352171D+06, .264325D+06, .198387D+06, .148884D+06,
     +  .111723D+06, .838288D+05, .628931D+05, .471814D+05,
     +  .353913D+05, .265450D+05, .199080D+05, .149292D+05 /
        DATA (UPDI(I),I=5565,5616) /
     +  .111946D+05, .839356D+04, .629292D+04, .471776D+04,
     +  .353667D+04, .265122D+04, .198741D+04, .148985D+04,
     +  .111689D+04, .837381D+03, .627889D+03, .470908D+03,
     +  .353223D+03, .265080D+03, .198215D+03, .148928D+03,
     +  .111979D+03, .842737D+02, .634952D+02, .479025D+02,
     +  .362269D+02, .274306D+02, .208181D+02, .158408D+02,
     +  .120880D+02, .925277D+01, .710431D+01, .547394D+01,
     +  .423045D+01, .327906D+01, .254830D+01, .198489D+01,
     +  .154861D+01, .121094D+01, .945955D+00, .740155D+00,
     +  .577946D+00, .451191D+00, .351645D+00, .273452D+00,
     +  .212059D+00, .163907D+00, .126208D+00, .967633D-01,
     +  .738356D-01, .560469D-01, .423035D-01, .317359D-01,
     +  .236555D-01, .175039D-01, .128730D-01, .937404D-02 /
        DATA (UPDI(I),I=5617,5668) /
     +  .676803D-02, .484240D-02, .343143D-02, .240691D-02,
     +  .167007D-02, .114550D-02, .776081D-03, .518985D-03,
     +  .341733D-03, .222265D-03, .141619D-03, .884278D-04,
     +  .539047D-04, .319115D-04, .182055D-04, .989739D-05,
     +  .505229D-05, .234658D-05, .953931D-06, .308029D-06,
     +  .593650D-07, .000000D+00, .000000D+00, .502828D-09,
     +  .000000D+00, .000000D+00, .626965D+06, .475885D+06,
     +  .355321D+06, .265272D+06, .198006D+06, .147768D+06,
     +  .110254D+06, .822480D+05, .613435D+05, .457430D+05,
     +  .341032D+05, .254203D+05, .189445D+05, .141157D+05,
     +  .105159D+05, .783265D+04, .583319D+04, .434344D+04,
     +  .323378D+04, .240731D+04, .179195D+04, .133379D+04,
     +  .992792D+03, .738978D+03, .550123D+03, .409546D+03 /
        DATA (UPDI(I),I=5669,5720) /
     +  .305026D+03, .226318D+03, .168733D+03, .125885D+03,
     +  .939974D+02, .702634D+02, .525881D+02, .394544D+02,
     +  .296356D+02, .223114D+02, .168411D+02, .127486D+02,
     +  .968066D+01, .737389D+01, .563698D+01, .432250D+01,
     +  .332460D+01, .256406D+01, .198225D+01, .153518D+01,
     +  .119183D+01, .924443D+00, .718364D+00, .557156D+00,
     +  .432120D+00, .334642D+00, .258624D+00, .199359D+00,
     +  .153198D+00, .117300D+00, .894464D-01, .678966D-01,
     +  .512807D-01, .385208D-01, .287667D-01, .213501D-01,
     +  .157336D-01, .115274D-01, .836486D-02, .602043D-02,
     +  .429569D-02, .303708D-02, .212664D-02, .147406D-02,
     +  .101088D-02, .685535D-03, .459565D-03, .303972D-03,
     +  .199159D-03, .128360D-03, .815553D-04, .510313D-04 /
        DATA (UPDI(I),I=5721,5772) /
     +  .314131D-04, .189986D-04, .112808D-04, .657766D-05,
     +  .375090D-05, .210089D-05, .114922D-05, .606546D-06,
     +  .298794D-06, .127927D-06, .379691D-07, .291247D-08,
     +  .000000D+00, .838457D+06, .633759D+06, .470862D+06,
     +  .349766D+06, .259737D+06, .192825D+06, .143107D+06,
     +  .106177D+06, .787531D+05, .583946D+05, .432860D+05,
     +  .320767D+05, .237631D+05, .175989D+05, .130300D+05,
     +  .964451D+04, .713675D+04, .527964D+04, .390491D+04,
     +  .288745D+04, .213475D+04, .157797D+04, .116632D+04,
     +  .861969D+03, .637059D+03, .470797D+03, .348058D+03,
     +  .256291D+03, .189639D+03, .140405D+03, .104035D+03,
     +  .771652D+02, .573040D+02, .426569D+02, .317894D+02,
     +  .237447D+02, .177819D+02, .133550D+02, .100617D+02 /
        DATA (UPDI(I),I=5773,5824) /
     +  .760441D+01, .576826D+01, .438926D+01, .335036D+01,
     +  .256461D+01, .196807D+01, .151314D+01, .116640D+01,
     +  .898376D+00, .693357D+00, .534160D+00, .411585D+00,
     +  .316712D+00, .243250D+00, .186375D+00, .142377D+00,
     +  .108392D+00, .821943D-01, .620554D-01, .466244D-01,
     +  .348466D-01, .258966D-01, .191306D-01, .140348D-01,
     +  .102390D-01, .740007D-02, .530607D-02, .377300D-02,
     +  .265940D-02, .185738D-02, .128487D-02, .880062D-03,
     +  .596712D-03, .400502D-03, .265722D-03, .175083D-03,
     +  .113893D-03, .733964D-04, .468906D-04, .297264D-04,
     +  .187179D-04, .117220D-04, .730485D-05, .450599D-05,
     +  .274535D-05, .162654D-05, .913696D-06, .465272D-06,
     +  .197862D-06, .564300D-07, .462806D-08, .000000D+00 /
        DATA (UPDI(I),I=5825,5876) /
     +  .110336D+07, .830686D+06, .614269D+06, .454107D+06,
     +  .335577D+06, .247888D+06, .183042D+06, .135104D+06,
     +  .996820D+05, .735170D+05, .541981D+05, .399395D+05,
     +  .294204D+05, .216629D+05, .159447D+05, .117312D+05,
     +  .862802D+04, .634327D+04, .466199D+04, .342515D+04,
     +  .251576D+04, .184728D+04, .135617D+04, .995424D+03,
     +  .730584D+03, .536103D+03, .393514D+03, .287642D+03,
     +  .211284D+03, .155276D+03, .114197D+03, .840671D+02,
     +  .619570D+02, .457706D+02, .338492D+02, .250895D+02,
     +  .186450D+02, .138958D+02, .103892D+02, .779217D+01,
     +  .586603D+01, .443020D+01, .335651D+01, .255047D+01,
     +  .194307D+01, .148325D+01, .113538D+01, .868439D+00,
     +  .665740D+00, .509478D+00, .390024D+00, .298218D+00 /
        DATA (UPDI(I),I=5877,5928) /
     +  .227625D+00, .173347D+00, .131641D+00, .996384D-01,
     +  .751301D-01, .564100D-01, .421557D-01, .313426D-01,
     +  .231749D-01, .170363D-01, .124390D-01, .903367D-02,
     +  .650043D-02, .464179D-02, .328800D-02, .230948D-02,
     +  .160808D-02, .110966D-02, .758757D-03, .514105D-03,
     +  .345294D-03, .229667D-03, .152073D-03, .997357D-04,
     +  .650667D-04, .422940D-04, .274358D-04, .177828D-04,
     +  .115221D-04, .745061D-05, .476757D-05, .299815D-05,
     +  .181654D-05, .103027D-05, .521899D-06, .216803D-06,
     +  .596017D-07, .502915D-08, .000000D+00, .142850D+07,
     +  .107142D+07, .788718D+06, .580403D+06, .426908D+06,
     +  .313857D+06, .230633D+06, .169393D+06, .124354D+06,
     +  .912442D+05, .669168D+05, .490506D+05, .359367D+05 /
        DATA (UPDI(I),I=5929,5980) /
     +  .263154D+05, .192606D+05, .140900D+05, .103026D+05,
     +  .752960D+04, .550056D+04, .401648D+04, .293170D+04,
     +  .213905D+04, .156025D+04, .113771D+04, .829455D+03,
     +  .604533D+03, .440707D+03, .319871D+03, .233308D+03,
     +  .170245D+03, .124307D+03, .908469D+02, .664645D+02,
     +  .487403D+02, .357789D+02, .263230D+02, .194162D+02,
     +  .143630D+02, .106588D+02, .793522D+01, .592978D+01,
     +  .444560D+01, .334378D+01, .252257D+01, .190820D+01,
     +  .144644D+01, .109960D+01, .835343D+00, .636114D+00,
     +  .483609D+00, .367842D+00, .279486D+00, .212009D+00,
     +  .160477D+00, .121144D+00, .911608D-01, .683467D-01,
     +  .510311D-01, .379285D-01, .280499D-01, .206330D-01,
     +  .150913D-01, .109648D-01, .792542D-02, .567696D-02 /
        DATA (UPDI(I),I=5981,6032) /
     +  .403621D-02, .284745D-02, .199263D-02, .138295D-02,
     +  .951769D-03, .649574D-03, .439764D-03, .295538D-03,
     +  .197044D-03, .131089D-03, .866353D-04, .571518D-04,
     +  .377064D-04, .249175D-04, .165016D-04, .109381D-04,
     +  .722892D-05, .471134D-05, .299928D-05, .182504D-05,
     +  .103006D-05, .514088D-06, .207780D-06, .551023D-07,
     +  .474495D-08, .000000D+00, .182043D+07, .136044D+07,
     +  .997155D+06, .730568D+06, .534960D+06, .391507D+06,
     +  .286361D+06, .209334D+06, .152938D+06, .111669D+06,
     +  .814891D+05, .594299D+05, .433165D+05, .315529D+05,
     +  .229705D+05, .167125D+05, .121524D+05, .883139D+04,
     +  .641449D+04, .465642D+04, .337858D+04, .245017D+04,
     +  .177618D+04, .128705D+04, .932360D+03, .675129D+03 /
        DATA (UPDI(I),I=6033,6084) /
     +  .488947D+03, .352491D+03, .255369D+03, .185073D+03,
     +  .134202D+03, .973956D+02, .707544D+02, .515195D+02,
     +  .375494D+02, .274277D+02, .200857D+02, .147514D+02,
     +  .108683D+02, .803306D+01, .595999D+01, .443647D+01,
     +  .331334D+01, .248211D+01, .186458D+01, .140367D+01,
     +  .105990D+01, .799791D+00, .605053D+00, .457012D+00,
     +  .345403D+00, .260798D+00, .196619D+00, .147930D+00,
     +  .111011D+00, .830502D-01, .619106D-01, .459670D-01,
     +  .339772D-01, .249929D-01, .182879D-01, .133077D-01,
     +  .962053D-02, .692030D-02, .493391D-02, .349238D-02,
     +  .245359D-02, .171053D-02, .118325D-02, .812167D-03,
     +  .553286D-03, .374306D-03, .251732D-03, .168265D-03,
     +  .112476D-03, .748859D-04, .499086D-04, .333562D-04 /
        DATA (UPDI(I),I=6085,6136) /
     +  .223767D-04, .150586D-04, .101350D-04, .678379D-05,
     +  .445870D-05, .284623D-05, .172532D-05, .963194D-06,
     +  .471817D-06, .185315D-06, .474732D-07, .415862D-08,
     +  .000000D+00, .228522D+07, .170188D+07, .124223D+07,
     +  .906277D+06, .660774D+06, .481472D+06, .350600D+06,
     +  .255136D+06, .185543D+06, .134843D+06, .979313D+05,
     +  .710751D+05, .515489D+05, .373611D+05, .270599D+05,
     +  .195853D+05, .141660D+05, .102392D+05, .739620D+04,
     +  .533908D+04, .385187D+04, .277724D+04, .200144D+04,
     +  .144159D+04, .103796D+04, .746931D+03, .537557D+03,
     +  .385033D+03, .277146D+03, .199542D+03, .143738D+03,
     +  .103618D+03, .747663D+02, .540707D+02, .391383D+02,
     +  .283909D+02, .206470D+02, .150582D+02, .110172D+02 /
        DATA (UPDI(I),I=6137,6188) /
     +  .808641D+01, .595795D+01, .440428D+01, .326667D+01,
     +  .243043D+01, .181339D+01, .135597D+01, .101711D+01,
     +  .762451D+00, .573086D+00, .430098D+00, .323021D+00,
     +  .242390D+00, .181629D+00, .135834D+00, .101333D+00,
     +  .753705D-01, .558656D-01, .412465D-01, .303205D-01,
     +  .221829D-01, .161463D-01, .116888D-01, .840769D-02,
     +  .601856D-02, .427091D-02, .300967D-02, .210571D-02,
     +  .146252D-02, .100844D-02, .690423D-03, .469577D-03,
     +  .317523D-03, .213758D-03, .143281D-03, .962421D-04,
     +  .645383D-04, .434176D-04, .293436D-04, .199238D-04,
     +  .135665D-04, .922120D-05, .621352D-05, .409364D-05,
     +  .260621D-05, .156696D-05, .862624D-06, .413967D-06,
     +  .157966D-06, .391534D-07, .348318D-08, .000000D+00 /
        DATA (UPDI(I),I=6189,6240) /
     +  .282838D+07, .209935D+07, .152620D+07, .110892D+07,
     +  .805177D+06, .584224D+06, .423605D+06, .306922D+06,
     +  .222218D+06, .160771D+06, .116229D+06, .839626D+05,
     +  .606079D+05, .437155D+05, .315073D+05, .226907D+05,
     +  .163289D+05, .117416D+05, .843695D+04, .605781D+04,
     +  .434665D+04, .311664D+04, .223339D+04, .159944D+04,
     +  .114491D+04, .819006D+03, .585891D+03, .417059D+03,
     +  .298343D+03, .213459D+03, .152787D+03, .109436D+03,
     +  .784515D+02, .563652D+02, .405297D+02, .292047D+02,
     +  .210968D+02, .152829D+02, .111064D+02, .809694D+01,
     +  .592556D+01, .435089D+01, .320546D+01, .236900D+01,
     +  .175586D+01, .130432D+01, .972022D+00, .723940D+00,
     +  .540688D+00, .403225D+00, .300962D+00, .224456D+00 /
        DATA (UPDI(I),I=6241,6292) /
     +  .167177D+00, .124283D+00, .921739D-01, .681629D-01,
     +  .502367D-01, .368837D-01, .269648D-01, .196217D-01,
     +  .142069D-01, .102319D-01, .732281D-02, .521664D-02,
     +  .368462D-02, .258511D-02, .180133D-02, .124658D-02,
     +  .856910D-03, .585317D-03, .397545D-03, .268770D-03,
     +  .181179D-03, .121815D-03, .822281D-04, .555211D-04,
     +  .376699D-04, .257010D-04, .176163D-04, .120949D-04,
     +  .826874D-05, .558546D-05, .367396D-05, .232490D-05,
     +  .138285D-05, .749354D-06, .351963D-06, .130507D-06,
     +  .313480D-07, .282916D-08, .000000D+00, .345464D+07,
     +  .255595D+07, .185092D+07, .133956D+07, .968759D+06,
     +  .700064D+06, .505505D+06, .364729D+06, .262948D+06,
     +  .189416D+06, .136335D+06, .980473D+05, .704534D+05 /
        DATA (UPDI(I),I=6293,6344) /
     +  .505821D+05, .362850D+05, .260065D+05, .186241D+05,
     +  .133258D+05, .952706D+04, .680549D+04, .485770D+04,
     +  .346461D+04, .246936D+04, .175873D+04, .125191D+04,
     +  .890462D+03, .633347D+03, .448170D+03, .318700D+03,
     +  .226655D+03, .161246D+03, .114783D+03, .817721D+02,
     +  .583820D+02, .417131D+02, .298650D+02, .214346D+02,
     +  .154270D+02, .111381D+02, .806708D+01, .586515D+01,
     +  .427840D+01, .313150D+01, .229929D+01, .169317D+01,
     +  .124965D+01, .925364D+00, .684812D+00, .508273D+00,
     +  .376697D+00, .279442D+00, .207148D+00, .153366D+00,
     +  .113345D+00, .835741D-01, .614499D-01, .450340D-01,
     +  .328806D-01, .239071D-01, .173037D-01, .124629D-01,
     +  .893009D-02, .635927D-02, .450858D-02, .316991D-02 /
        DATA (UPDI(I),I=6345,6396) /
     +  .221442D-02, .153696D-02, .105994D-02, .726539D-03,
     +  .495245D-03, .336011D-03, .227209D-03, .153416D-03,
     +  .103488D-03, .702026D-04, .477096D-04, .326146D-04,
     +  .224266D-04, .154818D-04, .106869D-04, .732563D-05,
     +  .494536D-05, .323874D-05, .203255D-05, .119401D-05,
     +  .636217D-06, .292323D-06, .105367D-06, .245660D-07,
     +  .224747D-08, .000000D+00, .377079D+07, .287859D+07,
     +  .216386D+07, .162661D+07, .122275D+07, .919172D+06,
     +  .690971D+06, .519432D+06, .390485D+06, .293554D+06,
     +  .220689D+06, .165915D+06, .124741D+06, .937880D+05,
     +  .705195D+05, .530273D+05, .398772D+05, .299910D+05,
     +  .225584D+05, .169703D+05, .127687D+05, .960948D+04,
     +  .723382D+04, .544722D+04, .410350D+04, .309272D+04 /
        DATA (UPDI(I),I=6397,6448) /
     +  .233228D+04, .175304D+04, .132423D+04, .100133D+04,
     +  .758098D+03, .574789D+03, .436564D+03, .332536D+03,
     +  .253753D+03, .194215D+03, .149159D+03, .115004D+03,
     +  .890570D+02, .692882D+02, .542022D+02, .426294D+02,
     +  .337197D+02, .268286D+02, .214721D+02, .172862D+02,
     +  .140075D+02, .113990D+02, .933685D+01, .767654D+01,
     +  .634531D+01, .526727D+01, .438931D+01, .367031D+01,
     +  .307835D+01, .258852D+01, .218129D+01, .184123D+01,
     +  .155613D+01, .131621D+01, .111363D+01, .942068D+00,
     +  .796386D+00, .672932D+00, .567027D+00, .476660D+00,
     +  .399493D+00, .333583D+00, .277314D+00, .229328D+00,
     +  .188481D+00, .153804D+00, .124453D+00, .997022D-01,
     +  .791370D-01, .619169D-01, .477296D-01, .361581D-01 /
        DATA (UPDI(I),I=6449,6500) /
     +  .268354D-01, .194358D-01, .136689D-01, .928055D-02,
     +  .601348D-02, .368696D-02, .209719D-02, .107649D-02,
     +  .476024D-03, .166235D-03, .377135D-04, .297705D-05,
     +  .000000D+00, .549014D+07, .418523D+07, .314070D+07,
     +  .235652D+07, .176790D+07, .132612D+07, .994577D+06,
     +  .745804D+06, .559163D+06, .419155D+06, .314147D+06,
     +  .235399D+06, .176357D+06, .132096D+06, .989231D+05,
     +  .740646D+05, .554412D+05, .414915D+05, .310455D+05,
     +  .232245D+05, .173707D+05, .129901D+05, .971308D+04,
     +  .726191D+04, .542924D+04, .405875D+04, .303485D+04,
     +  .226041D+04, .169140D+04, .126630D+04, .948751D+03,
     +  .711553D+03, .534335D+03, .402256D+03, .303244D+03,
     +  .229210D+03, .173800D+03, .132270D+03, .101090D+03 /
        DATA (UPDI(I),I=6501,6552) /
     +  .776157D+02, .599183D+02, .465075D+02, .363092D+02,
     +  .285179D+02, .225360D+02, .179167D+02, .143424D+02,
     +  .115312D+02, .933457D+01, .758595D+01, .619941D+01,
     +  .508874D+01, .419380D+01, .346856D+01, .287762D+01,
     +  .239363D+01, .199533D+01, .166611D+01, .139289D+01,
     +  .116532D+01, .975153D+00, .815827D+00, .681915D+00,
     +  .569667D+00, .474443D+00, .394119D+00, .326334D+00,
     +  .269139D+00, .220920D+00, .180329D+00, .146238D+00,
     +  .117696D+00, .938998D-01, .741212D-01, .579438D-01,
     +  .446179D-01, .338256D-01, .251804D-01, .183460D-01,
     +  .130299D-01, .897238D-02, .595591D-02, .376493D-02,
     +  .224640D-02, .123940D-02, .614401D-03, .260848D-03,
     +  .866885D-04, .186612D-04, .150176D-05, .000000D+00 /
        DATA (UPDI(I),I=6553,6604) /
     +  .770869D+07, .586336D+07, .438826D+07, .328339D+07,
     +  .245604D+07, .183664D+07, .137305D+07, .102616D+07,
     +  .766659D+06, .572587D+06, .427492D+06, .319046D+06,
     +  .238020D+06, .177501D+06, .132315D+06, .985897D+05,
     +  .734292D+05, .546649D+05, .406779D+05, .302556D+05,
     +  .224940D+05, .167159D+05, .124171D+05, .921994D+04,
     +  .684384D+04, .507777D+04, .376722D+04, .278275D+04,
     +  .206462D+04, .153211D+04, .113740D+04, .844954D+03,
     +  .628281D+03, .468200D+03, .349278D+03, .261184D+03,
     +  .195883D+03, .147422D+03, .111404D+03, .845647D+02,
     +  .645407D+02, .495253D+02, .382271D+02, .296865D+02,
     +  .231984D+02, .182398D+02, .144429D+02, .114867D+02,
     +  .920038D+01, .739838D+01, .598354D+01, .486116D+01 /
        DATA (UPDI(I),I=6605,6656) /
     +  .396543D+01, .324642D+01, .266607D+01, .219521D+01,
     +  .181136D+01, .149706D+01, .123870D+01, .102557D+01,
     +  .849217D+00, .702939D+00, .581204D+00, .480218D+00,
     +  .395458D+00, .324743D+00, .265741D+00, .216537D+00,
     +  .175554D+00, .141485D+00, .113241D+00, .899109D-01,
     +  .707391D-01, .550294D-01, .423753D-01, .321169D-01,
     +  .239473D-01, .175179D-01, .125292D-01, .872504D-02,
     +  .588166D-02, .381602D-02, .235229D-02, .136505D-02,
     +  .729915D-03, .349059D-03, .142062D-03, .448559D-04,
     +  .915196D-05, .749744D-06, .000000D+00, .104860D+08,
     +  .795473D+07, .593475D+07, .442603D+07, .329959D+07,
     +  .245885D+07, .183157D+07, .136372D+07, .101492D+07,
     +  .754968D+06, .561324D+06, .417132D+06, .309816D+06 /
        DATA (UPDI(I),I=6657,6708) /
     +  .229980D+06, .170621D+06, .126506D+06, .937414D+05,
     +  .694182D+05, .513742D+05, .379951D+05, .280826D+05,
     +  .207421D+05, .153110D+05, .112946D+05, .832715D+04,
     +  .613483D+04, .451847D+04, .331227D+04, .243840D+04,
     +  .179495D+04, .132147D+04, .973298D+03, .717326D+03,
     +  .529718D+03, .391491D+03, .289962D+03, .215352D+03,
     +  .160473D+03, .120053D+03, .902093D+02, .681497D+02,
     +  .517623D+02, .395474D+02, .304005D+02, .235173D+02,
     +  .183054D+02, .143518D+02, .113015D+02, .896411D+01,
     +  .713846D+01, .571788D+01, .460093D+01, .371738D+01,
     +  .301436D+01, .245188D+01, .199952D+01, .163400D+01,
     +  .133737D+01, .109572D+01, .898192D+00, .736268D+00,
     +  .603236D+00, .493576D+00, .403510D+00, .328687D+00 /
        DATA (UPDI(I),I=6709,6760) /
     +  .266921D+00, .215946D+00, .173914D+00, .139312D+00,
     +  .110894D+00, .876280D-01, .686618D-01, .532889D-01,
     +  .408668D-01, .310083D-01, .231395D-01, .169746D-01,
     +  .122056D-01, .857224D-02, .585475D-02, .386500D-02,
     +  .245170D-02, .147424D-02, .832380D-03, .431570D-03,
     +  .199226D-03, .778045D-04, .233946D-04, .454374D-05,
     +  .376939D-06, .000000D+00, .138807D+08, .105000D+08,
     +  .780722D+07, .580222D+07, .431006D+07, .320003D+07,
     +  .237464D+07, .176119D+07, .130547D+07, .967103D+06,
     +  .716001D+06, .529757D+06, .391701D+06, .289422D+06,
     +  .213700D+06, .157672D+06, .116247D+06, .856381D+05,
     +  .630397D+05, .463660D+05, .340754D+05, .250214D+05,
     +  .183587D+05, .134587D+05, .985916D+04, .721533D+04 /
        DATA (UPDI(I),I=6761,6812) /
     +  .527815D+04, .384164D+04, .280768D+04, .205140D+04,
     +  .149871D+04, .109515D+04, .800591D+03, .586309D+03,
     +  .429630D+03, .315445D+03, .232205D+03, .171474D+03,
     +  .127115D+03, .946363D+02, .708322D+02, .532995D+02,
     +  .403428D+02, .307238D+02, .235474D+02, .181596D+02,
     +  .141074D+02, .110073D+02, .865174D+01, .682727D+01,
     +  .541939D+01, .432155D+01, .346027D+01, .278060D+01,
     +  .224127D+01, .181113D+01, .146645D+01, .118911D+01,
     +  .965109D+00, .783604D+00, .636139D+00, .516085D+00,
     +  .418034D+00, .338271D+00, .272660D+00, .219049D+00,
     +  .175269D+00, .139561D+00, .110496D+00, .869030D-01,
     +  .678214D-01, .524629D-01, .401779D-01, .303855D-01,
     +  .227252D-01, .167025D-01, .120583D-01, .852565D-02 /
        DATA (UPDI(I),I=6813,6864) /
     +  .588159D-02, .394106D-02, .254868D-02, .158120D-02,
     +  .927825D-03, .509915D-03, .256479D-03, .114368D-03,
     +  .429037D-04, .123111D-04, .228366D-05, .190543D-06,
     +  .000000D+00, .189529D+08, .142838D+08, .105737D+08,
     +  .782272D+07, .578405D+07, .427404D+07, .315623D+07,
     +  .232922D+07, .171773D+07, .126586D+07, .932176D+06,
     +  .685919D+06, .504317D+06, .370487D+06, .271940D+06,
     +  .199427D+06, .146119D+06, .106958D+06, .782187D+05,
     +  .571441D+05, .417072D+05, .304086D+05, .221493D+05,
     +  .161163D+05, .117154D+05, .850589D+04, .617186D+04,
     +  .445419D+04, .322755D+04, .233748D+04, .169232D+04,
     +  .122520D+04, .887178D+03, .643434D+03, .466815D+03,
     +  .339281D+03, .247180D+03, .180625D+03, .132482D+03 /
        DATA (UPDI(I),I=6865,6916) /
     +  .975765D+02, .722469D+02, .537759D+02, .402621D+02,
     +  .303298D+02, .229938D+02, .175409D+02, .134805D+02,
     +  .104047D+02, .809083D+01, .631619D+01, .496017D+01,
     +  .391310D+01, .309966D+01, .246403D+01, .196461D+01,
     +  .157024D+01, .125740D+01, .100823D+01, .809067D+00,
     +  .649383D+00, .521042D+00, .417703D+00, .334246D+00,
     +  .267142D+00, .212601D+00, .168585D+00, .133097D+00,
     +  .104533D+00, .815994D-01, .632462D-01, .486200D-01,
     +  .370274D-01, .279019D-01, .207474D-01, .152476D-01,
     +  .110018D-01, .779033D-02, .539659D-02, .364313D-02,
     +  .238534D-02, .150471D-02, .908850D-03, .517845D-03,
     +  .275546D-03, .133681D-03, .572241D-04, .204873D-04,
     +  .557624D-05, .983072D-06, .814691D-07, .000000D+00 /
        DATA (UPDI(I),I=6917,6968) /
     +  .252017D+08, .189213D+08, .139434D+08, .102681D+08,
     +  .755640D+07, .555686D+07, .408342D+07, .299837D+07,
     +  .219989D+07, .161272D+07, .118127D+07, .864469D+06,
     +  .632055D+06, .461683D+06, .336908D+06, .245602D+06,
     +  .178856D+06, .130107D+06, .945424D+05, .686198D+05,
     +  .497490D+05, .360243D+05, .260564D+05, .188233D+05,
     +  .135827D+05, .978722D+04, .704690D+04, .504498D+04,
     +  .362607D+04, .260434D+04, .186954D+04, .134175D+04,
     +  .962937D+03, .692054D+03, .497436D+03, .358124D+03,
     +  .258403D+03, .186987D+03, .135796D+03, .990212D+02,
     +  .725815D+02, .534800D+02, .396354D+02, .295552D+02,
     +  .221796D+02, .167481D+02, .127415D+02, .973450D+01,
     +  .749343D+01, .579051D+01, .450135D+01, .351510D+01 /
        DATA (UPDI(I),I=6969,7020) /
     +  .275602D+01, .216838D+01, .171101D+01, .135327D+01,
     +  .107222D+01, .850546D+00, .675117D+00, .535893D+00,
     +  .425154D+00, .336931D+00, .266455D+00, .210421D+00,
     +  .165404D+00, .129506D+00, .100921D+00, .782056D-01,
     +  .602090D-01, .460041D-01, .348452D-01, .261323D-01,
     +  .193796D-01, .141709D-01, .102347D-01, .725007D-02,
     +  .503502D-02, .341687D-02, .225661D-02, .144316D-02,
     +  .887490D-03, .521442D-03, .288163D-03, .148219D-03,
     +  .692078D-04, .283536D-04, .964718D-05, .247582D-05,
     +  .411118D-06, .331581D-07, .000000D+00, .327210D+08,
     +  .244741D+08, .179541D+08, .131610D+08, .963998D+07,
     +  .705531D+07, .515938D+07, .376969D+07, .275187D+07,
     +  .200700D+07, .146236D+07, .106446D+07, .774043D+06 /
        DATA (UPDI(I),I=7021,7072) /
     +  .562257D+06, .407974D+06, .295688D+06, .214059D+06,
     +  .154776D+06, .111776D+06, .806173D+05, .580716D+05,
     +  .417745D+05, .300126D+05, .215323D+05, .154282D+05,
     +  .110368D+05, .788821D+04, .560418D+04, .399701D+04,
     +  .284817D+04, .202811D+04, .144359D+04, .102731D+04,
     +  .732001D+03, .521548D+03, .372141D+03, .266089D+03,
     +  .190783D+03, .137268D+03, .991559D+02, .719944D+02,
     +  .525438D+02, .385706D+02, .284865D+02, .211733D+02,
     +  .158352D+02, .119322D+02, .902863D+01, .688375D+01,
     +  .526823D+01, .405600D+01, .313678D+01, .243553D+01,
     +  .189751D+01, .148251D+01, .116087D+01, .910505D+00,
     +  .714888D+00, .561554D+00, .441050D+00, .346153D+00,
     +  .271322D+00, .212166D+00, .165638D+00, .128672D+00 /
        DATA (UPDI(I),I=7073,7124) /
     +  .995312D-01, .766011D-01, .586026D-01, .445233D-01,
     +  .335563D-01, .250588D-01, .185181D-01, .135240D-01,
     +  .973137D-02, .691192D-02, .481046D-02, .327900D-02,
     +  .218160D-02, .141071D-02, .881972D-03, .529254D-03,
     +  .302795D-03, .162478D-03, .808884D-04, .364050D-04,
     +  .143005D-04, .463516D-05, .112501D-05, .175958D-06,
     +  .133046D-07, .000000D+00, .415908D+08, .309931D+08,
     +  .226353D+08, .165173D+08, .120427D+08, .877257D+07,
     +  .638462D+07, .464229D+07, .337215D+07, .244704D+07,
     +  .177387D+07, .128449D+07, .929086D+06, .671232D+06,
     +  .484366D+06, .349084D+06, .251269D+06, .180621D+06,
     +  .129664D+06, .929513D+05, .665414D+05, .475645D+05,
     +  .339516D+05, .241975D+05, .172209D+05, .122340D+05 /
        DATA (UPDI(I),I=7125,7176) /
     +  .868235D+04, .612337D+04, .433521D+04, .306596D+04,
     +  .216645D+04, .152999D+04, .108009D+04, .763348D+03,
     +  .539367D+03, .381606D+03, .270518D+03, .192273D+03,
     +  .137125D+03, .981739D+02, .706450D+02, .510957D+02,
     +  .371693D+02, .272034D+02, .200366D+02, .148491D+02,
     +  .110880D+02, .831348D+01, .628109D+01, .476311D+01,
     +  .363363D+01, .278436D+01, .214196D+01, .165329D+01,
     +  .127960D+01, .992490D+00, .770976D+00, .599456D+00,
     +  .466239D+00, .362519D+00, .281618D+00, .218444D+00,
     +  .169001D+00, .130512D+00, .100255D+00, .766642D-01,
     +  .583097D-01, .440701D-01, .330653D-01, .245999D-01,
     +  .181257D-01, .132094D-01, .950825D-02, .673868D-02,
     +  .471142D-02, .322473D-02, .215975D-02, .141037D-02 /
        DATA (UPDI(I),I=7177,7228) /
     +  .894036D-03, .547155D-03, .320859D-03, .179037D-03,
     +  .934538D-04, .451268D-04, .196255D-04, .741431D-05,
     +  .229799D-05, .529713D-06, .779615D-07, .521459D-08,
     +  .000000D+00, .518710D+08, .385137D+08, .280051D+08,
     +  .203451D+08, .147667D+08, .107076D+08, .775665D+07,
     +  .561322D+07, .405781D+07, .293019D+07, .211354D+07,
     +  .152270D+07, .109571D+07, .787463D+06, .565205D+06,
     +  .405131D+06, .289996D+06, .207283D+06, .147948D+06,
     +  .105437D+06, .750283D+05, .533039D+05, .378118D+05,
     +  .267774D+05, .189334D+05, .133612D+05, .941826D+04,
     +  .659590D+04, .463687D+04, .325573D+04, .228367D+04,
     +  .160070D+04, .112138D+04, .786384D+03, .551246D+03,
     +  .386873D+03, .272014D+03, .191739D+03, .135602D+03 /
        DATA (UPDI(I),I=7229,7280) /
     +  .962647D+02, .686835D+02, .492530D+02, .355220D+02,
     +  .257746D+02, .188211D+02, .138281D+02, .102371D+02,
     +  .760904D+01, .569942D+01, .428453D+01, .324021D+01,
     +  .246129D+01, .187685D+01, .143589D+01, .110146D+01,
     +  .846658D+00, .651724D+00, .502077D+00, .386861D+00,
     +  .297954D+00, .229234D+00, .176069D+00, .134855D+00,
     +  .103084D+00, .783569D-01, .592766D-01, .445891D-01,
     +  .333193D-01, .247081D-01, .181615D-01, .132156D-01,
     +  .950711D-02, .675175D-02, .471817D-02, .325092D-02,
     +  .219102D-02, .144378D-02, .926750D-03, .576827D-03,
     +  .346188D-03, .198782D-03, .108423D-03, .551965D-04,
     +  .259301D-04, .109362D-04, .399093D-05, .118908D-05,
     +  .261791D-06, .362235D-07, .195957D-08, .000000D+00 /
        DATA (UPDI(I),I=7281,7332) /
     +  .635998D+08, .470554D+08, .340701D+08, .246439D+08,
     +  .178081D+08, .128553D+08, .927015D+07, .667755D+07,
     +  .480462D+07, .345295D+07, .247856D+07, .177689D+07,
     +  .127223D+07, .909668D+06, .649538D+06, .463126D+06,
     +  .329732D+06, .234398D+06, .166372D+06, .117895D+06,
     +  .834089D+05, .589090D+05, .415372D+05, .292355D+05,
     +  .205422D+05, .144039D+05, .100873D+05, .701693D+04,
     +  .489949D+04, .341640D+04, .237950D+04, .165592D+04,
     +  .115158D+04, .801566D+03, .557636D+03, .388350D+03,
     +  .270925D+03, .189465D+03, .132927D+03, .936072D+02,
     +  .662477D+02, .471204D+02, .337070D+02, .242579D+02,
     +  .175688D+02, .128023D+02, .940043D+01, .692977D+01,
     +  .514826D+01, .383836D+01, .287894D+01, .216883D+01 /
        DATA (UPDI(I),I=7333,7384) /
     +  .164014D+01, .124434D+01, .946508D+00, .721388D+00,
     +  .550547D+00, .420465D+00, .321140D+00, .245140D+00,
     +  .186902D+00, .142240D+00, .107927D+00, .817178D-01,
     +  .615117D-01, .460703D-01, .343020D-01, .253644D-01,
     +  .186071D-01, .135258D-01, .973006D-02, .691708D-02,
     +  .485229D-02, .334759D-02, .227616D-02, .151279D-02,
     +  .982344D-03, .620892D-03, .380184D-03, .224234D-03,
     +  .126380D-03, .675662D-04, .336541D-04, .154385D-04,
     +  .634263D-05, .224784D-05, .647960D-06, .137200D-06,
     +  .178677D-07, .677722D-09, .000000D+00, .767923D+08,
     +  .566206D+08, .408248D+08, .294049D+08, .211572D+08,
     +  .152064D+08, .109171D+08, .782858D+07, .560712D+07,
     +  .401103D+07, .286561D+07, .204456D+07, .145676D+07 /
        DATA (UPDI(I),I=7385,7436) /
     +  .103647D+07, .736363D+06, .522351D+06, .369967D+06,
     +  .261609D+06, .184686D+06, .130155D+06, .915692D+05,
     +  .643045D+05, .450788D+05, .315406D+05, .220284D+05,
     +  .153507D+05, .106831D+05, .738326D+04, .512173D+04,
     +  .354766D+04, .245422D+04, .169616D+04, .117128D+04,
     +  .809476D+03, .559055D+03, .386473D+03, .267606D+03,
     +  .185733D+03, .129316D+03, .903661D+02, .634609D+02,
     +  .447886D+02, .317902D+02, .227006D+02, .163131D+02,
     +  .117948D+02, .859359D+01, .628559D+01, .463354D+01,
     +  .342768D+01, .255092D+01, .190674D+01, .143066D+01,
     +  .107689D+01, .812666D+00, .614452D+00, .465175D+00,
     +  .352387D+00, .266942D+00, .202081D+00, .152780D+00,
     +  .115283D+00, .867158D-01, .650829D-01, .485506D-01 /
        DATA (UPDI(I),I=7437,7488) /
     +  .360302D-01, .265760D-01, .194636D-01, .141385D-01,
     +  .101743D-01, .724338D-02, .509442D-02, .353436D-02,
     +  .241048D-02, .161970D-02, .106321D-02, .681521D-03,
     +  .424946D-03, .256509D-03, .149022D-03, .826548D-04,
     +  .434412D-04, .212425D-04, .955343D-05, .384106D-05,
     +  .132937D-05, .373183D-06, .765552D-07, .942683D-08,
     +  .191805D-09, .000000D+00, .914401D+08, .671952D+08,
     +  .482522D+08, .346111D+08, .247989D+08, .177481D+08,
     +  .126870D+08, .905800D+07, .645890D+07, .459954D+07,
     +  .327103D+07, .232297D+07, .164732D+07, .116643D+07,
     +  .824658D+06, .582087D+06, .410198D+06, .288571D+06,
     +  .202658D+06, .142063D+06, .994066D+05, .694241D+05,
     +  .483951D+05, .336675D+05, .233769D+05, .161934D+05 /
        DATA (UPDI(I),I=7489,7540) /
     +  .112016D+05, .769321D+04, .530326D+04, .364993D+04,
     +  .250853D+04, .172221D+04, .118125D+04, .810781D+03,
     +  .556058D+03, .381689D+03, .262405D+03, .180809D+03,
     +  .124972D+03, .866894D+02, .604308D+02, .423350D+02,
     +  .298263D+02, .211406D+02, .150797D+02, .108224D+02,
     +  .782717D+01, .568269D+01, .415840D+01, .305352D+01,
     +  .225578D+01, .167374D+01, .124660D+01, .931411D+00,
     +  .697675D+00, .523580D+00, .393409D+00, .295773D+00,
     +  .222350D+00, .167031D+00, .125301D+00, .938056D-01,
     +  .699987D-01, .521139D-01, .385567D-01, .283747D-01,
     +  .207514D-01, .150661D-01, .108473D-01, .773518D-02,
     +  .545584D-02, .380065D-02, .261094D-02, .176266D-02,
     +  .117212D-02, .761082D-03, .482374D-03, .297254D-03 /
        DATA (UPDI(I),I=7541,7592) /
     +  .177237D-03, .101649D-03, .556192D-04, .288162D-04,
     +  .138771D-04, .614031D-05, .242603D-05, .823876D-06,
     +  .226482D-06, .453042D-07, .531660D-08, .207139D-10,
     +  .000000D+00, .107511D+09, .787483D+08, .563239D+08,
     +  .402382D+08, .287131D+08, .204643D+08, .145672D+08,
     +  .103562D+08, .735266D+07, .521306D+07, .369085D+07,
     +  .260928D+07, .184187D+07, .129811D+07, .913409D+06,
     +  .641630D+06, .449948D+06, .314960D+06, .220072D+06,
     +  .153476D+06, .106831D+06, .742116D+05, .514518D+05,
     +  .355961D+05, .245769D+05, .169267D+05, .116405D+05,
     +  .794643D+04, .544466D+04, .372415D+04, .254349D+04,
     +  .173506D+04, .118234D+04, .806194D+03, .549214D+03,
     +  .374437D+03, .255656D+03, .174940D+03, .120073D+03 /
        DATA (UPDI(I),I=7593,7644) /
     +  .827073D+02, .572496D+02, .398237D+02, .278592D+02,
     +  .196071D+02, .138876D+02, .989679D+01, .710790D+01,
     +  .512436D+01, .372384D+01, .271539D+01, .199211D+01,
     +  .146788D+01, .108572D+01, .805595D+00, .599250D+00,
     +  .446590D+00, .333219D+00, .248764D+00, .185692D+00,
     +  .138503D+00, .103156D+00, .766694D-01, .567937D-01,
     +  .419721D-01, .308208D-01, .225096D-01, .163353D-01,
     +  .117671D-01, .840460D-02, .594465D-02, .415818D-02,
     +  .287211D-02, .195592D-02, .130865D-02, .862275D-03,
     +  .554596D-03, .348066D-03, .212317D-03, .125261D-03,
     +  .710520D-04, .384322D-04, .196724D-04, .935306D-05,
     +  .408295D-05, .159006D-05, .531641D-06, .143661D-06,
     +  .281551D-07, .317853D-08, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=7645,7696) /
     +  .689519D+05, .101068D+06, .778373D+05, .599561D+05,
     +  .461917D+05, .355953D+05, .274368D+05, .211545D+05,
     +  .163162D+05, .125895D+05, .971836D+04, .750589D+04,
     +  .580055D+04, .448571D+04, .347162D+04, .268919D+04,
     +  .208522D+04, .161878D+04, .125834D+04, .979625D+03,
     +  .763947D+03, .596905D+03, .467404D+03, .366897D+03,
     +  .288794D+03, .228015D+03, .180643D+03, .143193D+03,
     +  .114367D+03, .917631D+02, .739952D+02, .599923D+02,
     +  .489252D+02, .401752D+02, .331974D+02, .276308D+02,
     +  .231735D+02, .195902D+02, .166972D+02, .143498D+02,
     +  .124382D+02, .108703D+02, .957701D+01, .850274D+01,
     +  .760359D+01, .684467D+01, .620041D+01, .564258D+01,
     +  .516042D+01, .473396D+01, .435640D+01, .401725D+01 /
        DATA (UPDI(I),I=7697,7748) /
     +  .370951D+01, .342763D+01, .316728D+01, .292508D+01,
     +  .269841D+01, .248528D+01, .228421D+01, .209406D+01,
     +  .191403D+01, .174353D+01, .158214D+01, .143025D+01,
     +  .128610D+01, .115051D+01, .102339D+01, .904691D+00,
     +  .794340D+00, .692273D+00, .598402D+00, .512615D+00,
     +  .434720D+00, .364475D+00, .302260D+00, .246885D+00,
     +  .198499D+00, .156737D+00, .121197D+00, .914452D-01,
     +  .670156D-01, .474432D-01, .321009D-01, .205895D-01,
     +  .122895D-01, .665027D-02, .312277D-02, .117208D-02,
     +  .292395D-03, .268721D-04, .000000D+00, .160435D+06,
     +  .124521D+06, .954243D+05, .731448D+05, .560812D+05,
     +  .430102D+05, .329959D+05, .253219D+05, .194402D+05,
     +  .149311D+05, .114734D+05, .882124D+04, .678637D+04 /
        DATA (UPDI(I),I=7749,7800) /
     +  .522455D+04, .402537D+04, .310423D+04, .239634D+04,
     +  .185203D+04, .143325D+04, .111082D+04, .862393D+03,
     +  .670807D+03, .522916D+03, .408622D+03, .320185D+03,
     +  .251653D+03, .198467D+03, .156600D+03, .124511D+03,
     +  .994533D+02, .798392D+02, .644452D+02, .523284D+02,
     +  .427870D+02, .352078D+02, .291846D+02, .243793D+02,
     +  .205296D+02, .174316D+02, .149253D+02, .128897D+02,
     +  .112239D+02, .985255D+01, .871525D+01, .776446D+01,
     +  .696280D+01, .628271D+01, .569431D+01, .518608D+01,
     +  .473698D+01, .433991D+01, .398388D+01, .366158D+01,
     +  .336727D+01, .309643D+01, .284555D+01, .261191D+01,
     +  .239343D+01, .218850D+01, .199591D+01, .181476D+01,
     +  .164437D+01, .148418D+01, .133448D+01, .119341D+01 /
        DATA (UPDI(I),I=7801,7852) /
     +  .106169D+01, .939092D+00, .825447D+00, .720575D+00,
     +  .624292D+00, .536398D+00, .456673D+00, .384856D+00,
     +  .320573D+00, .264085D+00, .214209D+00, .170986D+00,
     +  .133995D+00, .102791D+00, .769095D-01, .558567D-01,
     +  .391652D-01, .262237D-01, .166273D-01, .979734D-02,
     +  .522417D-02, .241121D-02, .886146D-03, .216091D-03,
     +  .200316D-04, .000000D+00, .203585D+06, .157319D+06,
     +  .119953D+06, .914859D+05, .697918D+05, .532564D+05,
     +  .406508D+05, .310391D+05, .237089D+05, .181172D+05,
     +  .138507D+05, .105945D+05, .810865D+04, .621020D+04,
     +  .475986D+04, .365139D+04, .280383D+04, .215541D+04,
     +  .165908D+04, .127889D+04, .987456D+03, .763863D+03,
     +  .592162D+03, .460156D+03, .358550D+03, .280222D+03 /
        DATA (UPDI(I),I=7853,7904) /
     +  .219760D+03, .172418D+03, .136326D+03, .108292D+03,
     +  .864633D+02, .694207D+02, .560753D+02, .456195D+02,
     +  .373549D+02, .308182D+02, .256270D+02, .214861D+02,
     +  .181671D+02, .154918D+02, .133262D+02, .115593D+02,
     +  .101082D+02, .890738D+01, .790522D+01, .706152D+01,
     +  .634665D+01, .572892D+01, .519600D+01, .472576D+01,
     +  .431074D+01, .393941D+01, .360417D+01, .329904D+01,
     +  .301930D+01, .276131D+01, .252220D+01, .229978D+01,
     +  .209233D+01, .189854D+01, .171740D+01, .154812D+01,
     +  .138999D+01, .124322D+01, .110584D+01, .978441D+00,
     +  .860696D+00, .752310D+00, .652995D+00, .562462D+00,
     +  .480408D+00, .406519D+00, .340465D+00, .281768D+00,
     +  .230583D+00, .185742D+00, .147195D+00, .114480D+00 /
        DATA (UPDI(I),I=7905,7956) /
     +  .871215D-01, .646358D-01, .465159D-01, .322970D-01,
     +  .213921D-01, .134027D-01, .779158D-02, .409072D-02,
     +  .185383D-02, .666060D-03, .158444D-03, .148292D-04,
     +  .000000D+00, .261711D+06, .201376D+06, .152791D+06,
     +  .115953D+06, .880151D+05, .668229D+05, .507459D+05,
     +  .385474D+05, .292904D+05, .222643D+05, .169304D+05,
     +  .128803D+05, .980421D+04, .746722D+04, .569124D+04,
     +  .434108D+04, .331425D+04, .253295D+04, .193817D+04,
     +  .148509D+04, .113974D+04, .876273D+03, .675111D+03,
     +  .521347D+03, .403685D+03, .313509D+03, .244319D+03,
     +  .190466D+03, .149659D+03, .118152D+03, .937647D+02,
     +  .748373D+02, .601023D+02, .486239D+02, .396016D+02,
     +  .325039D+02, .268962D+02, .224448D+02, .188930D+02 /
        DATA (UPDI(I),I=7957,8008) /
     +  .160420D+02, .137428D+02, .118730D+02, .103419D+02,
     +  .907799D+01, .802539D+01, .714088D+01, .639262D+01,
     +  .574705D+01, .519100D+01, .470123D+01, .426986D+01,
     +  .388485D+01, .353828D+01, .322390D+01, .293680D+01,
     +  .267316D+01, .243000D+01, .220496D+01, .199623D+01,
     +  .180236D+01, .162223D+01, .145494D+01, .129964D+01,
     +  .115642D+01, .102324D+01, .900541D+00, .787901D+00,
     +  .684910D+00, .591179D+00, .506321D+00, .429942D+00,
     +  .361645D+00, .301038D+00, .247561D+00, .201273D+00,
     +  .161031D+00, .126708D+00, .978147D-01, .738559D-01,
     +  .543388D-01, .387557D-01, .266506D-01, .174659D-01,
     +  .108154D-01, .620502D-02, .320864D-02, .142819D-02,
     +  .501983D-03, .116640D-03, .110182D-04, .000000D+00 /
        DATA (UPDI(I),I=8009,8060) /
     +  .210276D+06, .258756D+06, .195400D+06, .147580D+06,
     +  .111477D+06, .842183D+05, .636354D+05, .480922D+05,
     +  .363538D+05, .274879D+05, .207907D+05, .157310D+05,
     +  .119078D+05, .901834D+04, .683408D+04, .518243D+04,
     +  .393316D+04, .298784D+04, .227225D+04, .173024D+04,
     +  .131950D+04, .100798D+04, .771550D+03, .591916D+03,
     +  .455299D+03, .351240D+03, .271902D+03, .210542D+03,
     +  .164342D+03, .128898D+03, .101637D+03, .806124D+02,
     +  .643464D+02, .517527D+02, .419124D+02, .342157D+02,
     +  .281681D+02, .233922D+02, .195999D+02, .165692D+02,
     +  .141349D+02, .121623D+02, .105520D+02, .922624D+01,
     +  .812476D+01, .720108D+01, .642115D+01, .574948D+01,
     +  .517202D+01, .466443D+01, .421839D+01, .382134D+01 /
        DATA (UPDI(I),I=8061,8112) /
     +  .346503D+01, .314294D+01, .284995D+01, .258207D+01,
     +  .233615D+01, .210972D+01, .190081D+01, .170787D+01,
     +  .152963D+01, .136510D+01, .121327D+01, .107410D+01,
     +  .945510D+00, .827794D+00, .720420D+00, .622882D+00,
     +  .534697D+00, .455388D+00, .384482D+00, .321512D+00,
     +  .266026D+00, .217406D+00, .175626D+00, .139572D+00,
     +  .109057D+00, .835726D-01, .626152D-01, .456912D-01,
     +  .323007D-01, .220015D-01, .142690D-01, .873443D-02,
     +  .494635D-02, .251986D-02, .110206D-02, .379193D-03,
     +  .861754D-04, .821416D-05, .000000D+00, .463016D+06,
     +  .353138D+06, .265181D+06, .199145D+06, .149555D+06,
     +  .112316D+06, .843541D+05, .633579D+05, .475928D+05,
     +  .357554D+05, .268672D+05, .201931D+05, .151815D+05 /
        DATA (UPDI(I),I=8113,8164) /
     +  .114178D+05, .859106D+04, .646766D+04, .487235D+04,
     +  .367344D+04, .277221D+04, .209443D+04, .158452D+04,
     +  .120064D+04, .911464D+03, .693428D+03, .528891D+03,
     +  .404542D+03, .310497D+03, .238350D+03, .184472D+03,
     +  .143473D+03, .112196D+03, .882693D+02, .699064D+02,
     +  .558009D+02, .448639D+02, .363728D+02, .297482D+02,
     +  .245516D+02, .204509D+02, .171925D+02, .145888D+02,
     +  .124885D+02, .107811D+02, .938030D+01, .822013D+01,
     +  .724993D+01, .643285D+01, .573093D+01, .512905D+01,
     +  .460147D+01, .413933D+01, .372941D+01, .336303D+01,
     +  .303332D+01, .273491D+01, .246356D+01, .221592D+01,
     +  .198934D+01, .178167D+01, .159118D+01, .141646D+01,
     +  .125635D+01, .110969D+01, .976274D+00, .853935D+00 /
        DATA (UPDI(I),I=8165,8216) /
     +  .742813D+00, .642249D+00, .551620D+00, .470336D+00,
     +  .397826D+00, .333527D+00, .276903D+00, .227435D+00,
     +  .184455D+00, .147846D+00, .116540D+00, .902897D-01,
     +  .685786D-01, .509032D-01, .367791D-01, .257265D-01,
     +  .173262D-01, .110987D-01, .670239D-02, .373868D-02,
     +  .187229D-02, .802815D-03, .269938D-03, .599821D-04,
     +  .577233D-05, .000000D+00, .628123D+06, .476911D+06,
     +  .356229D+06, .266076D+06, .198718D+06, .148398D+06,
     +  .110812D+06, .827412D+05, .617799D+05, .461291D+05,
     +  .344449D+05, .257225D+05, .192119D+05, .143522D+05,
     +  .107251D+05, .801772D+04, .599686D+04, .448819D+04,
     +  .336178D+04, .252049D+04, .189202D+04, .142227D+04,
     +  .107101D+04, .808137D+03, .611267D+03, .463624D+03 /
        DATA (UPDI(I),I=8217,8268) /
     +  .352845D+03, .268538D+03, .206087D+03, .158946D+03,
     +  .123275D+03, .962058D+02, .755965D+02, .598895D+02,
     +  .478037D+02, .384902D+02, .312752D+02, .256533D+02,
     +  .212445D+02, .177612D+02, .149921D+02, .127688D+02,
     +  .109686D+02, .949714D+01, .828231D+01, .726932D+01,
     +  .641856D+01, .568967D+01, .506640D+01, .452172D+01,
     +  .404619D+01, .362596D+01, .325191D+01, .291684D+01,
     +  .261511D+01, .234222D+01, .209463D+01, .186947D+01,
     +  .166444D+01, .147762D+01, .130746D+01, .115262D+01,
     +  .101180D+01, .884627D+00, .768881D+00, .664540D+00,
     +  .570833D+00, .487036D+00, .412467D+00, .346475D+00,
     +  .288426D+00, .237726D+00, .193807D+00, .155969D+00,
     +  .124022D+00, .969487D-01, .744597D-01, .560398D-01 /
        DATA (UPDI(I),I=8269,8320) /
     +  .411959D-01, .294606D-01, .203802D-01, .135629D-01,
     +  .857474D-02, .510360D-02, .280067D-02, .137646D-02,
     +  .577335D-03, .189097D-03, .409337D-04, .398335D-05,
     +  .000000D+00, .839687D+06, .634849D+06, .471826D+06,
     +  .350619D+06, .260492D+06, .193493D+06, .143699D+06,
     +  .106700D+06, .792159D+05, .588040D+05, .436481D+05,
     +  .323970D+05, .240464D+05, .178495D+05, .132516D+05,
     +  .984040D+04, .730994D+04, .543274D+04, .404022D+04,
     +  .300705D+04, .224043D+04, .167136D+04, .124883D+04,
     +  .934869D+03, .701463D+03, .527712D+03, .398341D+03,
     +  .300642D+03, .228836D+03, .175057D+03, .134680D+03,
     +  .104281D+03, .813156D+02, .639466D+02, .506816D+02,
     +  .405331D+02, .327255D+02, .266814D+02, .219702D+02 /
        DATA (UPDI(I),I=8321,8372) /
     +  .182688D+02, .153411D+02, .130010D+02, .111139D+02,
     +  .957684D+01, .831197D+01, .726032D+01, .637961D+01,
     +  .562714D+01, .498562D+01, .442676D+01, .394053D+01,
     +  .351250D+01, .313311D+01, .279485D+01, .249177D+01,
     +  .221915D+01, .197322D+01, .175093D+01, .154979D+01,
     +  .136772D+01, .120299D+01, .105414D+01, .919697D+00,
     +  .799158D+00, .690241D+00, .592779D+00, .505904D+00,
     +  .428802D+00, .360718D+00, .300932D+00, .248757D+00,
     +  .203556D+00, .164724D+00, .131546D+00, .103776D+00,
     +  .804518D-01, .612556D-01, .456836D-01, .332606D-01,
     +  .235428D-01, .161074D-01, .105925D-01, .660954D-02,
     +  .387730D-02, .209323D-02, .100964D-02, .414270D-03,
     +  .132211D-03, .279000D-04, .274565D-05, .000000D+00 /
        DATA (UPDI(I),I=8373,8424) /
     +  .110466D+07, .831843D+06, .615292D+06, .455013D+06,
     +  .336378D+06, .248597D+06, .183669D+06, .135659D+06,
     +  .100173D+06, .739509D+05, .545818D+05, .402789D+05,
     +  .297204D+05, .219282D+05, .161792D+05, .119385D+05,
     +  .881113D+04, .650507D+04, .480493D+04, .355142D+04,
     +  .262727D+04, .194576D+04, .144312D+04, .107218D+04,
     +  .798341D+03, .595928D+03, .446316D+03, .334163D+03,
     +  .252351D+03, .191535D+03, .146219D+03, .112358D+03,
     +  .869668D+02, .679047D+02, .534511D+02, .424702D+02,
     +  .340782D+02, .276224D+02, .226196D+02, .187101D+02,
     +  .156329D+02, .131840D+02, .112167D+02, .961998D+01,
     +  .831017D+01, .722433D+01, .631761D+01, .554511D+01,
     +  .488853D+01, .431841D+01, .382416D+01, .339078D+01 /
        DATA (UPDI(I),I=8425,8476) /
     +  .300831D+01, .266889D+01, .236631D+01, .209561D+01,
     +  .185281D+01, .163465D+01, .143849D+01, .126206D+01,
     +  .110349D+01, .961175D+00, .833513D+00, .719851D+00,
     +  .617876D+00, .527285D+00, .447123D+00, .376508D+00,
     +  .314619D+00, .260689D+00, .213990D+00, .173855D+00,
     +  .139655D+00, .110674D+00, .866248D-01, .666023D-01,
     +  .502741D-01, .371546D-01, .267922D-01, .187711D-01,
     +  .127020D-01, .825441D-02, .508371D-02, .293944D-02,
     +  .156128D-02, .739150D-03, .296754D-03, .923348D-04,
     +  .190189D-04, .189234D-05, .000000D+00, .142989D+07,
     +  .107264D+07, .789803D+06, .581363D+06, .427758D+06,
     +  .314609D+06, .231297D+06, .169981D+06, .124874D+06,
     +  .917038D+05, .673231D+05, .494099D+05, .362542D+05 /
        DATA (UPDI(I),I=8477,8528) /
     +  .265960D+05, .195085D+05, .143090D+05, .104961D+05,
     +  .770047D+04, .565143D+04, .414967D+04, .304925D+04,
     +  .224278D+04, .165176D+04, .121844D+04, .900653D+03,
     +  .667335D+03, .496077D+03, .368598D+03, .276268D+03,
     +  .208122D+03, .157709D+03, .120308D+03, .924630D+02,
     +  .717047D+02, .560730D+02, .442755D+02, .353167D+02,
     +  .284660D+02, .231867D+02, .190821D+02, .158661D+02,
     +  .133175D+02, .112778D+02, .962773D+01, .827840D+01,
     +  .716304D+01, .623435D+01, .544543D+01, .477698D+01,
     +  .419850D+01, .369885D+01, .326248D+01, .287904D+01,
     +  .254038D+01, .224000D+01, .197272D+01, .173434D+01,
     +  .152144D+01, .133115D+01, .116111D+01, .100927D+01,
     +  .873890D+00, .753266D+00, .646606D+00, .551580D+00 /
        DATA (UPDI(I),I=8529,8580) /
     +  .467760D+00, .394122D+00, .329726D+00, .273706D+00,
     +  .225255D+00, .183623D+00, .148123D+00, .118114D+00,
     +  .928919D-01, .721376D-01, .550088D-01, .411667D-01,
     +  .301495D-01, .215335D-01, .149335D-01, .999481D-02,
     +  .641866D-02, .390191D-02, .222385D-02, .116221D-02,
     +  .540118D-03, .212231D-03, .644205D-04, .129679D-04,
     +  .130420D-05, .000000D+00, .182190D+07, .136174D+07,
     +  .998307D+06, .731586D+06, .535861D+06, .392304D+06,
     +  .287066D+06, .209957D+06, .153488D+06, .112156D+06,
     +  .819192D+05, .598100D+05, .436523D+05, .318496D+05,
     +  .232325D+05, .169438D+05, .123567D+05, .901169D+04,
     +  .657358D+04, .479678D+04, .350237D+04, .255932D+04,
     +  .187240D+04, .137185D+04, .100708D+04, .740968D+03 /
        DATA (UPDI(I),I=8581,8632) /
     +  .546929D+03, .403453D+03, .300239D+03, .224576D+03,
     +  .168982D+03, .128020D+03, .977282D+02, .752967D+02,
     +  .585148D+02, .459289D+02, .364288D+02, .292051D+02,
     +  .236677D+02, .193830D+02, .160407D+02, .134024D+02,
     +  .112983D+02, .960169D+01, .821845D+01, .707831D+01,
     +  .613175D+01, .533000D+01, .465284D+01, .406883D+01,
     +  .356627D+01, .312915D+01, .274676D+01, .241062D+01,
     +  .211399D+01, .185146D+01, .161864D+01, .141191D+01,
     +  .122827D+01, .106519D+01, .920498D+00, .792334D+00,
     +  .678890D+00, .579256D+00, .491096D+00, .413874D+00,
     +  .346512D+00, .288027D+00, .237520D+00, .194160D+00,
     +  .157185D+00, .125898D+00, .996608D-01, .777857D-01,
     +  .599358D-01, .453308D-01, .336341D-01, .244114D-01 /
        DATA (UPDI(I),I=8633,8684) /
     +  .172694D-01, .118550D-01, .784795D-02, .498077D-02,
     +  .298870D-02, .167910D-02, .863479D-03, .393972D-03,
     +  .151550D-03, .449033D-04, .884419D-05, .898844D-06,
     +  .000000D+00, .228678D+07, .170326D+07, .124345D+07,
     +  .907356D+06, .661728D+06, .482316D+06, .351347D+06,
     +  .255795D+06, .186126D+06, .135358D+06, .983864D+05,
     +  .714771D+05, .519039D+05, .376746D+05, .273366D+05,
     +  .198296D+05, .143815D+05, .104293D+05, .756382D+04,
     +  .548685D+04, .398210D+04, .289198D+04, .210249D+04,
     +  .153057D+04, .111627D+04, .815863D+03, .598188D+03,
     +  .438252D+03, .323936D+03, .240673D+03, .179889D+03,
     +  .135393D+03, .102698D+03, .786395D+02, .607511D+02,
     +  .474151D+02, .374058D+02, .298354D+02, .240609D+02 /
        DATA (UPDI(I),I=8685,8736) /
     +  .196130D+02, .161576D+02, .134400D+02, .112800D+02,
     +  .954377D+01, .813231D+01, .697217D+01, .601178D+01,
     +  .520072D+01, .451792D+01, .393109D+01, .342803D+01,
     +  .299227D+01, .261277D+01, .228076D+01, .198926D+01,
     +  .173265D+01, .150636D+01, .130659D+01, .113020D+01,
     +  .974520D+00, .837269D+00, .716476D+00, .610252D+00,
     +  .517577D+00, .436129D+00, .365275D+00, .303899D+00,
     +  .250987D+00, .205621D+00, .166960D+00, .134237D+00,
     +  .106761D+00, .838985D-01, .649893D-01, .496870D-01,
     +  .372734D-01, .274200D-01, .197229D-01, .138203D-01,
     +  .939139D-02, .614952D-02, .385714D-02, .228466D-02,
     +  .126534D-02, .640338D-03, .286872D-03, .108061D-03,
     +  .312721D-04, .603325D-05, .619467D-06, .000000D+00 /
        DATA (UPDI(I),I=8737,8788) /
     +  .283003D+07, .210082D+07, .152749D+07, .111006D+07,
     +  .806188D+06, .585118D+06, .424395D+06, .307620D+06,
     +  .222835D+06, .161316D+06, .116710D+06, .843874D+05,
     +  .609829D+05, .440465D+05, .317993D+05, .229482D+05,
     +  .165560D+05, .119419D+05, .861339D+04, .621324D+04,
     +  .448351D+04, .323711D+04, .233939D+04, .169268D+04,
     +  .122689D+04, .891078D+03, .649203D+03, .472553D+03,
     +  .347059D+03, .256213D+03, .190300D+03, .142343D+03,
     +  .107319D+03, .817008D+02, .627629D+02, .487236D+02,
     +  .382425D+02, .303549D+02, .243663D+02, .197730D+02,
     +  .162184D+02, .134324D+02, .112252D+02, .945613D+01,
     +  .802211D+01, .684666D+01, .587642D+01, .505948D+01,
     +  .437398D+01, .378691D+01, .328559D+01, .285315D+01 /
        DATA (UPDI(I),I=8789,8840) /
     +  .247823D+01, .215180D+01, .186666D+01, .161699D+01,
     +  .139803D+01, .120586D+01, .103719D+01, .889219D+00,
     +  .759584D+00, .646217D+00, .547162D+00, .461309D+00,
     +  .386358D+00, .321597D+00, .265885D+00, .218191D+00,
     +  .177590D+00, .143239D+00, .114379D+00, .903289D-01,
     +  .704722D-01, .541788D-01, .411015D-01, .305825D-01,
     +  .223068D-01, .159016D-01, .110372D-01, .742457D-02,
     +  .480896D-02, .298107D-02, .174307D-02, .951727D-03,
     +  .474003D-03, .208539D-03, .769439D-04, .217614D-04,
     +  .411667D-05, .426921D-06, .000000D+00, .345639D+07,
     +  .255750D+07, .185229D+07, .134077D+07, .969829D+06,
     +  .701010D+06, .506341D+06, .365468D+06, .263600D+06,
     +  .189992D+06, .136843D+06, .984960D+05, .708493D+05 /
        DATA (UPDI(I),I=8841,8892) /
     +  .509313D+05, .365929D+05, .262780D+05, .188633D+05,
     +  .135365D+05, .971261D+04, .696881D+04, .500138D+04,
     +  .359097D+04, .258044D+04, .185633D+04, .133762D+04,
     +  .965714D+03, .699362D+03, .505948D+03, .369341D+03,
     +  .271022D+03, .200102D+03, .148802D+03, .111551D+03,
     +  .844563D+02, .645371D+02, .498482D+02, .389368D+02,
     +  .307638D+02, .245853D+02, .198651D+02, .162254D+02,
     +  .133821D+02, .111361D+02, .934110D+01, .789006D+01,
     +  .670388D+01, .572762D+01, .490808D+01, .422269D+01,
     +  .363782D+01, .314033D+01, .271301D+01, .234419D+01,
     +  .202463D+01, .174691D+01, .150503D+01, .129408D+01,
     +  .111000D+01, .949374D+00, .809321D+00, .687375D+00,
     +  .581401D+00, .489393D+00, .410163D+00, .341449D+00 /
        DATA (UPDI(I),I=8893,8944) /
     +  .282474D+00, .232085D+00, .189245D+00, .153031D+00,
     +  .122612D+00, .972423D-01, .762588D-01, .590666D-01,
     +  .450701D-01, .339276D-01, .250404D-01, .181096D-01,
     +  .127945D-01, .879678D-02, .585796D-02, .375325D-02,
     +  .229953D-02, .132735D-02, .714529D-03, .350260D-03,
     +  .151352D-03, .547149D-04, .151319D-04, .280959D-05,
     +  .294219D-06, .000000D+00, .690363D+05, .100780D+06,
     +  .775819D+05, .597301D+05, .459918D+05, .354183D+05,
     +  .272802D+05, .210160D+05, .161937D+05, .124812D+05,
     +  .962255D+04, .742118D+04, .572566D+04, .441953D+04,
     +  .341314D+04, .263752D+04, .203959D+04, .157849D+04,
     +  .122278D+04, .948260D+03, .736289D+03, .572526D+03,
     +  .445926D+03, .347985D+03, .272151D+03, .213377D+03 /
        DATA (UPDI(I),I=8945,8996) /
     +  .167775D+03, .131908D+03, .104455D+03, .830595D+02,
     +  .663530D+02, .532801D+02, .430253D+02, .349801D+02,
     +  .286142D+02, .235740D+02, .195665D+02, .163643D+02,
     +  .137911D+02, .117092D+02, .100150D+02, .862308D+01,
     +  .747017D+01, .650653D+01, .569360D+01, .500156D+01,
     +  .440926D+01, .389311D+01, .344545D+01, .304986D+01,
     +  .270182D+01, .239302D+01, .211807D+01, .187259D+01,
     +  .165303D+01, .145643D+01, .128033D+01, .112263D+01,
     +  .981515D+00, .855406D+00, .742893D+00, .642715D+00,
     +  .553730D+00, .475242D+00, .405495D+00, .344128D+00,
     +  .290338D+00, .243387D+00, .202594D+00, .167334D+00,
     +  .137031D+00, .111154D+00, .892005D-01, .707082D-01,
     +  .554115D-01, .427013D-01, .323434D-01, .240144D-01 /
        DATA (UPDI(I),I=8997,9048) /
     +  .174203D-01, .122950D-01, .839772D-02, .551608D-02,
     +  .344114D-02, .201988D-02, .109188D-02, .527384D-03,
     +  .216366D-03, .685688D-04, .135633D-04, .846929D-06,
     +  .000000D+00, .160093D+06, .124218D+06, .951561D+05,
     +  .729075D+05, .558713D+05, .428245D+05, .328316D+05,
     +  .251766D+05, .193117D+05, .148174D+05, .113729D+05,
     +  .873243D+04, .670787D+04, .515519D+04, .396410D+04,
     +  .305013D+04, .234857D+04, .180987D+04, .139605D+04,
     +  .107802D+04, .833476D+03, .645327D+03, .500476D+03,
     +  .388870D+03, .302808D+03, .236371D+03, .185037D+03,
     +  .144822D+03, .114166D+03, .903687D+02, .718600D+02,
     +  .574335D+02, .461607D+02, .373507D+02, .304058D+02,
     +  .249278D+02, .205880D+02, .171326D+02, .143657D+02 /
        DATA (UPDI(I),I=9049,9100) /
     +  .121349D+02, .103257D+02, .884453D+01, .762202D+01,
     +  .660396D+01, .574844D+01, .502310D+01, .440501D+01,
     +  .386883D+01, .340608D+01, .299924D+01, .264321D+01,
     +  .232906D+01, .205092D+01, .180403D+01, .158447D+01,
     +  .138903D+01, .121499D+01, .106005D+01, .922221D+00,
     +  .799762D+00, .691141D+00, .595003D+00, .510080D+00,
     +  .435606D+00, .369806D+00, .312245D+00, .262083D+00,
     +  .218554D+00, .180956D+00, .148652D+00, .121055D+00,
     +  .976323D-01, .778928D-01, .613677D-01, .477894D-01,
     +  .365846D-01, .275191D-01, .202838D-01, .146008D-01,
     +  .102207D-01, .691886D-02, .450123D-02, .277838D-02,
     +  .161174D-02, .859855D-03, .409831D-03, .165502D-03,
     +  .514465D-04, .998197D-05, .631777D-06, .000000D+00 /
        DATA (UPDI(I),I=9101,9152) /
     +  .203226D+06, .157001D+06, .119672D+06, .912369D+05,
     +  .695715D+05, .530616D+05, .404785D+05, .308868D+05,
     +  .235741D+05, .179981D+05, .137455D+05, .105015D+05,
     +  .802644D+04, .613758D+04, .469573D+04, .359477D+04,
     +  .275386D+04, .211132D+04, .162019D+04, .124460D+04,
     +  .957247D+03, .737254D+03, .568736D+03, .439541D+03,
     +  .340419D+03, .264281D+03, .205752D+03, .160135D+03,
     +  .125538D+03, .988165D+02, .781384D+02, .621018D+02,
     +  .496331D+02, .399363D+02, .323293D+02, .263575D+02,
     +  .216485D+02, .179162D+02, .149408D+02, .125521D+02,
     +  .106231D+02, .905042D+01, .775778D+01, .668585D+01,
     +  .578892D+01, .503185D+01, .438966D+01, .383524D+01,
     +  .335912D+01, .294267D+01, .258016D+01, .226202D+01 /
        DATA (UPDI(I),I=9153,9204) /
     +  .198190D+01, .173464D+01, .151600D+01, .132248D+01,
     +  .115112D+01, .999433D+00, .865259D+00, .746724D+00,
     +  .642178D+00, .550175D+00, .469346D+00, .398857D+00,
     +  .336928D+00, .283057D+00, .236378D+00, .196100D+00,
     +  .161513D+00, .131967D+00, .106877D+00, .857092D-01,
     +  .679857D-01, .532390D-01, .412015D-01, .313358D-01,
     +  .234101D-01, .171316D-01, .122383D-01, .849807D-02,
     +  .570281D-02, .367564D-02, .224568D-02, .128817D-02,
     +  .678530D-03, .318154D-03, .126084D-03, .383636D-04,
     +  .728544D-05, .468066D-06, .000000D+00, .261334D+06,
     +  .201043D+06, .152495D+06, .115692D+06, .877842D+05,
     +  .666187D+05, .505653D+05, .383878D+05, .291493D+05,
     +  .221396D+05, .168202D+05, .127829D+05, .971817D+04 /
        DATA (UPDI(I),I=9205,9256) /
     +  .739124D+04, .562416D+04, .428187D+04, .326202D+04,
     +  .248687D+04, .189755D+04, .144929D+04, .110820D+04,
     +  .848505D+03, .650672D+03, .499848D+03, .384781D+03,
     +  .296891D+03, .229719D+03, .177666D+03, .138416D+03,
     +  .108275D+03, .850853D+02, .672037D+02, .533792D+02,
     +  .426884D+02, .343480D+02, .278360D+02, .227282D+02,
     +  .187008D+02, .155060D+02, .129537D+02, .109024D+02,
     +  .923767D+01, .787560D+01, .675120D+01, .581466D+01,
     +  .502779D+01, .436349D+01, .379275D+01, .330505D+01,
     +  .288066D+01, .251317D+01, .219237D+01, .191144D+01,
     +  .166480D+01, .144791D+01, .125699D+01, .108888D+01,
     +  .940875D+00, .810681D+00, .696293D+00, .595959D+00,
     +  .508149D+00, .431414D+00, .364859D+00, .306705D+00 /
        DATA (UPDI(I),I=9257,9308) /
     +  .256397D+00, .213044D+00, .175846D+00, .144082D+00,
     +  .117103D+00, .943253D-01, .752227D-01, .593283D-01,
     +  .461832D-01, .355224D-01, .268432D-01, .199192D-01,
     +  .144741D-01, .102627D-01, .706988D-02, .470387D-02,
     +  .300408D-02, .181701D-02, .103084D-02, .536349D-03,
     +  .248032D-03, .967644D-04, .288899D-04, .539917D-05,
     +  .352453D-06, .000000D+00, .210378D+06, .258406D+06,
     +  .195090D+06, .147307D+06, .111236D+06, .840044D+05,
     +  .634462D+05, .479250D+05, .362061D+05, .273573D+05,
     +  .206753D+05, .156291D+05, .118178D+05, .893890D+04,
     +  .676397D+04, .512056D+04, .387859D+04, .293973D+04,
     +  .222984D+04, .169288D+04, .128660D+04, .979022D+03,
     +  .746072D+03, .569509D+03, .435603D+03, .333928D+03 /
        DATA (UPDI(I),I=9309,9360) /
     +  .256694D+03, .197210D+03, .152633D+03, .118610D+03,
     +  .925945D+02, .726567D+02, .573362D+02, .455598D+02,
     +  .364269D+02, .293377D+02, .238087D+02, .194732D+02,
     +  .160525D+02, .133338D+02, .111597D+02, .940390D+01,
     +  .797416D+01, .679945D+01, .582560D+01, .501123D+01,
     +  .432701D+01, .374197D+01, .324455D+01, .281388D+01,
     +  .244286D+01, .212068D+01, .184001D+01, .159492D+01,
     +  .138054D+01, .119284D+01, .102844D+01, .884483D+00,
     +  .758527D+00, .648451D+00, .552416D+00, .468819D+00,
     +  .396144D+00, .333446D+00, .278953D+00, .232065D+00,
     +  .191878D+00, .157584D+00, .128462D+00, .103865D+00,
     +  .832154D-01, .659991D-01, .517617D-01, .400570D-01,
     +  .306244D-01, .229956D-01, .169512D-01, .122317D-01 /
        DATA (UPDI(I),I=9361,9412) /
     +  .860906D-02, .588439D-02, .388218D-02, .245698D-02,
     +  .147144D-02, .825772D-03, .424494D-03, .193659D-03,
     +  .744008D-04, .218342D-04, .402334D-05, .267307D-06,
     +  .000000D+00, .462597D+06, .352767D+06, .264853D+06,
     +  .198855D+06, .149298D+06, .112090D+06, .841537D+05,
     +  .631809D+05, .474364D+05, .356172D+05, .267451D+05,
     +  .200854D+05, .150863D+05, .113338D+05, .851698D+04,
     +  .640232D+04, .481474D+04, .362266D+04, .272748D+04,
     +  .205504D+04, .154985D+04, .117013D+04, .884631D+03,
     +  .669839D+03, .508161D+03, .386327D+03, .294499D+03,
     +  .224327D+03, .172156D+03, .132651D+03, .102682D+03,
     +  .798959D+02, .625243D+02, .492755D+02, .390797D+02,
     +  .312251D+02, .251445D+02, .204106D+02, .167015D+02 /
        DATA (UPDI(I),I=9413,9464) /
     +  .137734D+02, .114469D+02, .957984D+01, .806880D+01,
     +  .683476D+01, .581782D+01, .497245D+01, .426646D+01,
     +  .366645D+01, .315945D+01, .272323D+01, .234982D+01,
     +  .202764D+01, .174879D+01, .150688D+01, .129666D+01,
     +  .111381D+01, .954715D+00, .816319D+00, .696020D+00,
     +  .591577D+00, .501054D+00, .422771D+00, .355151D+00,
     +  .297194D+00, .247152D+00, .204378D+00, .167960D+00,
     +  .137090D+00, .111053D+00, .892126D-01, .710059D-01,
     +  .559351D-01, .435647D-01, .334697D-01, .253977D-01,
     +  .189218D-01, .138340D-01, .989631D-02, .690176D-02,
     +  .467151D-02, .304957D-02, .190815D-02, .112845D-02,
     +  .624496D-03, .315985D-03, .141541D-03, .532091D-04,
     +  .152055D-04, .272110D-05, .182605D-06, .000000D+00 /
        DATA (UPDI(I),I=9465,9516) /
     +  .627679D+06, .476518D+06, .355882D+06, .265769D+06,
     +  .198446D+06, .148158D+06, .110600D+06, .825537D+05,
     +  .616143D+05, .459829D+05, .343158D+05, .256086D+05,
     +  .191113D+05, .142635D+05, .106468D+05, .794873D+04,
     +  .593607D+04, .443463D+04, .331461D+04, .247897D+04,
     +  .185549D+04, .139014D+04, .104277D+04, .783312D+03,
     +  .589459D+03, .444466D+03, .336024D+03, .253796D+03,
     +  .193140D+03, .147570D+03, .113272D+03, .874001D+02,
     +  .678307D+02, .530220D+02, .417136D+02, .330679D+02,
     +  .264243D+02, .212893D+02, .172940D+02, .141610D+02,
     +  .116880D+02, .971570D+01, .812926D+01, .684137D+01,
     +  .578634D+01, .491444D+01, .419060D+01, .357905D+01,
     +  .306544D+01, .262623D+01, .225259D+01, .193222D+01 /
        DATA (UPDI(I),I=9517,9568) /
     +  .165669D+01, .141918D+01, .121410D+01, .103686D+01,
     +  .883627D+00, .751191D+00, .636810D+00, .538142D+00,
     +  .453174D+00, .380166D+00, .317502D+00, .264138D+00,
     +  .218359D+00, .179484D+00, .146604D+00, .118918D+00,
     +  .957241D-01, .764023D-01, .604072D-01, .472623D-01,
     +  .365527D-01, .278779D-01, .209956D-01, .155189D-01,
     +  .112525D-01, .797984D-02, .551418D-02, .369593D-02,
     +  .238742D-02, .147705D-02, .862768D-03, .471047D-03,
     +  .234793D-03, .103424D-03, .381574D-04, .106830D-04,
     +  .188219D-05, .128946D-06, .000000D+00, .839216D+06,
     +  .634432D+06, .471458D+06, .350294D+06, .260205D+06,
     +  .193239D+06, .143474D+06, .106502D+06, .790407D+05,
     +  .586493D+05, .435116D+05, .322765D+05, .239401D+05 /
        DATA (UPDI(I),I=9569,9620) /
     +  .177558D+05, .131690D+05, .976760D+04, .724580D+04,
     +  .537626D+04, .399051D+04, .296330D+04, .220196D+04,
     +  .163754D+04, .121910D+04, .908757D+03, .678532D+03,
     +  .507574D+03, .380663D+03, .285152D+03, .215234D+03,
     +  .163106D+03, .124172D+03, .950294D+02, .731551D+02,
     +  .567286D+02, .442793D+02, .348321D+02, .276254D+02,
     +  .220944D+02, .178205D+02, .144912D+02, .118799D+02,
     +  .981022D+01, .815538D+01, .681985D+01, .573214D+01,
     +  .483838D+01, .410070D+01, .348107D+01, .296376D+01,
     +  .252402D+01, .215219D+01, .183532D+01, .156448D+01,
     +  .133245D+01, .113336D+01, .962369D+00, .815472D+00,
     +  .689304D+00, .581022D+00, .488203D+00, .408775D+00,
     +  .340959D+00, .283112D+00, .234163D+00, .192439D+00 /
        DATA (UPDI(I),I=9621,9672) /
     +  .157235D+00, .127654D+00, .102909D+00, .823173D-01,
     +  .652797D-01, .512730D-01, .398443D-01, .306011D-01,
     +  .231693D-01, .173190D-01, .127009D-01, .913357D-02,
     +  .642122D-02, .439664D-02, .291827D-02, .186541D-02,
     +  .114119D-02, .658448D-03, .354701D-03, .174196D-03,
     +  .754766D-04, .273427D-04, .750839D-05, .130466D-05,
     +  .914950D-07, .000000D+00, .110417D+07, .831401D+06,
     +  .614902D+06, .454668D+06, .336073D+06, .248328D+06,
     +  .183431D+06, .135449D+06, .999874D+05, .737874D+05,
     +  .544376D+05, .401516D+05, .296082D+05, .218292D+05,
     +  .160920D+05, .118617D+05, .874351D+04, .644555D+04,
     +  .475256D+04, .350535D+04, .258678D+04, .191017D+04,
     +  .141186D+04, .104473D+04, .774243D+03, .574771D+03 /
        DATA (UPDI(I),I=9673,9724) /
     +  .427749D+03, .317898D+03, .238071D+03, .178991D+03,
     +  .135189D+03, .102647D+03, .784019D+02, .603290D+02,
     +  .467319D+02, .364879D+02, .287284D+02, .228139D+02,
     +  .182740D+02, .147601D+02, .120211D+02, .986320D+01,
     +  .814786D+01, .677142D+01, .565673D+01, .474590D+01,
     +  .399840D+01, .337406D+01, .285583D+01, .241787D+01,
     +  .204974D+01, .173790D+01, .147295D+01, .124735D+01,
     +  .105495D+01, .890726D+00, .750505D+00, .630813D+00,
     +  .528722D+00, .441751D+00, .367789D+00, .305030D+00,
     +  .251826D+00, .207087D+00, .169192D+00, .137421D+00,
     +  .110896D+00, .888521D-01, .706293D-01, .556527D-01,
     +  .434250D-01, .335183D-01, .255641D-01, .192157D-01,
     +  .142567D-01, .103735D-01, .739881D-02, .515688D-02 /
        DATA (UPDI(I),I=9725,9776) /
     +  .349884D-02, .229989D-02, .145488D-02, .880147D-03,
     +  .501665D-03, .266669D-03, .129054D-03, .550146D-04,
     +  .195764D-04, .527573D-05, .904562D-06, .648922D-07,
     +  .000000D+00, .142936D+07, .107218D+07, .789390D+06,
     +  .580998D+06, .427435D+06, .314324D+06, .231046D+06,
     +  .169759D+06, .124678D+06, .915310D+05, .671707D+05,
     +  .492754D+05, .361357D+05, .264916D+05, .194166D+05,
     +  .142281D+05, .104248D+05, .763776D+04, .559628D+04,
     +  .410118D+04, .300664D+04, .220535D+04, .161891D+04,
     +  .118959D+04, .875343D+03, .645122D+03, .476591D+03,
     +  .351533D+03, .261289D+03, .194967D+03, .146144D+03,
     +  .110129D+03, .834855D+02, .637659D+02, .490337D+02,
     +  .380111D+02, .297183D+02, .234390D+02, .186497D+02 /
        DATA (UPDI(I),I=9777,9828) /
     +  .149658D+02, .121113D+02, .987540D+01, .810807D+01,
     +  .669774D+01, .556187D+01, .463877D+01, .388537D+01,
     +  .325956D+01, .274303D+01, .230901D+01, .194628D+01,
     +  .164081D+01, .138280D+01, .116442D+01, .979287D+00,
     +  .822212D+00, .688905D+00, .575804D+00, .479919D+00,
     +  .398731D+00, .330109D+00, .272235D+00, .223471D+00,
     +  .182718D+00, .148413D+00, .119834D+00, .961246D-01,
     +  .765478D-01, .604702D-01, .473446D-01, .367011D-01,
     +  .281383D-01, .213126D-01, .159046D-01, .117126D-01,
     +  .845595D-02, .598200D-02, .413365D-02, .277920D-02,
     +  .180926D-02, .113269D-02, .677658D-03, .381592D-03,
     +  .200180D-03, .954784D-04, .400539D-04, .140048D-04,
     +  .370594D-05, .627227D-06, .459963D-07, .000000D+00 /
        DATA (UPDI(I),I=9829,9880) /
     +  .182134D+07, .136125D+07, .997869D+06, .731200D+06,
     +  .535519D+06, .392003D+06, .286800D+06, .209722D+06,
     +  .153281D+06, .111974D+06, .817583D+05, .596681D+05,
     +  .435273D+05, .317395D+05, .231356D+05, .168585D+05,
     +  .122816D+05, .894566D+04, .651554D+04, .474578D+04,
     +  .345757D+04, .251999D+04, .183789D+04, .134156D+04,
     +  .980514D+03, .717663D+03, .526492D+03, .385561D+03,
     +  .284540D+03, .210793D+03, .156870D+03, .117361D+03,
     +  .883317D+02, .669907D+02, .511538D+02, .393830D+02,
     +  .305843D+02, .239639D+02, .189454D+02, .151078D+02,
     +  .121514D+02, .984836D+01, .803788D+01, .660080D+01,
     +  .544953D+01, .451883D+01, .376329D+01, .313906D+01,
     +  .262669D+01, .219853D+01, .184274D+01, .154481D+01 /
        DATA (UPDI(I),I=9881,9932) /
     +  .129463D+01, .108410D+01, .906680D+00, .757032D+00,
     +  .630781D+00, .524303D+00, .434572D+00, .359050D+00,
     +  .295600D+00, .242410D+00, .197862D+00, .160859D+00,
     +  .129902D+00, .104272D+00, .831436D-01, .658090D-01,
     +  .516650D-01, .401944D-01, .309557D-01, .235748D-01,
     +  .177331D-01, .131385D-01, .960400D-02, .687985D-02,
     +  .482750D-02, .330739D-02, .220361D-02, .142079D-02,
     +  .880348D-03, .520896D-03, .289804D-03, .150049D-03,
     +  .705456D-04, .291296D-04, .100112D-04, .260253D-05,
     +  .434967D-06, .325833D-07, .000000D+00, .228619D+07,
     +  .170273D+07, .124298D+07, .906947D+06, .661367D+06,
     +  .481998D+06, .351065D+06, .255547D+06, .185907D+06,
     +  .135165D+06, .982165D+05, .713274D+05, .517720D+05 /
        DATA (UPDI(I),I=9933,9984) /
     +  .375585D+05, .272344D+05, .197397D+05, .143024D+05,
     +  .103598D+05, .750276D+04, .543322D+04, .393503D+04,
     +  .285067D+04, .206625D+04, .149878D+04, .108841D+04,
     +  .791430D+03, .576771D+03, .419511D+03, .307499D+03,
     +  .226248D+03, .167218D+03, .124247D+03, .928774D+02,
     +  .699640D+02, .530686D+02, .405897D+02, .313194D+02,
     +  .243857D+02, .191604D+02, .151872D+02, .121430D+02,
     +  .978420D+01, .793950D+01, .648278D+01, .532175D+01,
     +  .438794D+01, .363381D+01, .301402D+01, .250801D+01,
     +  .208747D+01, .173994D+01, .145055D+01, .120893D+01,
     +  .100676D+01, .837366D+00, .695319D+00, .576180D+00,
     +  .476288D+00, .392603D+00, .322586D+00, .264108D+00,
     +  .215379D+00, .174809D+00, .141313D+00, .113461D+00 /
        DATA (UPDI(I),I=9985,10036) /
     +  .905430D-01, .717681D-01, .564621D-01, .440537D-01,
     +  .340565D-01, .260588D-01, .197133D-01, .147267D-01,
     +  .108330D-01, .786039D-02, .558727D-02, .388878D-02,
     +  .264159D-02, .174419D-02, .111383D-02, .683093D-03,
     +  .399759D-03, .219761D-03, .112314D-03, .520578D-04,
     +  .211626D-04, .715126D-05, .182715D-05, .301671D-06,
     +  .230685D-07, .000000D+00, .282940D+07, .210026D+07,
     +  .152700D+07, .110963D+07, .805806D+06, .584781D+06,
     +  .424098D+06, .307359D+06, .222604D+06, .161113D+06,
     +  .116530D+06, .842295D+05, .608439D+05, .439241D+05,
     +  .316917D+05, .228536D+05, .164728D+05, .118688D+05,
     +  .854920D+04, .615689D+04, .443407D+04, .319375D+04,
     +  .230137D+04, .165936D+04, .119768D+04, .865483D+03 /
        DATA (UPDI(I),I=10037,10088) /
     +  .626778D+03, .452940D+03, .329867D+03, .241133D+03,
     +  .177060D+03, .130705D+03, .970717D+02, .726553D+02,
     +  .547605D+02, .416226D+02, .319196D+02, .247038D+02,
     +  .192960D+02, .152060D+02, .120887D+02, .968548D+01,
     +  .781542D+01, .634598D+01, .518060D+01, .424792D+01,
     +  .349853D+01, .288575D+01, .238810D+01, .197672D+01,
     +  .163859D+01, .135859D+01, .112610D+01, .932667D+00,
     +  .771511D+00, .637146D+00, .525099D+00, .431696D+00,
     +  .353902D+00, .289193D+00, .235465D+00, .190957D+00,
     +  .154119D+00, .123887D+00, .988986D-01, .784636D-01,
     +  .618262D-01, .483478D-01, .374909D-01, .288008D-01,
     +  .218950D-01, .164535D-01, .122073D-01, .891573D-02,
     +  .642172D-02, .452946D-02, .312710D-02, .210619D-02 /
        DATA (UPDI(I),I=10089,10140) /
     +  .137822D-02, .871748D-03, .529186D-03, .306319D-03,
     +  .166402D-03, .839536D-04, .383683D-04, .153592D-04,
     +  .510478D-05, .128244D-05, .209246D-06, .163233D-07,
     +  .000000D+00, .345572D+07, .255691D+07, .185177D+07,
     +  .134032D+07, .969426D+06, .700654D+06, .506027D+06,
     +  .365191D+06, .263357D+06, .189777D+06, .136654D+06,
     +  .983295D+05, .707028D+05, .508024D+05, .364796D+05,
     +  .261784D+05, .187758D+05, .134597D+05, .964516D+04,
     +  .690964D+04, .494949D+04, .354548D+04, .254057D+04,
     +  .182141D+04, .130704D+04, .938924D+03, .675905D+03,
     +  .485443D+03, .351378D+03, .255276D+03, .186287D+03,
     +  .136667D+03, .100875D+03, .750420D+02, .562183D+02,
     +  .424767D+02, .323843D+02, .249195D+02, .193545D+02 /
        DATA (UPDI(I),I=10141,10192) /
     +  .151671D+02, .119914D+02, .955504D+01, .766827D+01,
     +  .619273D+01, .502812D+01, .410054D+01, .335890D+01,
     +  .275550D+01, .226798D+01, .186707D+01, .153931D+01,
     +  .126936D+01, .104645D+01, .862013D+00, .709212D+00,
     +  .582532D+00, .477493D+00, .390432D+00, .318336D+00,
     +  .258712D+00, .209494D+00, .168958D+00, .135605D+00,
     +  .108393D+00, .860362D-01, .678637D-01, .531593D-01,
     +  .413211D-01, .318459D-01, .243108D-01, .183627D-01,
     +  .137078D-01, .101008D-01, .732476D-02, .523716D-02,
     +  .366556D-02, .251032D-02, .167648D-02, .108724D-02,
     +  .681181D-03, .409315D-03, .234368D-03, .125819D-03,
     +  .626718D-04, .282455D-04, .111365D-04, .364152D-05,
     +  .899880D-06, .145153D-06, .115445D-07, .000000D+00 /
C-----------------------------------------------------------------------
C
      Dr = DrI
      Fl = FlI
      Al = AlI
      DO I=1,6
         Amass(I) = AmassI(I)
      ENDDO
      Iorder = Nint(Dr)
      Nfl = Nint(Fl)
      Alambda = Al
C
      NX = NxI
      NT = NTI
      NfMx = NfMxI
C
      QINI = QINII
      QMAX = QMAXI
      DO I=0,NT
         QL(I) = QLI(I)
      ENDDO
C
      XMIN = XMINI
      DO I=0,NX
         XV(I) = XVI(I)
      ENDDO
C
      Do 11 Iq = 0, NT
         QL(Iq) = Log (QL(Iq) /Al)
   11 Continue
C
C                  Since quark = anti-quark for nfl>2 at this stage, 
C                  we Read  out only the non-redundent data points
C     No of flavors = NfMx (sea) + 1 (gluon) + 2 (valence) 

      Nblk = (NX+1) * (NT+1)
      Npts =  Nblk  * (NfMx+3)
      DO I=1,Npts
         UPD(I) = UPDI(I)
      ENDDO
C
      Return
C                        ****************************
      End
