#!/usr/bin/tclsh
# Part of MCU 8051 IDE ( http://mcu8051ide.sf.net )


############################################################################
#    Copyright (C) 2011 by Martin Ošmera and Monika Říhová (so far)        #
#    martin.osmera@gmail.com                                               #
#                                                                          #
#    This program is free software; you can redistribute it and#or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 2 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             #
############################################################################

# ------------------------------------------------------------------------------
#
# This file contains font definitions for HD44780 display driver simulator,
# which is a part of MCU 8051 IDE project.
#
# ------------------------------------------------------------------------------
#
# Format:
# { <-- Start all font definitions
#	n × { <-- Start one font definitions
#		240 × { <-- Start of one character definition (addr: [0x10,0xff])
#			10 × { <-- Start of one row on the character patter (starting from the top)
#				5 × {0|1} <-- Dots in the patter (0 == blank; 1 == filled)
#			} <-- End of one row on the character patter
#		} <-- End of one character definition
#	} <-- End one font definitions
# } <-- End all font definitions
#
# ------------------------------------------------------------------------------
#
# An example of a character definition:
#
# {  PATTERN:     CHARACTER:
#   {1 1 1 1 0} | # # # #
#   {1 0 0 0 1} | #       #
#   {1 0 0 0 1} | #       #
#   {1 1 1 1 0} | # # # #
#   {1 0 0 0 1} | #       #
#   {1 0 0 0 1} | #       #
#   {1 1 1 1 0} | # # # #
#   {0 0 0 0 0} |
#   {0 0 0 0 0} |
#   {0 0 0 0 0} |
# }
#
# ------------------------------------------------------------------------------

common CGROM {
{
	{
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}
	{
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}


	{
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 1 0 0} {0 0 1 0 0} {0 0 1 0 0} {0 0 1 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 0 1 0} {0 1 0 1 0} {0 1 0 1 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 0 1 0} {0 1 0 1 0} {1 1 1 1 1} {0 1 0 1 0} {1 1 1 1 1}
		{0 1 0 1 0} {0 1 0 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 1 0 0} {0 1 1 1 1} {1 0 1 0 0} {0 1 1 1 0} {0 0 1 0 1}
		{1 1 1 1 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{1 1 0 0 0} {1 1 0 0 1} {0 0 0 1 0} {0 0 1 0 0} {0 1 0 0 0}
		{1 0 0 1 1} {0 0 0 1 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 1 0 0} {1 0 0 1 0} {1 0 1 0 0} {0 1 0 0 0} {1 0 1 0 1}
		{1 0 0 1 0} {0 1 1 0 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 1 0 0} {0 0 1 0 0} {0 1 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}
	{
		{0 0 0 1 0} {0 0 1 0 0} {0 1 0 0 0} {0 1 0 0 0} {0 1 0 0 0}
		{0 0 1 0 0} {0 0 0 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 0 0 0} {0 0 1 0 0} {0 0 0 1 0} {0 0 0 1 0} {0 0 0 1 0}
		{0 0 1 0 0} {0 1 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 1 0 0} {1 0 1 0 1} {0 1 1 1 0} {1 0 1 0 1}
		{0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 1 0 0} {0 0 1 0 0} {1 1 1 1 1} {0 0 1 0 0}
		{0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 1 1 0 0}
		{0 0 1 0 0} {0 1 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {1 1 1 1 1} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 1 1 0 0} {0 1 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 1} {0 0 0 1 0} {0 0 1 0 0} {0 1 0 0 0}
		{1 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}


	{
		{0 1 1 1 0} {1 0 0 0 1} {1 0 0 1 1} {1 0 1 0 1} {1 1 0 0 1}
		{1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 1 0 0} {0 1 1 0 0} {0 0 1 0 0} {0 0 1 0 0} {0 0 1 0 0}
		{0 0 1 0 0} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 1 1 0} {1 0 0 0 1} {0 0 0 0 1} {0 0 0 1 0} {0 0 1 0 0}
		{0 1 0 0 0} {1 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{1 1 1 1 1} {0 0 0 1 0} {0 0 1 0 0} {0 0 0 1 0} {0 0 0 0 1}
		{1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 1 0} {0 0 1 1 0} {0 1 0 1 0} {1 0 0 1 0} {1 1 1 1 1}
		{0 0 0 1 0} {0 0 0 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{1 1 1 1 1} {1 0 0 0 0} {1 1 1 1 0} {0 0 0 0 1} {0 0 0 0 1}
		{1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 1 1 0} {0 1 0 0 0} {1 0 0 0 0} {1 1 1 1 0} {1 0 0 0 1}
		{1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{1 1 1 1 1} {1 0 0 0 1} {0 0 0 0 1} {0 0 0 1 0} {0 0 1 0 0}
		{0 0 1 0 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}
	{
		{0 1 1 1 0} {1 0 0 0 1} {1 0 0 0 1} {0 1 1 1 0} {1 0 0 0 1}
		{1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 1 1 0} {1 0 0 0 1} {1 0 0 0 1} {0 1 1 1 1} {0 0 0 0 1}
		{0 0 0 1 0} {0 1 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 1 0 0} {0 1 1 0 0} {0 0 0 0 0} {0 1 1 0 0}
		{0 1 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 1 0 0} {0 1 1 0 0} {0 0 0 0 0} {0 1 1 0 0}
		{0 0 1 0 0} {0 1 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 1 0} {0 0 1 0 0} {0 1 0 0 0} {1 0 0 0 0} {0 1 0 0 0}
		{0 0 1 0 0} {0 0 0 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {1 1 1 1 1} {0 0 0 0 0} {1 1 1 1 1}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 0 0 0} {0 0 1 0 0} {0 0 0 1 0} {0 0 0 0 1} {0 0 0 1 0}
		{0 0 1 0 0} {0 1 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 1 1 0} {1 0 0 0 1} {0 0 0 0 1} {0 0 0 1 0} {0 0 1 0 0}
		{0 0 0 0 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}


	{
		{0 1 1 1 0} {1 0 0 0 1} {0 0 0 0 1} {0 1 1 0 1} {1 0 1 0 1}
		{1 0 1 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 1 1 0} {1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1} {1 1 1 1 1}
		{1 0 0 0 1} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{1 1 1 1 0} {1 0 0 0 1} {1 0 0 0 1} {1 1 1 1 0} {1 0 0 0 1}
		{1 0 0 0 1} {1 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 1 1 0} {1 0 0 0 1} {1 0 0 0 0} {1 0 0 0 0} {1 0 0 0 0}
		{1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{1 1 1 0 0} {1 0 0 1 0} {1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1}
		{1 0 0 1 0} {1 1 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{1 1 1 1 1} {1 0 0 0 0} {1 0 0 0 0} {1 1 1 1 0} {1 0 0 0 0}
		{1 0 0 0 0} {1 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{1 1 1 1 1} {1 0 0 0 0} {1 0 0 0 0} {1 1 1 1 0} {1 0 0 0 0}
		{1 0 0 0 0} {1 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 1 1 0} {1 0 0 0 1} {1 0 0 0 0} {1 0 1 1 1} {1 0 0 0 1}
		{1 0 0 0 1} {0 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}
	{
		{1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1} {1 1 1 1 1} {1 0 0 0 1}
		{1 0 0 0 1} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 1 1 0} {0 0 1 0 0} {0 0 1 0 0} {0 0 1 0 0} {0 0 1 0 0}
		{0 0 1 0 0} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 1 1 1} {0 0 0 1 0} {0 0 0 1 0} {0 0 0 1 0} {0 0 0 1 0}
		{1 0 0 1 0} {0 1 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{1 0 0 0 1} {1 0 0 1 0} {1 0 1 0 0} {1 1 0 0 0} {1 0 1 0 0}
		{1 0 0 1 0} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{1 0 0 0 0} {1 0 0 0 0} {1 0 0 0 0} {1 0 0 0 0} {1 0 0 0 0}
		{1 0 0 0 0} {1 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{1 0 0 0 1} {1 1 0 1 1} {1 0 1 0 1} {1 0 1 0 1} {1 0 0 0 1}
		{1 0 0 0 1} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{1 0 0 0 1} {1 0 0 0 1} {1 1 0 0 1} {1 0 1 0 1} {1 0 0 1 1}
		{1 0 0 0 1} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 1 1 0} {1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1}
		{1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}


	{
		{1 1 1 1 0} {1 0 0 0 1} {1 0 0 0 1} {1 1 1 1 0} {1 0 0 0 0}
		{1 0 0 0 0} {1 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 1 1 0} {1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1} {1 0 1 0 1}
		{1 0 0 1 0} {0 1 1 0 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{1 1 1 1 0} {1 0 0 0 1} {1 0 0 0 1} {1 1 1 1 0} {1 0 1 0 0}
		{1 0 0 1 0} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 1 1 1} {1 0 0 0 0} {1 0 0 0 0} {0 1 1 1 0} {0 0 0 0 1}
		{0 0 0 0 1} {1 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{1 1 1 1 1} {0 0 1 0 0} {0 0 1 0 0} {0 0 1 0 0} {0 0 1 0 0}
		{0 0 1 0 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1}
		{1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1}
		{0 1 0 1 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1} {1 0 1 0 1} {1 0 1 0 1}
		{1 0 1 0 1} {0 1 0 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}
	{
		{1 0 0 0 1} {1 0 0 0 1} {0 1 0 1 0} {0 0 1 0 0} {0 1 0 1 0}
		{1 0 0 0 1} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1} {0 1 0 1 0} {0 0 1 0 0}
		{0 0 1 0 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{1 1 1 1 1} {0 0 0 0 1} {0 0 0 1 0} {0 0 1 0 0} {0 1 0 0 0}
		{1 0 0 0 0} {1 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{1 1 1 0 0} {1 0 0 0 0} {1 0 0 0 0} {1 0 0 0 0} {1 0 0 0 0}
		{1 0 0 0 0} {1 1 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{1 0 0 0 1} {0 1 0 1 0} {1 1 1 1 1} {0 0 1 0 0} {1 1 1 1 1}
		{0 0 1 0 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 1 1 1} {0 0 0 0 1} {0 0 0 0 1} {0 0 0 0 1} {0 0 0 0 1}
		{0 0 0 0 1} {0 0 1 1 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 1 0 0} {0 1 0 1 0} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {1 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}


	{
		{0 1 0 0 0} {0 0 1 0 0} {0 0 0 1 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 1 1 1 0} {0 0 0 0 1} {0 1 1 1 1}
		{1 0 0 0 1} {0 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{1 0 0 0 0} {1 0 0 0 0} {1 0 1 1 0} {1 1 0 0 1} {1 0 0 0 1}
		{1 0 0 0 1} {1 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 0} {1 0 0 0 0}
		{1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 1} {0 0 0 0 1} {0 1 1 0 1} {1 0 0 1 1} {1 0 0 0 1}
		{1 0 0 0 1} {0 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 1} {1 1 1 1 1}
		{1 0 0 0 0} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 1 1 0} {0 1 0 0 1} {0 1 0 0 0} {1 1 1 0 0} {0 1 0 0 0}
		{0 1 0 0 0} {0 1 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 1 1 1} {1 0 0 0 1} {1 0 0 0 1} {0 1 1 1 1}
		{0 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}
	{
		{1 0 0 0 0} {1 0 0 0 0} {1 0 1 1 0} {1 1 0 0 1} {1 0 0 0 1}
		{1 0 0 0 1} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 1 0 0} {0 0 0 0 0} {0 1 1 0 0} {0 0 1 0 0} {0 0 1 0 0}
		{0 0 1 0 0} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 1 0} {0 0 0 0 0} {0 0 1 1 0} {0 0 0 1 0} {0 0 0 1 0}
		{1 0 0 1 0} {0 1 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{1 0 0 0 0} {1 0 0 0 0} {1 0 0 1 0} {1 0 1 0 0} {1 1 0 0 0}
		{1 0 1 0 0} {1 0 0 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 1 0 0} {0 0 1 0 0} {0 0 1 0 0} {0 0 1 0 0} {0 0 1 0 0}
		{0 0 1 0 0} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {1 1 0 1 0} {1 0 1 0 1} {1 0 1 0 1}
		{1 0 0 0 1} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {1 0 1 1 0} {1 1 0 0 1} {1 0 0 0 1}
		{1 0 0 0 1} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 1} {1 0 0 0 1}
		{1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}


	{
		{0 0 0 0 0} {0 0 0 0 0} {1 1 1 1 0} {1 0 0 0 1} {1 1 1 1 0}
		{1 0 0 0 0} {1 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 1 1 0 1} {1 0 0 1 1} {0 1 1 1 1}
		{0 0 0 0 1} {0 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {1 0 1 1 0} {1 1 0 0 1} {1 0 0 0 0}
		{1 0 0 0 0} {1 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 0} {0 1 1 1 0}
		{0 0 0 0 1} {1 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 0 0 0} {0 1 0 0 0} {1 1 1 0 0} {0 1 0 0 0} {0 1 0 0 0}
		{0 1 0 0 1} {0 0 1 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1}
		{1 0 0 1 1} {0 1 1 0 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1}
		{0 1 0 1 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {1 0 0 0 1} {1 0 1 0 1} {1 0 1 0 1}
		{1 0 1 0 1} {0 1 0 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}
	{
		{0 0 0 0 0} {0 0 0 0 0} {1 0 0 0 1} {0 1 0 1 0} {0 0 1 0 0}
		{0 1 0 1 0} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {1 0 0 0 1} {1 0 0 0 1} {0 1 1 1 1}
		{0 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {1 1 1 1 1} {0 0 0 1 0} {0 0 1 0 0}
		{0 1 0 0 0} {1 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 1 0} {0 0 1 0 0} {0 0 1 0 0} {0 1 0 0 0} {0 0 1 0 0}
		{0 0 1 0 0} {0 0 0 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 1 0 0} {0 0 1 0 0} {0 0 1 0 0} {0 0 1 0 0} {0 0 1 0 0}
		{0 0 1 0 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 0 0 0} {0 0 1 0 0} {0 0 1 0 0} {0 0 0 1 0} {0 0 1 0 0}
		{0 0 1 0 0} {0 1 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 1 0 0} {0 0 0 1 0} {1 1 1 1 1} {0 0 0 1 0}
		{0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 1 0 0} {0 1 0 0 0} {1 1 1 1 1} {0 1 0 0 0}
		{0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}


	{
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}
	{
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}


	{
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}
	{
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}


	{
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 1 1 1 0}
		{0 1 0 1 0} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 1 1 1} {0 0 1 0 0} {0 0 1 0 0} {0 0 1 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 1 0 0} {0 0 1 0 0}
		{0 0 1 0 0} {1 1 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {1 0 0 0 0}
		{0 1 0 0 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 1 1 0 0} {0 1 1 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 1 1 1 1} {0 0 0 0 1} {1 1 1 1 1} {0 0 0 0 1}
		{0 0 0 1 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 1 0} {0 0 1 0 0} {0 1 1 0 0}
		{1 0 1 0 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}
	{
		{0 0 0 0 0} {0 0 0 0 0} {1 1 1 1 1} {0 0 0 0 1} {0 0 1 1 0}
		{0 0 1 0 0} {0 1 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 1 0 0} {1 1 1 1 1} {1 0 0 0 1}
		{0 0 0 0 1} {0 0 1 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {1 1 1 1 1} {0 0 1 0 0} {0 0 1 0 0}
		{0 0 1 0 0} {1 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 1 0} {1 1 1 1 1} {0 0 1 1 0}
		{0 1 0 1 0} {1 0 0 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 1 0 0 0} {1 1 1 1 1} {0 1 0 0 1}
		{0 1 0 1 0} {0 1 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 1 1 1 0} {0 0 0 1 0}
		{0 0 0 1 0} {1 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {1 1 1 1 0} {0 0 0 1 0} {1 1 1 1 0}
		{0 0 0 1 0} {1 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {1 0 1 0 1} {1 0 1 0 1}
		{0 0 0 0 1} {0 0 1 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}


	{
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {1 1 1 1 1} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{1 1 1 1 1} {0 0 0 0 1} {0 0 1 0 1} {0 0 1 1 0} {0 0 1 0 0}
		{0 0 1 0 0} {0 1 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 1} {0 0 0 1 0} {0 0 1 0 0} {0 1 1 0 0} {1 0 1 0 0}
		{0 0 1 0 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 1 0 0} {1 1 1 1 1} {1 0 0 0 1} {1 0 0 0 1} {0 0 0 0 1}
		{0 0 0 1 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 1 1 1 1} {0 0 1 0 0} {0 0 1 0 0} {0 0 1 0 0}
		{0 0 1 0 0} {1 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 1 0} {1 1 1 1 1} {0 0 0 1 0} {0 0 1 1 0} {0 1 0 1 0}
		{1 0 0 1 0} {0 0 0 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 0 0 0} {1 1 1 1 1} {0 1 0 0 1} {0 1 0 0 1} {0 1 0 0 1}
		{0 1 0 0 1} {1 0 0 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 1 0 0} {1 1 1 1 1} {0 0 1 0 0} {1 1 1 1 1} {0 0 1 0 0}
		{0 0 1 0 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}
	{
		{0 0 0 0 0} {0 1 1 1 1} {0 1 0 0 1} {1 0 0 0 1} {0 0 0 0 1}
		{0 0 0 1 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 0 0 0} {0 1 1 1 1} {1 0 0 1 0} {0 0 0 1 0} {0 0 0 1 0}
		{0 0 0 1 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{1 1 1 1 1} {0 0 0 0 1} {0 0 0 0 1} {0 0 0 0 1} {0 0 0 0 1}
		{0 0 0 0 1} {1 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 0 1 0} {1 1 1 1 1} {0 1 0 1 0} {0 1 0 1 0} {0 0 0 1 0}
		{0 0 1 0 0} {0 1 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 1 0 0 0} {0 0 0 0 1} {1 1 0 0 1} {0 0 0 0 1}
		{0 0 0 1 0} {1 1 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 1 1 1 1} {0 0 0 0 1} {0 0 0 1 0} {0 0 1 0 0}
		{0 1 0 1 0} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 0 0 0} {1 1 1 1 1} {0 1 0 0 1} {0 1 0 1 0} {0 1 0 0 0}
		{0 1 0 0 0} {0 0 1 1 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 0 0 0 1} {1 0 0 0 1} {0 1 0 0 1} {0 0 0 0 1}
		{0 0 0 1 0} {0 1 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}


	{
		{0 0 0 0 0} {0 1 1 1 1} {0 1 0 0 1} {1 0 1 0 1} {0 0 0 1 1}
		{0 0 0 1 0} {0 1 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 1 0} {1 1 1 0 0} {0 0 1 0 0} {1 1 1 1 1} {0 0 1 0 0}
		{0 0 1 0 0} {0 1 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 0 1 0 1} {1 0 1 0 1} {1 0 1 0 1} {0 0 0 0 1}
		{0 0 0 1 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 1 1 0} {0 0 0 0 0} {1 1 1 1 1} {0 0 1 0 0} {0 0 1 0 0}
		{0 0 1 0 0} {0 1 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 0 0 0} {0 1 0 0 0} {0 1 0 0 0} {0 1 1 0 0} {0 1 0 1 0}
		{0 1 0 0 0} {0 1 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 1 0 0} {0 0 1 0 0} {1 1 1 1 1} {0 0 1 0 0} {0 0 1 0 0}
		{0 1 0 0 0} {1 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {1 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 1 1 1 1} {0 0 0 0 1} {0 1 0 1 0} {0 0 1 0 0}
		{0 1 0 1 0} {1 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}
	{
		{0 0 1 0 0} {1 1 1 1 1} {0 0 0 1 0} {0 0 1 0 0} {0 1 1 1 0}
		{1 0 1 0 1} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 1 0} {0 0 0 1 0} {0 0 0 1 0} {0 0 0 1 0} {0 0 0 1 0}
		{0 0 1 0 0} {0 1 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 1 0 0} {0 0 0 1 0} {0 0 0 0 1} {1 0 0 0 1}
		{1 0 0 0 1} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 0 0 0} {0 1 0 0 0} {1 1 1 1 1} {0 1 0 0 0} {0 1 0 0 0}
		{0 1 0 0 0} {0 0 1 1 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 1 1 1 1} {0 0 0 0 1} {0 0 0 0 1} {0 0 0 0 1}
		{0 0 0 1 0} {0 1 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 0 0 0} {1 0 1 0 0} {0 0 0 1 0} {0 0 0 1 0}
		{0 0 0 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 1 0 0} {1 1 1 1 1} {0 0 1 0 0} {0 0 1 0 0} {1 0 1 0 1}
		{1 0 1 0 1} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 1 1 1 1} {0 0 0 0 1} {0 0 0 0 1} {0 1 0 1 0}
		{0 0 1 0 0} {0 0 0 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}


	{
		{0 0 0 0 0} {0 1 1 1 0} {0 0 0 0 0} {0 1 1 1 0} {0 0 0 0 0}
		{0 1 1 1 0} {0 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 1 0 0} {0 1 0 0 0} {1 0 0 0 0} {1 0 0 0 1}
		{1 1 1 1 1} {0 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 1} {0 0 0 0 1} {0 1 0 1 0} {0 0 1 0 0}
		{0 1 0 1 0} {1 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 1 1 1 1} {0 1 0 0 0} {1 1 1 1 1} {0 1 0 0 0}
		{0 1 0 0 0} {0 0 1 1 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 0 0 0} {0 1 0 0 0} {1 1 1 1 1} {0 1 0 0 1} {0 1 0 1 0}
		{0 1 0 0 0} {0 1 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 1 1 0} {0 0 0 1 0} {0 0 0 1 0} {0 0 0 1 0}
		{0 0 0 1 0} {1 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 1 1 1 1} {0 0 0 0 1} {1 1 1 1 1} {0 0 0 0 1}
		{0 0 0 0 1} {1 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 1 1 0} {0 0 0 0 0} {1 1 1 1 1} {0 0 0 0 1} {0 0 0 0 1}
		{0 0 0 1 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}
	{
		{1 0 0 1 0} {1 0 0 1 0} {1 0 0 1 0} {1 0 0 1 0} {0 0 0 1 0}
		{0 0 1 0 0} {0 1 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 1 0 0} {1 0 1 0 0} {1 0 1 0 0} {1 0 1 0 1}
		{1 0 1 0 1} {1 0 1 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 0 0 0 0} {1 0 0 0 0} {1 0 0 0 1} {1 0 0 1 0}
		{1 0 1 0 0} {1 1 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 1 1 1 1} {1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1}
		{1 0 0 0 1} {1 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 1 1 1 1} {1 0 0 0 1} {1 0 0 0 1} {0 0 0 0 1}
		{0 0 0 1 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 1 0 0} {0 0 0 0 0} {0 0 0 0 1} {0 0 0 0 1}
		{0 0 0 1 0} {1 1 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 1 0 0} {1 0 0 1 0} {0 1 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{1 1 1 0 0} {1 0 1 0 0} {1 1 1 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}


	{
		{0 0 0 0 0} {0 0 0 0 0} {0 1 0 0 1} {1 0 1 0 1} {1 0 0 1 0}
		{1 0 0 1 0} {0 1 1 0 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 0 1 0} {0 0 0 0 0} {0 1 1 1 0} {0 0 0 0 1} {0 1 1 1 1}
		{1 0 0 0 1} {0 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 1} {1 1 1 1 0}
		{1 0 0 0 1} {1 1 1 1 0} {1 0 0 0 0} {1 0 0 0 0} {1 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 0} {0 1 1 0 0}
		{1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1}
		{1 0 0 1 1} {1 1 1 0 1} {1 0 0 0 0} {1 0 0 0 0} {1 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 1 1 1 1} {1 0 1 0 0} {1 0 0 1 0}
		{1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 1 1 0} {0 1 0 0 1} {1 0 0 0 1}
		{1 0 0 0 1} {1 1 1 1 0} {1 0 0 0 0} {1 0 0 0 0} {1 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 1 1 1 1} {1 0 0 0 1} {1 0 0 0 1}
		{1 0 0 0 1} {0 1 1 1 1} {0 0 0 0 1} {0 0 0 0 1} {0 1 1 1 0}
	}
	{
		{0 0 0 0 0} {0 0 0 0 0} {0 0 1 1 1} {0 0 1 0 0} {0 0 1 0 0}
		{1 0 1 0 0} {0 1 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 1 0} {1 1 0 1 0} {0 0 0 1 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 1 0} {0 0 0 0 0} {0 0 1 1 0} {0 0 0 1 0} {0 0 0 1 0}
		{0 0 0 1 0} {0 0 0 1 0} {0 0 0 1 0} {1 0 0 1 0} {0 1 1 0 0}
	} {
		{0 0 0 0 0} {0 1 0 1 0} {0 0 1 0 0} {0 1 0 1 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 1 0 0} {0 1 1 1 0} {1 0 1 0 0} {1 0 1 0 1}
		{0 1 1 1 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 0 0 0} {0 1 0 0 0} {1 1 1 0 0} {0 1 0 0 0} {1 1 1 0 0}
		{0 1 0 0 0} {0 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 1 1 0} {0 0 0 0 0} {1 0 1 1 0} {1 1 0 0 1} {1 0 0 0 1}
		{1 0 0 0 1} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 0 1 0} {0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 1} {1 0 0 0 1}
		{1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}


	{
		{0 0 0 0 0} {0 0 0 0 0} {1 0 1 1 0} {1 1 0 0 1} {1 0 0 0 1}
		{1 0 0 0 1} {1 1 1 1 0} {1 0 0 0 0} {1 0 0 0 0} {1 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 1 1 0 1} {1 0 0 1 1} {1 0 0 0 1}
		{1 0 0 0 1} {0 1 1 1 1} {0 0 0 0 1} {0 0 0 0 1} {0 0 0 0 1}
	} {
		{0 1 1 1 0} {1 0 0 0 1} {1 1 1 1 1} {1 0 0 0 1} {1 0 0 0 1}
		{0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 1 0 1 1} {1 0 1 0 1}
		{1 1 0 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 1} {1 0 0 0 1}
		{0 1 0 1 0} {1 1 0 1 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 0 1 0} {0 0 0 0 0} {1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1}
		{1 0 0 0 1} {1 0 0 1 1} {0 1 1 0 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{1 1 1 1 1} {1 0 0 0 0} {0 1 0 0 0} {0 0 1 0 0} {0 1 0 0 0}
		{1 0 0 0 0} {1 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {1 1 1 1 1} {0 1 0 1 0} {0 1 0 1 0}
		{0 1 0 1 0} {1 0 0 1 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}
	{
		{1 1 1 1 1} {0 0 0 0 0} {1 0 0 0 1} {0 1 0 1 0} {0 0 1 0 0}
		{0 1 0 1 0} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1}
		{1 0 0 0 1} {0 1 1 1 1} {0 0 0 0 1} {0 0 0 0 1} {0 1 1 1 0}
	} {
		{0 0 0 0 0} {0 0 0 0 1} {1 1 1 1 0} {0 0 1 0 0} {1 1 1 1 1}
		{0 0 1 0 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {1 1 1 1 1} {0 1 0 0 0} {0 1 1 1 1}
		{0 1 0 0 1} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {1 1 1 1 1} {1 0 1 0 1} {1 1 1 1 1}
		{1 0 0 0 1} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 1 0 0} {0 0 0 0 0} {1 1 1 1 1} {0 0 0 0 0}
		{0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{1 1 1 1 1} {1 1 1 1 1} {1 1 1 1 1} {1 1 1 1 1} {1 1 1 1 1}
		{1 1 1 1 1} {1 1 1 1 1} {1 1 1 1 1} {1 1 1 1 1} {1 1 1 1 1}
	}
} {
} {
	{
		{0 0 0 0 0} {0 1 0 0 0} {0 1 1 0 0} {0 1 1 1 0} {0 1 1 1 1}
		{0 1 1 1 0} {0 1 1 0 0} {0 1 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 1 0} {0 0 1 1 0} {0 1 1 1 0} {1 1 1 1 0}
		{0 1 1 1 0} {0 0 1 1 0} {0 0 0 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 0 0 1} {1 0 0 1 0} {1 1 0 1 1} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 1 0 1 1} {0 1 0 0 1} {1 0 0 1 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 1 0 0} {0 1 1 1 0} {1 1 1 1 1} {0 0 0 0 0}
		{0 0 1 0 0} {0 1 1 1 0} {1 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 1 1 1 1} {0 1 1 1 0} {0 0 1 0 0} {0 0 0 0 0}
		{1 1 1 1 1} {0 1 1 1 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 1 1 1 0} {1 1 1 1 1} {1 1 1 1 1}
		{1 1 1 1 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 1} {0 0 0 0 1} {0 0 1 0 1} {0 1 0 0 1}
		{1 1 1 1 1} {0 1 0 0 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}
	{
		{0 0 0 0 0} {0 0 1 0 0} {0 1 1 1 0} {1 0 1 0 1} {0 0 1 0 0}
		{0 0 1 0 0} {0 0 1 0 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 1 0 0} {0 0 1 0 0} {0 0 1 0 0} {0 0 1 0 0}
		{1 0 1 0 1} {0 1 1 1 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 1 0 0} {0 0 0 1 0} {1 1 1 1 1}
		{0 0 0 1 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 1 0 0} {0 1 0 0 0} {1 1 1 1 1}
		{0 1 0 0 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 1 0} {0 0 1 0 0} {0 1 0 0 0} {0 0 1 0 0}
		{0 0 0 1 0} {0 0 0 0 0} {1 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 0 0 0} {0 0 1 0 0} {0 0 0 1 0} {0 0 1 0 0}
		{0 1 0 0 0} {0 0 0 0 0} {1 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 1 0 0} {0 0 1 0 0} {0 1 1 1 0}
		{0 1 1 1 0} {1 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {1 1 1 1 1} {0 1 1 1 0} {0 1 1 1 0}
		{0 0 1 0 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}


	{
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 1 0 0} {0 0 1 0 0} {0 0 1 0 0} {0 0 1 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 0 1 0} {0 1 0 1 0} {0 1 0 1 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 0 1 0} {0 1 0 1 0} {1 1 1 1 1} {0 1 0 1 0}
		{1 1 1 1 1} {0 1 0 1 0} {0 1 0 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 1 0 0} {0 1 1 1 1} {1 0 1 0 0} {0 1 1 1 0}
		{0 0 1 0 1} {1 1 1 1 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 1 0 0 0} {1 1 0 0 1} {0 0 0 1 0} {0 0 1 0 0}
		{0 1 0 0 0} {1 0 0 1 1} {0 0 0 1 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 1 0 0} {1 0 0 1 0} {1 0 1 0 0} {0 1 0 0 0}
		{1 0 1 0 1} {1 0 0 1 0} {0 1 1 0 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 1 0 0} {0 0 1 0 0} {0 1 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}
	{
		{0 0 0 0 0} {0 0 0 1 0} {0 0 1 0 0} {0 1 0 0 0} {0 1 0 0 0}
		{0 1 0 0 0} {0 0 1 0 0} {0 0 0 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 0 0 0} {0 0 1 0 0} {0 0 0 1 0} {0 0 0 1 0}
		{0 0 0 1 0} {0 0 1 0 0} {0 1 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 1 0 0} {1 0 1 0 1} {0 1 1 1 0}
		{1 0 1 0 1} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 1 0 0} {0 0 1 0 0} {1 1 1 1 1}
		{0 0 1 0 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 1 1 0 0} {0 0 1 0 0} {0 1 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {1 1 1 1 1}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 1 1 0 0} {0 1 1 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 1} {0 0 0 1 0} {0 0 1 0 0}
		{0 1 0 0 0} {1 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}


	{
		{0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 1} {1 0 0 1 1} {1 0 1 0 1}
		{1 1 0 0 1} {1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 1 0 0} {0 1 1 0 0} {0 0 1 0 0} {0 0 1 0 0}
		{0 0 1 0 0} {0 0 1 0 0} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 1} {0 0 0 0 1} {0 0 0 1 0}
		{0 0 1 0 0} {0 1 0 0 0} {1 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 1 1 1 1} {0 0 0 1 0} {0 0 1 0 0} {0 0 0 1 0}
		{0 0 0 0 1} {1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 1 0} {0 0 1 1 0} {0 1 0 1 0} {1 0 0 1 0}
		{1 1 1 1 1} {0 0 0 1 0} {0 0 0 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 1 1 1 1} {1 0 0 0 0} {1 1 1 1 0} {0 0 0 0 1}
		{0 0 0 0 1} {1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 1 1 0} {0 1 0 0 0} {1 0 0 0 0} {1 1 1 1 0}
		{1 0 0 0 1} {1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 1 1 1 1} {1 0 0 0 1} {0 0 0 0 1} {0 0 0 1 0}
		{0 0 1 0 0} {0 0 1 0 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}
	{
		{0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 1} {1 0 0 0 1} {0 1 1 1 0}
		{1 0 0 0 1} {1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 1} {1 0 0 0 1} {0 1 1 1 1}
		{0 0 0 0 1} {0 0 0 1 0} {0 1 1 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 1 1 0 0} {0 1 1 0 0} {0 0 0 0 0}
		{0 1 1 0 0} {0 1 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 1 1 0 0} {0 1 1 0 0} {0 0 0 0 0}
		{0 1 1 0 0} {0 0 1 0 0} {0 1 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 1 0} {0 0 1 0 0} {0 1 0 0 0} {1 0 0 0 0}
		{0 1 0 0 0} {0 0 1 0 0} {0 0 0 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {1 1 1 1 1} {0 0 0 0 0}
		{1 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 0 0 0} {0 0 1 0 0} {0 0 0 1 0} {0 0 0 0 1}
		{0 0 0 1 0} {0 0 1 0 0} {0 1 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 1} {0 0 0 0 1} {0 0 0 1 0}
		{0 0 1 0 0} {0 0 0 0 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}


	{
		{0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 1} {0 0 0 0 1} {0 1 1 0 1}
		{1 0 1 0 1} {1 0 1 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1}
		{1 1 1 1 1} {1 0 0 0 1} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 1 1 1 0} {1 0 0 0 1} {1 0 0 0 1} {1 1 1 1 0}
		{1 0 0 0 1} {1 0 0 0 1} {1 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 1} {1 0 0 0 0} {1 0 0 0 0}
		{1 0 0 0 0} {1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 1 1 0 0} {1 0 0 1 0} {1 0 0 0 1} {1 0 0 0 1}
		{1 0 0 0 1} {1 0 0 1 0} {1 1 1 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 1 1 1 1} {1 0 0 0 0} {1 0 0 0 0} {1 1 1 1 0}
		{1 0 0 0 0} {1 0 0 0 0} {1 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 1 1 1 1} {1 0 0 0 0} {1 0 0 0 0} {1 1 1 1 0}
		{1 0 0 0 0} {1 0 0 0 0} {1 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 1} {1 0 0 0 0} {1 0 1 1 1}
		{1 0 0 0 1} {1 0 0 0 1} {0 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0}
	}
	{
		{0 0 0 0 0} {1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1} {1 1 1 1 1}
		{1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 1 1 0} {0 0 1 0 0} {0 0 1 0 0} {0 0 1 0 0}
		{0 0 1 0 0} {0 0 1 0 0} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 1 1 1} {0 0 0 1 0} {0 0 0 1 0} {0 0 0 1 0}
		{0 0 0 1 0} {1 0 0 1 0} {0 1 1 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 0 0 0 1} {1 0 0 1 0} {1 0 1 0 0} {1 1 0 0 0}
		{1 0 1 0 0} {1 0 0 1 0} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 0 0 0 0} {1 0 0 0 0} {1 0 0 0 0} {1 0 0 0 0}
		{1 0 0 0 0} {1 0 0 0 0} {1 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 0 0 0 1} {1 1 0 1 1} {1 0 1 0 1} {1 0 1 0 1}
		{1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 0 0 0 1} {1 0 0 0 1} {1 1 0 0 1} {1 0 1 0 1}
		{1 0 0 1 1} {1 0 0 0 1} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1}
		{1 0 0 0 1} {1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	}


	{
		{0 0 0 0 0} {1 1 1 1 0} {1 0 0 0 1} {1 0 0 0 1} {1 1 1 1 0}
		{1 0 0 0 0} {1 0 0 0 0} {1 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1}
		{1 0 1 0 1} {1 0 0 1 0} {0 1 1 0 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 1 1 1 0} {1 0 0 0 1} {1 0 0 0 1} {1 1 1 1 0}
		{1 0 1 0 0} {1 0 0 1 0} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 1 1 1} {1 0 0 0 0} {1 0 0 0 0} {0 1 1 1 0}
		{0 0 0 0 1} {0 0 0 0 1} {1 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 1 1 1 1} {0 0 1 0 0} {0 0 1 0 0} {0 0 1 0 0}
		{0 0 1 0 0} {0 0 1 0 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1}
		{1 0 0 0 1} {1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1}
		{1 0 0 0 1} {0 1 0 1 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1} {1 0 1 0 1}
		{1 0 1 0 1} {1 0 1 0 1} {0 1 0 1 0} {0 0 0 0 0} {0 0 0 0 0}
	}
	{
		{0 0 0 0 0} {1 0 0 0 1} {1 0 0 0 1} {0 1 0 1 0} {0 0 1 0 0}
		{0 1 0 1 0} {1 0 0 0 1} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1} {0 1 0 1 0}
		{0 0 1 0 0} {0 0 1 0 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 1 1 1 1} {0 0 0 0 1} {0 0 0 1 0} {0 0 1 0 0}
		{0 1 0 0 0} {1 0 0 0 0} {1 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 1 1 0 0} {1 0 0 0 0} {1 0 0 0 0} {1 0 0 0 0}
		{1 0 0 0 0} {1 0 0 0 0} {1 1 1 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 0 0 0 1} {0 1 0 1 0} {1 1 1 1 1} {0 0 1 0 0}
		{1 1 1 1 1} {0 0 1 0 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 1 1 1} {0 0 0 0 1} {0 0 0 0 1} {0 0 0 0 1}
		{0 0 0 0 1} {0 0 0 0 1} {0 0 1 1 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 1 0 0} {0 1 0 1 0} {1 0 0 0 1} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {1 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0}
	}


	{
		{0 0 0 0 0} {0 1 0 0 0} {0 0 1 0 0} {0 0 0 1 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 1 1 1 0} {0 0 0 0 1}
		{0 1 1 1 1} {1 0 0 0 1} {0 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 0 0 0 0} {1 0 0 0 0} {1 0 1 1 0} {1 1 0 0 1}
		{1 0 0 0 1} {1 0 0 0 1} {1 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 0}
		{1 0 0 0 0} {1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 1} {0 0 0 0 1} {0 1 1 0 1} {1 0 0 1 1}
		{1 0 0 0 1} {1 0 0 0 1} {0 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 1}
		{1 1 1 1 1} {1 0 0 0 0} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 1 1 0} {0 1 0 0 1} {0 1 0 0 0} {1 1 1 0 0}
		{0 1 0 0 0} {0 1 0 0 0} {0 1 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 1 1 1 1} {1 0 0 0 1} {1 0 0 0 1}
		{0 1 1 1 1} {0 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	}
	{
		{0 0 0 0 0} {1 0 0 0 0} {1 0 0 0 0} {1 0 1 1 0} {1 1 0 0 1}
		{1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 1 0 0} {0 0 0 0 0} {0 1 1 0 0} {0 0 1 0 0}
		{0 0 1 0 0} {0 0 1 0 0} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 1 0} {0 0 0 0 0} {0 0 1 1 0} {0 0 0 1 0}
		{0 0 0 1 0} {1 0 0 1 0} {0 1 1 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 0 0 0 0} {1 0 0 0 0} {1 0 0 1 0} {1 0 1 0 0}
		{1 1 0 0 0} {1 0 1 0 0} {1 0 0 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 1 0 0} {0 0 1 0 0} {0 0 1 0 0} {0 0 1 0 0}
		{0 0 1 0 0} {0 0 1 0 0} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {1 1 0 1 0} {1 0 1 0 1}
		{1 0 1 0 1} {1 0 0 0 1} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {1 0 1 1 0} {1 1 0 0 1}
		{1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 1}
		{1 0 0 0 1} {1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	}


	{
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {1 1 1 1 0} {1 0 0 0 1}
		{1 1 1 1 0} {1 0 0 0 0} {1 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 1 1 0 1} {1 0 0 1 1}
		{0 1 1 1 1} {0 0 0 0 1} {0 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {1 0 1 1 0} {1 1 0 0 1}
		{1 0 0 0 0} {1 0 0 0 0} {1 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 0}
		{0 1 1 1 0} {0 0 0 0 1} {1 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 0 0 0} {0 1 0 0 0} {1 1 1 0 0} {0 1 0 0 0}
		{0 1 0 0 0} {0 1 0 0 1} {0 0 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {1 0 0 0 1} {1 0 0 0 1}
		{1 0 0 0 1} {1 0 0 1 1} {0 1 1 0 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {1 0 0 0 1} {1 0 0 0 1}
		{1 0 0 0 1} {0 1 0 1 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {1 0 0 0 1} {1 0 1 0 1}
		{1 0 1 0 1} {1 0 1 0 1} {0 1 0 1 0} {0 0 0 0 0} {0 0 0 0 0}
	}
	{
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {1 0 0 0 1} {0 1 0 1 0}
		{0 0 1 0 0} {0 1 0 1 0} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {1 0 0 0 1} {1 0 0 0 1}
		{0 1 1 1 1} {0 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {1 1 1 1 1} {0 0 0 1 0}
		{0 0 1 0 0} {0 1 0 0 0} {1 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 1 0} {0 0 1 0 0} {0 0 1 0 0} {0 1 0 0 0}
		{0 0 1 0 0} {0 0 1 0 0} {0 0 0 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 1 0 0} {0 0 1 0 0} {0 0 1 0 0} {0 0 1 0 0}
		{0 0 1 0 0} {0 0 1 0 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 0 0 0} {0 0 1 0 0} {0 0 1 0 0} {0 0 0 1 0}
		{0 0 1 0 0} {0 0 1 0 0} {0 1 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
		{0 1 1 0 1} {1 0 0 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 1 0 0} {0 1 0 1 0} {1 0 0 0 1} {1 0 0 0 1}
		{1 0 0 0 1} {1 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}


	{
		{0 0 0 0 0} {1 1 1 1 1} {1 0 0 0 1} {1 0 0 0 0} {1 1 1 1 0}
		{1 0 0 0 1} {1 0 0 0 1} {1 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 1 1 1} {0 0 1 0 1} {0 0 1 0 1} {0 1 0 0 1} {1 0 0 0 1}
		{1 1 1 1 1} {1 0 0 0 1} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 0 1 0 1} {1 0 1 0 1} {1 0 1 0 1} {0 1 1 1 0}
		{1 0 1 0 1} {1 0 1 0 1} {1 0 1 0 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 1 1 1 0} {0 0 0 0 1} {0 0 0 0 1} {0 0 1 1 0}
		{0 0 0 0 1} {0 0 0 0 1} {1 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 0 0 0 1} {1 0 0 0 1} {1 0 0 1 1} {1 0 1 0 1}
		{1 1 0 0 1} {1 0 0 0 1} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 0 1 0} {0 0 1 0 0} {1 0 0 0 1} {1 0 0 0 1} {1 0 0 1 1}
		{1 0 1 0 1} {1 1 0 0 1} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 1 1 1} {0 0 1 0 1} {0 0 1 0 1} {0 0 1 0 1}
		{0 0 1 0 1} {1 0 1 0 1} {0 1 0 0 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 1 1 1 1} {1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1}
		{1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0}
	}
	{
		{0 0 0 0 0} {1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1} {0 1 0 1 0}
		{0 0 1 0 0} {0 1 0 0 0} {1 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1}
		{1 0 0 0 1} {1 1 1 1 1} {0 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1} {0 1 1 1 1}
		{0 0 0 0 1} {0 0 0 0 1} {0 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {1 0 1 0 1} {1 0 1 0 1} {1 0 1 0 1}
		{1 0 1 0 1} {1 0 1 0 1} {1 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 0 1 0 1} {1 0 1 0 1} {1 0 1 0 1} {1 0 1 0 1}
		{1 0 1 0 1} {1 1 1 1 1} {0 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 1 0 0 0} {0 1 0 0 0} {0 1 0 0 0} {0 1 1 1 0}
		{0 1 0 0 1} {0 1 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1} {1 1 0 0 1}
		{1 0 1 0 1} {1 0 1 0 1} {1 1 0 0 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 1} {0 0 1 0 1} {0 1 0 1 1}
		{0 0 0 0 1} {1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	}


	{
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 1 0 0 1} {1 0 1 0 1}
		{1 0 0 1 0} {1 0 0 1 0} {0 1 1 0 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 1 0 0} {0 0 1 1 0} {0 0 1 0 1} {0 0 1 0 1}
		{0 0 1 0 0} {1 1 1 0 0} {1 1 1 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 1 1 1 1} {1 0 0 0 1} {1 0 0 0 0} {1 0 0 0 0}
		{1 0 0 0 0} {1 0 0 0 0} {1 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {1 1 1 1 1} {0 1 0 1 0}
		{0 1 0 1 0} {0 1 0 1 0} {1 0 0 1 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 1 1 1 1} {1 0 0 0 0} {0 1 0 0 0} {0 0 1 0 0}
		{0 1 0 0 0} {1 0 0 0 0} {1 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 1 1 1 1} {1 0 0 1 0}
		{1 0 0 1 0} {1 0 0 1 0} {0 1 1 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 1 1 0} {0 0 1 0 1} {0 0 1 1 1} {0 0 1 0 1} {0 0 1 0 1}
		{1 1 1 0 1} {1 1 0 1 1} {0 0 0 1 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 1} {0 1 1 1 0} {1 0 1 0 0}
		{0 0 1 0 0} {0 0 1 0 0} {0 0 0 1 0} {0 0 0 0 0} {0 0 0 0 0}
	}
	{
		{0 0 0 0 0} {0 0 1 0 0} {0 1 1 1 0} {0 1 1 1 0} {0 1 1 1 0}
		{1 1 1 1 1} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 1} {1 0 0 0 1} {1 1 1 1 1}
		{1 0 0 0 1} {1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 1} {1 0 0 0 1}
		{1 0 0 0 1} {0 1 0 1 0} {1 1 0 1 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 1 1 0} {0 1 0 0 1} {0 0 1 0 0} {0 1 0 1 0}
		{1 0 0 0 1} {1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 1 0 1 1} {1 0 1 0 1}
		{1 1 0 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 1 0 1 0} {1 1 1 1 1} {1 1 1 1 1}
		{1 1 1 1 1} {0 1 1 1 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 0}
		{0 1 1 0 0} {1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1}
		{1 0 0 0 1} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}


	{
		{0 0 0 0 0} {1 1 0 1 1} {1 1 0 1 1} {1 1 0 1 1} {1 1 0 1 1}
		{1 1 0 1 1} {1 1 0 1 1} {1 1 0 1 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 1 0 0}
		{0 0 1 0 0} {0 0 1 0 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 1 0 0} {0 1 1 1 0} {1 0 1 0 0} {1 0 1 0 0}
		{1 0 1 0 1} {0 1 1 1 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 1 1 0} {0 1 0 0 0} {0 1 0 0 0} {1 1 1 0 0}
		{0 1 0 0 0} {0 1 0 0 1} {1 0 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {1 0 0 0 1} {0 1 1 1 0} {0 1 0 1 0}
		{0 1 1 1 0} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 0 0 0 1} {0 1 0 1 0} {1 1 1 1 1} {0 0 1 0 0}
		{1 1 1 1 1} {0 0 1 0 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 1 0 0} {0 0 1 0 0} {0 0 1 0 0} {0 0 0 0 0}
		{0 0 1 0 0} {0 0 1 0 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 1 1 0} {0 1 0 0 1} {0 0 1 0 0} {0 1 0 1 0}
		{0 0 1 0 0} {1 0 0 1 0} {0 1 1 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}
	{
		{0 0 0 0 0} {0 0 0 1 0} {0 0 1 0 1} {0 0 1 0 0} {1 1 1 1 1}
		{0 0 1 0 0} {1 0 1 0 0} {0 1 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 1 1 1 1} {1 0 0 0 1} {1 0 1 0 1} {1 0 1 1 1}
		{1 0 1 0 1} {1 0 0 0 1} {1 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 1 1 0} {0 0 0 0 1} {0 1 1 1 1} {1 0 0 0 1}
		{0 1 1 1 1} {0 0 0 0 0} {1 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 1 0 1} {0 1 0 1 0} {1 0 1 0 0} {0 1 0 1 0}
		{0 0 1 0 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 0 0 1 0} {1 0 1 0 1} {1 0 1 0 1} {1 1 1 0 1}
		{1 0 1 0 1} {1 0 1 0 1} {1 0 0 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 1 1 1} {1 0 0 0 1} {1 0 0 0 1} {0 1 1 1 1}
		{0 0 1 0 1} {0 1 0 0 1} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 1 1 1 1} {1 0 0 0 1} {1 0 1 0 1} {1 0 0 0 1}
		{1 0 0 1 1} {1 0 1 0 1} {1 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 1 0 0} {0 1 0 0 0} {0 1 1 0 0} {0 0 0 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}


	{
		{0 1 1 0 0} {1 0 0 1 0} {1 0 0 1 0} {1 0 0 1 0} {0 1 1 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 1 0 0} {0 0 1 0 0} {1 1 1 1 1} {0 0 1 0 0}
		{0 0 1 0 0} {0 0 0 0 0} {1 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 1 0 0} {1 0 0 1 0} {0 0 1 0 0} {0 1 0 0 0} {1 1 1 1 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{1 1 1 0 0} {0 0 0 1 0} {0 1 1 0 0} {0 0 0 1 0} {1 1 1 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{1 1 1 0 0} {1 0 0 1 0} {1 1 1 0 0} {1 0 0 0 0} {1 0 0 1 0}
		{1 0 1 1 1} {1 0 0 1 0} {0 0 0 1 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1} {1 0 0 1 1}
		{1 1 1 0 1} {1 0 0 0 0} {1 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 1 1 1} {1 0 0 1 1} {1 0 0 1 1} {0 1 1 1 1}
		{0 0 0 1 1} {0 0 0 1 1} {0 0 0 1 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 1 1 0 0}
		{0 1 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}
	{
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 1 0 1 0} {1 0 0 0 1}
		{1 0 1 0 1} {1 0 1 0 1} {0 1 0 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 0 0 0} {1 1 0 0 0} {0 1 0 0 0} {0 1 0 0 0} {1 1 1 0 0}
		{0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1}
		{0 1 1 1 0} {0 0 0 0 0} {1 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {1 0 1 0 0} {0 1 0 1 0} {0 0 1 0 1}
		{0 1 0 1 0} {1 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{1 0 0 0 1} {1 0 0 1 0} {1 0 1 0 0} {0 1 0 1 0} {1 0 1 1 0}
		{0 1 0 1 0} {0 1 1 1 1} {0 0 0 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{1 0 0 0 1} {1 0 0 1 0} {1 0 1 0 0} {0 1 0 1 0} {1 0 1 0 1}
		{0 0 0 0 1} {0 0 0 1 0} {0 0 1 1 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{1 1 0 0 0} {0 1 0 0 0} {1 1 0 0 0} {0 1 0 0 1} {1 1 0 1 1}
		{0 0 1 0 1} {0 0 1 1 1} {0 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 1 0 0} {0 1 0 0 0}
		{1 0 0 0 0} {1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	}


	{
		{0 1 0 0 0} {0 0 1 0 0} {0 0 1 0 0} {0 1 0 1 0} {1 0 0 0 1}
		{1 1 1 1 1} {1 0 0 0 1} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 1 0} {0 0 1 0 0} {0 0 1 0 0} {0 1 0 1 0} {1 0 0 0 1}
		{1 1 1 1 1} {1 0 0 0 1} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 1 0 0} {0 1 0 1 0} {0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 1}
		{1 1 1 1 1} {1 0 0 0 1} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 1 0 1} {1 0 0 1 0} {0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 1}
		{1 1 1 1 1} {1 0 0 0 1} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 0 1 0} {0 0 0 0 0} {0 0 1 0 0} {0 1 0 1 0} {1 0 0 0 1}
		{1 1 1 1 1} {1 0 0 0 1} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 1 0 0} {0 1 0 1 0} {0 0 1 0 0} {0 1 1 1 0} {1 0 0 0 1}
		{1 1 1 1 1} {1 0 0 0 1} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 1 1 1} {0 1 1 0 0} {1 0 1 0 0} {1 0 1 1 1}
		{1 1 1 0 0} {1 0 1 0 0} {1 0 1 1 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 1 1 0} {1 0 0 0 1} {1 0 0 0 0} {1 0 0 0 0} {1 0 0 0 1}
		{0 1 1 1 0} {0 0 0 1 0} {0 0 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	}
	{
		{0 1 0 0 0} {0 0 1 0 0} {0 0 0 0 0} {1 1 1 1 1} {1 0 0 0 0}
		{1 1 1 1 0} {1 0 0 0 0} {1 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 1 0} {0 0 1 0 0} {0 0 0 0 0} {1 1 1 1 1} {1 0 0 0 0}
		{1 1 1 1 0} {1 0 0 0 0} {1 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 1 0 0} {0 1 0 1 0} {0 0 0 0 0} {1 1 1 1 1} {1 0 0 0 0}
		{1 1 1 1 0} {1 0 0 0 0} {1 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 0 1 0} {0 0 0 0 0} {1 1 1 1 1} {1 0 0 0 0}
		{1 1 1 1 0} {1 0 0 0 0} {1 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 0 0 0} {0 0 1 0 0} {0 0 0 0 0} {0 1 1 1 0} {0 0 1 0 0}
		{0 0 1 0 0} {0 0 1 0 0} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 1 0} {0 0 1 0 0} {0 0 0 0 0} {0 1 1 1 0} {0 0 1 0 0}
		{0 0 1 0 0} {0 0 1 0 0} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 1 0 0} {0 1 0 1 0} {0 0 0 0 0} {0 1 1 1 0} {0 0 1 0 0}
		{0 0 1 0 0} {0 0 1 0 0} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 0 1 0} {0 0 0 0 0} {0 1 1 1 0} {0 0 1 0 0}
		{0 0 1 0 0} {0 0 1 0 0} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	}


	{
		{0 0 0 0 0} {0 1 1 1 0} {0 1 0 0 1} {0 1 0 0 1} {1 1 1 0 1}
		{0 1 0 0 1} {0 1 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 1 0 1} {1 0 0 1 0} {0 0 0 0 0} {1 0 0 0 1} {1 1 0 0 1}
		{1 0 1 0 1} {1 0 0 1 1} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 0 0 0} {0 0 1 0 0} {0 1 1 1 0} {1 0 0 0 1} {1 0 0 0 1}
		{1 0 0 0 1} {1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 1 0} {0 0 1 0 0} {0 1 1 1 0} {1 0 0 0 1} {1 0 0 0 1}
		{1 0 0 0 1} {1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 1 0 0} {0 1 0 1 0} {0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 1}
		{1 0 0 0 1} {1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 1 0 1} {1 0 0 1 0} {0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 1}
		{1 0 0 0 1} {1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 0 1 0} {0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 1} {1 0 0 0 1}
		{1 0 0 0 1} {1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {1 0 0 0 1} {0 1 0 1 0} {0 0 1 0 0}
		{0 1 0 1 0} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}
	{
		{0 1 1 1 0} {0 0 1 0 0} {0 1 1 1 0} {1 0 1 0 1} {0 1 1 1 0}
		{0 0 1 0 0} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 0 0 0} {0 0 1 0 0} {1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1}
		{1 0 0 0 1} {1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 1 0} {0 0 1 0 0} {1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1}
		{1 0 0 0 1} {1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 1 0 0} {0 1 0 1 0} {0 0 0 0 0} {1 0 0 0 1} {1 0 0 0 1}
		{1 0 0 0 1} {1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 0 1 0} {0 0 0 0 0} {1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1}
		{1 0 0 0 1} {1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 1 0} {0 0 1 0 0} {1 0 0 0 1} {0 1 0 1 0} {0 0 1 0 0}
		{0 0 1 0 0} {0 0 1 0 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{1 1 0 0 0} {0 1 0 0 0} {0 1 1 1 0} {0 1 0 0 1} {0 1 0 0 1}
		{0 1 1 1 0} {0 1 0 0 0} {1 1 1 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 1 1 0} {0 1 0 0 1} {0 1 0 0 1} {0 1 1 1 0}
		{0 1 0 0 1} {0 1 0 0 1} {1 0 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	}


	{
		{0 1 0 0 0} {0 0 1 0 0} {0 0 0 0 0} {0 1 1 1 0} {0 0 0 0 1}
		{0 1 1 1 1} {1 0 0 0 1} {0 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 1 0} {0 0 1 0 0} {0 0 0 0 0} {0 1 1 1 0} {0 0 0 0 1}
		{0 1 1 1 1} {1 0 0 0 1} {0 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 1 0 1} {1 0 0 1 0} {0 0 0 0 0} {0 1 1 1 0} {0 0 0 0 1}
		{0 1 1 1 1} {1 0 0 0 1} {0 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 1 0 0} {0 1 0 1 0} {0 0 0 0 0} {0 1 1 1 0} {0 0 0 0 1}
		{0 1 1 1 1} {1 0 0 0 1} {0 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 0 1 0} {0 0 0 0 0} {0 1 1 1 0} {0 0 0 0 1}
		{0 1 1 1 1} {1 0 0 0 1} {0 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 1 0 0} {0 1 0 1 0} {0 0 1 0 0} {0 1 1 1 0} {0 0 0 0 1}
		{0 1 1 1 1} {1 0 0 0 1} {0 1 1 1 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {1 1 0 1 0} {0 0 1 0 1} {0 1 1 1 1}
		{1 0 1 0 0} {1 0 1 0 1} {0 1 0 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 0} {1 0 0 0 1}
		{0 1 1 1 0} {0 0 1 0 0} {0 1 1 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}
	{
		{0 1 0 0 0} {0 0 1 0 0} {0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 1}
		{1 1 1 1 1} {1 0 0 0 0} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 1 0} {0 0 1 0 0} {0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 1}
		{1 1 1 1 1} {1 0 0 0 0} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 1 0 0} {0 1 0 1 0} {0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 1}
		{1 1 1 1 1} {1 0 0 0 0} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 0 1 0} {0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 1}
		{1 1 1 1 1} {1 0 0 0 0} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 0 0 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 1 0 0} {0 1 1 0 0}
		{0 0 1 0 0} {0 0 1 0 0} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 1 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 1 0 0} {0 1 1 0 0}
		{0 0 1 0 0} {0 0 1 0 0} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 1 0 0} {0 1 0 1 0} {0 0 0 0 0} {0 0 1 0 0} {0 1 1 0 0}
		{0 0 1 0 0} {0 0 1 0 0} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 0 1 0} {0 0 0 0 0} {0 0 1 0 0} {0 1 1 0 0}
		{0 0 1 0 0} {0 0 1 0 0} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	}


	{
		{0 0 0 0 0} {1 0 1 0 0} {0 1 0 0 0} {1 0 1 0 0} {0 0 0 1 0}
		{0 1 1 1 1} {1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 1 0 1} {1 0 0 1 0} {0 0 0 0 0} {1 0 1 1 0} {1 1 0 0 1}
		{1 0 0 0 1} {1 0 0 0 1} {1 0 0 0 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 0 0 0} {0 0 1 0 0} {0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 1}
		{1 0 0 0 1} {1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 1 0} {0 0 1 0 0} {0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 1}
		{1 0 0 0 1} {1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 1 0 0} {0 1 0 1 0} {0 0 0 0 0} {0 1 1 1 0}
		{1 0 0 0 1} {1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 1 0 1} {1 0 0 1 0} {0 0 0 0 0} {0 1 1 1 0}
		{1 0 0 0 1} {1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 0 1 0} {0 0 0 0 0} {0 1 1 1 0} {1 0 0 0 1}
		{1 0 0 0 1} {1 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 0 0} {0 0 1 0 0} {0 0 0 0 0} {1 1 1 1 1}
		{0 0 0 0 0} {0 0 1 0 0} {0 0 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	}
	{
		{0 0 0 0 0} {0 0 0 1 0} {0 0 1 0 0} {0 1 1 1 0} {1 0 1 0 1}
		{0 1 1 1 0} {0 0 1 0 0} {0 1 0 0 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 1 0 0 0} {0 0 1 0 0} {0 0 0 0 0} {1 0 0 0 1} {1 0 0 0 1}
		{1 0 0 0 1} {1 0 0 1 1} {0 1 1 0 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 1 0} {0 0 1 0 0} {0 0 0 0 0} {1 0 0 0 1} {1 0 0 0 1}
		{1 0 0 0 1} {1 0 0 1 1} {0 1 1 0 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 1 0 0} {0 1 0 1 0} {0 0 0 0 0} {1 0 0 0 1} {1 0 0 0 1}
		{1 0 0 0 1} {1 0 0 1 1} {0 1 1 0 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 0 1 0} {0 0 0 0 0} {1 0 0 0 1} {1 0 0 0 1}
		{1 0 0 0 1} {1 0 0 1 1} {0 1 1 0 1} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 0 0 1 0} {0 0 1 0 0} {1 0 0 0 1} {1 0 0 0 1}
		{0 1 1 1 1} {0 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 1 0 0} {0 0 1 0 0} {0 0 1 1 0} {0 0 1 0 1}
		{0 0 1 1 0} {0 0 1 0 0} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	} {
		{0 0 0 0 0} {0 1 0 1 0} {0 0 0 0 0} {1 0 0 0 1} {1 0 0 0 1}
		{0 1 1 1 1} {0 0 0 0 1} {0 1 1 1 0} {0 0 0 0 0} {0 0 0 0 0}
	}
}

}
