/*************************************************************************
* COPYRIGHT (C) 1999 - 2003  EDF R&D
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/


/******************************************************************************
 * - Nom du fichier : test10.c
 *
 * - Description : ecriture de champs de resultats MED 
 *
 *****************************************************************************/

#include <med.h>
#include <med_utils.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#define USER_INTERLACE MED_FULL_INTERLACE

int main (int argc, char **argv)
{
  med_err ret=0;
  med_idt fid;
  
  /* Constantes */
  med_float a=0.446948490915965;
  med_float b=0.091576213509771;
  med_float p1=0.11169079483905;
  med_float p2=0.0549758718227661;

  /* Maillage support aux champs*/
  /* Ces maillages sont vides*/
  char maa1[MED_TAILLE_NOM+1]= "maa1";
  char maa2[MED_TAILLE_NOM+1]= "maa2";
  char lien_maa2[MED_TAILLE_NOM+1]= "./testfoo.med";
  char maa3[MED_TAILLE_NOM+1]= "maa3";

  /*TEMPORAIRE*/
  med_int ngauss1 = 2;

  /* Caractristiques du champ n 1 sur TRIA6 */
  char nomcha1[MED_TAILLE_NOM+1]  = "champ reel";
  char comp1[2*MED_TAILLE_PNOM+1] = "comp1   comp2   ";
  char unit1[2*MED_TAILLE_PNOM+1] = "unit1   unit2   ";
  med_int ncomp1  = 2; 
  /* Caractristiques du model n 1 de localisation des points de gauss pour le champ n1*/
  med_int ngauss1_1 = 6;
  char gauss1_1[MED_TAILLE_NOM+1]  = "Model n1";
  med_float refcoo1[12] = { -1.0,1.0, -1.0,-1.0, 1.0,-1.0, -1.0,0.0, 0.0,-1.0, 0.0,0.0 }; 
  med_float gscoo1_1[12] = { 2*b-1, 1-4*b, 2*b-1, 2*b-1, 1-4*b, 2*b-1, 1-4*a, 2*a-1, 2*a-1, 1-4*a, 2*a-1, 2*a-1   }; 
  med_float wg1_1[6] = { 4*p2,4*p2,4*p2,4*p1,4*p1,4*p1, }; 
  med_int   nval1_1= 1*6; /*1 valeurs et 6 points de gauss par valeur */
  med_float valr1_1[1*6*2]  = {0.0,1.0, 2.0,3.0, 10.0,11.0, 12.0,13.0, 20.0,21.0, 22.0,23.0};  /* 2 composantes*/
  /* Caractristiques du model n 2 de localisation des points de gauss pour le champ n1*/
  med_int ngauss1_2 = 3;
  char gauss1_2[MED_TAILLE_NOM+1]  = "Model n2";
  med_float gscoo1_2[6] = { -2/3,1/3, -2/3,-2/3, 1/3,-2/3  }; 
  med_float wg1_2[3] = { 2/3, 2/3, 2/3 }; 
  med_int   nval1_2= 2*3; /*2 valeurs et 3 points de gauss par valeur */
  med_float valr1_2[2*3*2]  = {0.0,1.0, 2.0,3.0, 10.0,11.0,   12.0,13.0, 20.0,21.0, 22.0,23.0};  /* 2 composantes*/
  med_float valr1_2p[2*3*2]  = {                              12.0,13.0, 20.0,21.0, 22.0,23.0};  /* 2 composantes*/
 /* Caractristiques du model n 3 sans points de gauss pour le champ n1*/
  med_int   nval1_3= 6; /*6 valeurs et pas de points de gauss */
  med_float valr1_3[2*3*2]  = {0.0,1.0, 2.0,3.0, 10.0,11.0, 12.0,13.0, 20.0,21.0, 22.0,23.0};  /* 2 composantes*/
  med_float valr1_3p[2*2*2] = {         2.0,3.0, 10.0,11.0                                 };  /* 2 composantes profil1 */
  
  /* Caractristiques du champ n 2 */
  char nomcha2[MED_TAILLE_NOM+1]  = "champ entier";
  char comp2[3*MED_TAILLE_PNOM+1] = "comp1   comp2   comp3   ";
  char unit2[3*MED_TAILLE_PNOM+1] = "unit1   unit2   unit3   ";
  med_int ncomp2  = 3; 
  med_int nval2 = 5;   /*5 valeurs */
  med_int   valr2[5*3  ]  = {0,1,2, 10,11,12, 20,21,22, 30,31,32, 40,41,42};              /* 3 composantes*/
  med_int   valr2p[3*3  ] = {0,1,2,           20,21,22,           40,41,42};              /* 3 composantes*/

  /* Profils utiliss */
  char nomprofil1[MED_TAILLE_NOM+1]  = "PROFIL(champ(1))";
  med_int profil1[2] = { 2, 3 };
  med_int profil2[3] = { 1, 3, 5 };

  /* ouverture du fichier */
  if ((fid = MEDouvrir("test10.med",MED_CREATION)) < 0){
    MESSAGE("Erreur  l'ouverture du fichier : ");
    return -1;
  }
  
  /* creation de maa1 de dimension 3*/
  if ( MEDmaaCr(fid,maa1,3,MED_NON_STRUCTURE,"Maillage vide") < 0) {
    MESSAGE("Erreur  la cration du maillage : ");SSCRUTE(maa1);
    ret = -1;
  };

  /* creation de maa3 de dimension 3*/
  if ( MEDmaaCr(fid,maa3,3,MED_NON_STRUCTURE,"Maillage vide") < 0) {
    MESSAGE("Erreur  la cration du maillage : ");SSCRUTE(maa3);
    ret = -1;
  };
    
  /* creation du champ rel n1 */
  if ( MEDchampCr(fid,nomcha1,MED_FLOAT64,comp1,unit1,ncomp1) < 0) {
    MESSAGE("Erreur  la cration du champ : ");SSCRUTE(nomcha1);
    ret = -1;
  };
  
  /* creation du champ entier n2 */
  if ( MEDchampCr(fid,nomcha2,MED_INT32,comp2,unit2,ncomp2) < 0) {
    MESSAGE("Erreur  la cration du champ : ");SSCRUTE(nomcha2);
    ret = -1;
  };
  
  /* creation du lien au fichier distant contenant maa2 */
  if (MEDlienEcr(fid,lien_maa2,maa2) < 0) {
    MESSAGE("Erreur  la cration du lien : ");SSCRUTE(lien_maa2);
    ret = -1;
  };

  /* creation de la localisation des points de Gauss modle n1 */
  if (MEDgaussEcr(fid, MED_TRIA6, refcoo1, USER_INTERLACE,
		  ngauss1_1, gscoo1_1, wg1_1, gauss1_1) < 0) {
    MESSAGE("Erreur  la cration du modle n1 : ");SSCRUTE(gauss1_1);
    ret = -1;
  };

   /* creation de la localisation des points de Gauss modle n2 */
  if (MEDgaussEcr(fid, MED_TRIA6, refcoo1, USER_INTERLACE,
		  ngauss1_2, gscoo1_2, wg1_2, gauss1_2) < 0) {
    MESSAGE("Erreur  la cration du modle n1 : ");SSCRUTE(gauss1_2);
    ret = -1;
  };
 
  /* ecriture du champ n1*/
  /* enregistre uniquement les composantes n2 de valr1_1, et n'utilise ni pas de temps ni n d'ordre*/
  if ( MEDchampEcr(fid,maa1,nomcha1,(unsigned char*)valr1_1,USER_INTERLACE,nval1_1,gauss1_1,
		   2,MED_NOPFL,MED_MAILLE,MED_TRIA6,MED_NOPDT,"",0.0,MED_NONOR ) < 0) {
    MESSAGE("Erreur  l'criture du champ : ");
    SSCRUTE(nomcha1);ISCRUTE(MED_NOPDT);ISCRUTE(MED_NONOR);SSCRUTE(MED_NOPFL);
    SSCRUTE(maa1);
    ret = -1;
  };
  

  /* enregistre uniquement les composantes n1 de valr1_1, et n'utilise ni pas de temps ni n d'ordre */
  if ( MEDchampEcr(fid,maa1,nomcha1,(unsigned char*)valr1_1,USER_INTERLACE,nval1_1,gauss1_1,
		      1,MED_NOPFL,MED_MAILLE,MED_TRIA6,MED_NOPDT,"",0.0,MED_NONOR) < 0) {
    MESSAGE("Erreur  l'criture du champ : ");
    SSCRUTE(nomcha1);ISCRUTE(MED_NOPDT);ISCRUTE(MED_NONOR);SSCRUTE(MED_NOPFL);
    SSCRUTE(maa1);
    ret = -1;
  };


  /* enregistre uniquement les composantes n2 de valr1_2, au pas de temps n1(5.5), n'utilise pas de nd'ordre*/
  /* ce champ repose sur le maillage maa2 qui est distant */
  if ( MEDchampEcr(fid,maa2,nomcha1,(unsigned char*)valr1_2,USER_INTERLACE,nval1_2,gauss1_2,
		      2,MED_NOPFL,MED_MAILLE,MED_TRIA6,1,"ms",5.5,MED_NONOR) < 0) {
    MESSAGE("Erreur  l'criture du champ : ");
    SSCRUTE(nomcha1);ISCRUTE(1);ISCRUTE(MED_NONOR);SSCRUTE(MED_NOPFL);
    SSCRUTE(maa2);
    ret = -1;
  };

  /* enregistre uniquement les composantes n2 de valr1_2, au pas de temps n1(5.5), n'utilise pas de nd'ordre*/
  /* ce champ repose sur le maillage maa1 qui est local */
  if ( MEDchampEcr(fid,maa1,nomcha1,(unsigned char*)valr1_2,USER_INTERLACE,nval1_2,gauss1_2,
		      2,MED_NOPFL,MED_MAILLE,MED_TRIA6,1,"ms",5.5,MED_NONOR) < 0) {
    MESSAGE("Erreur  l'criture du champ : ");
    SSCRUTE(nomcha1);ISCRUTE(1);ISCRUTE(MED_NONOR);SSCRUTE(MED_NOPFL);
    SSCRUTE(maa1);
    ret = -1;
  };

    /* enregistre uniquement les composantes n1 de valr1_1, au pas de temps n1(5.5), et nd'itration n2*/
    /* ce champ repose sur le maillage maa3 qui est local */
  if ( MEDchampEcr(fid,maa3,nomcha1,(unsigned char*)valr1_2,USER_INTERLACE,nval1_2,gauss1_2,
		   1,MED_NOPFL,MED_MAILLE,MED_TRIA6,1,"ms",5.5,2) < 0) {
    MESSAGE("Erreur  l'criture du champ : ");
    SSCRUTE(nomcha1);ISCRUTE(1);ISCRUTE(2);SSCRUTE(MED_NOPFL);
    SSCRUTE(maa3);
    ret = -1;
  };
  
  /* Creation d'un profil (selection  du deuxieme lment de valr1_1) */
  /* On n'utilise que la premire valeur (2) du profil */
  if ( MEDprofilEcr(fid,profil1,1,nomprofil1) < 0) {
    MESSAGE("Erreur  l'criture du profil : ");
    SSCRUTE(profil1);
    ret = -1;
  };


  /* enregistre toutes les composantes du deuxime lment de valr1_1 (premier lment en stockage compact de valr1p),
     au pas de temps n2(5.6), et nd'itration n2*/
  if ( MEDchampEcr(fid,maa1, nomcha1,(unsigned char*)valr1_3p,USER_INTERLACE,nval1_3,MED_NOGAUSS,
		   MED_ALL,nomprofil1,MED_MAILLE,MED_TRIA6,2,"ms",5.6,2) < 0) {
    MESSAGE("Erreur  l'criture du champ : ");
    SSCRUTE(nomcha1);ISCRUTE(2);ISCRUTE(2);SSCRUTE(nomprofil1);
    SSCRUTE(maa1);SSCRUTE(MED_NOLIEN);
    ret = -1;
  };

  /* enregistre toutes les composantes du deuxime lment de valr1_1 (premier lment en stockage compact de valr1p),
     au pas de temps n2(5.6), et nd'itration n2 : ? NE PASSE PAS ?*/
  if ( MEDchampEcr(fid,maa2, nomcha1,(unsigned char*)valr1_2p,USER_INTERLACE,nval1_2,gauss1_2,
		   MED_ALL,nomprofil1,MED_MAILLE,MED_TRIA6,2,"ms",5.6,2) < 0) {
    MESSAGE("Erreur  l'criture du champ : ");
    SSCRUTE(nomcha1);ISCRUTE(2);ISCRUTE(2);SSCRUTE(nomprofil1);
    SSCRUTE(maa1);SSCRUTE(MED_NOLIEN);
    ret = -1;
  }; 


  /* enregistre la composante n2 du deuxime lment de valr1, au pas de temps n2(5.7), et nd'itration n2*/
  if ( MEDchampEcr(fid,maa1,nomcha1,(unsigned char*)valr1_3p,USER_INTERLACE,nval1_3,MED_NOGAUSS,
		   2,nomprofil1,MED_MAILLE,MED_TRIA6,3,"ms",5.7,2) < 0)  {
    MESSAGE("Erreur  l'criture du champ : ");
    SSCRUTE(nomcha1);ISCRUTE(2);ISCRUTE(2);SSCRUTE(nomprofil1);
    SSCRUTE(maa1);SSCRUTE(MED_NOLIEN);
    ret = -1;
  };
    
    
    
  /* Ecriture du champ n 2 */
  /* TESTER EGALEMENT EN MODE FULL_INTERLACE EN MODIFIANT LA SIGNATURE DE LA ROUTINE */
    
  /* enregistre la composante n1 des lments de valr2, et n'utilise ni pas de temps ni n d'ordre */
  if (MEDchampEcr(fid,maa1,nomcha2,(unsigned char*)valr2,USER_INTERLACE,nval2,MED_NOGAUSS,
		  1,MED_NOPFL,MED_ARETE,MED_SEG2,MED_NOPDT,"",0.0,MED_NONOR) < 0)  {
    MESSAGE("Erreur  l'criture du champ : ");
    SSCRUTE(nomcha2);ISCRUTE(MED_NOPDT);ISCRUTE(MED_NONOR);SSCRUTE(MED_NOPFL);
    SSCRUTE(maa1);SSCRUTE(MED_NOLIEN);
    ret = -1;
  };


  /* enregistre la composante n2 des lments de valr2, et n'utilise ni pas de temps ni n d'ordre */
  /*        pour des raisons de compltude des tests on change le type d'lment (aucun sens phys.))*/
  if (MEDchampEcr(fid,maa1,nomcha2,(unsigned char*)valr2,USER_INTERLACE,nval2,MED_NOGAUSS,
                      2,MED_NOPFL,MED_NOEUD,0,MED_NOPDT,"",0.0,MED_NONOR) < 0)  {
    MESSAGE("Erreur  l'criture du champ : ");
    SSCRUTE(nomcha2);ISCRUTE(MED_NOPDT);ISCRUTE(MED_NONOR);SSCRUTE(MED_NOPFL);
    SSCRUTE(maa1);SSCRUTE(MED_NOLIEN);
    ret = -1;
  };

  /* enregistre la composante n3 des lments de valr2, et n'utilise ni pas de temps ni n d'ordre */
  /*        pour des raisons de compltude des tests on change le type d'lment (aucun sens phys.))*/
  if ( MEDchampEcr(fid,maa1,nomcha2,(unsigned char*)valr2,USER_INTERLACE,nval2,MED_NOGAUSS,
		   3,MED_NOPFL,MED_FACE,MED_TRIA6,MED_NOPDT,"",0.0,MED_NONOR) < 0 ) {
    MESSAGE("Erreur  l'criture du champ : ");
    SSCRUTE(nomcha2);ISCRUTE(MED_NOPDT);ISCRUTE(MED_NONOR);SSCRUTE(MED_NOPFL);
    SSCRUTE(maa1);SSCRUTE(MED_NOLIEN);
    ret = -1;
  };

  /* Creation d'un profil (selection  des lments 1,3,5 de valr2) */
  /* On utilise les trois valeurs du profil */
  if ( MEDprofilEcr(fid,profil2,3,"PROFIL(champ2)") < 0) {
    MESSAGE("Erreur  l'criture du profil : ");
    SSCRUTE(profil1);
    ret = -1;
  };

  /* enregistre la composante n3 des lments du profil2 de valr2, et n'utilise ni pas de temps ni n d'ordre */
  if ( MEDchampEcr(fid,maa1,nomcha2,(unsigned char*)valr2p,USER_INTERLACE,nval2,MED_NOGAUSS,
                      3,"PROFIL(champ2)",MED_MAILLE,MED_TRIA6,MED_NOPDT,"",0.0,MED_NONOR) < 0 ) {
    MESSAGE("Erreur  l'criture du champ : ");
    SSCRUTE(nomcha2);ISCRUTE(MED_NOPDT);ISCRUTE(MED_NONOR);SSCRUTE(MED_NOPFL);
    SSCRUTE(maa1);SSCRUTE(MED_NOLIEN);
    ret = -1;
  };


  /* fermeture du fichier */
  if ( MEDfermer(fid) < 0 ) ret=-1;
  
  return ret;
}




