/*************************************************************************
* COPYRIGHT (C) 1999 - 2007  EDF R&D, CEA/DEN
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

#include <med.h>
#include <med_config.h>
#include <med_outils.h>
#include <stdlib.h>
#include <string.h>


#define nedfngau F77_FUNC(edfngau,EDFNGAU)
#define nedfgaui F77_FUNC(edfgaui,EDFGAUI)
#define nedfgaue F77_FUNC(edfgaue,EDFGAUE)
#define nedfgaul F77_FUNC(edfgaul,EDFGAUL)

#ifdef PPRO_NT
med_int 
__stdcall EDFGAUI(med_int *fid, med_int *indice, char * locname, unsigned int bidon,
		  med_int *typ_geo, med_int *ngauss)
#else
med_int
nedfgaui(med_int *fid,med_int *indice, char * locname,
	 med_int *typ_geo, med_int *ngauss)
#endif
{
  med_int ret;
  char fs1[MED_TAILLE_NOM+1];
  med_geometrie_element type;

  ret = (med_int) MEDgaussInfo((med_idt)*fid,(med_int) *indice, (char *) fs1, 
			       &type, (med_int *) ngauss); 
  
  strncpy(locname,fs1,MED_TAILLE_NOM);
  _MEDfstring(locname,MED_TAILLE_NOM);
  *typ_geo = (med_int) type;

  return(ret); 
}


#ifdef PPRO_NT
med_int 
__stdcall EDFNGAU(med_int *fid)
#else
med_int 
nedfngau(med_int *fid)
#endif
{
  med_int ret; 
  
  ret = (med_int) MEDnGauss((med_idt) *fid); 

  return(ret); 
}


#ifdef PPRO_NT
med_int
__stdcall EDFGAUE(med_int *fid,med_int *typ_geo,
		  med_float *refcoo, med_int *mode_coo,
		  med_int *ngauss, med_float *gscoo, med_float *wg,
		  char *locname, unsigned int bidon1, med_int *lon1)
#else
med_int 
nedfgaue(med_int *fid,med_int *typ_geo,
		  med_float *refcoo, med_int *mode_coo,
		  med_int *ngauss, med_float *gscoo, med_float *wg,
		  char *locname, med_int *lon1)
#endif
{
  med_int ret;
  char *fn1;
  med_geometrie_element type = (med_geometrie_element) *typ_geo;
  med_mode_switch mode = (med_mode_switch) *mode_coo;

  fn1 = _MED2cstring(locname, (int) * lon1);

  if (!fn1) return(-1); 
  
  ret = (med_int) MEDgaussEcr( (med_idt) *fid, type,
			       (med_float *) refcoo, mode,
			       (med_int) *ngauss, (med_float *) gscoo, (med_float *) wg,
			       (char *) fn1);

  _MEDcstringFree(fn1);

  return (ret);
}


#ifdef PPRO_NT
med_int
__stdcall EDFGAUL(med_int * fid, med_float *refcoo, med_float *gscoo, med_float * wg,
		  med_int *mode_coo, char *locname, unsigned int bidon1, med_int *lon1)
#else
med_int 
nedfgaul(med_int * fid, med_float *refcoo, med_float *gscoo, med_float * wg,
	 med_int *mode_coo, char *locname, med_int *lon1)
#endif
{
  med_int ret;
  char *fn1;
  med_mode_switch mode = (med_mode_switch) *mode_coo;

  fn1 = _MED2cstring(locname, (int) * lon1);

  if (!fn1) return(-1); 
  
  ret = (med_int) MEDgaussLire( (med_idt) *fid, (med_float *) refcoo, (med_float *)gscoo,
				(med_float *) wg, mode,
				(char *) fn1);

  _MEDcstringFree(fn1);

  return (ret);
}

