/*************************************************************************
* COPYRIGHT (C) 1999 - 2007  EDF R&D, CEA/DEN
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

#include <med.h>
#include <med_config.h>
#include <med_outils.h>

#include <string.h>
#include <stdlib.h>

med_err 
MEDequivCr(med_idt fid,char *maa, char *eq, char *desc)
{
  med_idt root=0,eqid=0;
  med_err ret=-1;
  char chemin[MED_TAILLE_MAA+MED_TAILLE_EQS+MED_TAILLE_NOM+1];
  char tmp[MED_TAILLE_EQS+1];
  med_mode_acces MED_MODE_ACCES;

  /*
   * On inhibe le gestionnaire d'erreur
   */
  _MEDmodeErreurVerrouiller();

  if ( (MED_MODE_ACCES = _MEDmodeAcces(fid) ) == MED_UNDEF_MODE_ACCES ) {
    MESSAGE("Impossible de dterminer le mode d'acces au fichier.");
    goto ERROR;
  }

  if ( MED_MODE_ACCES == MED_LECTURE ) {
    MESSAGE("Impossible de crer une quivalence en mode MED_LECTURE.");
    goto ERROR;
  };

  /* 
   * Si le Data Group "EQS" n'existe pas, on le cree
   */
  strcpy(chemin,MED_MAA);
  NOFINALBLANK(maa,ERROR);
  strcat(chemin,maa);
  strncpy(tmp,MED_EQS,MED_TAILLE_EQS-1);
  tmp[MED_TAILLE_EQS-1] = '\0';
  strcat(chemin,tmp);
  if ((root = _MEDdatagroupOuvrir(fid,chemin)) < 0)
    if ((root = _MEDdatagroupCreer(fid,chemin)) < 0) {
      MESSAGE("Erreur  la cration du datagroup : ");
      SSCRUTE(chemin);
      goto ERROR;
    }

  /*
   * Si une equivalence du meme nom existe => erreur
   * Sinon on la cree
   */
  NOFINALBLANK(eq,ERROR);
  if ((eqid = _MEDdatagroupCreer(root,eq)) < 0) {
    MESSAGE("Erreur  la cration de l'quivalence : ");
    SSCRUTE(eq);
    goto ERROR;
  }

  /*
   * L'attribut "DES"
   */
  if ((ret = _MEDattrStringEcrire(eqid,MED_NOM_DES,MED_TAILLE_DESC,desc)) < 0) {
    MESSAGE("Erreur  l'criture de la description de l'quivalence : ");
    SSCRUTE(desc);
    goto ERROR;
  }

  /*
   * On ferme tout 
   */
  ret=0;
 ERROR:
  if (eqid>0)     if (_MEDdatagroupFermer(eqid) < 0) {
    MESSAGE("Impossible de fermer le datagroup : ");
    ISCRUTE_id(eqid);ret = -1; 
  }
  
  if (root>0)     if (_MEDdatagroupFermer(root) < 0) {
    MESSAGE("Impossible de fermer le datagroup : ");
    ISCRUTE_id(root); ret = -1; 
  }

  return ret;
}



