/*************************************************************************
* COPYRIGHT (C) 1999 - 2003  EDF R&D
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

#include <med.h>
#include <med_config.h>
#include <med_outils.h>
#include <hdf5.h>

/*
 * - Nom de la fonction : _MEDfichierNo
 * - Description : Renvoi le numro de fichier contenant l'objet
 *                 identifis par id1 
 * - Parametres :
 *     - id     (IN)  : identificateur de l'objet1
 *     - fileno (OUT) : numro de fichier unique 
 * - Resultat : numro hdf du fichier en cas de succes, -1 sinon
 */ 
med_err _MEDfichierNo(med_idt id, unsigned long * fileno )
{ 

  H5G_stat_t statbuf;

  if ( H5Gget_objinfo(id, "/", 1 , &statbuf ) < 0 ) {
    MESSAGE("Impossible d'identifier un numro de fichier correct  partir de l'indentifiant :");
    ISCRUTE_id(id);
    return -1;
  };

  *fileno = statbuf.fileno[0];
/*   ISCRUTE_id(id); */
/*   ISCRUTE(statbuf.fileno[0]); */
/*   ISCRUTE(statbuf.fileno[1]); */

  return 0;
}
