#include <stdio.h>
#include <stdlib.h>


/******************************************************************************
 *
 * - Nom de la fonction : exit_if
 * - Description : gestion et affichage des erreurs.
 * - Parametres :
 *     - fichier    (IN) : nom du fichier.
 *     - ligne      (IN) : ligne ou s'est produite l'erreur.
 *     - condition  (IN) : condition a evaluer pour voir s'il y a une erreur.
 *     - message    (IN) : message a afficher sur le "stderr" en cas d'erreur.
 *     - arg        (IN) : parametre en complement au message.
 *
 ******************************************************************************/
void exit_if(char * fichier,int ligne, int condition,char * message, char * arg) 
{
  if (condition == 0)
    return;
  if (message != NULL)
    if (arg == NULL)
      fprintf(stderr,"%s : %d : >>>> ERREUR : %s  \n",
	      fichier,ligne,message);
    else
      fprintf(stderr,"%s : %d : >>>> ERREUR : %s %s \n",
	      fichier,ligne,message,arg);
  else
    fprintf(stderr,"%s : %d : >>>> ERREUR d'allocation memoire \n",
	    fichier,ligne);
  exit(EXIT_FAILURE);
} 
