/*************************************************************************
* COPYRIGHT (C) 1999 - 2007  EDF R&D, CEA/DEN
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

/******************************************************************************
 * - Nom du fichier : test1.c
 *
 * - Description : tests des routines d'ouverture/fermeture de
 *                 fichiers MED 
 *
 *****************************************************************************/

#include <med.h>
#define MESGERR
#include <med_utils.h>

#ifdef DEF_LECT_ECR
#define MODE_ACCES MED_LECTURE_ECRITURE
#elif DEF_LECT_AJOUT
#define MODE_ACCES MED_LECTURE_AJOUT
#else
#define MODE_ACCES MED_CREATION
#endif

int main (int argc, char **argv)


{
  med_err ret = 0;
  med_idt fid;
  char des[MED_TAILLE_DESC+1]="Ceci est un courte description du mon fichier test1.med";

  /* creation du fichier "test1.med" */
  fid = MEDouvrir("test1.med",MODE_ACCES);
  if (fid < 0) {
    MESSAGE("Erreur  la creation du fichier");
    return -1;
  }

  /* ecriture d'un en-tete dans le fichier */
  if (MEDfichDesEcr(fid,des) < 0) {
    MESSAGE("Erreur  l'ecriture de l'en-tete du fichier");
    ret = -1;
  }

  /* fermeture du fichier */
  if ((ret = MEDfermer(fid)) < 0) {
    MESSAGE("Erreur  la fermeture du fichier"); 
    return -1; 
  } 

  /* re-ouverture du fichier en lecture seule */
  fid = MEDouvrir("test1.med",MED_LECTURE);
  if (fid < 0) {
    MESSAGE("Erreur  l'ouverture du fichier en mode MED_LECTURE");
    return -1;
  }

  /* fermeture du fichier */
  if (MEDfermer(fid) < 0)
    ret = -1;
  
  return ret;
}




