/*************************************************************************
* COPYRIGHT (C) 1999 - 2007  EDF R&D, CEA/DEN
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/
#include <string.h>

#define MESGERR

#ifdef __cplusplus
extern "C" {
#endif

#include "med_config.h"
#include "med_outils.h"

#ifdef __cplusplus
}
#endif

#include "med21.h"
#include "med_hdfi21.h"
#include "MAJ_21_22.h"

void MAJ_21_22_maillages(med_idt fid)
{
  med_idt gid;
  med_err ret;
  int n,i;
  char nom[MED_TAILLE_NOM+1];
  char chemin[MED_TAILLE_MAA+MED_TAILLE_NOM+1];
  char description[MED_TAILLE_DESC+1] = "Maillage converti au format MED V2.2";
  med_int type = (med_int) MED_NON_STRUCTURE;
  med_int dimension;
  
  /* Lecture du nombre de maillages */
  n = 0;
  _MEDnObjets(fid,MED_MAA,&n);
  EXIT_IF(n < 0,"Erreur a la lecture du nombre de maillage",NULL);

  /* 
   * Mise a jour des maillages :
   *  - type : MED_NON_STRUCTURE
   *  - description : "Maillage converti au format V2.2"
   */
  for (i=0;i<n;i++) {
    /* on recupere le nom du maillage */
    ret = _MEDobjetIdentifier(fid,MED_MAA,i,nom);
    EXIT_IF(ret < 0,"Identification d'un maillage",NULL);
    fprintf(stdout,"  >>> Normalisation du maillage [%s] \n",nom);

    /* on accede au maillage */
    strcpy(chemin,MED_MAA);
    strcat(chemin,nom);
    gid = _MEDdatagroupOuvrir(fid,chemin); 
    EXIT_IF(gid < 0,"Accs au maillage",nom);

    /* lecture de la dimension du maillage */
    ret = _MEDattrEntierLire(gid,(char *)(MED_NOM_DIM),&dimension);
    EXIT_IF(ret < 0,"Lecture de la dimension du maillage",nom);

    /* Ecriture du type et de la description */
    ret = _MEDattrStringEcrire(gid,(char *)(MED_NOM_DES),MED_TAILLE_DESC,description);
    EXIT_IF(ret < 0,"Ecriture de la description du maillage ",nom);
    ret = _MEDattrEntierEcrire(gid,(char *)(MED_NOM_TYP),&type);
    EXIT_IF(ret < 0,"Ecriture de la dimension du maillage ",nom);
    
    /* Mise a jour des noeuds du maillage */ 
    MAJ_21_22_noeuds_maillage(gid,dimension);  
    fprintf(stdout,"  ... Normalisation des noeuds effectue ... \n");
    
    /* Mise a jour des lments du maillage */ 
    MAJ_21_22_elements_maillage(gid,dimension);  
    fprintf(stdout,"  ... Normalisation des lments effectue ... \n");
    
    /* Mise a jour des familles du maillage */
    MAJ_21_22_familles_maillage(gid);
    fprintf(stdout,"  ... Normalisation des familles effectue ... \n");
    
    /* On ferme tout */
    ret = _MEDdatagroupFermer(gid);
    EXIT_IF(ret < 0,"Fermeture de l'accs au maillage",NULL);

    fprintf(stdout,"  >>> Normalisation du maillage [%s] ... OK ... \n",nom);
  }
}
