AC_DEFUN([MED_CHECK_HDF5],dnl
[

## Guess where as hdf5 is located by the HDF5HOME environement varaible
## or by the --with-hdf5 option

AC_ARG_WITH([hdf5],
            AC_HELP_STRING([--with-hdf5=<path>],
	                   [Use <path> for HDF5 path.]),
	    [],
	    [withval=yes])

if test ! "x$withval" = "xno"
then

## If user hasn't provided hdf5 path try using "$HDF5HOME" 
    test "x$withval" = "xyes" && hdf5home=${HDF5HOME} || hdf5home=$withval
				   
      if test -n "$hdf5home" ; then
#If user specified a specific hdf5home, be careful to not detect an hdf5 package in the system 
       if test ! -d "$hdf5home" ; then
         AC_MSG_ERROR([The directory |$hdf5home| doesn't exist, please verify either HDF5HOME or --with-hdf5=<path>])
       fi

       if test ! -d "$hdf5home/lib" ; then
         AC_MSG_ERROR([The directory |$hdf5home/lib| doesn't exist, please verify either HDF5HOME or --with-hdf5=<path>])
       fi

       if test ! -d "$hdf5home/include" ; then
         AC_MSG_ERROR([The directory |$hdf5home/include| doesn't exist, please verify either HDF5HOME or --with-hdf5=<path>])
       fi

       LDFLAGS_save="$LDFLAGS"
       LIBS_save="$LIBS"
       CPPFLAGS_save="$CPPFLAGS"

       LDFLAGS="-L$hdf5home/lib $LDFLAGS"
       CPPFLAGS="-I$hdf5home/include $CPPFLAGS "
      fi

      AC_CHECK_LIB([hdf5],[H5open],[],[AC_MSG_ERROR([either use HDF5HOME env. var. or --with-hdf5=<path>])],[])

      AC_PATH_PROG([H5DUMP],[h5dump],[no],[$hdf5home/bin$PATH_SEPARATOR$PATH$PATH_SEPARATOR])
      if test "X$H5DUMP" = "Xno"; then
         AC_MSG_ERROR([Can't find h5dump, please verify your env. var. PATH])
      fi
#      H5DUMP="h5dump"

      AX_ABSOLUTE_HEADER([H5public.h])
      HDF5_ABS_PATH="$gl_cv_absolute_H5public_h"
      HDF5_USED_VER="unknown"
      if test -n "$HDF5_ABS_PATH" ; then 
         HDF5_USED_VER=` grep H5_VERS_INFO $HDF5_ABS_PATH | sed  's/\([[^"]]*\)\(".*"\)\([[^"]]*\)/\2/g' `
      fi


#      AC_DEFINE(H5_USE_16_API,[],[Using HDF5-1.6 API compatibility with HDF5 1.8 libraries])
      HDF5_CPPFLAGS="-DH5_USE_16_API"

      if test -n "$hdf5home" ; then

dnl TODO : VERIFIER LES SOUS CHAINES !
dnl        if test ! AS_DIRNAME(["$hdf5home"]) = AS_DIRNAME(["$HDF5_ABS_PATH"]) ; then
dnl          AC_MSG_WARN([BE CAREFUL, we use $hdf5home as HDF5HOME but found H5public.h in $HDF5_ABS_PATH ])
dnl        fi
dnl        if test ! AS_DIRNAME(["$hdf5home"]) = AS_DIRNAME(["$H5DUMP"]) ; then
dnl          AC_MSG_WARN([BE CAREFUL, we use $hdf5home as HDF5HOME but found h5dump in $H5DUMP ])
dnl        fi

        HDF5_CPPFLAGS="$HDF5_CPPFLAGS -I$hdf5home/include"
        HDF5_LDFLAGS="-L$hdf5home/lib"
        LDFLAGS="$LDFLAGS_save"
        CPPFLAGS="$CPPFLAGS_save"
        LIBS="$LIBS_save"
#        H5DUMP="$hdf5home/bin/h5dump"
      fi

      AC_SUBST(HDF5_CPPFLAGS)
      AC_SUBST(HDF5_LDFLAGS)
#La ligne suivante est inutile car effectue par AC_CHECK_PROG 
#      AC_SUBST(H5DUMP)
      AC_SUBST([HDF5_USED_VER])
      HDF5_LIBS="-lhdf5"
      AC_SUBST([HDF5_LIBS])
else
## In case user explicitly ask to not use hdf5 !
    AC_MSG_WARN([Can't compile MED without hdf5])
    AC_MSG_ERROR([either use HDF5HOME env. var. or --with-hdf5=<path>])
fi
])

