/*************************************************************************
* COPYRIGHT (C) 1999 - 2007  EDF R&D, CEA/DEN
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

#include <med.h>
#include <med_config.h>
#include <med_outils.h>
#include <med_versioned.h>
#include <stdlib.h>
#include <string.h>

#define nedffamc232 F77_FUNC(edffamc232,EDFFAMC232)


#ifdef PPRO_NT
void
__stdcall EDFFAMC232(int dummy,...)
#else
void
nedffamc232(int dummy,...)
#endif
{

  med_int *fid;
  char    *maa;
  med_int *lon1;
  char    *fam;
  med_int *lon2; 
  med_int *num;
  med_int *attr_ident;
  med_int *attr_val;
  char    *attr_desc; 
  med_int *lon3;
  med_int *n_attr;
  char    *groupe ;
  med_int *lon4; 
  med_int *n_groupe;
  med_err *fret ;

  med_int ret=-1;
  char *  fn1, *fn2, *fn3, *fn4;

  va_list params;
  va_start(params,dummy);

  fid        = va_arg(params,  med_int* );
  maa        = va_arg(params,  char*    );
  lon1       = va_arg(params,  med_int* );
  fam        = va_arg(params,  char*    );
  lon2       = va_arg(params,  med_int* ); 
  num        = va_arg(params,  med_int* );
  attr_ident = va_arg(params,  med_int* );
  attr_val   = va_arg(params,  med_int* );
  attr_desc  = va_arg(params,  char*    ); 
  lon3       = va_arg(params,  med_int* );
  n_attr     = va_arg(params,  med_int* );
  groupe     = va_arg(params,  char*    );
  lon4       = va_arg(params,  med_int* ); 
  n_groupe   = va_arg(params,  med_int* );
  fret       = va_arg(params,  med_err* );


  fn1 = _MED2cstring(maa, (int) * lon1);
  fn2 = _MED2cstring(fam, (int) * lon2);
  fn3 = _MED1cstring(attr_desc,(int) * lon3,
		     (int) *n_attr*MED_TAILLE_DESC);
  fn4 = _MED1cstring(groupe, (int) * lon4,
		     (int) *n_groupe*MED_TAILLE_LNOM);
  
  if (!fn1 || !fn2 || !fn3 || !fn4)
    goto ERROR; 

  if( MEDfamCr((med_idt) *fid,fn1,fn2,(med_int) *num, 
	       (med_int *) attr_ident,
	       (med_int *) attr_val, fn3, (med_int) *n_attr, fn4, 
	       (med_int) *n_groupe) < 0 )
    goto ERROR;

  _MEDcstringFree(fn1);
  _MEDcstringFree(fn2); 
  _MEDcstringFree(fn3);
  _MEDcstringFree(fn4);

  ret=0;
 ERROR:
  va_end(params);
  *fret = ret;
  return;
 
}






