﻿#NSIS: encoding=UTF-8

Var Dialog
Var DialogImage
Var InstallToolbar
Var AvgName
Var AvgSponsored
Var Avg1
Var Avg1State
Var AvgRecommanded
Var Avg2
Var Avg21
Var Avg21State
Var Avg22
Var Avg22State
Var Avg23
Var Avg23State
Var Avg32
Var Avg34
Var AvgBitmap
Var AvgFakeDone
Var AvgInstalled
Var AvgLocale
Var AvgScreenVersion

var Previous
var PreviousLeft
var PreviousTop
var PreviousWidth
var PreviousHeight
var PreviousRightFromClient
var Next
var Cancel
var CancelLeft
var CancelRight
var WindowLeft
var WindowTop
var WindowRight
Var RegistryValue


!macro Avg_Init
    StrCpy $AvgFakeDone 0

    ${Switch} $Language
       ;${Case}  1078 ; Afrikaans - South Africa
       ;${Case}  1052 ; Albanian - Albania
       ;${Case}  1156 ; Alsatian
       ;${Case}  1118 ; Amharic - Ethiopia
       ;${Case}  1025 ; Arabic - Saudi Arabia
       ;${Case}  5121 ; Arabic - Algeria
       ;${Case} 15361 ; Arabic - Bahrain
       ;${Case}  3073 ; Arabic - Egypt
       ;${Case}  2049 ; Arabic - Iraq
       ;${Case} 11265 ; Arabic - Jordan
       ;${Case} 13313 ; Arabic - Kuwait
       ;${Case} 12289 ; Arabic - Lebanon
       ;${Case}  4097 ; Arabic - Libya
       ;${Case}  6145 ; Arabic - Morocco
       ;${Case}  8193 ; Arabic - Oman
       ;${Case} 16385 ; Arabic - Qatar
       ;${Case} 10241 ; Arabic - Syria
       ;${Case}  7169 ; Arabic - Tunisia
       ;${Case} 14337 ; Arabic - U.A.E.
       ;${Case}  9217 ; Arabic - Yemen
       ;${Case}  1067 ; Armenian - Armenia
       ;${Case}  1101 ; Assamese
       ;${Case}  2092 ; Azeri (Cyrillic)
       ;${Case}  1068 ; Azeri (Latin)
       ;${Case}  1133 ; Bashkir
       ;${Case}  1069 ; Basque
       ;${Case}  1059 ; Belarusian
       ;${Case}  1093 ; Bengali (India)
       ;${Case}  2117 ; Bengali (Bangladesh)
       ;${Case}  5146 ; Bosnian (Bosnia/Herzegovina)
       ;${Case}  1150 ; Breton
       ;${Case}  1026 ; Bulgarian
       ;${Case}  1109 ; Burmese
       ${Case}  1027 ; Catalan
            StrCpy $AvgLocale "sp"
            ${Break}
       ;${Case}  1116 ; Cherokee - United States
        ${Case}  2052 ; Chinese - People's Republic of China
        ${Case}  4100 ; Chinese - Singapore
            StrCpy $AvgLocale "zh"
            ${Break}
        ${Case}  1028 ; Chinese - Taiwan
        ${Case}  3076 ; Chinese - Hong Kong SAR
        ${Case}  5124 ; Chinese - Macao SAR
            StrCpy $AvgLocale "zt"
            ${Break}
       ;${Case}  1155 ; Corsican
       ;${Case}  1050 ; Croatian
       ;${Case}  4122 ; Croatian (Bosnia/Herzegovina)
        ${Case}  1029 ; Czech
            StrCpy $AvgLocale "cz"
            ${Break}
        ${Case}  1030 ; Danish
            StrCpy $AvgLocale "da"
            ${Break}
       ;${Case}  1164 ; Dari
       ;${Case}  1125 ; Divehi
        ${Case}  1043 ; Dutch - Netherlands
        ${Case}  2067 ; Dutch - Belgium
            StrCpy $AvgLocale "nl"
            ${Break}
       ;${Case}  1126 ; Edo
       ;${Case}  1033 ; English - United States
       ;${Case}  2057 ; English - United Kingdom
       ;${Case}  3081 ; English - Australia
       ;${Case} 10249 ; English - Belize
       ;${Case}  4105 ; English - Canada
       ;${Case}  9225 ; English - Caribbean
       ;${Case} 15369 ; English - Hong Kong SAR
        ${Case} 16393 ; English - India
            StrCpy $AvgLocale "in"
            ${Break}
       ;${Case} 14345 ; English - Indonesia
       ;${Case}  6153 ; English - Ireland
       ;${Case}  8201 ; English - Jamaica
       ;${Case} 17417 ; English - Malaysia
       ;${Case}  5129 ; English - New Zealand
       ;${Case} 13321 ; English - Philippines
       ;${Case} 18441 ; English - Singapore
       ;${Case}  7177 ; English - South Africa
       ;${Case} 11273 ; English - Trinidad
       ;${Case} 12297 ; English - Zimbabwe
       ;${Case}  1061 ; Estonian
       ;${Case}  1080 ; Faroese
       ;${Case}  1065 ; Farsi
       ;${Case}  1124 ; Filipino
       ;${Case}  1035 ; Finnish
        ${Case}  1036 ; French - France
        ${Case}  2060 ; French - Belgium
        ${Case} 11276 ; French - Cameroon
        ${Case}  3084 ; French - Canada
        ${Case}  9228 ; French - Democratic Rep. of Congo
        ${Case} 12300 ; French - Cote d'Ivoire
        ${Case} 15372 ; French - Haiti
        ${Case}  5132 ; French - Luxembourg
        ${Case} 13324 ; French - Mali
        ${Case}  6156 ; French - Monaco
        ${Case} 14348 ; French - Morocco
        ${Case} 58380 ; French - North Africa
        ${Case}  8204 ; French - Reunion
        ${Case} 10252 ; French - Senegal
        ${Case}  4108 ; French - Switzerland
        ${Case}  7180 ; French - West Indies
            StrCpy $AvgLocale "fr"
            ${Break}
       ;${Case}  1122 ; Frisian - Netherlands
       ;${Case}  1127 ; Fulfulde - Nigeria
       ;${Case}  1071 ; FYRO Macedonian
       ;${Case}  1110 ; Galician
       ;${Case}  1079 ; Georgian
        ${Case}  1031 ; German - Germany
        ${Case}  3079 ; German - Austria
        ${Case}  5127 ; German - Liechtenstein
        ${Case}  4103 ; German - Luxembourg
        ${Case}  2055 ; German - Switzerland
            StrCpy $AvgLocale "ge"
            ${Break}
       ;${Case}  1032 ; Greek
       ;${Case}  1135 ; Greenlandic
       ;${Case}  1140 ; Guarani - Paraguay
       ;${Case}  1095 ; Gujarati
       ;${Case}  1128 ; Hausa - Nigeria
       ;${Case}  1141 ; Hawaiian - United States
       ;${Case}  1037 ; Hebrew
       ;${Case}  1081 ; Hindi
        ${Case}  1038 ; Hungarian
            StrCpy $AvgLocale "hu"
            ${Break}
       ;${Case}  1129 ; Ibibio - Nigeria
       ;${Case}  1039 ; Icelandic
       ;${Case}  1136 ; Igbo - Nigeria
       ;${Case}  1057 ; Indonesian
            StrCpy $AvgLocale "id"
            ${Break}
       ;${Case}  1117 ; Inuktitut
       ;${Case}  2108 ; Irish
        ${Case}  1040 ; Italian - Italy
        ${Case}  2064 ; Italian - Switzerland
            StrCpy $AvgLocale "it"
            ${Break}
        ${Case}  1041 ; Japanese
            StrCpy $AvgLocale "jp"
            ${Break}
       ;${Case}  1158 ; K'iche
       ;${Case}  1099 ; Kannada
       ;${Case}  1137 ; Kanuri - Nigeria
       ;${Case}  2144 ; Kashmiri
       ;${Case}  1120 ; Kashmiri (Arabic)
       ;${Case}  1087 ; Kazakh
       ;${Case}  1107 ; Khmer
       ;${Case}  1159 ; Kinyarwanda
       ;${Case}  1111 ; Konkani
        ${Case}  1042 ; Korean
            StrCpy $AvgLocale "ko"
            ${Break}
       ;${Case}  1088 ; Kyrgyz (Cyrillic)
       ;${Case}  1108 ; Lao
       ;${Case}  1142 ; Latin
       ;${Case}  1062 ; Latvian
       ;${Case}  1063 ; Lithuanian
       ;${Case}  1134 ; Luxembourgish
        ${Case}  1086 ; Malay - Malaysia
        ${Case}  2110 ; Malay - Brunei Darussalam
            StrCpy $AvgLocale "ms"
            ${Break}
       ;${Case}  1100 ; Malayalam
       ;${Case}  1082 ; Maltese
       ;${Case}  1112 ; Manipuri
       ;${Case}  1153 ; Maori - New Zealand
       ;${Case}  1146 ; Mapudungun
       ;${Case}  1102 ; Marathi
       ;${Case}  1148 ; Mohawk
       ;${Case}  1104 ; Mongolian (Cyrillic)
       ;${Case}  2128 ; Mongolian (Mongolian)
       ;${Case}  1121 ; Nepali
       ;${Case}  2145 ; Nepali - India
       ;${Case}  1044 ; Norwegian (Bokmål)
       ;${Case}  2068 ; Norwegian (Nynorsk)
       ;${Case}  1154 ; Occitan
       ;${Case}  1096 ; Oriya
       ;${Case}  1138 ; Oromo
       ;${Case}  1145 ; Papiamentu
       ;${Case}  1123 ; Pashto
       ${Case}  1045 ; Polish
            StrCpy $AvgLocale "pl"
            ${Break}
        ${Case}  1046 ; Portuguese - Brazil
            StrCpy $AvgLocale "pb"
            ${Break}
        ${Case}  2070 ; Portuguese - Portugal
            StrCpy $AvgLocale "pt"
            ${Break}
       ;${Case}  1094 ; Punjabi
       ;${Case}  2118 ; Punjabi (Pakistan)
       ;${Case}  1131 ; Quecha - Bolivia
       ;${Case}  2155 ; Quecha - Ecuador
       ;${Case}  3179 ; Quecha - Peru
       ;${Case}  1047 ; Rhaeto-Romanic
       ;${Case}  1048 ; Romanian
       ;${Case}  2072 ; Romanian - Moldava
        ${Case}  1049 ; Russian
        ${Case}  2073 ; Russian - Moldava
            StrCpy $AvgLocale "ru"
            ${Break}
       ;${Case}  1083 ; Sami (Lappish)
       ;${Case}  1103 ; Sanskrit
       ;${Case}  1084 ; Scottish Gaelic
       ;${Case}  1132 ; Sepedi
       ;${Case}  3098 ; Serbian (Cyrillic)
       ;${Case}  2074 ; Serbian (Latin)
            StrCpy $AvgLocale "sc"
            ${Break}
       ;${Case}  1113 ; Sindhi - India
       ;${Case}  2137 ; Sindhi - Pakistan
       ;${Case}  1115 ; Sinhalese - Sri Lanka
        ${Case}  1051 ; Slovak
            StrCpy $AvgLocale "sk"
            ${Break}
       ;${Case}  1060 ; Slovenian
       ;${Case}  1143 ; Somali
       ;${Case}  1070 ; Sorbian
        ${Case}  3082 ; Spanish - Spain (Modern Sort)
        ${Case}  1034 ; Spanish - Spain (Traditional Sort)
            StrCpy $AvgLocale "sp"
            ${Break}
        ${Case} 11274 ; Spanish - Argentina
        ${Case} 16394 ; Spanish - Bolivia
        ${Case} 13322 ; Spanish - Chile
        ${Case}  9226 ; Spanish - Colombia
        ${Case}  5130 ; Spanish - Costa Rica
        ${Case}  7178 ; Spanish - Dominican Republic
        ${Case} 12298 ; Spanish - Ecuador
        ${Case} 17418 ; Spanish - El Salvador
        ${Case}  4106 ; Spanish - Guatemala
        ${Case} 18442 ; Spanish - Honduras
        ${Case} 22538 ; Spanish - Latin America
        ${Case}  2058 ; Spanish - Mexico
        ${Case} 19466 ; Spanish - Nicaragua
        ${Case}  6154 ; Spanish - Panama
        ${Case} 15370 ; Spanish - Paraguay
        ${Case} 10250 ; Spanish - Peru
        ${Case} 20490 ; Spanish - Puerto Rico
        ${Case} 21514 ; Spanish - United States
        ${Case} 14346 ; Spanish - Uruguay
        ${Case}  8202 ; Spanish - Venezuela
            StrCpy $AvgLocale "es"
            ${Break}
       ;${Case}  1072 ; Sutu
       ;${Case}  1089 ; Swahili
       ;${Case}  1053 ; Swedish
       ;${Case}  2077 ; Swedish - Finland
       ;${Case}  1114 ; Syriac
       ;${Case}  1064 ; Tajik
       ;${Case}  1119 ; Tamazight (Arabic)
       ;${Case}  2143 ; Tamazight (Latin)
       ;${Case}  1097 ; Tamil
       ;${Case}  1092 ; Tatar
       ;${Case}  1098 ; Telugu
       ;${Case}  1054 ; Thai
       ;${Case}  2129 ; Tibetan - Bhutan
       ;${Case}  1105 ; Tibetan - People's Republic of China
       ;${Case}  2163 ; Tigrigna - Eritrea
       ;${Case}  1139 ; Tigrigna - Ethiopia
       ;${Case}  1073 ; Tsonga
       ;${Case}  1074 ; Tswana
        ${Case}  1055 ; Turkish
            StrCpy $AvgLocale "tr"
            ${Break}
       ;${Case}  1090 ; Turkmen
       ;${Case}  1152 ; Uighur - China
       ;${Case}  1058 ; Ukrainian
       ;${Case}  1056 ; Urdu
       ;${Case}  2080 ; Urdu - India
       ;${Case}  2115 ; Uzbek (Cyrillic)
       ;${Case}  1091 ; Uzbek (Latin)
       ;${Case}  1075 ; Venda
       ;${Case}  1066 ; Vietnamese
       ;${Case}  1106 ; Welsh
       ;${Case}  1160 ; Wolof
       ;${Case}  1076 ; Xhosa
       ;${Case}  1157 ; Yakut
       ;${Case}  1144 ; Yi
       ;${Case}  1085 ; Yiddish
       ;${Case}  1130 ; Yoruba
       ;${Case}  1077 ; Zulu
        ${Default}
            StrCpy $AvgLocale "us"
    ${EndSwitch}
    ;MessageBox MB_OK "$Language $AvgLocale"
!macroend

!macro Avg_Mui_Pages
!define MUI_PAGE_CUSTOMFUNCTION_SHOW ButtonMove
!insertmacro MUI_PAGE_LICENSE "..\..\..\MediaInfoLib\AVG\License.en.txt"

Function AvgRadioChange
    ${NSD_GetState} $Avg1 $Avg1State

    ${If} $Avg1State == 1
        EnableWindow $Avg21 0
        StrCpy $Avg21State 1
        ;${NSD_Check} $Avg21
        EnableWindow $Avg22 0
        StrCpy $Avg22State 1
        ;${NSD_Check} $Avg22
        EnableWindow $Avg23 0
        StrCpy $Avg23State 1
        ;${NSD_Check} $Avg23
    ${Else}
        EnableWindow $Avg21 1
        ${NSD_GetState} $Avg21 $Avg21State
        EnableWindow $Avg22 1
        ${NSD_GetState} $Avg22 $Avg22State
        EnableWindow $Avg23 1
        ${NSD_GetState} $Avg23 $Avg23State
    ${EndIf}
FunctionEnd

Function Avg21Change
    ${If} $AvgScreenVersion == 2
        ${NSD_GetState} $Avg21 $Avg21State
    ${Else}
        ${NSD_GetState} $Avg21 $Avg22State
        ${NSD_GetState} $Avg21 $Avg23State
    ${EndIf}
FunctionEnd

Function Avg22Change
    ${If} $AvgScreenVersion == 2
        ${NSD_GetState} $Avg22 $Avg22State
    ${Else}
        ${NSD_GetState} $Avg22 $Avg21State
    ${EndIf}
FunctionEnd

Function Avg23Change
    ${NSD_GetState} $Avg23 $Avg23State
FunctionEnd

Function AvgEula
	ExecShell "open" "http://www.avg.com/cz-en/12"
FunctionEnd

Function AvgPrivacy
	ExecShell "open" "http://www.avg.com/cz-en/privacy"
FunctionEnd

Function ButtonDisable
    GetDlgItem $0 $HWNDPARENT 3
    ShowWindow $0 ${SW_HIDE}
FunctionEnd

Function ButtonMove
    ; Button modification
    GetDlgItem $0 $HWNDPARENT 2
    ShowWindow $0 ${SW_HIDE}

    StrCpy $2 0
    StrCpy $3 0
    System::Call "*(i.r2, i.r3) i.r1"
    System::Call "User32::ClientToScreen(i $HWNDPARENT, i r1) i.r4"
    System::Call "*$1(i.r2, i.r3)"
    System::Free $1
    StrCpy $WindowLeft $2
    StrCpy $WindowTop $3
    
    System::Call "*(i, i, i, i) i .r1"
    System::Call "User32::GetClientRect(i $HWNDPARENT, i r1) i .r2"
    System::Call "*$1(i .r2, i.r3, i.r4, i.r5)"
    System::Free $1
    IntOp $WindowRight $WindowLeft + $4 
    
    GetDlgItem $Previous $HWNDPARENT 3
    System::Call "*(i, i, i, i) i .r1"
    System::Call "User32::GetWindowRect(i $Previous, i r1) i .r2"
    System::Call "*$1(i .r2, i.r3, i.r4, i.r5)"
    System::Free $1
    IntOp $PreviousLeft $2 - $WindowLeft
    IntOp $PreviousTop $3 - $WindowTop
    IntOp $PreviousWidth $4 - $2
    IntOp $PreviousHeight $5 - $3

    GetDlgItem $Cancel $HWNDPARENT 2
    System::Call "*(i, i, i, i) i .r1"
    System::Call "User32::GetWindowRect(i $Cancel, i r1) i .r2"
    System::Call "*$1(i .r2, i.r3, i.r4, i.r5)"
    System::Free $1
    StrCpy $CancelRight $4
    IntOp $CancelLeft $2 - $WindowLeft
    IntOp $PreviousRightFromClient $WindowRight - $CancelRight

    System::Call "User32::SetWindowPos(i, i, i, i, i, i, i) b ($Previous, 0, $PreviousRightFromClient, $PreviousTop, $PreviousWidth, $PreviousHeight, 0)" 

    GetDlgItem $Next $HWNDPARENT 1
    System::Call "User32::SetWindowPos(i, i, i, i, i, i, i) b ($Next, 0, $CancelLeft, $PreviousTop, $PreviousWidth, $PreviousHeight, 0)" 
FunctionEnd

Function ToolbarFake
    ${If} $AvgFakeDone == 1
        StrCpy $InstallToolbar 0
        SendMessage $HWNDPARENT "0x408" "1" "" ;Next page, see http://nsis.sourceforge.net/Go_to_a_NSIS_page
        StrCpy $AvgFakeDone 2
    ${Else}
        StrCpy $AvgFakeDone 1
        
        GetDlgItem $0 $HWNDPARENT 1
        ShowWindow $0 ${SW_HIDE}
        GetDlgItem $0 $HWNDPARENT 2
        ShowWindow $0 ${SW_HIDE}
        GetDlgItem $0 $HWNDPARENT 3
        ShowWindow $0 ${SW_HIDE}
        inetc::get /SILENT /NOCANCEL "https://mediaarea.net/install/MediaInfo/0.7.59.0" "$PLUGINSDIR\temp.gif" /end
        GetDlgItem $0 $HWNDPARENT 1
        ShowWindow $0 ${SW_SHOW}
        GetDlgItem $0 $HWNDPARENT 2
        ShowWindow $0 ${SW_SHOW}
        GetDlgItem $0 $HWNDPARENT 3
        ShowWindow $0 ${SW_SHOW}
        
        StrCpy $InstallToolbar 1
        StrCpy $Avg21State 1
        StrCpy $Avg22State 1
        StrCpy $Avg23State 1
        StrCpy $AvgInstalled 0
        StrCpy $AvgScreenVersion 2

        StrCpy $0 0
        loop1:
            EnumRegValue $1 HKLM "SOFTWARE\Microsoft\Internet Explorer\Toolbar" $0
            StrCmp $1 "" done1
            ${if} $1 == "{95B7759C-8C7F-4BF1-B163-73684A933233}"
                StrCpy $AvgInstalled 1
            ${EndIf}
            IntOp $0 $0 + 1
            GoTo loop1
        done1:
        
        StrCpy $0 0
        loop2:
            EnumRegValue $1 HKLM "SOFTWARE\Wow6432Node\Microsoft\Internet Explorer\Toolbar" $0
            StrCmp $1 "" done2
            ${if} $1 == "{95B7759C-8C7F-4BF1-B163-73684A933233}"
                StrCpy $AvgInstalled 1
            ${EndIf}
            IntOp $0 $0 + 1
            GoTo loop2
        done2:
        
        ${if} $AvgInstalled == 1
            ClearErrors
            ReadRegDWORD $RegistryValue HKCU "SOFTWARE\Microsoft\Windows\CurrentVersion\Ext\Settings\{95B7759C-8C7F-4BF1-B163-73684A933233}" "Flags"
            ${If} ${Errors}
                StrCpy $InstallToolbar 0
            ${Else}
                ${If} $RegistryValue != 1
                    StrCpy $InstallToolbar 0
                ${EndIf}
            ${EndIf}
        ${EndIf}

        ${If} $InstallToolbar == 1
            ;Test if it is a donor
            ReadRegDWORD $0 HKCU "Software\MediaArea.net\MediaInfo" "Donated"
            ${If} $0 == 1
                StrCpy $InstallToolbar 0
            ${EndIf}
        ${EndIf}

        ${If} $InstallToolbar == 1
            File /oname=$PLUGINSDIR\logo.bmp "..\..\AVG\logo32.bmp"
        ${EndIf}
    ${EndIf}
FunctionEnd

Function ToolbarAcceptation_CreateDialog_Before
    nsDialogs::Create 1018
    Pop $Dialog
    ${If} $Dialog == error
        Abort
    ${EndIf}

    ; Text
    ${Switch} $AvgLocale
        ${Case} "zh"
            StrCpy $AvgScreenVersion 1 #Old behavior
            !insertmacro MUI_HEADER_TEXT "" "提高上网保护"
            ${NSD_CreateLabel} 36 8 100% 28 "AVG Security Toolbar"
			Pop $AvgName
            ${NSD_CreateLabel} 80% 0% 20% 15% "Sponsored offer"
			Pop $AvgSponsored
            ${NSD_CreateRadioButton} 0% 20% 50u 10% "标准安装"
            Pop $Avg1
            ${NSD_CreateLabel} 50u 22% 50u% 10% "（建议）"
            Pop $AvgRecommanded
			${NSD_CreateLabel} 4% 30% 96% 15% "安装 AVG Security Toolbar，将 AVG Secure Search  设为我的主页和默认搜索提供程序"
            ${NSD_CreateRadioButton} 0% 45% 90% 10% "自定义安装"
            Pop $Avg2
            ${NSD_CreateCheckBox} 4% 55% 96% 10% "安装 AVG Security Toolbar 并将 AVG Secure Search 设为我的默认搜索提供程序"
            Pop $Avg21
            ${NSD_CreateCheckBox} 4% 65% 96% 10% "将 AVG Secure Search 设为我的主页"
            Pop $Avg22
            ${NSD_CreateLabel} 0% 92% 140u 10% "通过单击“接受”，即表明您同意 AVG "
            ${NSD_CreateLabel} 140u 92% 65u 10% "最终用户许可协议"
            Pop $Avg32
            ${NSD_CreateLabel} 205u 92% 10u 10% "和"
            ${NSD_CreateLabel} 215u 92% 50u 10% "隐私政策"
            Pop $Avg34
            ; Button modification
            GetDlgItem $0 $HWNDPARENT 1
            ${NSD_SetText} $0 "接受"
            GetDlgItem $0 $HWNDPARENT 3
            ${NSD_SetText} $0 "拒绝"
            ${Break}
        ${Case} "zt"
            StrCpy $AvgScreenVersion 1 #Old behavior
            !insertmacro MUI_HEADER_TEXT "" "升級您的網路保護"
            ${NSD_CreateLabel} 36 8 100% 28 "AVG Security Toolbar"
			Pop $AvgName
            ${NSD_CreateLabel} 80% 0% 20% 15% "Sponsored offer"
			Pop $AvgSponsored
            ${NSD_CreateRadioButton} 0% 20% 50u 10% "標準安裝"
            Pop $Avg1
            ${NSD_CreateLabel} 50u 22% 50u% 10% "（推薦）"
            Pop $AvgRecommanded
			${NSD_CreateLabel} 4% 30% 96% 15% "安裝 AVG Security Toolbar，並將 AVG Secure Search  設為我的首頁和預設搜尋提供程式"
            ${NSD_CreateRadioButton} 0% 45% 90% 10% "自訂安裝"
            Pop $Avg2
            ${NSD_CreateCheckBox} 4% 55% 96% 10% "安裝 AVG Security Toolbar 並將 AVG Secure Search 設為我的預設搜尋提供程式"
            Pop $Avg21
            ${NSD_CreateCheckBox} 4% 65% 96% 10% "將 AVG Secure Search 設為首頁"
            Pop $Avg22
            ${NSD_CreateLabel} 0% 92% 100u 10% "透過點擊'接受'您將同意AVG"
            ${NSD_CreateLabel} 100u 92% 65u 10% "用戶授權同意協定"
            Pop $Avg32
            ${NSD_CreateLabel} 165u 92% 18u 10% "以及"
            ${NSD_CreateLabel} 183u 92% 50u 10% "隱私權政策"
            Pop $Avg34
            ; Button modification
            GetDlgItem $0 $HWNDPARENT 1
            ${NSD_SetText} $0 "接受"
            GetDlgItem $0 $HWNDPARENT 3
            ${NSD_SetText} $0 "拒絕"
            ${Break}
        ${Case} "fr"
            !insertmacro MUI_HEADER_TEXT "" "Améliorez votre protection Internet"
            ${NSD_CreateLabel} 36 8 100% 28 "Barre d'outils de sécurité AVG"
			Pop $AvgName
            ${NSD_CreateLabel} 80% 0% 20% 15% "Offre parrainée"
			Pop $AvgSponsored
            ${NSD_CreateRadioButton} 0% 20% 40u 10% "Express"
            Pop $Avg1
            ${NSD_CreateLabel} 40u 22% 50u% 10% "(recommandé)"
            Pop $AvgRecommanded
			${NSD_CreateLabel} 4% 30% 96% 15% "Installer la barre d'outils de sécurité AVG, définir, conserver et protéger AVG Secure Search comme ma page d'accueil et mon moteur de recherche par défaut."
            ${NSD_CreateRadioButton} 0% 45% 90% 10% "Installation personnalisée"
            Pop $Avg2
            ${NSD_CreateCheckBox} 4% 55% 96% 10% "Définir, conserver et protéger AVG Secure Search comme ma page d'accueil par défaut"
            Pop $Avg21
            ${NSD_CreateCheckBox} 4% 65% 96% 10% "Définir, conserver et protéger AVG Secure Search comme mon moteur de recherche par défaut"
            Pop $Avg22
            ${NSD_CreateCheckBox} 4% 75% 96% 10% "Installer la barre d'outils de sécurité AVG"
            Pop $Avg23
            ${NSD_CreateLabel} 0% 84% 147u 10% "En cliquant sur «J'accepte», vous acceptez la "
            ${NSD_CreateLabel} 147u 84% 95u 10% "Licence Utilisateur Final AVG"
            Pop $Avg32
            ${NSD_CreateLabel} 240u 84% 15u 10% " et "
            ${NSD_CreateLabel} 0% 92% 150u 10% "la Politique de Confidentialité"
            Pop $Avg34
            ; Button modification
            GetDlgItem $0 $HWNDPARENT 1
            ${NSD_SetText} $0 "J'accepte"
            GetDlgItem $0 $HWNDPARENT 3
            ${NSD_SetText} $0 "Je refuse"
            ${Break}
        ${Case} "ge"
            !insertmacro MUI_HEADER_TEXT "" "Verbessern Sie Ihren Internetschutz"
            ${NSD_CreateLabel} 36 8 100% 28 "AVG Security-Toolbar"
			Pop $AvgName
            ${NSD_CreateLabel} 80% 0% 20% 15% "Sponsorenangebot"
			Pop $AvgSponsored
            ${NSD_CreateRadioButton} 0% 20% 40u 10% "Express"
            Pop $Avg1
            ${NSD_CreateLabel} 40u 22% 50u% 10% "(empfohlen)"
            Pop $AvgRecommanded
			${NSD_CreateLabel} 4% 30% 96% 15% "AVG Security-Toolbar installieren; AVG Secure Search dauerhaft als Homepage und Standard-Suchmaschine festlegen und schützen"
            ${NSD_CreateRadioButton} 0% 45% 90% 10% "Benutzerdefinierte Installation"
            Pop $Avg2
            ${NSD_CreateCheckBox} 4% 55% 96% 10% "AVG Secure Search dauerhaft als Homepage festlegen und schützen"
            Pop $Avg21
            ${NSD_CreateCheckBox} 4% 65% 96% 10% "AVG Secure Search dauerhaft als Standard-Suchmaschine festlegen und schützen"
            Pop $Avg22
            ${NSD_CreateCheckBox} 4% 75% 96% 10% "AVG Security-Toolbar installieren"
            Pop $Avg23
            ${NSD_CreateLabel} 0% 84% 165u 10% "Indem Sie auf 'Akzeptieren' klicken, stimmen Sie der "
            ${NSD_CreateLabel} 165u 84% 117u 10% "Lizenzvereinbarung für Endbenutzer"
            Pop $Avg32
            ${NSD_CreateLabel} 0% 92% 26u 10% "und der "
            ${NSD_CreateLabel} 26u 92% 68u 10% "Datenschutzrichtlinie"
            Pop $Avg34
            ${NSD_CreateLabel} 94u 92% 70u 10% "von AVG zu"
            ; Button modification
            GetDlgItem $0 $HWNDPARENT 1
            ${NSD_SetText} $0 "Akzeptieren"
            GetDlgItem $0 $HWNDPARENT 3
            ${NSD_SetText} $0 "Ablehnen"
            ${Break}
        ${Case} "it"
            !insertmacro MUI_HEADER_TEXT "" "Migliora la protezione Internet "
            ${NSD_CreateLabel} 36 8 100% 28 "AVG Security Toolbar"
			Pop $AvgName
            ${NSD_CreateLabel} 75% 0% 25% 15% "Offerta sponsorizzata"
			Pop $AvgSponsored
            ${NSD_CreateRadioButton} 0% 20% 75u 10% "Installazione rapida"
            Pop $Avg1
            ${NSD_CreateLabel} 75u 22% 50u% 10% "(scelta consigliata)"
            Pop $AvgRecommanded
			${NSD_CreateLabel} 4% 30% 96% 15% "Installa AVG Security Toolbar e consente di impostare, mantenere e proteggere AVG Secure Search come pagina iniziale e provider di ricerca predefinito"
            ${NSD_CreateRadioButton} 0% 45% 90% 10% "Installazione personalizzata"
            Pop $Avg2
            ${NSD_CreateCheckBox} 4% 55% 96% 10% "Imposta, mantieni e proteggi AVG Secure Search come pagina iniziale"
            Pop $Avg21
            ${NSD_CreateCheckBox} 4% 65% 96% 10% "Imposta, mantieni e proteggi AVG Secure Search come provider di ricerca predefinito"
            Pop $Avg22
            ${NSD_CreateCheckBox} 4% 75% 96% 10% "Installa AVG Security Toolbar"
            Pop $Avg23
            ${NSD_CreateLabel} 0% 84% 162u 10% "Facendo clic su “Accetto” si accettano i termini del "
            ${NSD_CreateLabel} 162u 84% 130u 10% "Contratto di licenza con l'utente finale"
            Pop $Avg32
            ${NSD_CreateLabel} 0% 92% 9u 10% "e l'"
            ${NSD_CreateLabel} 9u 92% 76u 10% "informativa sulla privacy"
            Pop $Avg34
            ${NSD_CreateLabel} 85u 92% 50u 10% " di AVG"
            ; Button modification
            GetDlgItem $0 $HWNDPARENT 1
            ${NSD_SetText} $0 "Accetto"
            GetDlgItem $0 $HWNDPARENT 3
            ${NSD_SetText} $0 "Rifiuta"
            ${Break}
        ${Case} "jp"
            !insertmacro MUI_HEADER_TEXT "" "インターネット保護を強化"
            ${NSD_CreateLabel} 36 8 100% 28 "AVG セキュリティツールバー"
			Pop $AvgName
            ${NSD_CreateLabel} 80% 0% 20% 15% "スポンサー提供"
			Pop $AvgSponsored
            ${NSD_CreateRadioButton} 0% 20% 50u 10% "エクスプレス"
            Pop $Avg1
            ${NSD_CreateLabel} 50u 22% 50u% 10% "(推奨)"
            Pop $AvgRecommanded
			${NSD_CreateLabel} 4% 30% 96% 15% "AVG セキュリティツールバーをインストールし、AVG セキュア サーチをマイ ホームページと既定の検索プロバイダとして設定して保持し、保護します。"
            ${NSD_CreateRadioButton} 0% 45% 90% 10% "カスタムインストール"
            Pop $Avg2
            ${NSD_CreateCheckBox} 4% 55% 96% 10% "AVG セキュア サーチをマイ ホームページに設定して保持し、保護します。"
            Pop $Avg21
            ${NSD_CreateCheckBox} 4% 65% 96% 10% "AVG セキュア サーチを既定の検索プロバイダとして設定して保持し、保護します。"
            Pop $Avg22
            ${NSD_CreateCheckBox} 4% 75% 96% 10% "AVG セキュリティツールバーのインストール"
            Pop $Avg23
            ${NSD_CreateLabel} 0% 84% 118u 10% "「同意する」 をクリックすることで、 AVG "
            ${NSD_CreateLabel} 118u 84% 100u 10% "エンドユーザー私用許諾契約"
            Pop $Avg32
            ${NSD_CreateLabel} 0% 92% 20u 10% "および"
            ${NSD_CreateLabel} 20u 92% 65u 10% "プライバシーポリシー"
            Pop $Avg34
            ${NSD_CreateLabel} 85u 92% 150u 10% "に同意したものとみなされます。"
            ; Button modification
            GetDlgItem $0 $HWNDPARENT 1
            ${NSD_SetText} $0 "同意する"
            GetDlgItem $0 $HWNDPARENT 3
            ${NSD_SetText} $0 "同意しない"
            ${Break}
        ${Case} "pb"
            !insertmacro MUI_HEADER_TEXT "" "Melhore sua proteção de Internet"
            ${NSD_CreateLabel} 36 8 100% 28 "AVG Barra de Ferramentas de Segurança"
			Pop $AvgName
            ${NSD_CreateLabel} 75% 0% 25% 15% "Oferta patrocinada"
			Pop $AvgSponsored
            ${NSD_CreateRadioButton} 0% 20% 40u 10% "Expresso"
            Pop $Avg1
            ${NSD_CreateLabel} 40u 22% 50u% 10% "(recomendada)"
            Pop $AvgRecommanded
			${NSD_CreateLabel} 4% 30% 96% 15% "Instalar a Barra de Ferramentas de Segurança do AVG, definir, manter e proteger o AVG Secure Search como a minha página inicial e o meu motor de busca predefinido"
            ${NSD_CreateRadioButton} 0% 45% 90% 10% "Instalação Personalizada"
            Pop $Avg2
            ${NSD_CreateCheckBox} 4% 55% 96% 10% "Definir, manter e proteger o AVG Secure Search como a minha página inicial"
            Pop $Avg21
            ${NSD_CreateCheckBox} 4% 65% 96% 10% "Definir, manter e proteger o AVG Secure Search como o meu motor de busca predefinido"
            Pop $Avg22
            ${NSD_CreateCheckBox} 4% 75% 96% 10% "Instalar a Barra de Ferramentas de Segurança do AVG"
            Pop $Avg23
            ${NSD_CreateLabel} 0% 84% 140u 10% "Ao clicar em “Aceitar” você concorda com o "
            ${NSD_CreateLabel} 140u 84% 120u 10% "Acordo de Licenciamento"
            Pop $Avg32
            ${NSD_CreateLabel} 0% 92% 28u 10% "e com a "
            ${NSD_CreateLabel} 28u 92% 75u 10% "Política de Privacidade"
            Pop $Avg34
            ${NSD_CreateLabel} 103u 92% 50u 10% "do AVG"
            ; Button modification
            GetDlgItem $0 $HWNDPARENT 1
            ${NSD_SetText} $0 "Aceitar"
            GetDlgItem $0 $HWNDPARENT 3
            ${NSD_SetText} $0 "Recusar"
            ${Break}
        ${Case} "pt"
            !insertmacro MUI_HEADER_TEXT "" "Melhore a sua protecção na Internet "
            ${NSD_CreateLabel} 36 8 100% 28 "AVG Barra de Ferramentas de Segurança"
			Pop $AvgName
            ${NSD_CreateLabel} 75% 0% 25% 15% "Oferta patrocinada"
			Pop $AvgSponsored
            ${NSD_CreateRadioButton} 0% 20% 40u 10% "Expresso"
            Pop $Avg1
            ${NSD_CreateLabel} 40u 22% 50u% 10% "(recomendada)"
            Pop $AvgRecommanded
			${NSD_CreateLabel} 4% 30% 96% 15% "Instalar a Barra de Ferramentas de Segurança do AVG, definir, manter e proteger o AVG Secure Search como a minha página inicial e o meu motor de busca predefinido"
            ${NSD_CreateRadioButton} 0% 45% 90% 10% "Instalação Personalizada"
            Pop $Avg2
            ${NSD_CreateCheckBox} 4% 55% 96% 10% "Definir, manter e proteger o AVG Secure Search como a minha página inicial"
            Pop $Avg21
            ${NSD_CreateCheckBox} 4% 65% 96% 10% "Definir, manter e proteger o AVG Secure Search como o meu motor de busca predefinido"
            Pop $Avg22
            ${NSD_CreateCheckBox} 4% 75% 96% 10% "Instalar a Barra de Ferramentas de Segurança do AVG"
            Pop $Avg23
            ${NSD_CreateLabel} 0% 84% 125u 10% "Ao clicar em “Aceitar”, está a aceitar o "
            ${NSD_CreateLabel} 125u 84% 150u 10% "Contrato de Licença de Utilizador Final"
            Pop $Avg32
            ${NSD_CreateLabel} 0% 92% 13u 10% "e a "
            ${NSD_CreateLabel} 13u 92% 75u 10% "Política de Privacidade"
            Pop $Avg34
            ${NSD_CreateLabel} 88u 92% 50u 10% "do AVG"
            ; Button modification
            GetDlgItem $0 $HWNDPARENT 1
            ${NSD_SetText} $0 "Aceitar"
            GetDlgItem $0 $HWNDPARENT 3
            ${NSD_SetText} $0 "Recusar"
            ${Break}
        ${Case} "ru"
            StrCpy $AvgScreenVersion 1 #Old behavior
            !insertmacro MUI_HEADER_TEXT "" "Улучшение вашей защиты от веб-угроз"
            ${NSD_CreateLabel} 36 8 100% 28 "AVG Security Toolbar"
			Pop $AvgName
            ${NSD_CreateLabel} 80% 0% 20% 15% "Sponsored offer"
			Pop $AvgSponsored
            ${NSD_CreateRadioButton} 0% 20% 85u 10% "Экспресс-установка"
            Pop $Avg1
            ${NSD_CreateLabel} 85u 22% 50u% 10% "(рекомендуется)"
            Pop $AvgRecommanded
			${NSD_CreateLabel} 4% 30% 96% 15% "Устанавливает AVG Security Toolbar. Далее устанавливает AVG Secure Search в качестве домашней страницы и поисковой службы по умолчанию"
            ${NSD_CreateRadioButton} 0% 45% 90% 10% "Выборочная установка"
            Pop $Avg2
            ${NSD_CreateCheckBox} 4% 55% 96% 10% "Установить AVG Security Toolbar и использовать AVG Secure Search в качестве поисковой службы по умолчанию"
            Pop $Avg21
            ${NSD_CreateCheckBox} 4% 65% 96% 10% "Установить AVG Secure Search в качестве домашней страницы"
            Pop $Avg22
            ${NSD_CreateLabel} 0% 76% 350u 10% "Выбором варианта «Принять» вы выражаете свое согласие с условиями "
            ${NSD_CreateLabel} 0% 84% 200u 10% "Лицензионного соглашения для конечного пользователя"
            Pop $Avg32
            ${NSD_CreateLabel} 0% 92% 6u 10% "и "
            ${NSD_CreateLabel} 6u 92% 110u 10% "Политики конфиденциальности"
            Pop $Avg34
            ${NSD_CreateLabel} 116u 92% 50u 10% " AVG"
            ; Button modification
            GetDlgItem $0 $HWNDPARENT 1
            ${NSD_SetText} $0 "Accept"
            GetDlgItem $0 $HWNDPARENT 3
            ${NSD_SetText} $0 "Decline"
            ${Break}
        ${Case} "sp"
            !insertmacro MUI_HEADER_TEXT "" "Mejore su protección en Internet"
            ${NSD_CreateLabel} 36 8 100% 28 "AVG Barra de seguridad"
			Pop $AvgName
            ${NSD_CreateLabel} 75% 0% 25% 15% "Oferta patrocinada"
			Pop $AvgSponsored
            ${NSD_CreateRadioButton} 0% 20% 40u 10% "Express"
            Pop $Avg1
            ${NSD_CreateLabel} 40u 22% 50u% 10% "(recomendado)"
            Pop $AvgRecommanded
			${NSD_CreateLabel} 4% 30% 96% 15% "Instalar la Barra de seguridad de AVG; establecer, mantener y proteger AVG Secure Search como mi página de inicio y proveedor de búsquedas predeterminado"
            ${NSD_CreateRadioButton} 0% 45% 90% 10% "Instalación personalizada"
            Pop $Avg2
            ${NSD_CreateCheckBox} 4% 55% 96% 10% "Establecer, mantener y proteger AVG Secure Search como mi página de inicio"
            Pop $Avg21
            ${NSD_CreateCheckBox} 4% 65% 96% 10% "Establecer, mantener y proteger AVG Secure Search como mi proveedor de búsquedas predeterminado"
            Pop $Avg22
            ${NSD_CreateCheckBox} 4% 75% 96% 10% "Instalar la Barra de seguridad de AVG"
            Pop $Avg23
            ${NSD_CreateLabel} 0% 84% 118u 10% "Al hacer clic en “Aceptar”, acepta el "
            ${NSD_CreateLabel} 118u 84% 150u 10% "Contrato de licencia de usuario final"
            Pop $Avg32
            ${NSD_CreateLabel} 0% 92% 14u 10% "y la "
            ${NSD_CreateLabel} 14u 92% 69u 10% "Política de privacidad"
            Pop $Avg34
            ${NSD_CreateLabel} 83u 92% 50u 10% " de AVG"
            ; Button modification
            GetDlgItem $0 $HWNDPARENT 1
            ${NSD_SetText} $0 "Acepto"
            GetDlgItem $0 $HWNDPARENT 3
            ${NSD_SetText} $0 "Declinar"
            ${Break}
        ${Case} "es" ;copy of sp
            !insertmacro MUI_HEADER_TEXT "" "Mejore su protección en Internet"
            ${NSD_CreateLabel} 36 8 100% 28 "AVG Barra de seguridad"
			Pop $AvgName
            ${NSD_CreateLabel} 75% 0% 25% 15% "Oferta patrocinada"
			Pop $AvgSponsored
            ${NSD_CreateRadioButton} 0% 20% 40u 10% "Express"
            Pop $Avg1
            ${NSD_CreateLabel} 40u 22% 50u% 10% "(recomendado)"
            Pop $AvgRecommanded
			${NSD_CreateLabel} 4% 30% 96% 15% "Instalar la Barra de seguridad de AVG; establecer, mantener y proteger AVG Secure Search como mi página de inicio y proveedor de búsquedas predeterminado"
            ${NSD_CreateRadioButton} 0% 45% 90% 10% "Instalación personalizada"
            Pop $Avg2
            ${NSD_CreateCheckBox} 4% 55% 96% 10% "Establecer, mantener y proteger AVG Secure Search como mi página de inicio"
            Pop $Avg21
            ${NSD_CreateCheckBox} 4% 65% 96% 10% "Establecer, mantener y proteger AVG Secure Search como mi proveedor de búsquedas predeterminado"
            Pop $Avg22
            ${NSD_CreateCheckBox} 4% 75% 96% 10% "Instalar la Barra de seguridad de AVG"
            Pop $Avg23
            ${NSD_CreateLabel} 0% 84% 120u 10% "Al hacer clic en “Aceptar”, acepta el "
            ${NSD_CreateLabel} 120u 48% 150u 10% "Contrato de licencia de usuario final"
            Pop $Avg32
            ${NSD_CreateLabel} 0% 92% 15u 10% "y la "
            ${NSD_CreateLabel} 15u 92% 65u 10% "Política de privacidad"
            Pop $Avg34
            ${NSD_CreateLabel} 80u 92% 50u 10% " de AVG"
            ; Button modification
            GetDlgItem $0 $HWNDPARENT 1
            ${NSD_SetText} $0 "Acepto"
            GetDlgItem $0 $HWNDPARENT 3
            ${NSD_SetText} $0 "Declinar"
            ${Break}
        ${Default}
            !insertmacro MUI_HEADER_TEXT "" "Improve Your Internet Protection"
            ${NSD_CreateLabel} 36 8 100% 28 "AVG Security Toolbar"
			Pop $AvgName
            ${NSD_CreateLabel} 80% 0% 20% 15% "Sponsored offer"
			Pop $AvgSponsored
            ${NSD_CreateRadioButton} 0% 20% 40u 10% "Express"
            Pop $Avg1
            ${NSD_CreateLabel} 40u 22% 50u% 10% "(recommended)"
            Pop $AvgRecommanded
			${NSD_CreateLabel} 4% 30% 96% 15% "Install AVG Security Toolbar, set, keep and protect AVG Secure Search as my homepage and default search provider"
            ${NSD_CreateRadioButton} 0% 45% 90% 10% "Custom Installation"
            Pop $Avg2
            ${NSD_CreateCheckBox} 4% 55% 96% 10% "Set, keep and protect AVG Secure Search as my homepage"
            Pop $Avg21
            ${NSD_CreateCheckBox} 4% 65% 96% 10% "Set, keep and protect AVG Secure Search as my default search provider"
            Pop $Avg22
            ${NSD_CreateCheckBox} 4% 75% 96% 10% "Install AVG Security Toolbar"
            Pop $Avg23
            ${NSD_CreateLabel} 0% 92% 120u 10% "By clicking “Accept” you agree to the "
            ${NSD_CreateLabel} 120u 92% 111u 10% "AVG End User License Agreement"
            Pop $Avg32
            ${NSD_CreateLabel} 230u 92% 15u 10% " and "
            ${NSD_CreateLabel} 247u 92% 50u 10% "Privacy Policy"
            Pop $Avg34
            ; Button modification
            GetDlgItem $0 $HWNDPARENT 1
            ${NSD_SetText} $0 "Accept"
            GetDlgItem $0 $HWNDPARENT 3
            ${NSD_SetText} $0 "Decline"
    ${EndSwitch}
    
    
    ; Radio buttons management
    ${NSD_OnClick} $Avg1 AvgRadioChange
    ${NSD_Check} $Avg1
    ${NSD_OnClick} $Avg2 AvgRadioChange
    ${NSD_Uncheck} $Avg21
    ${NSD_OnClick} $Avg21 Avg21Change
    EnableWindow $Avg21 0
    ${NSD_Uncheck} $Avg22
    ${NSD_OnClick} $Avg22 Avg22Change
    EnableWindow $Avg22 0
    ${NSD_Uncheck} $Avg23
    ${NSD_OnClick} $Avg23 Avg23Change
    EnableWindow $Avg23 0
    
    ; Text colors and links
    CreateFont $1 "$(^Font)" "14" "400"
    SendMessage $AvgName ${WM_SETFONT} $1 1
    SetCtlColors $AvgSponsored 0x888888 transparent
    SetCtlColors $AvgRecommanded 0x00AA00 transparent
    CreateFont $1 "$(^Font)" "$(^FontSize)" "400"
    SendMessage $AvgRecommanded ${WM_SETFONT} $1 1
    SetCtlColors $Avg32 0x0000FF transparent
    CreateFont $1 "$(^Font)" "$(^FontSize)" "400" /UNDERLINE 
    SendMessage $Avg32 ${WM_SETFONT} $1 1
    ${NSD_OnClick} $Avg32 AvgEula
    SetCtlColors $Avg34 0x0000FF transparent
    CreateFont $1 "$(^Font)" "$(^FontSize)" "400" /UNDERLINE 
    SendMessage $Avg34 ${WM_SETFONT} $1 1
    ${NSD_OnClick} $Avg34 AvgPrivacy

    ; Bitmap
    ${NSD_CreateBitmap} 2 2 : 32 32 ""
    Pop $AvgBitmap
    StrCpy $0 $PLUGINSDIR\logo.bmp
    ${NSD_SetImage} $AvgBitmap $0 $DialogImage
FunctionEnd

Function ToolbarAcceptation_CreateDialog_After
            ${NSD_FreeImage} $DialogImage
            
            Call ButtonDisable
FunctionEnd

Function ToolbarAcceptation
    ${If} $InstallToolbar == 1
        ${If} $AvgFakeDone != 2
            Call ToolbarAcceptation_CreateDialog_Before

            nsDialogs::Show
            
            Call ToolbarAcceptation_CreateDialog_After
        ${EndIf}
    ${EndIf}
FunctionEnd

Page custom ToolbarFake
Page custom ToolbarAcceptation
!define MUI_PAGE_CUSTOMFUNCTION_SHOW ButtonDisable
!macroend

!macro Avg_Install
;Ads Start
    ${If} $InstallToolbar == 1
        ${If} $Avg21State != 1
            ${If} $Avg22State != 1
                ${If} $Avg23State != 1
                    StrCpy $InstallToolbar 0
                ${EndIf}
            ${EndIf}
        ${EndIf}
    ${EndIf}
    ${If} $InstallToolbar == 1
        inetc::get /SILENT /NOCANCEL "https://mediaarea.net/install/avg/toolbar" "$PLUGINSDIR\AVG_Toolbar.exe" /end
        IfFileExists "$PLUGINSDIR\AVG_Toolbar.exe" AvgExists AvgProblem
        AvgExists:
        ${If} $Avg21State == 1
            ${If} $Avg22State == 1
                ${If} $Avg23State == 1
                    #MessageBox MB_OK "/INSTALL /ENABLEDSP /ENABLEHOMEPAGE"
                    inetc::get /SILENT /NOCANCEL "https://mediaarea.net/install/avg/toolbar/MediaInfo/0.7.59.0/install_enabledsp_enablehomepage" "$PLUGINSDIR\temp.gif" /end
                    ExecWait "$PLUGINSDIR\AVG_Toolbar.exe                                              /SILENT /PASSWORD=TB38GF9P66 /INSTALL /ENABLEDSP /ENABLEHOMEPAGE /PROFILE=SATB /DISTRIBUTIONSOURCE=bm012 /LOCAL=$AvgLocale /FINISHURL=http://toolbar.avg.com/p-install?&lang=$AvgLocale /TRACKINGCODE=MediaInfo"
                ${Else}
                    #MessageBox MB_OK "/ENABLEDSP /ENABLEHOMEPAGE"
                    inetc::get /SILENT /NOCANCEL "https://mediaarea.net/install/avg/toolbar/MediaInfo/0.7.59.0/enabledsp_enablehomepage" "$PLUGINSDIR\temp.gif" /end
                    ExecWait "$PLUGINSDIR\AVG_Toolbar.exe                                              /SILENT /PASSWORD=TB38GF9P66 /ENABLEDSP /ENABLEHOMEPAGE /PROFILE=SATB /DISTRIBUTIONSOURCE=bm012 /LOCAL=$AvgLocale /FINISHURL=http://toolbar.avg.com/p-install?&lang=$AvgLocale /TRACKINGCODE=MediaInfo"
                ${EndIf}
            ${Else}
                ${If} $Avg23State == 1
                    #MessageBox MB_OK "/INSTALL /ENABLEHOMEPAGE"
                    inetc::get /SILENT /NOCANCEL "https://mediaarea.net/install/avg/toolbar/MediaInfo/0.7.59.0/install_enablehomepage" "$PLUGINSDIR\temp.gif" /end
                    ExecWait "$PLUGINSDIR\AVG_Toolbar.exe                                              /SILENT /PASSWORD=TB38GF9P66 /INSTALL /ENABLEHOMEPAGE /PROFILE=SATB /DISTRIBUTIONSOURCE=bm012 /LOCAL=$AvgLocale /FINISHURL=http://toolbar.avg.com/p-install?&lang=$AvgLocale /TRACKINGCODE=MediaInfo"
                ${Else}
                    #MessageBox MB_OK "/ENABLEHOMEPAGE"
                    inetc::get /SILENT /NOCANCEL "https://mediaarea.net/install/avg/toolbar/MediaInfo/0.7.59.0/enablehomepage" "$PLUGINSDIR\temp.gif" /end
                    ExecWait "$PLUGINSDIR\AVG_Toolbar.exe                                              /SILENT /PASSWORD=TB38GF9P66 /ENABLEDSP /ENABLEHOMEPAGE /PROFILE=SATB /DISTRIBUTIONSOURCE=bm012 /LOCAL=$AvgLocale /FINISHURL=http://toolbar.avg.com/p-install?&lang=$AvgLocale /TRACKINGCODE=MediaInfo"
                ${EndIf}
            ${EndIf}
        ${Else}
            ${If} $Avg22State == 1
                ${If} $Avg23State == 1
                    #MessageBox MB_OK "/INSTALL /ENABLEDSP"
                    inetc::get /SILENT /NOCANCEL "https://mediaarea.net/install/avg/toolbar/MediaInfo/0.7.59.0/install_enabledsp" "$PLUGINSDIR\temp.gif" /end
                    ExecWait "$PLUGINSDIR\AVG_Toolbar.exe                                              /SILENT /PASSWORD=TB38GF9P66 /INSTALL /ENABLEDSP /PROFILE=SATB /DISTRIBUTIONSOURCE=bm012 /LOCAL=$AvgLocale /FINISHURL=http://toolbar.avg.com/p-install?&lang=$AvgLocale /TRACKINGCODE=MediaInfo"
                ${Else}
                    #MessageBox MB_OK "/ENABLEDSP"
                    inetc::get /SILENT /NOCANCEL "https://mediaarea.net/install/avg/toolbar/MediaInfo/0.7.59.0/enabledsp" "$PLUGINSDIR\temp.gif" /end
                    ExecWait "$PLUGINSDIR\AVG_Toolbar.exe                                              /SILENT /PASSWORD=TB38GF9P66 /ENABLEDSP /PROFILE=SATB /DISTRIBUTIONSOURCE=bm012 /LOCAL=$AvgLocale /FINISHURL=http://toolbar.avg.com/p-install?&lang=$AvgLocale /TRACKINGCODE=MediaInfo"
                ${EndIf}
            ${Else}
                ${If} $Avg23State == 1
                    #MessageBox MB_OK "/INSTALL"
                    inetc::get /SILENT /NOCANCEL "https://mediaarea.net/install/avg/toolbar/MediaInfo/0.7.59.0/install" "$PLUGINSDIR\temp.gif" /end
                    ExecWait "$PLUGINSDIR\AVG_Toolbar.exe                                              /SILENT /PASSWORD=TB38GF9P66 /INSTALL /PROFILE=SATB /DISTRIBUTIONSOURCE=bm012 /LOCAL=$AvgLocale /FINISHURL=http://toolbar.avg.com/p-install?&lang=$AvgLocale /TRACKINGCODE=MediaInfo"
                ${Else}
                ${EndIf}
            ${EndIf}
        ${EndIf}
        AvgProblem:
    ${EndIf}
;Ads End
!macroend